/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.cnf;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.EMailNotifier;
import com.adventnet.sa.server.nf.Notifier;
import com.adventnet.sa.server.nf.ScriptNotifier;
import com.adventnet.sa.server.nf.SmsNotifier;
import java.util.HashSet;
import java.util.Set;

public class CorrelProfile {
    private Long notifId = null;
    private Set<Notifier> notifiers = new HashSet<Notifier>();

    public CorrelProfile(Long notifId) {
        this.notifId = notifId;
        this.setProfileDetails();
    }

    private void setProfileDetails() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"NotificationType"));
            query.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"NotfnConfiguration", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"NotfnConfigurationSms", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"ScriptDetails", (String)"*"));
            query.addJoin(new Join("NotificationType", "NotfnConfiguration", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
            query.addJoin(new Join("NotificationType", "NotfnConfigurationSms", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
            query.addJoin(new Join("NotificationType", "ScriptDetails", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
            query.setCriteria(new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)this.notifId, 0));
            DataObject doo = DataAccess.get((SelectQuery)query);
            this.setNotifiers(doo);
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
        }
    }

    private void setNotifiers(DataObject doo) throws DataAccessException {
        Row r = doo.getRow("NotfnConfiguration");
        if (r != null) {
            this.notifiers.add(new EMailNotifier(r));
        }
        if ((r = doo.getRow("NotfnConfigurationSms")) != null) {
            this.notifiers.add(new SmsNotifier(r));
        }
        if ((r = doo.getRow("ScriptDetails")) != null) {
            this.notifiers.add(new ScriptNotifier(r));
        }
    }

    Long getNotifId() {
        return this.notifId;
    }

    Set<Notifier> getNotifiers() {
        return this.notifiers;
    }
}

