/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.cnf;

import java.util.Calendar;
import java.util.logging.Logger;

public class CorrelationConstants {
    private static final Logger LOGGER = Logger.getLogger(CorrelationConstants.class.getName());
    public static int dailyMailLimit = 500;
    public static int dailySmsLimit = 50;
    private static int numMailsSentToday = 0;
    private static int numSmsSentToday = 0;
    public static Calendar currentDay = Calendar.getInstance();

    public static void init() {
        dailyMailLimit = Integer.parseInt(System.getProperty("Correlation_dailyMailLimit", "500"));
        if ("Off".equals(System.getProperty("Correlation_Email", "On"))) {
            LOGGER.info("Correlation Email Notification is Disabled so Limit set to 0");
            dailyMailLimit = 0;
        }
        if ("Off".equals(System.getProperty("Correlation_SMS", "On"))) {
            LOGGER.info("Correlation SMS Notification is Disabled so Limit set to 0");
            dailySmsLimit = 0;
        }
        dailySmsLimit = Integer.parseInt(System.getProperty("Correlation_dailySMSLimit", "50"));
        LOGGER.info("Correlation Sms limit set to: " + dailySmsLimit + " mail limit set to: " + dailyMailLimit);
    }

    public static boolean isDailyEmailLimitReached() {
        CorrelationConstants.checkAndResetValues();
        if (numMailsSentToday >= dailyMailLimit) {
            LOGGER.fine("Correlation Daily Email Limit reached. ");
            return true;
        }
        return false;
    }

    public static boolean isDailySmsLimitReached() {
        CorrelationConstants.checkAndResetValues();
        return numSmsSentToday >= dailySmsLimit;
    }

    private static void checkAndResetValues() {
        Calendar today = Calendar.getInstance();
        if (today.get(6) != currentDay.get(6)) {
            LOGGER.info("Day changed. resetting mail/sms count and current day:" + today);
            numMailsSentToday = 0;
            numSmsSentToday = 0;
            currentDay = today;
        }
    }

    public static void updateSentEmailCount() {
        ++numMailsSentToday;
    }

    public static void updateSentSmsCount() {
        ++numSmsSentToday;
    }
}

