/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.cnf;

import com.adventnet.ds.query.Criteria;
import com.adventnet.nba.engine.NotifyHandler;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.cnf.CorrelProfile;
import com.adventnet.sa.server.cnf.CorrelationConstants;
import com.adventnet.sa.server.cnf.CorrelationNotifyIntiator;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class CorrelationNotifyHandle
implements NotifyHandler {
    private static final Logger LOGGER = Logger.getLogger(CorrelationNotifyHandle.class.getName());
    private static SimpleDateFormat time_Format = new SimpleDateFormat("HH:mm:ss, EEE, MMM dd yyyy");
    private static CorrelationNotifyHandle instance = null;
    private Map<Long, CorrelProfile> corrMap = new ConcurrentHashMap<Long, CorrelProfile>();
    private final ExecutorService threadexecutor = Executors.newFixedThreadPool(2);
    private String defaultCrit = "Alerts triggered upon Occurrence of 1 or more events";

    public static synchronized CorrelationNotifyHandle getInstance() {
        if (instance == null) {
            instance = new CorrelationNotifyHandle();
        }
        return instance;
    }

    public void initCorrMap() {
        try {
            LOGGER.info("Init Correlation Rule Map");
            List<String> tables = Arrays.asList("NotificationType", "CorrNotificationMapping");
            DataObject doo = DataAccess.get(tables, (Criteria)null);
            Iterator iter = doo.getRows("CorrNotificationMapping");
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                Long ruleId = (Long)r.get("RULE_ID");
                Long NotifId = (Long)r.get("NOTIFID");
                this.corrMap.put(ruleId, new CorrelProfile(NotifId));
            }
            CorrelationConstants.init();
        }
        catch (DataAccessException e) {
            LOGGER.info("Exception in Data Access Exception Notification Handle");
            e.printStackTrace();
        }
        catch (Exception e) {
            LOGGER.info("Exception While Intializing Correlation Map");
            e.printStackTrace();
        }
        LOGGER.info("Correlation Profiles -->" + this.corrMap);
    }

    public void addProf(Long ruleId, Long notifId) {
        LOGGER.info("Correlation Ruleid " + ruleId + " with NotifId " + notifId + " is added");
        this.corrMap.put(ruleId, new CorrelProfile(notifId));
    }

    public void deleteProf(Long ruleId) {
        LOGGER.info("Correlation Ruleid " + ruleId + " is deleted");
        this.corrMap.remove(ruleId);
    }

    public void updateProf(Long ruleId, Long notifId) {
        this.deleteProf(ruleId);
        this.addProf(ruleId, notifId);
    }

    public void notifyHandle(Map notifyMap) {
        try {
            Hashtable<String, String> log = new Hashtable<String, String>();
            log.putAll(notifyMap);
            String rid = log.get("RULEID").toString();
            String ruleName = log.get("RULENAME").toString();
            Long ruleId = Long.valueOf(rid);
            CorrelProfile corrProfile = this.corrMap.get(ruleId);
            if (corrProfile == null) {
                LOGGER.fine("Notification not configured for this ruleId" + ruleId);
                return;
            }
            Long lgTime = (Long)log.get("TIME");
            log.put("Time", this.formatTime(lgTime));
            log.put("RULECRITERIA", this.defaultCrit);
            this.threadexecutor.execute(new CorrelationNotifyIntiator(log, corrProfile));
        }
        catch (Exception e) {
            LOGGER.info("Error While Processing Correlation Notification");
            e.printStackTrace();
        }
    }

    private String formatTime(Long millisecon) {
        Date time = new Date(millisecon);
        return time_Format.format(time);
    }

    public void shutdown() {
        LOGGER.info("Shutting down Correlation Notification Handler");
        this.threadexecutor.shutdown();
    }
}

