/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.dbsync;

import com.adventnet.sa.server.dbsync.domain.DomainSyncHandler;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sa.server.util.InheritedHostHandler;
import com.manageengine.ads.fw.dbsync.ExecutorImpl;
import com.manageengine.ads.fw.discovery.ad.ADDiscoveryModuleHandler;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ads.fw.mail.MailHandler;
import com.manageengine.ads.fw.service.util.ProductUniqueSeqGenerator;
import com.manageengine.ela.server.common.handlers.domain.DomainHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ELAExecutorImpl
extends ExecutorImpl {
    private static Logger out = Logger.getLogger("ADSDBSyncLogger");
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(JSONObject jsonRow) {
        Object object = lock;
        synchronized (object) {
            String result;
            block10: {
                result = "success";
                try {
                    String moduleName = jsonRow.getString("MODULE_NAME");
                    Properties params = this.getDetails(jsonRow);
                    out.log(Level.FINE, "Selected ModuleName : " + moduleName + "  Details : " + params);
                    String sourceStamp = params.getProperty("PRODUCT_SEQ_NUMBER");
                    int operation = jsonRow.getInt("OPERATION");
                    if (sourceStamp != null && ProductUniqueSeqGenerator.getCurrentSeqNumber().equals(sourceStamp)) {
                        out.log(Level.INFO, "Duplicate Host Information  : " + sourceStamp);
                        break block10;
                    }
                    if (moduleName.equals("DomainConfiguration")) {
                        this.handleDomainModule(params, operation, sourceStamp);
                        break block10;
                    }
                    if (moduleName.equals("MemberServerOrWorkStationAddUpdate") || moduleName.equals("MemberServerOrWorkStationDelete") || moduleName.equals("DomainController") || moduleName.equals("DomainControllerEnableDisable") || moduleName.equals("ADSHostModules")) {
                        this.handleHostModule(params, operation);
                        break block10;
                    }
                    if (moduleName.equals("HostAddDeleteSync") || moduleName.equals("HostUpdateSync")) {
                        out.log(Level.INFO, "Skipping ELA published syncing Module " + moduleName);
                        break block10;
                    }
                    if (moduleName.equalsIgnoreCase("ADSMailSettings")) {
                        this.handleMailModule(jsonRow, operation);
                        break block10;
                    }
                    return super.execute(jsonRow);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = e.getMessage() != null ? e.getMessage() : e.toString();
                    out.log(Level.INFO, "Unable to Execute Row - Reason : " + result);
                }
            }
            return result;
        }
    }

    private void handleMailModule(JSONObject jsonRow, int operation) throws Exception {
        if (operation == 1 || operation == 2) {
            JSONObject newMailSettings = this.getRowDetails(jsonRow);
            String newServerName = newMailSettings.has("SERVER_NAME") ? newMailSettings.getString("SERVER_NAME") : null;
            String string = newServerName = !"null".equalsIgnoreCase(newServerName) ? newServerName : null;
            if (CommonUtil.isMailServerConfigured()) {
                String serverName;
                JSONObject mailSettings = MailHandler.getMailSettings();
                String string2 = serverName = mailSettings.has("SERVER_NAME") ? mailSettings.getString("SERVER_NAME") : null;
                if (newServerName != null && (serverName == null || serverName.equalsIgnoreCase(newServerName))) {
                    String newFromMailId;
                    String fromMailId = mailSettings.has("FROM_MAIL_ID") ? this.parseMailID(mailSettings.getString("FROM_MAIL_ID")) : null;
                    String string3 = newFromMailId = newMailSettings.has("FROM_MAIL_ID") ? this.parseMailID(newMailSettings.getString("FROM_MAIL_ID")) : null;
                    if (serverName == null || fromMailId == null || fromMailId.equalsIgnoreCase(newFromMailId)) {
                        if (mailSettings.has("ADMIN_MAIL_ID")) {
                            newMailSettings.remove("ADMIN_MAIL_ID");
                        } else if (newMailSettings.has("ADMIN_MAIL_ID") && !"null".equalsIgnoreCase(newMailSettings.getString("ADMIN_MAIL_ID"))) {
                            newMailSettings.put("ADMIN_MAIL_ID", (Object)this.parseMailID(newMailSettings.getString("ADMIN_MAIL_ID")));
                        } else {
                            newMailSettings.put("ADMIN_MAIL_ID", (Object)newFromMailId);
                        }
                        if (serverName != null && fromMailId != null) {
                            newMailSettings.remove("FROM_MAIL_ID");
                        } else {
                            newMailSettings.put("FROM_MAIL_ID", (Object)newFromMailId);
                        }
                        JSONObject jSecurityIDs = MailHandler.getConnectionSecurity();
                        Iterator keys = jSecurityIDs.keys();
                        String connectionSecurityID = "null";
                        while (keys.hasNext()) {
                            String key = (String)keys.next();
                            if (!jSecurityIDs.getString(key).equals(newMailSettings.getString("CONNECTION_SECURITY_ID"))) continue;
                            connectionSecurityID = key;
                            break;
                        }
                        newMailSettings.put("CONNECTION_SECURITY_ID", (Object)connectionSecurityID);
                        MailHandler.setMailSettings((JSONObject)newMailSettings, (boolean[])new boolean[]{true});
                        CommonUtil.setMailServerConfigured();
                    }
                }
            } else if (newServerName != null) {
                JSONObject jSecurityIDs = MailHandler.getConnectionSecurity();
                Iterator keys = jSecurityIDs.keys();
                String connectionSecurityID = "null";
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (!jSecurityIDs.getString(key).equals(newMailSettings.getString("CONNECTION_SECURITY_ID"))) continue;
                    connectionSecurityID = key;
                    break;
                }
                newMailSettings.put("CONNECTION_SECURITY_ID", (Object)connectionSecurityID);
                MailHandler.setMailSettings((JSONObject)newMailSettings, (boolean[])new boolean[]{true});
                CommonUtil.setMailServerConfigured();
            }
        }
    }

    private void handleDomainModule(Properties params, int operation, String sourceStamp) throws Exception {
        String passWord;
        Properties domainProperties = this.getRequiredDomainDetails(params);
        String userName = domainProperties.containsKey("USER_DISTINGUISHED_NAME") ? domainProperties.getProperty("USER_DISTINGUISHED_NAME") : null;
        String string = passWord = domainProperties.containsKey("PASSWORD") ? domainProperties.getProperty("PASSWORD") : null;
        if (operation == 1) {
            JSONObject domaindetails = ADSDomainHandler.getDomainDetails((String)domainProperties.getProperty("DOMAIN_NAME"));
            if (domaindetails != null && domaindetails.length() > 0) {
                out.info("Given domain already exits going to update");
                DomainHandler.updateDomain(domainProperties.getProperty("DOMAIN_NAME"), (ArrayList<String>)((ArrayList)domainProperties.get("DOMAIN_CONTROLLER_LIST")), userName, passWord, true);
            } else {
                out.info("Given domain is not exits going to add new domain");
                DomainHandler.addDomain(domainProperties.getProperty("DOMAIN_NAME"), (ArrayList<String>)((ArrayList)domainProperties.get("DOMAIN_CONTROLLER_LIST")), userName, passWord, true);
                ADDiscoveryModuleHandler.updateDomainModules((Properties)domainProperties, (boolean)false);
            }
        } else if (operation == 2) {
            DomainHandler.updateDomain(domainProperties.getProperty("DOMAIN_NAME"), (ArrayList<String>)((ArrayList)domainProperties.get("DOMAIN_CONTROLLER_LIST")), userName, passWord, true);
            DomainSyncHandler.updateSlstate(domainProperties.getProperty("DOMAIN_NAME"));
            out.log(Level.INFO, "Domain updated successfully");
        } else {
            String domainName = domainProperties.getProperty("DOMAIN_NAME");
            DomainSyncHandler.deleteAssociatedHosts(domainName, sourceStamp);
        }
    }

    private void collectDcInformations(Properties domainProperties) {
        ArrayList<Properties> dcList = new ArrayList<Properties>();
        if (domainProperties.containsKey("DOMAIN_CONTROLLER_LIST")) {
            ArrayList dcs = (ArrayList)domainProperties.get("DOMAIN_CONTROLLER_LIST");
            for (String dcName : dcs) {
                Properties localProp = new Properties();
                localProp.put("DOMAIN_CONTROLLER_NAME", dcName);
                localProp.put("PRIORITY_ID", new Integer(1));
                localProp.put("MESSAGE", "-");
                dcList.add(localProp);
            }
        }
        out.info("collectDcInformations result : " + dcList);
        domainProperties.put("DOMAIN_CONTROLLER_LIST", dcList);
    }

    private void handleHostModule(Properties hostProperties, int operation) throws Exception {
        if (operation == 1) {
            InheritedHostHandler.addInheritedHost(hostProperties);
        } else if (operation == 3) {
            InheritedHostHandler.checkAnddeleteHost(hostProperties);
        } else {
            InheritedHostHandler.updateInheritedHost(hostProperties);
        }
    }

    private Properties getRequiredDomainDetails(Properties domainProperties) {
        Properties localProp = new Properties();
        localProp.put("DOMAIN_NAME", domainProperties.get("DomainName"));
        if (domainProperties.containsKey("IsAuthRequired") && domainProperties.getProperty("IsAuthRequired").equalsIgnoreCase("TRUE")) {
            localProp.put("IS_AUTHENTICATION_REQUIRED", "true");
            localProp.put("USER_DISTINGUISHED_NAME", domainProperties.get("UserName"));
            localProp.put("PASSWORD", domainProperties.get("Password"));
        } else {
            localProp.put("IS_AUTHENTICATION_REQUIRED", "false");
            localProp.put("USER_DISTINGUISHED_NAME", "");
            localProp.put("PASSWORD", "");
        }
        if (domainProperties.containsKey("DomainFlatName")) {
            localProp.put("DOMAIN_FLAT_NAME", domainProperties.get("DomainFlatName"));
        }
        if (domainProperties.containsKey("STATUS_MESSAGE")) {
            localProp.put("STATUS_MESSAGE", domainProperties.get("STATUS_MESSAGE"));
        }
        if (domainProperties.containsKey("DCList")) {
            localProp.put("DOMAIN_CONTROLLER_LIST", this.getDclist(domainProperties.get("DCList")));
        }
        return localProp;
    }

    private Object getDclist(Object object) {
        ArrayList<String> dcList = new ArrayList<String>();
        if (object != null) {
            String[] dcNames;
            for (String dc : dcNames = object.toString().split(",")) {
                dcList.add(dc);
            }
        }
        return dcList;
    }

    private Properties getDetails(JSONObject row) throws Exception {
        Properties properties = new Properties();
        JSONArray columns = row.getJSONArray("COLUMNS");
        for (int i = 0; i < columns.length(); ++i) {
            JSONObject column = columns.getJSONObject(i);
            properties.put(column.getString("NAME"), column.getString("VALUE"));
        }
        return properties;
    }

    private JSONObject getRowDetails(JSONObject row) throws Exception {
        JSONObject rowDetails = new JSONObject();
        JSONArray columns = row.getJSONArray("COLUMNS");
        for (int i = 0; i < columns.length(); ++i) {
            JSONObject column = columns.getJSONObject(i);
            rowDetails.put(column.getString("NAME"), (Object)column.getString("VALUE"));
        }
        return rowDetails;
    }

    private String parseMailID(String mailId) throws Exception {
        try {
            StringTokenizer st = new StringTokenizer(mailId, ",");
            String individualMailId = null;
            String finalMailId = null;
            while (st.hasMoreTokens()) {
                individualMailId = st.nextToken();
                if (individualMailId.contains("<") && individualMailId.contains(">")) {
                    StringTokenizer stz = new StringTokenizer(individualMailId, "<>");
                    while (stz.hasMoreTokens()) {
                        String key = stz.nextToken();
                        individualMailId = stz.nextToken();
                    }
                }
                if (finalMailId == null) {
                    finalMailId = individualMailId;
                    continue;
                }
                finalMailId = finalMailId + "," + individualMailId;
            }
            if (finalMailId != null) {
                return finalMailId;
            }
        }
        catch (Exception e) {
            out.log(Level.INFO, "Exception while converting MAIL ID : " + e.getMessage());
        }
        return mailId;
    }
}

