/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.dbsync;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sa.server.util.HostDBHandler;
import com.manageengine.ads.fw.dbsync.DBSyncModulesContainer;
import com.manageengine.ads.fw.dbsync.PublisherImpl;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ads.fw.license.LicenseManager;
import com.manageengine.ads.fw.service.util.ProductUniqueSeqGenerator;
import com.manageengine.ela.server.common.discovery.windows.domain.DomainDiscoveryListner;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import com.manageengine.ela.server.common.util.StringUtil;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class ELAPublisherImpl
extends PublisherImpl {
    private static Logger out = Logger.getLogger("ADSDBSyncLogger");
    private static Map<String, String> tableModuleMap = DBSyncModulesContainer.getTableModuleMap();

    public void addRow(Row row) throws Exception {
        int operation = row.getOperationIndex();
        String tableName = row.getOriginalTableName();
        if (tableName.equalsIgnoreCase("Hosts")) {
            Long host_id = (Long)row.get("HOST_ID");
            String moduleName = tableModuleMap.get(tableName);
            Properties prop = ELAPublisherImpl.getHostProperties(host_id);
            if (operation == 3) {
                HostDBHandler.deleteHostsCache(host_id);
            }
            if ("Windows".equalsIgnoreCase(prop.getProperty("TYPE"))) {
                if (this.isCanbePublished(host_id)) {
                    out.log(Level.FINE, "EVENTLOG Publishing Row :" + row);
                    List columnList = row.getColumns();
                    this.createRow(moduleName, operation);
                    for (Object columnName : columnList) {
                        JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName.toString());
                        if (columnSyncDetails == null) continue;
                        JSONObject column = this.constructColumn(row, columnSyncDetails);
                        if (column.getString("NAME").equals("HOST_NAME") && prop.containsKey("HOST_NAME")) {
                            String syncValue = prop.getProperty(column.getString("NAME"));
                            this.addColumn(column.getString("NAME"), syncValue, column.getString("ORIGINAL_VALUE"));
                            continue;
                        }
                        this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
                    }
                    if (prop.containsKey("DOMAIN_NAME")) {
                        String syncValue = prop.getProperty("DOMAIN_NAME");
                        this.addColumn("DOMAIN_NAME", syncValue, syncValue);
                    }
                    this.addColumn("PRODUCT_SEQ_NUMBER", ProductUniqueSeqGenerator.getCurrentSeqNumber(), null);
                    this.addColumn("LICENSE_CODE", LicenseManager.getLicenseCode(), null);
                    this.addColumn("HOST_STATUS", prop.getProperty("LOG_COLLECTION_STATUS", "1"), null);
                    this.addRowtoEvent();
                } else {
                    out.log(Level.FINE, "Inherited Host Cannot be Published");
                }
            } else {
                out.log(Level.FINE, "Skipping Add Host module because of non windows host");
            }
        } else if (tableName.equalsIgnoreCase(ADSDomainHandler.tableName)) {
            if (operation == 1) {
                String moduleName = tableModuleMap.get(tableName);
                List columnList = row.getColumns();
                this.createRow(moduleName, operation);
                String domain_Name = (String)row.get("DOMAIN_NAME");
                for (Object columnName : columnList) {
                    JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName.toString());
                    if (columnSyncDetails == null) continue;
                    JSONObject column = this.constructColumn(row, columnSyncDetails);
                    this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
                }
                String dcList = StringUtil.listToString(DomainDiscoveryListner.getDCCache(domain_Name));
                if (dcList == null) {
                    dcList = ELAPublisherImpl.getDCList(domain_Name);
                }
                this.addColumn("DCList", dcList, null);
                this.setCredentailDetails(row);
                this.addRowtoEvent();
            }
        } else if (tableName.equalsIgnoreCase("HostDetails")) {
            out.log(Level.FINE, "Skipping Add HostDetails module ");
        } else if (tableName.equalsIgnoreCase("ADSMailSettings")) {
            if (CommonUtil.isMailServerConfigured()) {
                super.addRow(row);
            } else {
                out.log(Level.FINE, "Skipping default mail configuration from syncing");
            }
        } else {
            super.addRow(row);
        }
    }

    private static String getDCList(String domainName) {
        List dcList = ADSDomainHandler.getDCList((String)domainName);
        return StringUtil.listToString(dcList);
    }

    private void setCredentailDetails(Row row) {
        try {
            Long credentialId = (Long)row.get("CREDENTIAL_ID");
            if (credentialId != null) {
                JSONObject credential = ADSDomainHandler.getCredential((Long)credentialId);
                if (credential != null) {
                    this.addColumn("UserName", credential.getString("USER_NAME"), null);
                    this.addColumn("Password", credential.getString("PASSWORD"), null);
                }
            } else {
                this.addColumn("UserName", "", null);
                this.addColumn("Password", "", null);
            }
        }
        catch (Exception e) {
            out.severe("Exception in elapublisher set crdentials:" + e);
        }
    }

    private boolean isCanbePublished(Long host_id) {
        boolean canbePublished = true;
        try {
            Row row = HostDBHandler.getHostDetailsRow(host_id);
            if (row != null) {
                canbePublished = (Integer)row.get("ISINHERITED") != 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return canbePublished;
    }

    private String getLogCollectionStatus(Long host_id) {
        try {
            return this.findLogCollectionStatus(HostDBHandler.getHostDetailsRow(host_id));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return "1";
        }
    }

    private String findLogCollectionStatus(Row row) {
        if (row != null) {
            int status;
            Object collection_status = row.get("LOG_COLLECTION_STATUS");
            int n = status = collection_status != null ? Integer.parseInt(collection_status.toString()) : 0;
            if (status == 0) {
                return "0";
            }
            return "1";
        }
        return "1";
    }

    public void addRow(Row row, List<String> columnList) throws Exception {
        int operation = row.getOperationIndex();
        String tableName = row.getOriginalTableName();
        out.log(Level.FINE, "EVENTLOG Publishing Row :" + row);
        if (tableName.equalsIgnoreCase("HostDetails")) {
            String moduleName = tableModuleMap.get(tableName);
            Properties prop = ELAPublisherImpl.getHostProperties((Long)row.get("HOST_ID"));
            if ("Windows".equals(prop.getProperty("TYPE"))) {
                String syncValue;
                List uniqueColumns = DBSyncModulesContainer.getUniqueTableColumnsForModule((String)moduleName);
                for (String uniqueColumn : uniqueColumns) {
                    if (columnList.contains(uniqueColumn)) continue;
                    columnList.add(uniqueColumn);
                }
                this.createRow(moduleName, operation);
                for (String columnName : columnList) {
                    JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName);
                    if (columnSyncDetails == null) continue;
                    JSONObject column = this.constructColumn(row, columnSyncDetails);
                    this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
                }
                if (prop.containsKey("HOST_NAME")) {
                    syncValue = prop.getProperty("HOST_NAME");
                    this.addColumn("HOST_NAME", syncValue, syncValue);
                }
                if (prop.containsKey("DOMAIN_NAME")) {
                    syncValue = prop.getProperty("DOMAIN_NAME");
                    this.addColumn("DOMAIN_NAME", syncValue, null);
                }
                this.addColumn("PRODUCT_SEQ_NUMBER", ProductUniqueSeqGenerator.getCurrentSeqNumber(), null);
                this.addColumn("LICENSE_CODE", LicenseManager.getLicenseCode(), null);
                this.addColumn("HOST_STATUS", this.getLogCollectionStatus((Long)row.get("HOST_ID")), null);
                this.addRowtoEvent();
            } else {
                out.log(Level.FINE, "Skipping Update Host module because of non windows host --> " + prop.getProperty("HOST_NAME"));
            }
        } else if (tableName.equalsIgnoreCase(ADSDomainHandler.tableName)) {
            String moduleName = tableModuleMap.get(tableName);
            List uniqueColumns = DBSyncModulesContainer.getUniqueTableColumnsForModule((String)moduleName);
            for (String uniqueColumn : uniqueColumns) {
                if (columnList.contains(uniqueColumn)) continue;
                columnList.add(uniqueColumn);
            }
            String[] authColumns = new String[]{"IS_AUTHENTICATION_REQUIRED", "USER_DISTINGUISHED_NAME", "PASSWORD"};
            boolean containsAuthChanges = false;
            for (String string : authColumns) {
                if (!columnList.contains(string)) continue;
                containsAuthChanges = true;
                break;
            }
            if (containsAuthChanges) {
                for (String string : authColumns) {
                    if (columnList.contains(string)) continue;
                    columnList.add(string);
                }
            }
            this.createRow(moduleName, operation);
            for (String columnName : columnList) {
                JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName);
                if (columnSyncDetails == null) continue;
                JSONObject jSONObject = this.constructColumn(row, columnSyncDetails);
                this.addColumn(jSONObject.getString("NAME"), jSONObject.getString("VALUE"), jSONObject.getString("ORIGINAL_VALUE"));
            }
            this.addColumn("DCList", ELAPublisherImpl.getDCList(row.get("DOMAIN_NAME").toString()).toString(), null);
            this.addRowtoEvent();
        } else {
            super.addRow(row, columnList);
        }
    }

    private JSONObject constructColumn(Row row, JSONObject columnSyncDetails) throws Exception {
        JSONObject result = new JSONObject();
        Object value = null;
        Object originalValue = row.getOriginalValue(columnSyncDetails.getString("COLUMN_NAME"));
        if (columnSyncDetails != null) {
            value = row.get(columnSyncDetails.getString("COLUMN_NAME"));
            String stringValue = value == null ? null : value.toString();
            value = DBSyncModulesContainer.getColumnValue((String)row.getOriginalTableName(), (String)columnSyncDetails.getString("COLUMN_NAME"), (String)stringValue, (JSONObject)columnSyncDetails);
            stringValue = originalValue == null ? null : originalValue.toString();
            originalValue = DBSyncModulesContainer.getColumnValue((String)row.getOriginalTableName(), (String)columnSyncDetails.getString("COLUMN_NAME"), (String)stringValue, (JSONObject)columnSyncDetails);
        }
        result.put("NAME", (Object)columnSyncDetails.getString("MODULE_COLUMN_NAME"));
        if (value != null) {
            result.put("VALUE", (Object)value.toString());
        } else {
            result.put("VALUE", JSONObject.NULL);
        }
        if (originalValue != null) {
            result.put("ORIGINAL_VALUE", (Object)originalValue.toString());
        } else {
            result.put("ORIGINAL_VALUE", JSONObject.NULL);
        }
        return result;
    }

    public static Properties getHostProperties(Long hostID) {
        Properties prop = new Properties();
        try {
            if (HostDBHandler.hostNameVsTypeMap.containsKey(hostID)) {
                prop.putAll((Map<?, ?>)HostDBHandler.hostNameVsTypeMap.get(hostID));
                if (prop.containsKey("HOST_NAME")) {
                    prop.put("HOST_NAME", ELAPublisherImpl.gethostNameFromHostName(prop.getProperty("HOST_NAME")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    private static String gethostNameFromHostName(String hostDNsName) throws Exception {
        if (!InetAddressHandler.isValidInet4Address(hostDNsName)) {
            return ELAPublisherImpl.checkForDNSSuffix(hostDNsName);
        }
        InetAddress address = InetAddressHandler.getInetAddress(hostDNsName);
        String hostName = address.getHostName();
        if (InetAddressHandler.isValidInet4Address(hostDNsName)) {
            throw new Exception("Unable to resolve Host Name  " + hostName + " hence cannot be synced with ADAP");
        }
        return ELAPublisherImpl.checkForDNSSuffix(hostName);
    }

    private static String checkForDNSSuffix(String hostName) {
        if (hostName.indexOf(".") != -1) {
            return hostName.substring(0, hostName.indexOf("."));
        }
        return hostName;
    }

    static {
        try {
            HostDBHandler.reloadHoastCache();
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }
}

