/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.dbsync.domain;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.QueryConstructionException;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.HostDBHandler;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ela.server.common.handlers.domain.DomainHandler;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;

public class DomainSyncHandler {
    private static Persistence persistenceLite = PersistenceDBUtil.getPersistenceLite();
    private static final Logger LOGGER = Logger.getLogger(HostDBHandler.class.getName());

    public static void updateSlstate(String domainName) throws Exception {
        DomainHandler.updateSlstate(domainName);
    }

    public static boolean deleteAssociatedHosts(String domainName, String sourceStamp) throws Exception {
        boolean flag = false;
        try {
            Long domainID;
            if (sourceStamp == null) {
                LOGGER.info("WARNING : Request processed based on Old ADAP request  deleteAssociatedHosts");
                LOGGER.info("Source Stamp Not found for domain delete Operation of : " + domainName);
            }
            if ((domainID = HostDBHandler.getDomainID(domainName)) == null) {
                throw new Exception("No such domain configured : " + domainName);
            }
            Properties prop = new Properties();
            prop.setProperty("DOMAIN_NAME", domainName);
            Criteria crit = new Criteria(Column.getColumn((String)"HostDetails", (String)"DOMAIN_ID"), (Object)domainID, 0);
            if (sourceStamp != null) {
                Criteria temp = new Criteria(Column.getColumn((String)"HostDetails", (String)"SOURCE_PRODUCT"), (Object)sourceStamp, 0);
                temp = temp.or(new Criteria(Column.getColumn((String)"HostDetails", (String)"SOURCE_PRODUCT"), null, 0));
                crit = crit.and(temp);
            }
            crit = crit.and(new Criteria(Column.getColumn((String)"HostDetails", (String)"ISINHERITED"), (Object)new Integer(1), 0));
            DataObject doo = persistenceLite.get("HostDetails", crit);
            LOGGER.info("Total Hosts to be deleted : " + doo.size("EventlogHostDomainMapping"));
            Iterator itr = doo.getRows("HostDetails");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                try {
                    prop.put("ELA_HOST_ID", row.get("HOST_ID"));
                    HostDBHandler.deleteHost(prop);
                }
                catch (Exception exp) {
                    LOGGER.info("Unable to Delete Host : " + row.get("HOST_NAME") + "   Reason : " + exp.getMessage());
                }
            }
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static int getHostEntriesCount(String sourceStamp) throws SQLException, QueryConstructionException {
        int rowCount = 0;
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"HostDetails"));
        Criteria crit = new Criteria(Column.getColumn((String)"HostDetails", (String)"SOURCE_PRODUCT"), (Object)sourceStamp, 0);
        query.addSelectColumn(new Column(null, "*").count());
        query.setCriteria(crit);
        RelationalAPI relAPI = RelationalAPI.getInstance();
        DataSet dataSet = relAPI.executeQuery((Query)query, relAPI.getConnection());
        while (dataSet.next()) {
            rowCount = (Integer)dataSet.getValue(1);
        }
        dataSet.close();
        return rowCount;
    }

    public static Properties getDomainFromAAALogin(String loginName) {
        Properties properties = new Properties();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)loginName, 0, false);
            DataObject dataObject = DataAccess.get((String)"AaaLogin", (Criteria)criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getFirstRow("AaaLogin");
                String domainName = (String)row.get("DOMAINNAME");
                properties.setProperty("DOMAINNAME", domainName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static Properties getDomainDetails(String aaaLoginDomainNAme) {
        Properties properties = new Properties();
        try {
            Row row = DomainSyncHandler.getDomainDetailsRow(aaaLoginDomainNAme);
            if (row != null) {
                String domainName = (String)row.get("DOMAIN_NAME");
                properties.setProperty("DOMAIN_NAME", domainName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static Row getDomainDetailsRow(String domainName) {
        Row result = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)ADSDomainHandler.tableName, (String)"DOMAIN_DNS_NAME"), (Object)domainName, 0, false);
            criteria = criteria.or(Column.getColumn((String)ADSDomainHandler.tableName, (String)"DOMAIN_FLAT_NAME"), (Object)domainName, 0, false);
            criteria = criteria.or(Column.getColumn((String)ADSDomainHandler.tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            DataObject dataObject = DataAccess.get((String)ADSDomainHandler.tableName, (Criteria)criteria);
            if (!dataObject.isEmpty()) {
                result = dataObject.getFirstRow(ADSDomainHandler.tableName);
            }
        }
        catch (Exception exp) {
            LOGGER.info("Exception in DomainDetails Row: " + exp.getMessage());
        }
        return result;
    }
}

