/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.dbsync.host;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.sa.server.dbsync.host.HostActionDetails;
import com.adventnet.sa.server.util.HostDBHandler;
import com.manageengine.ads.fw.api.RestAPI;
import com.manageengine.ads.fw.api.RestAPIUtil;
import com.manageengine.ads.fw.service.util.ProductUniqueSeqGenerator;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HostBatchExecutor {
    private static Logger out = Logger.getLogger("ADSDBSyncLogger");
    private static final int MAXLIMIT = 1000;
    private static HashMap<String, HashMap<String, List<HostActionDetails>>> pendingActions = new HashMap();
    private static int currentLimit = 0;
    private static final String CONVERT_HOST_API = "CONVERT_HOST_AND_INHERITEDHOST";

    public static void add(String seqNumber, String domain, HostActionDetails details) throws DataAccessException {
        if (currentLimit == 1000) {
            out.info("Max Limit Reached going to call Batchupdate");
            HostBatchExecutor.batchUpdate();
        }
        if (seqNumber != null && domain != null && details != null) {
            HostBatchExecutor.checkAndAddDetails(seqNumber, domain, details);
        } else {
            out.info("Invalid Entries, null value found");
        }
    }

    private static void checkAndAddDetails(String seqNumber, String domain, HostActionDetails details) {
        if (pendingActions.containsKey(seqNumber)) {
            HashMap<String, List<HostActionDetails>> tempPMap = pendingActions.get(seqNumber);
            List<Object> list = null;
            if (tempPMap.containsKey(domain)) {
                list = tempPMap.get(domain);
            } else {
                list = new ArrayList();
                tempPMap.put(domain, list);
            }
            list.add(details);
        } else {
            HashMap tempPMap = new HashMap();
            ArrayList<HostActionDetails> list = new ArrayList<HostActionDetails>();
            list.add(details);
            tempPMap.put(domain, list);
            pendingActions.put(seqNumber, tempPMap);
        }
        ++currentLimit;
    }

    public static void removeHost(String seqNumber, String domain, String hostName) {
        if (pendingActions.containsKey(seqNumber)) {
            HashMap<String, List<HostActionDetails>> tempPMap = pendingActions.get(seqNumber);
            if (tempPMap.containsKey(domain)) {
                List<HostActionDetails> list = tempPMap.get(domain);
                for (HostActionDetails host : list) {
                    if (!hostName.equals(host.getHostName())) continue;
                    list.remove(host);
                    --currentLimit;
                    out.info("Requested Host Was removed from list");
                }
            } else {
                out.info("Requested Domain not found");
            }
        } else {
            out.info("Requested Product not found in pending action");
        }
    }

    public static void removeDomain(String seqNumber, String domain) {
        if (pendingActions.containsKey(seqNumber)) {
            HashMap<String, List<HostActionDetails>> tempPMap = pendingActions.get(seqNumber);
            if (tempPMap.containsKey(domain)) {
                List<HostActionDetails> list = tempPMap.get(domain);
                tempPMap.remove(domain);
                currentLimit -= list.size();
            } else {
                out.info("Requested Domain not found");
            }
        } else {
            out.info("Requested Product not found in pending action");
        }
    }

    private static void batchUpdate() throws DataAccessException {
        out.info("##################  Batch update Action called ##################");
        out.info("pendingActions : " + pendingActions);
        Object parentProduct = HostBatchExecutor.getParentParoductSeqNumber();
        Set<Map.Entry<String, HashMap<String, List<HostActionDetails>>>> products = pendingActions.entrySet();
        for (Map.Entry<String, HashMap<String, List<HostActionDetails>>> set : products) {
            out.info("Selected Product :" + set.getKey());
            try {
                JSONObject json = new JSONObject();
                Set<Map.Entry<String, List<HostActionDetails>>> domains = set.getValue().entrySet();
                for (Map.Entry<String, List<HostActionDetails>> subSet : domains) {
                    out.info("Selected Domain :" + subSet.getKey());
                    try {
                        json.put(subSet.getKey(), HostBatchExecutor.loadDomainDetailsBasedOnAction(subSet.getValue()));
                    }
                    catch (JSONException e) {
                        out.info("Problem while Processing following domain : " + subSet.getKey());
                        e.printStackTrace();
                    }
                    out.info("Selected Domain :" + subSet.getKey() + "  Conversions completed");
                }
                HostBatchExecutor.processInheritedHosts(json, set.getKey(), parentProduct);
            }
            catch (Exception exp) {
                out.info("Problem while Processing following product : " + set.getKey());
            }
            out.info("Selected Product :" + set.getKey() + "  Conversions completed");
        }
        currentLimit = 0;
        pendingActions.clear();
    }

    private static Object loadDomainDetailsBasedOnAction(List<HostActionDetails> value) throws JSONException {
        JSONObject json = new JSONObject();
        for (HostActionDetails host : value) {
            if ("DBSYNC_CONVERTTO_HOST".equals(host.getAction())) {
                HostBatchExecutor.loadHostBasedOnAction("DBSYNC_CONVERTTO_HOST", json, host);
                continue;
            }
            if (!"DBSYNC_CONVERTTO_INHHOST".equals(host.getAction())) continue;
            HostBatchExecutor.loadHostBasedOnAction("DBSYNC_CONVERTTO_INHHOST", json, host);
        }
        return json;
    }

    private static void loadHostBasedOnAction(String limiter, JSONObject parrentJson, HostActionDetails host) throws JSONException {
        JSONObject json = null;
        if (parrentJson.has(limiter)) {
            json = parrentJson.getJSONObject(limiter);
        } else {
            json = new JSONObject();
            parrentJson.put(limiter, (Object)json);
        }
        JSONArray array = null;
        if (host.getHostStatus() != 0) {
            if (json.has("DBSYNC_HOST_ENABLED")) {
                array = json.getJSONArray("DBSYNC_HOST_ENABLED");
            } else {
                array = new JSONArray();
                json.put("DBSYNC_HOST_ENABLED", (Object)array);
            }
        } else if (json.has("DBSYNC_HOST_DISABLED")) {
            array = json.getJSONArray("DBSYNC_HOST_DISABLED");
        } else {
            array = new JSONArray();
            json.put("DBSYNC_HOST_ENABLED", (Object)array);
        }
        array.put((Object)host.getHostName());
    }

    private static void processInheritedHosts(JSONObject json, String product_seqNumber, Object parentProduct) throws Exception {
        Iterator domains = json.keys();
        while (domains.hasNext()) {
            JSONArray requestArray;
            JSONObject sampleJson;
            String domainName = (String)domains.next();
            JSONObject hostCategry = json.getJSONObject(domainName);
            JSONObject requestJsonObject = new JSONObject();
            ArrayList<String> failedHosts = new ArrayList<String>();
            if (hostCategry.has("DBSYNC_CONVERTTO_HOST")) {
                sampleJson = hostCategry.getJSONObject("DBSYNC_CONVERTTO_HOST");
                requestArray = new JSONArray();
                if (sampleJson.has("DBSYNC_HOST_ENABLED")) {
                    HostBatchExecutor.loadJsonArrayToJsonArray(requestArray, sampleJson.getJSONArray("DBSYNC_HOST_ENABLED"));
                } else {
                    HostBatchExecutor.loadJsonArrayToJsonArray(requestArray, sampleJson.getJSONArray("DBSYNC_HOST_DISABLED"));
                }
                HostBatchExecutor.jsonArrayToList(failedHosts, requestArray);
                requestJsonObject.put("DBSYNC_CONVERTTO_HOST", (Object)requestArray);
            }
            if (hostCategry.has("DBSYNC_CONVERTTO_INHHOST")) {
                sampleJson = hostCategry.getJSONObject("DBSYNC_CONVERTTO_INHHOST");
                requestArray = new JSONArray();
                if (sampleJson.has("DBSYNC_HOST_ENABLED")) {
                    HostBatchExecutor.loadJsonArrayToJsonArray(requestArray, sampleJson.getJSONArray("DBSYNC_HOST_ENABLED"));
                } else {
                    HostBatchExecutor.loadJsonArrayToJsonArray(requestArray, sampleJson.getJSONArray("DBSYNC_HOST_DISABLED"));
                }
                HostBatchExecutor.jsonArrayToList(failedHosts, requestArray);
                requestJsonObject.put("DBSYNC_CONVERTTO_INHHOST", (Object)requestArray);
            }
            HostBatchExecutor.addEventlogHostBasedOnResult(product_seqNumber, domainName, hostCategry, failedHosts);
            HostBatchExecutor.switchHostAndInheritedHost(parentProduct, product_seqNumber, domainName, requestJsonObject, failedHosts);
        }
        out.info("processInheritedHosts method Completed Process");
    }

    private static void addEventlogHostBasedOnResult(String product_seqNumber, String domainName, JSONObject hostCategry, List<String> failedHosts) throws Exception {
        JSONObject sampleJson;
        if (hostCategry.has("DBSYNC_CONVERTTO_HOST")) {
            sampleJson = hostCategry.getJSONObject("DBSYNC_CONVERTTO_HOST");
            if (sampleJson.has("DBSYNC_HOST_ENABLED")) {
                HostBatchExecutor.addAllHosts(product_seqNumber, domainName, sampleJson.getJSONArray("DBSYNC_HOST_ENABLED"), failedHosts, 1, true);
            } else {
                HostBatchExecutor.addAllHosts(product_seqNumber, domainName, sampleJson.getJSONArray("DBSYNC_HOST_ENABLED"), failedHosts, 0, true);
            }
        }
        if (hostCategry.has("DBSYNC_CONVERTTO_INHHOST")) {
            sampleJson = hostCategry.getJSONObject("DBSYNC_CONVERTTO_INHHOST");
            if (sampleJson.has("DBSYNC_HOST_ENABLED")) {
                HostBatchExecutor.addAllHosts(product_seqNumber, domainName, sampleJson.getJSONArray("DBSYNC_HOST_ENABLED"), failedHosts, 1, false);
            } else {
                HostBatchExecutor.addAllHosts(product_seqNumber, domainName, sampleJson.getJSONArray("DBSYNC_HOST_ENABLED"), failedHosts, 0, false);
            }
        }
    }

    private static void addAllHosts(String seqNumber, String domain, JSONArray array, List<String> failedList, int status, boolean isInherited) throws JSONException, Exception {
        Long domainID = HostDBHandler.getDomainID(domain);
        for (int index = 0; index < array.length(); ++index) {
            if (failedList.contains(array.getString(index))) {
                HostDBHandler.addNewEventlogHost(array.getString(index), null, domainID, seqNumber, "", status, !isInherited);
                continue;
            }
            HostDBHandler.addNewEventlogHost(array.getString(index), null, domainID, seqNumber, "", status, isInherited);
        }
        out.info("Hosts are successfully added in EventllogAnalyzer");
    }

    private static boolean switchHostAndInheritedHost(Object parentProduct, String product_seqNumber, String domainName, JSONObject requestJsonObject, List<String> failedHosts) {
        if (domainName == null || requestJsonObject == null) {
            out.fine("Unable to process request hostname or domain name becomes null  : " + requestJsonObject + " , " + domainName);
            return false;
        }
        try {
            Properties params = new Properties();
            params.setProperty("DOMAIN_NAME", domainName);
            params.setProperty("HOSTS_LIST", requestJsonObject.toString());
            params.setProperty("SEQUENCE_ID", ProductUniqueSeqGenerator.getCurrentSeqNumber());
            params.setProperty("DESTINATION_SEQUENCE_NUMBER", product_seqNumber);
            Criteria crit = new Criteria(Column.getColumn((String)"ADSProductDetails", (String)"SEQUENCE_ID"), parentProduct, 0);
            DataObject dobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSProductDetails", crit);
            if (!dobj.isEmpty()) {
                RestAPI api = new RestAPI();
                api.execute(RestAPIUtil.getAPIId((Long)((Long)dobj.getFirstValue("ADSProductDetails", "PRODUCT_ID")), (String)CONVERT_HOST_API), params);
                JSONObject responseResult = api.getResponseJSON();
                out.info("responseResult in ADAP: " + responseResult);
                if (responseResult.has("sSTATUS") && responseResult.getString("sSTATUS").equalsIgnoreCase("SUCCESS")) {
                    failedHosts.clear();
                    return true;
                }
                if (responseResult.has("FAILED_HOSTDETAILS")) {
                    failedHosts.clear();
                    HostBatchExecutor.jsonArrayToList(failedHosts, responseResult.getJSONArray("FAILED_HOSTDETAILS"));
                    out.info("Failed for Following hosts");
                } else {
                    out.info("No Object found in failed List");
                }
                out.info("Failed to Update Details in remote server for host  : " + requestJsonObject + " details : " + responseResult);
                return false;
            }
            out.info("Unable to Find product API");
            return false;
        }
        catch (Exception exp) {
            out.info("Exception while processing remote product exception details : " + exp.getMessage());
            return false;
        }
    }

    private static void jsonArrayToList(List<String> failedHosts, JSONArray jsonArray) throws JSONException {
        for (int index = 0; index < jsonArray.length(); ++index) {
            failedHosts.add(jsonArray.getString(index));
        }
    }

    private static void loadJsonArrayToJsonArray(JSONArray requestArray, JSONArray jsonArray) throws JSONException {
        for (int index = 0; index < jsonArray.length(); ++index) {
            requestArray.put(jsonArray.get(index));
        }
    }

    public static void forceSync() {
        try {
            HostBatchExecutor.batchUpdate();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private static Object getParentParoductSeqNumber() throws DataAccessException {
        Criteria crit = new Criteria(Column.getColumn((String)"ADSProductParams", (String)"PARAM_NAME"), (Object)"PARENT_APP_SEQNO", 0);
        DataObject dobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSProductParams", crit);
        if (!dobj.isEmpty()) {
            return dobj.getFirstValue("ADSProductParams", "PARAM_VALUE");
        }
        return null;
    }
}

