/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.enterprise.dc;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.enterprise.EnterpriseException;
import com.adventnet.la.enterprise.dc.DataCollector;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.json.JSONObject;

public class ELADataCollector
extends DataCollector {
    private static final Logger LOGGER = Logger.getLogger(ELADataCollector.class.getName());
    private static boolean isCentralArchiveEnabled = false;

    public ELADataCollector(Row details) throws EnterpriseException {
        super(details);
    }

    protected void processCentralArchive(BufferedReader br, String end) throws EnterpriseException {
        try {
            boolean isScpfileTransferComplete = false;
            JSONObject successArchives = new JSONObject();
            ArrayList<String> afidList = new ArrayList<String>();
            ArrayList<Long> successAfidList = new ArrayList<Long>();
            String line = null;
            while ((line = br.readLine()) != null) {
                LOGGER.log(Level.FINE, line);
                if (line.indexOf("isScpfileTransferComplete") != -1) {
                    isScpfileTransferComplete = "true".equals(line.substring(line.indexOf("=") + 1));
                    continue;
                }
                if (line.equals(end)) {
                    this.updateLicenseManager = true;
                    continue;
                }
                if ("".equals(line)) continue;
                successArchives = new JSONObject(line);
                Iterator iterator = successArchives.keys();
                while (iterator.hasNext()) {
                    String key = iterator.next().toString();
                    afidList.add(key);
                }
            }
            LOGGER.log(Level.FINE, "SCP File Transfer Status <-> {0}", isScpfileTransferComplete);
            if (isScpfileTransferComplete) {
                LOGGER.log(Level.FINE, "Files received in AS process started");
                LOGGER.log(Level.FINE, "AFIDs to process <-> {0}", afidList);
                String archiveHome = System.getProperty("server.home") + File.separator + "archive";
                Criteria nameCrit = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"sysArchiveLocation", 0);
                Criteria valueCrit = new Criteria(new Column("SystemConfigurations", "CONF_VALUE"), (Object)"archive", 1);
                DataObject sysConfigDO = DataAccess.get((String)"SystemConfigurations", (Criteria)nameCrit.and(valueCrit));
                if (sysConfigDO.size("SystemConfigurations") > 0) {
                    archiveHome = (String)sysConfigDO.getFirstValue("SystemConfigurations", "CONF_VALUE");
                }
                archiveHome = archiveHome + File.separator + this.collectorID;
                LOGGER.log(Level.FINE, "AdminServer archiveHome <-> {0}", archiveHome);
                Table sysArchived = Table.getTable((String)"SysArchivedFiles");
                Column afidCol = Column.getColumn((String)"SysArchivedFiles", (String)"AFID");
                SelectQueryImpl selectQuery = new SelectQueryImpl(sysArchived);
                selectQuery.setCriteria(new Criteria(afidCol, (Object)afidList.toArray(), 8));
                selectQuery.addSortColumn(new SortColumn(afidCol, true));
                selectQuery.addSelectColumn(Column.getColumn((String)"SysArchivedFiles", (String)"*"));
                DataObject archiveDO = DataAccess.get((SelectQuery)selectQuery);
                Iterator archiveItr = archiveDO.getRows("SysArchivedFiles");
                while (archiveItr.hasNext()) {
                    Row archiveRow = (Row)archiveItr.next();
                    Long afid = (Long)archiveRow.get("AFID");
                    Long status = (Long)archiveRow.get("STATUS");
                    String fileName = (String)archiveRow.get("FILE_NAME");
                    int fileIndex = fileName.lastIndexOf("/");
                    fileIndex = fileIndex == -1 ? fileName.lastIndexOf("\\") : fileIndex;
                    LOGGER.log(Level.FINE, "{0} fileName before", fileName);
                    fileName = archiveHome + File.separator + fileName.substring(fileIndex + 1);
                    LOGGER.log(Level.FINE, "{0} fileName after", fileName);
                    Long checkSumInMS = successArchives.getLong(afid.toString());
                    if (new File(fileName).exists()) {
                        Long checkSumInAS = this.calculateChecksum(fileName);
                        LOGGER.log(Level.FINE, "FileName <-> {0} CheckSumInMS <-> {1} CheckSumInAS <-> {2}", new Object[]{fileName, checkSumInMS, checkSumInAS});
                        if (checkSumInMS.longValue() != checkSumInAS.longValue()) continue;
                        archiveRow.set("FILE_NAME", (Object)fileName);
                        archiveRow.set("STATUS", (Object)"10");
                        archiveDO.updateRow(archiveRow);
                        successAfidList.add(afid);
                        continue;
                    }
                    LOGGER.log(Level.FINE, "{0} is not found", fileName);
                }
                if (!successAfidList.isEmpty()) {
                    DataAccess.update((DataObject)archiveDO);
                    this.successAFIDs = this.convertToRange(successAfidList);
                    this.filesReceived = true;
                    LOGGER.log(Level.FINE, "Successfully transfered archives <-> {0}", successArchives);
                } else {
                    LOGGER.log(Level.FINE, "File Mismatched in Sync or Failed in CheckSum <-> {0}", successArchives);
                    this.filesReceived = false;
                }
            }
            LOGGER.log(Level.FINE, "Files received in AS process completed");
        }
        catch (Exception ioExp) {
            ioExp.printStackTrace();
            throw new EnterpriseException("Error while processing response from Collector", (Throwable)ioExp);
        }
    }

    protected void setCentralArchiveParams() {
        try {
            DataObject sysConfigDO = DataAccess.get((String)"SystemConfigurations", (Criteria)null);
            Criteria nameCrit = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"centralArchiveStatus", 0);
            Criteria valueCrit = new Criteria(new Column("SystemConfigurations", "CONF_VALUE"), (Object)"true", 0);
            Row statusRow = sysConfigDO.getRow("SystemConfigurations", nameCrit.and(valueCrit));
            if (statusRow == null) {
                isCentralArchiveEnabled = false;
                return;
            }
            isCentralArchiveEnabled = true;
            String sshParams = "";
            Iterator sshItr = sysConfigDO.getRows("SystemConfigurations");
            while (sshItr.hasNext()) {
                Row sshRow = (Row)sshItr.next();
                if ("SSHUserName".equals((String)sshRow.get("CONF_NAME"))) {
                    sshParams = sshParams + "&sshUserName=" + (String)sshRow.get("CONF_VALUE");
                    continue;
                }
                if ("SSHPassword".equals((String)sshRow.get("CONF_NAME"))) {
                    sshParams = sshParams + "&sshPassword=" + (String)sshRow.get("CONF_VALUE");
                    continue;
                }
                if (!"SSHPort".equals((String)sshRow.get("CONF_NAME"))) continue;
                sshParams = sshParams + "&sshPort=" + (String)sshRow.get("CONF_VALUE");
            }
            this.sshServerParams = sshParams + "&CID=" + this.collectorID;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while setting Central Archive params <-> {0}", e);
            e.printStackTrace();
        }
    }

    protected String addSSHParams(String url) {
        if (isCentralArchiveEnabled) {
            url = url + "&isCentralArchiveEnabled=" + isCentralArchiveEnabled;
            url = url + this.sshServerParams;
            if (this.filesReceived) {
                url = url + "&filesReceived=" + this.filesReceived;
                url = url + "&successAFIDs=" + this.successAFIDs;
                this.resetAfterTransfer = true;
            }
        }
        return url;
    }

    protected void resetScpVariables() {
        if (this.resetAfterTransfer) {
            LOGGER.log(Level.FINE, "Resetting SCP Variables");
            this.filesReceived = false;
            this.successAFIDs = "";
        }
        this.resetAfterTransfer = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Long calculateChecksum(String fileName) {
        Long checksum;
        block23: {
            checksum = null;
            FileInputStream file = null;
            BufferedInputStream in = null;
            file = new FileInputStream(fileName);
            CheckedInputStream check = new CheckedInputStream(file, new CRC32());
            in = new BufferedInputStream(check);
            int ch = 0;
            while ((ch = in.read()) != -1) {
            }
            checksum = check.getChecksum().getValue();
            LOGGER.log(Level.FINE, "Checksum for file <> {0} is <-> {1}", new Object[]{fileName, checksum});
            try {
                if (file != null) {
                    file.close();
                }
                if (in != null) {
                    in.close();
                }
                break block23;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception while clossing IO Strams, while calculating checksum for the file" + fileName + " <-> {0}", checksum);
            }
            break block23;
            catch (FileNotFoundException e) {
                LOGGER.log(Level.SEVERE, "File not found while calculating checksum for the file" + fileName + " <-> {0}", checksum);
                e.printStackTrace();
                try {
                    if (file != null) {
                        file.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e2) {
                    LOGGER.log(Level.SEVERE, "Exception while clossing IO Strams, while calculating checksum for the file" + fileName + " <-> {0}", checksum);
                }
            }
            catch (IOException e2) {
                LOGGER.log(Level.SEVERE, "IO Exception while calculating checksum for the file" + fileName + " <-> {0}", checksum);
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        try {
                            if (file != null) {
                                file.close();
                            }
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (Exception e3) {
                            LOGGER.log(Level.SEVERE, "Exception while clossing IO Strams, while calculating checksum for the file" + fileName + " <-> {0}", checksum);
                        }
                        throw throwable;
                    }
                }
                try {
                    if (file != null) {
                        file.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e4) {
                    LOGGER.log(Level.SEVERE, "Exception while clossing IO Strams, while calculating checksum for the file" + fileName + " <-> {0}", checksum);
                }
            }
        }
        return checksum;
    }

    private String convertToRange(ArrayList<Long> successArchives) {
        long rangeStart = 0L;
        long increment = 1L;
        String archiveRangeString = "";
        for (int index = 0; index < successArchives.size(); ++index) {
            long item = successArchives.get(index);
            if (index == 0) {
                rangeStart = item;
                increment = 1L;
                continue;
            }
            if (rangeStart + increment == item) {
                ++increment;
                if (index != successArchives.size() - 1) continue;
                archiveRangeString = archiveRangeString + rangeStart + "-" + item + ",";
                continue;
            }
            if (item != rangeStart) {
                archiveRangeString = archiveRangeString + rangeStart + "-" + item + ",";
            }
            if ("".equals(archiveRangeString)) {
                archiveRangeString = archiveRangeString + item + ",";
            } else if (archiveRangeString.indexOf(rangeStart + "-") != -1) {
                archiveRangeString = archiveRangeString + item + ",";
            }
            if (index == successArchives.size() - 1) {
                archiveRangeString = archiveRangeString + item + ",";
            }
            rangeStart = item;
            increment = 1L;
        }
        archiveRangeString = archiveRangeString.substring(0, archiveRangeString.length() - 1);
        LOGGER.finer("Range of successArchives :::: " + archiveRangeString);
        return archiveRangeString;
    }
}

