/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.enterprise.dc;

import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.enterprise.EnterpriseException;
import com.adventnet.la.enterprise.EnterpriseStartUpUtil;
import com.adventnet.la.enterprise.dc.DataRetriver;
import com.adventnet.la.enterprise.dc.DefaultDataSynchronizer;
import com.adventnet.la.enterprise.startup.StartUPUtil;
import com.adventnet.la.ssh.SSHUtils;
import com.adventnet.la.ssh.ScpFileUploader;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ELADataSynchronizer
extends DefaultDataSynchronizer {
    private HashMap specialTables = new HashMap();
    private DataRetriver dataRetriver;
    private HashMap insertTableVsQueryMap = null;
    private static final Logger LOGGER = Logger.getLogger(ELADataSynchronizer.class.getName());

    public ELADataSynchronizer(DataRetriver dataRetriver) {
        super(dataRetriver);
        this.dataRetriver = dataRetriver;
        this.specialTables.put("Hosts", "HOST_ID");
        this.specialTables.put("HostDetails", "HOST_ID");
        this.specialTables.put("HostGroupMapping", "HOSTID");
        this.exclTablesList.add("SysArchivedFiles");
        if ("DS".equals(System.getProperty("server.type"))) {
            this.loadDefaultInfo();
        }
    }

    public void clearCruncherDetails() throws EnterpriseException {
        super.clearCruncherDetails();
        try {
            UpdateQueryImpl query = new UpdateQueryImpl("HostDetails");
            query.setUpdateColumn("ISSYNCED", (Object)new Integer(0));
            DataAccess.update((UpdateQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EnterpriseException(e.getMessage(), (Throwable)e);
        }
    }

    public void syncTables(String tableName, String columnName, long cruncherPointer, OutputStream out) throws Exception {
        if (this.specialTables.containsKey(tableName)) {
            this.handleSpecialTables(tableName, columnName, cruncherPointer, out);
        } else {
            if ("SysArchivedFiles".equals(tableName)) {
                LOGGER.log(Level.FINE, "isScpfileTransferComplete <-> " + ScpFileUploader.isScpfileTransferComplete + " isScpThreadAlive <-> " + ScpFileUploader.isScpThreadAlive);
                if (ScpFileUploader.isCentralArchiveEnabled && !ScpFileUploader.isScpfileTransferComplete && !ScpFileUploader.isScpThreadAlive && !SSHUtils.getArchivedFileDO().isEmpty()) {
                    LOGGER.log(Level.FINE, "Initializing the Scp Thread ........");
                    ScpFileUploader scpuploader = new ScpFileUploader();
                    scpuploader.start();
                }
            }
            this.superSyncTables(tableName, columnName, cruncherPointer, out);
        }
    }

    private void superSyncTables(String tableName, String columnName, long cruncherPointer, OutputStream out) throws Exception {
        super.syncTables(tableName, columnName, cruncherPointer, out);
    }

    private void handleSpecialTables(String tableName2, String columnName, long cruncherPointer, OutputStream out) throws Exception {
        try {
            if ("HostDetails".equals(tableName2)) {
                Criteria syncCrit = new Criteria(new Column("HostDetails", "ISSYNCED"), (Object)0, 0);
                DataObject syncDO = DataAccess.get((String)"HostDetails", (Criteria)syncCrit);
                int size = syncDO.size("HostDetails");
                if (size == -1) {
                    return;
                }
                long[] range = new long[size];
                int i = 0;
                Iterator syncItr = syncDO.getRows("HostDetails");
                while (syncItr.hasNext()) {
                    Row syncRow = (Row)syncItr.next();
                    range[i++] = (Long)syncRow.get("HOST_ID");
                    syncRow.set("ISSYNCED", (Object)new Integer(1));
                    syncDO.updateRow(syncRow);
                }
                long maxCount = this.dataRetriver.getCountFor(tableName2, cruncherPointer);
                for (String tableName2 : this.specialTables.keySet()) {
                    columnName = (String)this.specialTables.get(tableName2);
                    this.superSyncSpecialTables(tableName2, columnName, range, cruncherPointer, maxCount, out, "HostDetails", "HOST_ID", "ISSYNCED", "0");
                }
                DataAccess.update((DataObject)syncDO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void superSyncSpecialTables(String tableName, String columnName, long[] range, long cruncherPointer, long maxCount, OutputStream out, String joinTableName, String joinColumnName, String joinCriteriColumnName, String joinCriteriaValue) throws Exception {
        super.syncSpecialTables(tableName, columnName, range, cruncherPointer, maxCount, out, joinTableName, joinColumnName, joinCriteriColumnName, joinCriteriaValue);
    }

    protected void loadDefaultInfo() {
        HashMap<String, String> delUpdateFKMap = new HashMap<String, String>();
        delUpdateFKMap.put("Hosts", "HOST_ID");
        delUpdateFKMap.put("HostDetails", "HOST_ID");
        delUpdateFKMap.put("HostGroupMapping", "HOSTID");
        delUpdateFKMap.put("HostFilter", "HOSTID");
        delUpdateFKMap.put("HostNotification", "HOSTID");
        delUpdateFKMap.put("Hosts2ReportConfig", "HOST_ID");
        delUpdateFKMap.put("SysArchivedFiles", "HOST_ID");
        delUpdateFKMap.put("AppResources", "HOSTID");
        delUpdateFKMap.put("ImportedLogs", "HOST_ID");
        this.duListener.setFKTableVsColumnMap(delUpdateFKMap);
        this.insertTableVsQueryMap = new HashMap();
        String[] insertTables = new String[]{"Hosts", "HostDetails", "HostGroupMapping", "HostFilter", "HostNotification", "Hosts2ReportConfig", "SysArchivedFiles", "AppResources", "ImportedLogs"};
        String[] insertColumns = new String[]{"HOST_ID", "HOST_ID", "HOSTID", "HOSTID", "HOSTID", "HOST_ID", "HOST_ID", "HOSTID", "HOST_ID"};
        try {
            for (int i = 0; i < insertTables.length; ++i) {
                String query = this.getSyncInsertQuery(insertTables[i], insertColumns[i]);
                this.insertTableVsQueryMap.put(insertTables[i], query);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getSyncInsertQuery(String tableName, String columnName) {
        long collectorStartID = EnterpriseStartUpUtil.getCollectorStartID();
        String query = "";
        try {
            TableDefinition tdf = MetaDataUtil.getTableDefinitionByName((String)tableName);
            if (tdf == null) {
                LOGGER.log(Level.FINER, "WARNING : Table - " + tableName + " is not available");
                return query;
            }
            List<String> columns = tdf.getColumnNames();
            if (StartUPUtil.getInstance().getCustomColumnOrderJsonObj().has(tableName)) {
                String tempColumns = StartUPUtil.getInstance().getCustomColumnOrderJsonObj().get(tableName).toString();
                if (tempColumns.length() > 1) {
                    columns = Arrays.asList(tempColumns.substring(1, tempColumns.length() - 1).split(","));
                }
                LOGGER.log(Level.FINER, "NOTE: Using Admin Server Column order for  " + tableName + " order is " + columns.toString());
            }
            StringBuffer sb = new StringBuffer("select ");
            for (int i = 0; i < columns.size(); ++i) {
                String cName = (String)columns.get(i);
                if (cName.equals(columnName)) {
                    String cNamewithTName = cName;
                    if (this.specialTables.containsKey(tableName)) {
                        cNamewithTName = tableName + "." + cName;
                    }
                    sb.append("( CASE WHEN " + cNamewithTName + " >= " + collectorStartID + " THEN " + cNamewithTName);
                    sb.append(" ELSE (" + cNamewithTName + " + " + collectorStartID + ") END )");
                    sb.append(" as ");
                }
                sb.append(cName);
                if (i >= columns.size() - 1) continue;
                sb.append(",");
            }
            sb.append(" from ");
            LOGGER.log(Level.FINER, "Converted collector's SyncInsertQuery for " + tableName + " is :: " + sb.toString());
            query = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return query;
    }

    protected void handleSelectDataToOutfile(String tableName, String columnName, long[] range, String fileName, boolean isJoin, String joinTableName, String joinColumnName, String joinCriteriColumnName, String joinCriteriaValue) {
        try {
            if (this.insertTableVsQueryMap == null || this.insertTableVsQueryMap.get(tableName) == null) {
                if (isJoin) {
                    this.dataRetriver.selectDataToOutfile(tableName, columnName, fileName, joinTableName, joinColumnName, joinCriteriColumnName, joinCriteriaValue);
                } else {
                    this.dataRetriver.selectDataToOutfile(tableName, columnName, range, fileName);
                }
            } else {
                String query = (String)this.insertTableVsQueryMap.get(tableName);
                if (isJoin) {
                    this.dataRetriver.selectDataToOutfile(query, tableName, columnName, fileName, joinTableName, joinColumnName, joinCriteriColumnName, joinCriteriaValue);
                } else {
                    this.dataRetriver.selectDataToOutfile(query, tableName, columnName, range, fileName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean getCentralArchiveStatus() {
        boolean status = false;
        try {
            Criteria nameCrit = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"centralArchiveStatus", 0);
            Criteria valueCrit = new Criteria(new Column("SystemConfigurations", "CONF_VALUE"), (Object)"true", 0);
            DataObject sysConfigDO = DataAccess.get((String)"SystemConfigurations", (Criteria)nameCrit.and(valueCrit));
            if (sysConfigDO.size("SystemConfigurations") > 0) {
                status = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }
}

