/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.fieldgen;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.fieldgen.LogFormatHandler;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.imp.ImportAppLogManager;
import com.adventnet.sa.server.lc.FieldRepository;
import com.adventnet.sa.server.parser.DbUtil;
import com.adventnet.sa.server.univlogparser.SyslogHandlerInitializer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogFormatHandlerImpl
implements LogFormatHandler {
    private static LogFormatHandlerImpl handlerImpl = null;
    private static final Logger LOGGER = Logger.getLogger(LogFormatHandlerImpl.class.getName());

    private LogFormatHandlerImpl() {
    }

    public static synchronized LogFormatHandlerImpl getInstance() {
        if (handlerImpl == null) {
            handlerImpl = new LogFormatHandlerImpl();
        }
        return handlerImpl;
    }

    public Map<Long, String> getIdVsLogTypeNameMap() {
        return DbUtil.get_instance().getAppIdVsLogTypeNameMap();
    }

    public boolean isDefaultType(String logType, long formatId) {
        String formatName;
        if (formatId > -1L && (formatName = DbUtil.get_instance().getLogTypeNameForFormatId(formatId)) != null && formatName.equalsIgnoreCase(logType)) {
            return true;
        }
        return FieldRepository.get_instance().isDefaultLogType(logType);
    }

    public long addFormatDetailsInToTable(String formatName) {
        try {
            DataObject dataObj = DataAccess.constructDataObject();
            Row row = new Row("FormatDetails");
            row.set("FORMATNAME", (Object)formatName);
            row.set("FORMATDESC", (Object)formatName);
            row.set("ISTABLECREATED", (Object)1);
            row.set("HRTRENDTABLENAME", (Object)"app_hr_trend_sa");
            row.set("REPORTTABLENAME", (Object)"app_reports_hr_trend_sa");
            dataObj.addRow(row);
            DataAccess.add((DataObject)dataObj);
            LOGGER.log(Level.FINER, "In LogFormatHandler.addFormatDetailsInToTable added dataObj for formatName - {0} is -- {1}", new Object[]{formatName, dataObj});
            long formatId = (Long)dataObj.getRow("FormatDetails").get("FORMATID");
            DbUtil.get_instance().addToFormatMap(formatId, formatName);
            return formatId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public void deleteLogTypeFromDB(long formatId) {
        try {
            Criteria crit = new Criteria(new Column("FormatDetails", "FORMATID"), (Object)formatId, 0);
            DataAccess.delete((String)"FormatDetails", (Criteria)crit);
            SyslogHandlerInitializer.getInstance().clearAllLernings();
            boolean isDefType = this.isDefaultType("null", formatId);
            DbUtil.get_instance().deleteFromFormatMap(formatId);
            if (!isDefType) {
                String tableName = "ImportedAppLogs";
                SelectQueryImpl query = new SelectQueryImpl(new Table(tableName));
                query.addSelectColumn(new Column(tableName, "*"));
                Criteria appLogsCrit = new Criteria(new Column(tableName, "FORMATID"), (Object)formatId, 0);
                query.setCriteria(appLogsCrit);
                Persistence persistence = PersistenceDBUtil.getPersistence();
                DataObject obj = DataAccess.get((SelectQuery)query);
                Iterator itr = obj.getRows(tableName);
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    Long ilid = (Long)row.get("IL_ID");
                    int outVal = ImportAppLogManager.get_instance().disableImport(ilid);
                    persistence.delete(row);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void changeFormatNameFromTable(long formatId, String newFormatName) {
        try {
            String tableName = "FormatDetails";
            UpdateQueryImpl query = new UpdateQueryImpl(tableName);
            Criteria crt = new Criteria(new Column(tableName, "FORMATID"), (Object)formatId, 0);
            query.setCriteria(crt);
            query.setUpdateColumn("FORMATNAME", (Object)newFormatName);
            query.setUpdateColumn("FORMATDESC", (Object)newFormatName);
            DataAccess.update((UpdateQuery)query);
            DbUtil.get_instance().updateFormatNameIntoMap(formatId, newFormatName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFormatNameForId(long formatId) {
        return DbUtil.get_instance().getLogTypeNameForFormatId(formatId);
    }

    public long getFormatIdForName(String formatName) {
        Long fId = DbUtil.get_instance().getFormatIdForLogType(formatName);
        if (fId == null && (fId = DbUtil.get_instance().getFormatId(formatName)) == null) {
            return -1L;
        }
        return fId;
    }

    public List getIndexedFields(String key) {
        return FieldRepository.get_instance().getIndexedFields(key);
    }
}

