/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.identifier;

import com.adventnet.sa.server.identifier.IdentityRule;
import com.adventnet.sa.server.identifier.IdentityRuleSet;
import com.adventnet.sa.server.identifier.IdentityRulesPopulator;
import com.adventnet.sa.server.identifier.ParserDetails;
import com.adventnet.sa.server.imp.ImportConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Identifier {
    private static Identifier _instance = null;
    private ArrayList parserList = null;
    private Vector iRuleSets = null;

    public static synchronized Identifier get_instance() {
        if (_instance == null) {
            _instance = new Identifier(ImportConstants.IDENTITYRULES_DIR);
        }
        return _instance;
    }

    private Identifier(String directory) {
        this.iRuleSets = IdentityRulesPopulator.get_instance().getRules(directory);
        this.parserList = this.setParserList();
    }

    private int evaluateIdentityRules(String data, Vector iRules) {
        int parserId = -1;
        for (IdentityRule iRule : iRules) {
            boolean result = this.matchPattern(data, iRule.getRegex());
            if (!result) continue;
            parserId = iRule.getParserId();
        }
        return parserId;
    }

    public ArrayList getMatchingFormats(BufferedReader reader) throws IOException {
        ArrayList parsers = new ArrayList();
        String data = reader.readLine();
        int parserid = -1;
        for (IdentityRuleSet iRuleSet : this.iRuleSets) {
            parserid = data != null ? this.evaluateIdentityRules(data, iRuleSet.getIdRules()) : -1;
            if (parserid > 0) {
                parsers.add(iRuleSet.getParsers().elementAt(parserid - 1));
                continue;
            }
            if (parserid != 0) continue;
            int lines = 0;
            int maxLines = iRuleSet.getMaxLines();
            Vector secIdRules = iRuleSet.getSecIdRules();
            do {
                if (data.matches("^\\s*$")) continue;
                parserid = this.evaluateIdentityRules(data, secIdRules);
                if (parserid > 0) break;
                ++lines;
            } while (lines < maxLines && (data = reader.readLine()) != null);
            if (parserid > 0) {
                parsers.add(iRuleSet.getParsers().elementAt(parserid - 1));
                continue;
            }
            parsers.addAll(iRuleSet.getParsers());
        }
        return parsers;
    }

    public ArrayList getParserList() {
        return this.parserList;
    }

    private boolean matchPattern(String data, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(data);
        return m.find();
    }

    private ArrayList setParserList() {
        ArrayList<ParserDetails> parserList = new ArrayList<ParserDetails>();
        for (IdentityRuleSet iRuleSet : this.iRuleSets) {
            for (ParserDetails parser : iRuleSet.getParsers()) {
                parserList.add(parser);
            }
        }
        return parserList;
    }
}

