/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.identifier;

import com.adventnet.sa.server.identifier.IdentityRule;
import com.adventnet.sa.server.identifier.IdentityRuleSet;
import com.adventnet.sa.server.identifier.ParserDetails;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IdentityRulesPopulator {
    private static IdentityRulesPopulator _instance = null;

    public static synchronized IdentityRulesPopulator get_instance() {
        if (_instance == null) {
            _instance = new IdentityRulesPopulator();
        }
        return _instance;
    }

    private IdentityRulesPopulator() {
    }

    private IdentityRule getIdentityRule(Element element) {
        IdentityRule iRule = new IdentityRule();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("isPrimary") && attr.getValue().equals("false")) {
                iRule.setPrimary(false);
            }
            if (!attr.getName().equals("parserid")) continue;
            iRule.setParserId(Integer.parseInt(attr.getValue()));
        }
        NodeList nodes = element.getElementsByTagName("regex");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            iRule.setRegex(this.getRegex(nodeElement));
        }
        return iRule;
    }

    private Vector getIdentityRules(Element element) {
        Vector<IdentityRuleSet> iRuleSets = new Vector<IdentityRuleSet>();
        NodeList nodes = element.getElementsByTagName("Identity-RuleSet");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            iRuleSets.add(this.getIdentityRuleSet(nodeElement));
        }
        return iRuleSets;
    }

    private IdentityRuleSet getIdentityRuleSet(Element element) {
        IdentityRuleSet iRuleSet = new IdentityRuleSet();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().equals("maxLines")) continue;
            iRuleSet.setMaxLines(Integer.parseInt(attr.getValue()));
        }
        NodeList nodes = element.getElementsByTagName("Identity-Rule");
        Vector<IdentityRule> idRules = new Vector<IdentityRule>(4);
        Vector<IdentityRule> secIdRules = new Vector<IdentityRule>(4);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            IdentityRule iRule = this.getIdentityRule(nodeElement);
            if (iRule.isPrimary()) {
                idRules.add(iRule);
                continue;
            }
            secIdRules.add(iRule);
        }
        iRuleSet.setIdRules(idRules);
        if (!secIdRules.isEmpty()) {
            iRuleSet.setSecIdRules(secIdRules);
        }
        nodes = element.getElementsByTagName("Parser");
        Vector<ParserDetails> parsers = new Vector<ParserDetails>(4);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            parsers.add(this.getParserDetails(nodeElement));
        }
        iRuleSet.setParsers(parsers);
        return iRuleSet;
    }

    private ParserDetails getParserDetails(Element element) {
        ParserDetails parserDetails = new ParserDetails();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("id")) {
                parserDetails.setId(Integer.parseInt(attr.getValue()));
            }
            if (attr.getName().equals("desc")) {
                parserDetails.setDesc(attr.getValue());
            }
            if (attr.getName().equals("formatName")) {
                parserDetails.setFormatName(attr.getValue());
            }
            if (attr.getName().equals("type")) {
                parserDetails.setType(attr.getValue());
            }
            if (attr.getName().equals("os")) {
                parserDetails.setOs(attr.getValue());
            }
            if (!attr.getName().equals("formatGroup")) continue;
            parserDetails.setFormatGroup(attr.getValue());
        }
        return parserDetails;
    }

    private String getRegex(Element element) {
        String regex = null;
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 4) continue;
            regex = ((CDATASection)node).getData().trim();
        }
        return regex;
    }

    public Vector getRules(String directory) {
        Vector iRules = new Vector();
        File dir = new File(directory);
        File[] files = dir.listFiles();
        try {
            DocumentBuilderFactory dBuildFac = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuild = dBuildFac.newDocumentBuilder();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                FileInputStream is = new FileInputStream(file);
                Document doc = dBuild.parse(is);
                Element rootNode = doc.getDocumentElement();
                iRules.addAll(this.getIdentityRules(rootNode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iRules;
    }
}

