/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.imp;

import com.adventnet.sa.server.imp.Encryption256Bit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public abstract class AbstractEncryptionHandler {
    protected Cipher encryptCipher;
    protected Cipher decryptCipher;
    private BASE64Encoder base64Encoder = new BASE64Encoder();
    private BASE64Decoder base64Decoder = new BASE64Decoder();
    private String archDescriptorFile = "archivedesc.properties";
    private final char logDelimiter = (char)124;
    private static boolean isDynamicEncryption = false;
    private static final Logger LOGGER = Logger.getLogger(AbstractEncryptionHandler.class.getName());

    abstract void encryptFile(BufferedInputStream var1, BufferedOutputStream var2);

    abstract void decryptFile(BufferedInputStream var1, BufferedOutputStream var2);

    public String encryptLog(String plainText) {
        String encryptedText = null;
        try {
            byte[] encryptedTextBytes = this.encryptCipher.doFinal(plainText.getBytes("UTF-8"));
            encryptedText = this.base64Encoder.encode(encryptedTextBytes);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return encryptedText;
    }

    public String decryptLog(String encryptedText, boolean isLoadArchive) {
        String decryptedText = "";
        try {
            byte[] encryptedTextBytes = this.base64Decoder.decodeBuffer(encryptedText);
            byte[] decryptedTextBytes = this.decryptCipher.doFinal(encryptedTextBytes);
            if (decryptedTextBytes != null) {
                decryptedText = isLoadArchive ? new String(decryptedTextBytes) : new String(decryptedTextBytes, "UTF8");
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Encryption256Bit.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return decryptedText;
    }

    public String readEncryptedLine(BufferedReader br) {
        int val = -1;
        StringBuilder line = new StringBuilder();
        try {
            while ((val = br.read()) > 0 && val != 124) {
                line.append((char)val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result = line.toString().trim();
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createZipArchive(File archiveFile, Vector tobeZippedFiles) {
        boolean toreturn = true;
        int BUFFER_SIZE = 10240;
        BASE64Encoder encoder = new BASE64Encoder();
        ZipOutputStream out = null;
        FileOutputStream stream = null;
        try {
            FileInputStream in = null;
            byte[] buffer = new byte[BUFFER_SIZE];
            stream = new FileOutputStream(archiveFile);
            out = new ZipOutputStream(stream);
            block22: for (int i = 0; i < tobeZippedFiles.size(); ++i) {
                if (tobeZippedFiles.get(i) == null || !((File)tobeZippedFiles.get(i)).exists() || ((File)tobeZippedFiles.get(i)).isDirectory()) continue;
                String isEncryptEnabled = System.getProperty("sysEnableArchiveEncrypt", "false");
                String fileName = ((File)tobeZippedFiles.get(i)).getName();
                if (!fileName.equals(this.archDescriptorFile) && isEncryptEnabled.equals("true")) {
                    fileName = fileName + "_enc";
                }
                LOGGER.log(Level.INFO, "Adding the file {0}", fileName);
                ZipEntry zipAdd = new ZipEntry(fileName);
                zipAdd.setTime(((File)tobeZippedFiles.get(i)).lastModified());
                try {
                    out.putNextEntry(zipAdd);
                    in = new FileInputStream((File)tobeZippedFiles.get(i));
                    if (!fileName.equals(this.archDescriptorFile) && isEncryptEnabled.equals("true")) {
                        int nRead;
                        while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                            byte[] utf8 = this.encryptCipher.update(buffer, 0, nRead);
                            String s = encoder.encode(utf8);
                            out.write(s.getBytes());
                        }
                        byte[] utf8 = this.encryptCipher.doFinal();
                        String s = encoder.encode(utf8);
                        out.write(s.getBytes());
                        continue;
                    }
                    while (true) {
                        int nRead;
                        if ((nRead = in.read(buffer, 0, buffer.length)) <= 0) {
                            continue block22;
                        }
                        out.write(buffer, 0, nRead);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            out.close();
            LOGGER.log(Level.INFO, "Archiving completed Successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            toreturn = false;
            LOGGER.log(Level.INFO, "Error: {0}", e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return toreturn;
    }

    public char getLogDelimiter() {
        return '|';
    }

    public static boolean isDynamicEncryption() {
        return isDynamicEncryption;
    }

    public static void setDynamicEncryption(boolean isDynamicEncryption) {
        AbstractEncryptionHandler.isDynamicEncryption = isDynamicEncryption;
    }
}

