/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.imp;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.imp.ImportAppLogManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Archiver
implements Runnable {
    private static Logger logger = Logger.getLogger(Archiver.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String baseArchiveLocation = ImportAppLogManager.get_instance().getArchiveLocation();
        Table table = new Table("FormatDetails");
        SelectQueryImpl query = new SelectQueryImpl(table);
        query.addSelectColumn(new Column("FormatDetails", "*"));
        query.addSelectColumn(new Column("AppResources", "*"));
        query.addSelectColumn(new Column("Hosts", "*"));
        Join join = new Join("FormatDetails", "AppResources", new String[]{"FORMATID"}, new String[]{"FORMATID"}, 2);
        Join join2 = new Join("AppResources", "Hosts", new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 2);
        query.addJoin(join);
        query.addJoin(join2);
        Criteria criteria = new Criteria(new Column("FormatDetails", "ISTABLECREATED"), (Object)new Long(1L), 0);
        query.setCriteria(criteria);
        try {
            DataObject dataObject = DataAccess.get((SelectQuery)query);
            Iterator iterator = dataObject.getRows("FormatDetails");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String formatName = (String)row.get("FORMATNAME");
                Long formatId = (Long)row.get("FORMATID");
                logger.log(Level.FINER, "Trying to archive for format " + formatName);
                Criteria criteria2 = new Criteria(new Column("AppResources", "FORMATID"), (Object)formatId, 0);
                Iterator iterator2 = dataObject.getRows("AppResources", criteria2);
                while (iterator2.hasNext()) {
                    Row row2 = (Row)iterator2.next();
                    Long hostId = (Long)row2.get("HOSTID");
                    Criteria criteria3 = new Criteria(new Column("Hosts", "HOST_ID"), (Object)hostId, 0);
                    Row row3 = dataObject.getRow("Hosts", criteria3);
                    String hostName = (String)row3.get("DNS_NAME");
                    logger.log(Level.FINER, "Trying to archive for host " + hostName + " hostid " + hostId);
                    String archiveLocation = baseArchiveLocation + formatName + File.separator + hostName;
                    File archiveDir = new File(archiveLocation);
                    if (!archiveDir.exists() || !archiveDir.isDirectory()) continue;
                    String zipFileName = archiveDir.getAbsolutePath() + this.getTimeString() + ".zip";
                    logger.log(Level.FINER, "To be zip name ----> " + zipFileName);
                    FileOutputStream zipFile = null;
                    BufferedInputStream origin = null;
                    ZipOutputStream out = null;
                    File[] files = archiveDir.listFiles();
                    if (files.length <= 0) continue;
                    try {
                        zipFile = new FileOutputStream(zipFileName);
                        out = new ZipOutputStream(zipFile);
                        byte[] data = new byte[8192];
                        for (int i = 0; i < files.length; ++i) {
                            File file = files[i];
                            logger.log(Level.FINER, "Handling ---> " + file.getName());
                            FileInputStream fi = null;
                            try {
                                fi = new FileInputStream(file);
                                origin = new BufferedInputStream(fi, 8192);
                                ZipEntry entry = new ZipEntry(file.getName());
                                out.putNextEntry(entry);
                                int count = 0;
                                while ((count = origin.read(data, 0, 8192)) != -1) {
                                    out.write(data, 0, count);
                                }
                                continue;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                continue;
                            }
                            finally {
                                if (fi != null) {
                                    fi.close();
                                }
                                if (origin != null) {
                                    origin.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            if (origin != null) {
                                origin.close();
                            }
                            if (out != null) {
                                out.close();
                            }
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        for (int i = 0; i < files.length; ++i) {
                            File file = files[i];
                            file.delete();
                        }
                        logger.log(Level.INFO, "Archive completed for format " + formatName + " host " + hostName + " :: zipName" + zipFileName);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getTimeString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        return format.format(new Date());
    }
}

