/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.imp;

import com.adventnet.sa.server.arch.ArchiveConstants;
import com.adventnet.sa.server.imp.AbstractEncryptionHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class Encryption256Bit
extends AbstractEncryptionHandler {
    private static final int KEYSIZE = 256;
    private final int pswdIterations = 65536;
    private static Encryption256Bit staticEncryptionObj = null;
    private static Encryption256Bit dynamicEncryptionObj = null;
    private final ReentrantLock enc256Lock = new ReentrantLock();
    private final ReentrantLock dec256Lock = new ReentrantLock();
    private static final Logger LOGGER = Logger.getLogger(Encryption256Bit.class.getName());

    private Encryption256Bit(String password, String initializationVector, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] saltBytes = salt.getBytes("UTF-8");
        byte[] ivBytes = initializationVector.getBytes("UTF-8");
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), saltBytes, 65536, 256);
        SecretKey secretKey = factory.generateSecret(spec);
        SecretKeySpec secret = new SecretKeySpec(secretKey.getEncoded(), "AES");
        this.encryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        this.encryptCipher.init(1, (Key)secret, new IvParameterSpec(ivBytes));
        this.decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        this.decryptCipher.init(2, (Key)secret, new IvParameterSpec(ivBytes));
    }

    public static synchronized Encryption256Bit getInstance(String fileName) {
        if (AbstractEncryptionHandler.isDynamicEncryption() && fileName.endsWith("dyn_256_enc")) {
            if (dynamicEncryptionObj == null) {
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(ArchiveConstants.getInstance().getArchiveLocation() + File.separator + "EncryptedKey.enc"));
                    String password = br.readLine();
                    LOGGER.log(Level.INFO, "Dynamic encryption key successfully set for 256 bit mode");
                    dynamicEncryptionObj = new Encryption256Bit(password, "ufkyfzl@y&sq^pfb", "transferthedata_Quickly");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        br.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            return dynamicEncryptionObj;
        }
        if (staticEncryptionObj == null) {
            try {
                staticEncryptionObj = new Encryption256Bit("EVENTLOG", "ufkyfzl@y&sq^pfb", "transferthedata_Quickly");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return staticEncryptionObj;
    }

    @Override
    public String encryptLog(String plainText) {
        this.enc256Lock.lock();
        try {
            String string = super.encryptLog(plainText);
            return string;
        }
        finally {
            this.enc256Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decryptLog(String encryptedText, boolean isLoadArchive) {
        this.dec256Lock.lock();
        try {
            String string = super.decryptLog(encryptedText, isLoadArchive);
            return string;
        }
        finally {
            this.dec256Lock.unlock();
        }
    }

    @Override
    public void encryptFile(BufferedInputStream inData, BufferedOutputStream outData) {
    }

    @Override
    public void decryptFile(BufferedInputStream inData, BufferedOutputStream outData) {
    }
}

