/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.imp;

import com.adventnet.sa.server.arch.ArchiveConstants;
import com.adventnet.sa.server.imp.AbstractEncryptionHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.Key;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class EncryptionAPI
extends AbstractEncryptionHandler {
    private static int encryptMode = 1;
    private static int decryptMode = 2;
    private static EncryptionAPI staticEncryptionAPI = null;
    private static EncryptionAPI dynamicEncryptionAPI = null;
    private static EncryptionAPI encryptionObj = null;
    private static EncryptionAPI decryptionObj = null;
    public static String archDescriptorFile = "archivedesc.properties";
    private final ReentrantLock encLock = new ReentrantLock();
    private final ReentrantLock decLock = new ReentrantLock();
    private static final Logger LOGGER = Logger.getLogger(EncryptionAPI.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EncryptionAPI(boolean isDynamic) {
        try {
            byte[] key;
            byte[] iv = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
            if (!isDynamic) {
                key = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
            } else {
                try (BufferedReader br = null;){
                    br = new BufferedReader(new FileReader(ArchiveConstants.getInstance().getArchiveLocation() + File.separator + "EncryptedKey.enc"));
                    key = br.readLine().getBytes();
                    LOGGER.log(Level.INFO, "Dynamic encryption key successfully set");
                }
            }
            IvParameterSpec paramSpec = new IvParameterSpec(iv);
            SecretKeySpec seckey = new SecretKeySpec(key, "AES");
            this.encryptCipher = Cipher.getInstance("AES/CFB/NoPadding");
            this.encryptCipher.init(1, (Key)seckey, paramSpec);
            this.decryptCipher = Cipher.getInstance("AES/CFB/NoPadding");
            this.decryptCipher.init(2, (Key)seckey, paramSpec);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static synchronized EncryptionAPI getInstance(String fileName) {
        if (AbstractEncryptionHandler.isDynamicEncryption() && fileName.endsWith("dyn_enc")) {
            if (dynamicEncryptionAPI == null) {
                dynamicEncryptionAPI = new EncryptionAPI(true);
            }
            return dynamicEncryptionAPI;
        }
        if (staticEncryptionAPI == null) {
            staticEncryptionAPI = new EncryptionAPI(false);
        }
        return staticEncryptionAPI;
    }

    @Override
    public String encryptLog(String plainText) {
        this.encLock.lock();
        try {
            String string = super.encryptLog(plainText);
            return string;
        }
        finally {
            this.encLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decryptLog(String encryptedText, boolean isLoadArchive) {
        this.decLock.lock();
        try {
            String string = super.decryptLog(encryptedText, isLoadArchive);
            return string;
        }
        finally {
            this.decLock.unlock();
        }
    }

    @Override
    public void encryptFile(BufferedInputStream inData, BufferedOutputStream outData) {
        try {
            LOGGER.log(Level.INFO, "Reading encrypted file and decrypting...");
            while (inData.available() > 0) {
                byte[] encryptedBytes = new byte[inData.available()];
                inData.read(encryptedBytes);
                byte[] cleartextBytes = this.encryptCipher.update(encryptedBytes);
                String s = new BASE64Encoder().encode(cleartextBytes);
                outData.write(s.getBytes());
            }
            byte[] last = this.encryptCipher.doFinal();
            String s2 = new BASE64Encoder().encode(last);
            outData.write(s2.getBytes());
            inData.close();
            outData.flush();
            outData.close();
            System.out.println("Done!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void decryptFile(BufferedInputStream inData, BufferedOutputStream outData) {
        try {
            LOGGER.log(Level.INFO, "Reading encrypted file and decrypting...");
            while (inData.available() > 0) {
                byte[] encryptedBytes = new byte[inData.available()];
                inData.read(encryptedBytes);
                byte[] decoded = new BASE64Decoder().decodeBuffer(new String(encryptedBytes));
                byte[] cleartextBytes = this.decryptCipher.update(decoded);
                outData.write(cleartextBytes, 0, cleartextBytes.length);
            }
            byte[] last = this.decryptCipher.doFinal();
            outData.write(last);
            inData.close();
            outData.flush();
            LOGGER.log(Level.INFO, "Done!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getArchiveMetaData(File zipfile) {
        ZipFile zipFile = null;
        Properties toreturn = null;
        try {
            toreturn = new Properties();
            zipFile = new ZipFile(zipfile);
            ZipEntry zipentry = zipFile.getEntry(archDescriptorFile);
            if (zipentry == null) {
                Properties properties = null;
                return properties;
            }
            toreturn.load(zipFile.getInputStream(zipentry));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return toreturn;
    }
}

