/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.imp;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.imp.ImportAppLogTask;
import com.adventnet.sa.server.parser.DbUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportAppLogManager {
    private static final Logger LOGGER = Logger.getLogger(ImportAppLogManager.class.getName());
    private static ImportAppLogManager _instance = null;
    private static boolean isSuspended = false;
    private ClockDaemon scheduler = null;
    private HashMap taskHash = new HashMap();
    public ArrayList locks = new ArrayList();
    public Hashtable lock = new Hashtable();

    public static synchronized ImportAppLogManager get_instance() {
        if (_instance == null) {
            _instance = new ImportAppLogManager();
        }
        return _instance;
    }

    private ImportAppLogManager() {
        this.scheduler = new ClockDaemon();
        this.initLocks();
        this.initializeTasks();
    }

    private void initLocks() {
        Collection formatIds = DbUtil.get_instance().getAllFormatIds();
        for (Long id : formatIds) {
            this.lock.put(id, new Semaphore());
        }
    }

    private void initializeTasks() {
        try {
            Table table = new Table("ImportedAppLogs");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            Criteria cri = new Criteria(new Column("ImportedAppLogs", "IMPORT_TYPE"), (Object)"remote", 0);
            Criteria cri1 = new Criteria(new Column("ImportedAppLogs", "TIME_INTERVAL"), (Object)new Long(-1L), 1);
            Criteria cri2 = new Criteria(new Column("ImportedAppLogs", "STATUS"), (Object)new Long(1011L), 1);
            sql.addSelectColumn(new Column("ImportedAppLogs", "*"));
            sql.setCriteria(cri1.and(cri2));
            DataObject dObj = DataAccess.get((SelectQuery)sql);
            Iterator iterator = dObj.getRows("ImportedAppLogs");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                LOGGER.log(Level.INFO, "Initializing task {0}", row);
                this.importLog((Long)row.get("IL_ID"), row.get("TIME_INTERVAL"));
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public void acquire(Long id) {
        ((Semaphore)this.lock.get(id)).acquire();
    }

    public void release(Long id) {
        ((Semaphore)this.lock.get(id)).release();
    }

    public synchronized boolean acquireLockForId(Long id) {
        LOGGER.log(Level.FINE, "Waiting to acquire log for ID : " + id);
        LOGGER.log(Level.INFO, "Current Lock size is : " + this.locks.size());
        if (this.locks.size() <= 5 && !this.locks.contains(id)) {
            this.locks.add(id);
            return true;
        }
        return false;
    }

    public synchronized void releaseLockForId(Long formatId) {
        this.locks.remove(formatId);
        this.locks.notifyAll();
    }

    public int disableImport(Long il_id) {
        if (!this.taskHash.containsKey(il_id)) {
            return 1012;
        }
        Object taskHandle = this.taskHash.remove(il_id);
        ClockDaemon.cancel(taskHandle);
        this.updateStatus(il_id, 1011, "MESSAGE", "Successfully Disabled");
        return 0;
    }

    public int enableImport(Long il_id) throws DataAccessException {
        if (this.taskHash.containsKey(il_id)) {
            return 1013;
        }
        DataObject dObj = this.getConfiguration(il_id);
        if (dObj == null) {
            return 1014;
        }
        Row row = dObj.getRow("ImportedAppLogs");
        this.importLog((Long)row.get("IL_ID"), row.get("TIME_INTERVAL"));
        this.updateStatus(il_id, 1010, "MESSAGE", "Successfully Enabled");
        return 1010;
    }

    private void importLog(Long il_Id, Object timeInterval) {
        Long timeLong = null;
        long timeInMillis = -1L;
        if (timeInterval != null) {
            if (timeInterval instanceof Long) {
                timeLong = (Long)timeInterval;
            } else if (!"-".equals(timeInterval)) {
                timeLong = Long.valueOf((String)timeInterval);
            }
        }
        if (timeLong != null) {
            timeInMillis = timeLong * 60L * 1000L;
        }
        ImportAppLogTask task = new ImportAppLogTask(il_Id);
        Object taskHandle = null;
        LOGGER.log(Level.INFO, "About to import ::: " + task);
        if (timeInMillis <= 0L) {
            this.scheduler.executeAfterDelay(1L, (Runnable)task);
        } else {
            taskHandle = this.scheduler.executePeriodically(timeInMillis, (Runnable)task, true);
            this.taskHash.put(il_Id, taskHandle);
        }
    }

    public void importLog(Hashtable hash) {
        this.updateDB(hash);
        this.importLog((Long)hash.get("IL_ID"), hash.get("TIME_INTERVAL"));
    }

    private void updateDB(Hashtable hash) {
        Row row = new Row("ImportedAppLogs");
        List columnList = row.getColumns();
        for (String column : columnList) {
            if (hash.get(column) != null) {
                row.set(column, hash.get(column));
                continue;
            }
            if (!"MESSAGE".equals(column)) continue;
            row.set(column, (Object)"-");
        }
        row.set("STATUS", (Object)new Long(1000L));
        row.set("MESSAGE", (Object)"Importing Of Logs Started");
        try {
            DataObject dObj = DataAccess.constructDataObject();
            dObj.addRow(row);
            dObj = DataAccess.add((DataObject)dObj);
            hash.put("IL_ID", dObj.getFirstValue("ImportedAppLogs", "IL_ID"));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        if (_instance != null) {
            _instance.shutdownScheduler();
        }
    }

    private void shutdownScheduler() {
        LOGGER.log(Level.INFO, "Cancelling scheduled application imports and initiating shutdown");
        for (Object taskHandle : this.taskHash.values()) {
            ClockDaemon.cancel(taskHandle);
        }
        this.scheduler.shutDown();
    }

    public DataObject getConfiguration(Long il_id) {
        if (il_id == null) {
            return null;
        }
        try {
            DataObject dObj = null;
            Row row = new Row("ImportedAppLogs");
            row.set("IL_ID", (Object)il_id);
            dObj = PersistenceDBUtil.getPersistence().get("ImportedAppLogs", row);
            return dObj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void updateStatus(Long il_id, int type, HashMap hash) {
        try {
            DataObject dObj = this.getConfiguration(il_id);
            Row row = dObj.getRow("ImportedAppLogs");
            row.set("STATUS", (Object)new Long(type));
            if (hash != null) {
                Long l = (Long)hash.remove("RECORDS");
                if (l != null) {
                    row.set("RECORDS", (Object)l);
                }
                for (String key : hash.keySet()) {
                    row.set(key, hash.get(key));
                }
                if (!hash.containsKey("MESSAGE")) {
                    row.set("MESSAGE", (Object)"-");
                }
            }
            dObj.updateRow(row);
            PersistenceDBUtil.getPersistence().update(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateStatus(Long il_id, int type, Object key, Object value) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, value);
        this.updateStatus(il_id, type, map);
    }

    public String getArchiveLocation() {
        Table table = new Table("SystemConfigurations");
        SelectQueryImpl query = new SelectQueryImpl(table);
        query.addSelectColumn(new Column("SystemConfigurations", "*"));
        query.setCriteria(new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"sysArchiveLocation", 0));
        String archiveDir = null;
        try {
            DataObject dataObject = DataAccess.get((SelectQuery)query);
            archiveDir = (String)dataObject.getFirstValue("SystemConfigurations", "CONF_VALUE") + File.separator;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        if (archiveDir != null && "archive\\".equals(archiveDir)) {
            archiveDir = System.getProperty("server.home") + File.separator + archiveDir;
        }
        return archiveDir;
    }

    public static boolean isSuspended() {
        return isSuspended;
    }

    public static void setSuspendImport(boolean status) {
        isSuspended = status;
    }

    private class Semaphore {
        private boolean inUse = false;

        private Semaphore() {
        }

        public synchronized void acquire() {
            while (this.inUse) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.inUse = true;
        }

        public synchronized void release() {
            this.inUse = false;
            this.notify();
        }
    }
}

