/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.imp;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.imp.AbstractEncryptionHandler;
import com.adventnet.sa.server.imp.Encryption256Bit;
import com.adventnet.sa.server.imp.EncryptionAPI;
import com.adventnet.sa.server.imp.FTPUtil;
import com.adventnet.sa.server.imp.ImportAppLogManager;
import com.adventnet.sa.server.imp.ImportDMCrunch;
import com.adventnet.sa.server.imp.SFTPUtil;
import com.adventnet.sa.server.parser.DbUtil;
import com.adventnet.sa.server.parser.LogFormat;
import com.adventnet.sa.server.parser.ParserRulesPopulator;
import com.adventnet.sa.server.parser.RecordParser;
import com.adventnet.sa.server.univlogparser.ImportHandler;
import com.enterprisedt.net.ftp.FTPClient;
import com.sshtools.sftp.SftpClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ImportAppLogTask
implements Runnable {
    private static Logger LOGGER = Logger.getLogger(ImportAppLogTask.class.getName());
    private Hashtable hash = null;
    private Long il_id = null;
    private DataObject dObj = null;
    private ArchiveFileManager afManager = null;
    private static String defaultFolder = System.getProperty("server.dir") + File.separator + "server" + File.separator;
    private boolean isEncryptedFile = false;
    private AbstractEncryptionHandler encryptionBaseObj = null;

    public ImportAppLogTask(Long il_Id) {
        this.il_id = il_Id;
        this.afManager = ArchiveFileManager.getInstance();
    }

    private String getFileName(String fileName, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        String currentFormat = format.format(new Date());
        StringBuffer regex = new StringBuffer();
        if (pattern.equals("EEE")) {
            regex.append("(Mon|Tue|Wed|Thu|Fri|Sat|Sun)");
            return fileName.replaceAll(regex.toString(), currentFormat);
        }
        if (fileName.indexOf(currentFormat) < 0) {
            int length = pattern.length();
            block4: for (int i = 0; i < length; ++i) {
                char c = pattern.charAt(i);
                switch (c) {
                    case 'E': 
                    case 'M': {
                        regex.append("[A-Za-z0-9]");
                        continue block4;
                    }
                    case 'D': 
                    case 'F': 
                    case 'H': 
                    case 'K': 
                    case 'S': 
                    case 'W': 
                    case 'd': 
                    case 'h': 
                    case 'k': 
                    case 'm': 
                    case 's': 
                    case 'w': 
                    case 'y': {
                        regex.append("\\d");
                        continue block4;
                    }
                    default: {
                        regex.append(c);
                    }
                }
            }
            return fileName.replaceAll(regex.toString(), currentFormat);
        }
        return fileName;
    }

    private Hashtable getProperties(Row row) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        List list = row.getColumns();
        for (String key : list) {
            if (row.get(key) == null) continue;
            hash.put(key, row.get(key));
        }
        return hash;
    }

    private boolean isFileUpdated(File location) {
        try {
            long fileTime;
            Date tStamp = (Date)this.dObj.getFirstValue("ImportedAppLogs", "LAST_MODIFIED_TIME");
            if (tStamp == null) {
                return true;
            }
            long dbTime = tStamp.getTime();
            if (dbTime == (fileTime = location.lastModified())) {
                return false;
            }
            if (dbTime < fileTime) {
                return true;
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGUNZipContent(File inputGZFile, File tempZipFile) {
        GZIPInputStream in = null;
        OutputStream out = null;
        try {
            in = new GZIPInputStream(new FileInputStream(inputGZFile));
            out = new FileOutputStream(tempZipFile);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        block17: {
            if (ImportAppLogManager.isSuspended()) {
                LOGGER.log(Level.INFO, "Low Disk Space Import Task Temporarily Suspended.");
                return;
            }
            LOGGER.log(Level.INFO, "Starting Import");
            this.dObj = ImportAppLogManager.get_instance().getConfiguration(this.il_id);
            if (this.dObj == null) {
                LOGGER.log(Level.INFO, "No dataObject exists for il_id : " + this.il_id);
                return;
            }
            try {
                this.hash = this.getProperties(this.dObj.getRow("ImportedAppLogs"));
            }
            catch (DataAccessException e) {
                LOGGER.log(Level.INFO, "Exception while fetching row for il_id :" + this.il_id);
                LOGGER.log(Level.INFO, "Error code : " + e.getErrorCode());
                return;
            }
            String fileName = (String)this.hash.get("FILE_NAME");
            Object timeInterval = this.hash.get("TIME_INTERVAL");
            String importType = this.hash.containsKey("IMPORT_TYPE") ? this.hash.get("IMPORT_TYPE") : "";
            this.processFile(fileName, false);
            if (this.hash.get("DYNAMIC_PATTERN") != null && timeInterval != null && (Long)timeInterval > 0L) {
                String currentFileName = this.getFileName(fileName, (String)this.hash.get("DYNAMIC_PATTERN"));
                String loctn1 = (String)this.hash.get("LOCATION");
                int lastSlashIndex1 = loctn1.lastIndexOf(File.separator);
                String tempLocation1 = lastSlashIndex1 >= 0 ? loctn1.substring(0, lastSlashIndex1) : loctn1;
                File currentFile1 = new File(tempLocation1 + File.separator + currentFileName);
                boolean exists = currentFile1.exists();
                File existFile = new File(currentFileName);
                LOGGER.log(Level.FINE, "Updating filename-- Old filename local =  " + fileName + ", New filename = " + currentFileName);
                try {
                    if (importType.equalsIgnoreCase("local")) {
                        if (exists && !currentFileName.equals(fileName)) {
                            LOGGER.log(Level.INFO, "Updating filename-- Old filename =  " + fileName + ", New filename = " + currentFileName);
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("FILE_NAME", currentFileName);
                            this.updateStatus(1013, map);
                            this.processFile(currentFileName, true);
                        }
                        break block17;
                    }
                    if (importType.equalsIgnoreCase("remote")) {
                        String remoteHost = URLDecoder.decode((String)this.hash.get("REMOTE_HOSTNAME"));
                        String remoteUser = URLDecoder.decode((String)this.hash.get("REMOTE_USERNAME"));
                        String remotePwd = URLDecoder.decode((String)this.hash.get("REMOTE_PASSWORD"));
                        String remoteDir = (String)this.hash.get("REMOTE_DIR");
                        String protocol = (String)this.hash.get("PROTOCOL");
                        int ftpPort = Integer.parseInt((String)this.hash.get("FTPPORT"));
                        File remoteFile = new File(currentFileName);
                        loctn1 = (String)this.hash.get("LOCATION");
                        lastSlashIndex1 = loctn1.lastIndexOf("/");
                        tempLocation1 = lastSlashIndex1 >= 0 ? loctn1.substring(0, lastSlashIndex1) : loctn1;
                        String remoteFilePath = tempLocation1 + "/" + currentFileName;
                        if (protocol.equals("FTP")) {
                            FTPClient client = null;
                            try {
                                client = fileName.endsWith(".gz") || fileName.endsWith(".zip") ? FTPUtil.getFTPClient(remoteHost, remoteUser, remotePwd, true, ftpPort) : FTPUtil.getFTPClient(remoteHost, remoteUser, remotePwd, false, ftpPort);
                                LOGGER.log(Level.FINE, "Updating filename-- Old filename FTP =  " + fileName + ", New filename = " + currentFileName);
                                if (client.exists(remoteFilePath) && !currentFileName.equals(fileName)) {
                                    LOGGER.log(Level.INFO, "Updating filename-- Old filename =  " + fileName + ", New filename = " + currentFileName);
                                    HashMap<String, String> map = new HashMap<String, String>();
                                    map.put("FILE_NAME", currentFileName);
                                    this.updateStatus(1013, map);
                                    this.processFile(currentFileName, true);
                                }
                                break block17;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                LOGGER.log(Level.INFO, "Unable to Ftp {0}", remoteHost);
                            }
                            break block17;
                        }
                        if (!protocol.equals("SFTP")) break block17;
                        SftpClient client1 = null;
                        try {
                            client1 = fileName.endsWith(".gz") || fileName.endsWith(".zip") ? SFTPUtil.getSFTPClient(remoteHost, remoteUser, remotePwd, true, ftpPort) : SFTPUtil.getSFTPClient(remoteHost, remoteUser, remotePwd, false, ftpPort);
                            if (!currentFileName.equals(fileName)) {
                                LOGGER.log(Level.INFO, "Updating filename-- Old filename =  " + fileName + ", New filename = " + currentFileName);
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("FILE_NAME", currentFileName);
                                this.updateStatus(1013, map);
                                this.processFile(currentFileName, true);
                            }
                            break block17;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            LOGGER.log(Level.INFO, "Unable to Ftp {0}", remoteHost);
                        }
                        break block17;
                    }
                    LOGGER.log(Level.INFO, " New File = " + currentFileName + " is not there");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    LOGGER.log(Level.INFO, "checking current file");
                }
            }
        }
        this.dObj = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processFile(String fileName, boolean isDynamic) {
        File location;
        boolean isSupported;
        Long formatId;
        LogFormat format;
        String formatName;
        String importType;
        long inTime;
        block122: {
            block123: {
                String remoteHost;
                String host;
                block117: {
                    String size;
                    long sizeInBytes;
                    String f;
                    String ftpLoc;
                    int ftpPort;
                    String protocol;
                    String remoteDir;
                    String remotePwd;
                    String remoteUser;
                    block124: {
                        SftpClient client1;
                        block116: {
                            block121: {
                                inTime = System.currentTimeMillis();
                                host = null;
                                importType = this.hash.containsKey("IMPORT_TYPE") ? this.hash.get("IMPORT_TYPE") : "";
                                formatName = DbUtil.get_instance().getFormatName((Long)this.hash.get("FORMATID"));
                                LOGGER.info("ImportAppLogTask.processFile() corresoponding format name for formatID ::: " + this.hash.get("FORMATID") + " is :::: " + formatName);
                                format = ParserRulesPopulator.get_instance().getParserRules(formatName);
                                LOGGER.info("ImportAppLogTask.processFile() .... LogFormat object obtained for format name :::::: " + formatName + " is ::::" + format);
                                LOGGER.info("ImportAppLogTask.processFile() .... Parser Rules are ::::: " + format.getParserRules().size());
                                formatId = (Long)this.hash.get("FORMATID");
                                LOGGER.info("ImportAppLogTask.processFile() Format ID obtained is :::::::::::::::::: " + formatId);
                                isSupported = format.getParserRules().size() != 0;
                                LOGGER.info("ImportAppLogTask.processFile() isSupportedApp value is  :::::::::::::::::: " + isSupported);
                                if (isSupported) {
                                    format.setFormatId((Long)this.hash.get("FORMATID"));
                                    DbUtil.get_instance().updateFormatDetails(format);
                                    formatId = format.getFormatId();
                                }
                                location = new File((String)this.hash.get("LOCATION"));
                                if (!importType.equalsIgnoreCase("local")) break block121;
                                host = (String)this.hash.get("REMOTE_CLIENT");
                                Object timeInterval = this.hash.get("TIME_INTERVAL");
                                if (timeInterval != null && (Long)timeInterval > 0L) {
                                    String loctn = (String)this.hash.get("LOCATION");
                                    int lastSlashIndex = loctn.lastIndexOf(File.separator);
                                    String tempLocation = lastSlashIndex >= 0 ? loctn.substring(0, lastSlashIndex) : loctn;
                                    File currentFile = new File(tempLocation + File.separator + fileName);
                                    File newFile = new File(defaultFolder + "imported_localfiles" + File.separator + formatId.toString() + File.separator + currentFile.getName());
                                    location = ImportAppLogTask.copyFileToLocalDir(currentFile, newFile);
                                }
                                break block122;
                            }
                            if (!importType.equalsIgnoreCase("remote")) break block123;
                            remoteHost = URLDecoder.decode((String)this.hash.get("REMOTE_HOSTNAME"));
                            remoteUser = URLDecoder.decode((String)this.hash.get("REMOTE_USERNAME"));
                            remotePwd = URLDecoder.decode((String)this.hash.get("REMOTE_PASSWORD"));
                            remoteDir = (String)this.hash.get("REMOTE_DIR");
                            protocol = (String)this.hash.get("PROTOCOL");
                            ftpPort = Integer.parseInt((String)this.hash.get("FTPPORT"));
                            if (!protocol.equals("SFTP")) break block124;
                            client1 = null;
                            client1 = fileName.endsWith(".gz") || fileName.endsWith(".zip") ? SFTPUtil.getSFTPClient(remoteHost, remoteUser, remotePwd, true, ftpPort) : SFTPUtil.getSFTPClient(remoteHost, remoteUser, remotePwd, false, ftpPort);
                            if (client1 == null) break block116;
                            ftpLoc = System.getProperty("server.dir") + File.separator + "server" + File.separator + "imported_files" + File.separator + this.hash.get("FORMATID") + File.separator;
                            f = SFTPUtil.doSFTP(client1, ftpLoc, remoteDir, fileName);
                            LOGGER.log(Level.FINE, f);
                            if (f == null) break block116;
                            location = new File(f);
                            sizeInBytes = location.length();
                            size = null;
                            size = sizeInBytes > 524288L ? (float)(sizeInBytes * 100L / 0x100000L) / 100.0f + " MB" : (sizeInBytes > 1024L ? (float)(sizeInBytes * 100L / 1024L) / 100.0f + " KB" : sizeInBytes + " Bytes");
                            LOGGER.log(Level.INFO, "got file with size" + size);
                            this.updateStatus(1001, "SIZE", size);
                        }
                        try {
                            SFTPUtil.logOut(client1);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.INFO, "Exception while SFTP logout");
                        }
                        break block117;
                        catch (Exception e) {
                            try {
                                e.printStackTrace();
                                LOGGER.log(Level.INFO, "Unable to SFTP {0}", remoteHost);
                            }
                            catch (Throwable throwable) {
                                try {
                                    SFTPUtil.logOut(client1);
                                }
                                catch (Exception e2) {
                                    LOGGER.log(Level.INFO, "Exception while SFTP logout");
                                }
                                throw throwable;
                            }
                            try {
                                SFTPUtil.logOut(client1);
                            }
                            catch (Exception e3) {
                                LOGGER.log(Level.INFO, "Exception while SFTP logout");
                            }
                            break block117;
                        }
                    }
                    if (protocol.equals("FTP")) {
                        FTPClient client;
                        block118: {
                            client = null;
                            client = fileName.endsWith(".gz") || fileName.endsWith(".zip") ? FTPUtil.getFTPClient(remoteHost, remoteUser, remotePwd, true, ftpPort) : FTPUtil.getFTPClient(remoteHost, remoteUser, remotePwd, false, ftpPort);
                            if (client == null) break block118;
                            ftpLoc = System.getProperty("server.dir") + File.separator + "server" + File.separator + "imported_files" + File.separator + this.hash.get("FORMATID") + File.separator;
                            f = FTPUtil.doFTP(client, ftpLoc, remoteDir, fileName);
                            LOGGER.log(Level.FINE, f);
                            if (f == null) break block118;
                            location = new File(f);
                            sizeInBytes = location.length();
                            size = null;
                            size = sizeInBytes > 524288L ? (float)(sizeInBytes * 100L / 0x100000L) / 100.0f + " MB" : (sizeInBytes > 1024L ? (float)(sizeInBytes * 100L / 1024L) / 100.0f + " KB" : sizeInBytes + " Bytes");
                            LOGGER.log(Level.INFO, "got file with size" + size);
                            this.updateStatus(1001, "SIZE", size);
                        }
                        try {
                            FTPUtil.logOut(client);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.INFO, "Exception while FTP logout");
                        }
                        break block117;
                        catch (Exception e) {
                            try {
                                e.printStackTrace();
                                LOGGER.log(Level.INFO, "Unable to Ftp {0}", remoteHost);
                            }
                            catch (Throwable throwable) {
                                try {
                                    FTPUtil.logOut(client);
                                }
                                catch (Exception e4) {
                                    LOGGER.log(Level.INFO, "Exception while FTP logout");
                                }
                                throw throwable;
                            }
                            try {
                                FTPUtil.logOut(client);
                            }
                            catch (Exception e5) {
                                LOGGER.log(Level.INFO, "Exception while FTP logout");
                            }
                        }
                    }
                }
                if (location == null) {
                    LOGGER.log(Level.FINE, "ImportLogTask:failed to fetch file<->{0}", this.hash);
                }
                host = remoteHost;
                break block122;
            }
            if (!importType.equalsIgnoreCase("archive")) {
                LOGGER.log(Level.FINE, "No log type mentioned for Import{0}", this.hash);
            }
        }
        Enumeration<? extends ZipEntry> en = null;
        ZipFile zipFile = null;
        if (location != null && location.exists()) {
            if (!this.isFileUpdated(location)) {
                this.updateStatus(1006);
                return;
            }
            BufferedReader reader = null;
            boolean markReached = false;
            Object zipFileLocation = null;
            String oldArchiveFileName = null;
            StringBuffer tempBuf = new StringBuffer();
            tempBuf.append(System.getProperty("server.dir"));
            tempBuf.append(File.separator);
            tempBuf.append("server");
            tempBuf.append(File.separator);
            tempBuf.append("tmp");
            tempBuf.append(File.separator);
            File tempGZFileName = new File(tempBuf.toString() + "importFile.zip");
            File importedGZFile = new File(tempBuf.toString() + "importGZFile.log");
            File importedZipFile = new File(tempBuf.toString() + "importZipFile.log");
            int recordCount = 0;
            Long appId = (Long)this.hash.get("APPID");
            String importedTime = null;
            try {
                String header;
                if (fileName.endsWith(".gz")) {
                    this.loadGUNZipContent(location, tempGZFileName);
                    try {
                        zipFile = new ZipFile(tempGZFileName);
                    }
                    catch (Exception ee) {
                        LOGGER.log(Level.INFO, "Got Exception while creating ZipFile object on {0}. Going to try to read it directly", tempGZFileName);
                        reader = this.getReaderObj(location);
                    }
                } else if (fileName.endsWith(".zip")) {
                    zipFile = new ZipFile(location);
                } else {
                    reader = this.getReaderObj(location);
                }
                if (zipFile != null) {
                    en = zipFile.entries();
                    reader = this.getReaderObj(en, zipFile);
                } else if (location.getName().endsWith("_enc")) {
                    this.isEncryptedFile = true;
                }
                String data = null;
                String recordMarker = (String)this.dObj.getFirstValue("ImportedAppLogs", "RECORD_MARKER");
                LOGGER.log(Level.INFO, "marker : " + recordMarker);
                if (recordMarker != null && !recordMarker.equals("") && !isDynamic) {
                    boolean useEquals;
                    boolean bl = useEquals = recordMarker.length() < 1023;
                    if (format.getNumLines() >= 0) {
                        while (reader != null) {
                            data = this.getRecord(reader);
                            if (data == null) {
                                this.closeReaderObj(reader);
                                if (zipFile != null) {
                                    reader = this.getReaderObj(en, zipFile);
                                    continue;
                                }
                            } else {
                                data = data.trim();
                                boolean bl2 = isSupported ? (useEquals ? data.equals(recordMarker) : data.startsWith(recordMarker)) : data.length() > 0 && recordMarker.startsWith(data);
                                boolean match = bl2;
                                if (!match) continue;
                                markReached = true;
                                LOGGER.log(Level.INFO, "Marker found");
                                this.updateStatus(1002);
                            }
                            break;
                        }
                    } else {
                        String[] markerLines = recordMarker.split("\n");
                        int lines = markerLines.length - 1;
                        while (reader != null) {
                            data = this.getRecord(reader);
                            if (data == null) {
                                this.closeReaderObj(reader);
                                if (zipFile != null) {
                                    reader = this.getReaderObj(en, zipFile);
                                    continue;
                                }
                            } else {
                                if (!data.equals(markerLines[0])) continue;
                                markReached = true;
                                while (lines-- > 0 && reader != null) {
                                    data = this.getRecord(reader);
                                    if (data != null) continue;
                                    this.closeReaderObj(reader);
                                    if (zipFile == null) break;
                                    reader = this.getReaderObj(en, zipFile);
                                }
                                LOGGER.log(Level.INFO, "Marker found");
                                this.updateStatus(1002);
                            }
                            break;
                        }
                    }
                }
                if (!markReached) {
                    LOGGER.log(Level.INFO, "Closing and opening file");
                    this.closeReaderObj(reader);
                    this.updateStatus(1003);
                    if (zipFile != null) {
                        en = zipFile.entries();
                        reader = this.getReaderObj(en, zipFile);
                    } else {
                        if (location.getName().endsWith("_enc")) {
                            this.isEncryptedFile = true;
                        }
                        reader = this.getReaderObj(location);
                    }
                } else {
                    int lastDotIndex = fileName.lastIndexOf(".");
                    String tempFileName = lastDotIndex > 0 ? fileName.substring(0, lastDotIndex) : fileName;
                    oldArchiveFileName = tempFileName + "_" + this.getArchiveSuffix((String)this.hash.get("IMPORTED_TIME")) + ".zip";
                    LOGGER.log(Level.INFO, "Old Archive Filename ----->   " + oldArchiveFileName);
                }
                LOGGER.log(Level.INFO, "Trying to acquiring lock for id {0}", formatId);
                String headerRecord = (String)this.dObj.getFirstValue("ImportedAppLogs", "HEADER_RECORD");
                RecordParser parser = null;
                int numLines = 1;
                String hostName = this.getHostName(appId);
                String appKey = formatName + "_" + hostName;
                if (isSupported) {
                    ImportAppLogManager.get_instance().acquire(formatId);
                    parser = new RecordParser(format, appId);
                    if (headerRecord != null && !"".equals(headerRecord)) {
                        LOGGER.log(Level.INFO, "HEADER record present in db ::: " + headerRecord);
                        parser.parseRecord(headerRecord);
                    }
                }
                Timestamp minTime = null;
                Timestamp maxTime = null;
                if (!isSupported) {
                    String importedFromHost = hostName;
                    String toProcessFile = (String)this.hash.get("FILE_NAME");
                    ImportHandler iHandler = new ImportHandler(importedFromHost, toProcessFile, reader, formatId);
                    iHandler.setAppID(appId);
                    iHandler.setImportedAppLogsID(this.il_id);
                    iHandler.setArchiveManager(this.afManager);
                    if (headerRecord != null) {
                        iHandler.setHeaderInfo(headerRecord.split(","));
                    }
                    iHandler.startLogImport();
                    iHandler.close();
                    String tempRecordMarker = iHandler.getRecordMarker();
                    recordMarker = tempRecordMarker == null ? recordMarker : tempRecordMarker;
                    recordCount = iHandler.getRecordsProcessedCount();
                    headerRecord = headerRecord == null ? iHandler.getHeaderInfo() : headerRecord;
                    minTime = new Timestamp(iHandler.getMinTime());
                    maxTime = new Timestamp(iHandler.getMaxTime() + 3599000L);
                    LOGGER.info("ImportHandler.processFile() RecordMarker is :::::::::::::::: " + recordMarker);
                    LOGGER.info("ImportHandler.processFile() total number of records processed is :::::::::: " + recordCount);
                    LOGGER.info("ImportHandler.processFile() header info: is :::::::::: " + headerRecord);
                } else {
                    if (numLines == 1) {
                        while (reader != null) {
                            data = this.getRecord(reader);
                            if (data == null) {
                                this.closeReaderObj(reader);
                                if (zipFile != null) {
                                    reader = this.getReaderObj(en, zipFile);
                                    continue;
                                }
                                break;
                            }
                            if (data.matches("^\\s*$")) continue;
                            boolean result = parser.parseRecord(data);
                            if (result) {
                                recordMarker = data;
                                if (++recordCount % 20000 == 0) {
                                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                                    hashMap.put("RECORDS", new Long(recordCount));
                                    int recMarkerLen = recordMarker.length();
                                    if (recMarkerLen > 1024) {
                                        recordMarker = recordMarker.substring(0, 1023);
                                    }
                                    hashMap.put("RECORD_MARKER", recordMarker);
                                    this.updateStatus(1015, hashMap);
                                }
                                this.afManager.archiveAppLog(formatName, hostName, appKey, data);
                                continue;
                            }
                            LOGGER.info("Unparsed record: " + data);
                        }
                    } else if (numLines < 0) {
                        while (reader != null) {
                            data = this.getRecord(reader);
                            if (data == null) {
                                this.closeReaderObj(reader);
                                if (zipFile != null) {
                                    reader = this.getReaderObj(en, zipFile);
                                    continue;
                                }
                                break;
                            }
                            String tempData = "";
                            boolean result = false;
                            while (!result) {
                                result = parser.parseRecord(data);
                                if (result) continue;
                                tempData = this.getRecord(reader);
                                if (tempData == null || data.matches("^\\s*$")) break;
                                data = data + tempData;
                            }
                            if (result) {
                                recordMarker = data;
                                if (++recordCount % 20000 == 0) {
                                    this.updateStatus(1015, "RECORDS", new Long(recordCount));
                                }
                                this.afManager.archiveAppLog(formatName, hostName, appKey, data);
                                continue;
                            }
                            LOGGER.info("Unparsed record: " + data);
                        }
                    } else {
                        while (reader != null) {
                            data = this.getRecord(reader);
                            if (data == null) {
                                this.closeReaderObj(reader);
                                if (zipFile != null) {
                                    reader = this.getReaderObj(en, zipFile);
                                    continue;
                                }
                                break;
                            }
                            if (data.matches("^\\s*$")) continue;
                            String dataForRecMarker = data;
                            reader.mark(8192);
                            String tempData = "";
                            for (int i = 1; i < numLines && (tempData = this.getRecord(reader)) != null && !data.matches("^\\s*$"); ++i) {
                                data = data + "\n" + tempData;
                            }
                            boolean result = parser.parseRecord(data);
                            if (result) {
                                if (++recordCount % 20000 == 0) {
                                    this.updateStatus(1015, "RECORDS", new Long(recordCount));
                                }
                                this.afManager.archiveAppLog(formatName, hostName, appKey, data);
                            } else {
                                LOGGER.info("Unparsed record: " + data);
                            }
                            if (parser.MULITILINE_MATCH) {
                                recordMarker = tempData;
                                continue;
                            }
                            reader.reset();
                            recordMarker = dataForRecMarker;
                        }
                    }
                    parser.residualUpdate();
                    ImportDMCrunch.get_instance().executeCrunch(format.getFormatName() + "_hr_trend_sa", formatId);
                    ImportDMCrunch.get_instance().executeCrunch(format.getFormatName() + "_reports_hr_trend_sa", formatId);
                    if (parser.containsLongReport) {
                        ImportDMCrunch.get_instance().executeCrunch(format.getFormatName() + "_longreports_hr_trend_sa", formatId);
                    }
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("RECORDS", new Long(recordCount));
                map.put("MESSAGE", "Imported [" + recordCount + "] records");
                if (recordMarker != null && recordMarker.length() > 1023) {
                    recordMarker = recordMarker.substring(0, 1023);
                }
                map.put("RECORD_MARKER", recordMarker);
                importedTime = this.getImportedTime();
                map.put("IMPORTED_TIME", importedTime);
                if (recordCount > 0) {
                    map.put("START_TIME", minTime == null ? new Timestamp(parser.minTime) : minTime);
                    map.put("END_TIME", maxTime == null ? new Timestamp(parser.maxTime + 3599000L) : maxTime);
                }
                map.put("TIME_TAKEN", new Long(System.currentTimeMillis() - inTime));
                if (!this.hash.containsKey("FORMATID")) {
                    map.put("FORMATID", formatId);
                }
                String string = header = isSupported ? parser.HEADER_RECORD : headerRecord;
                if (header != null) {
                    LOGGER.log(Level.INFO, "updating header record :::: " + header);
                    map.put("HEADER_RECORD", header);
                }
                LOGGER.log(Level.INFO, "ImportLogAction.processFile() .... Map is :::::::::::::::::::::: " + map);
                this.updateStatus(1004, map);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.log(Level.INFO, "ImportLogTask:unable to parse file{0}", location);
                this.updateStatus(1005, "TIME_TAKEN", new Long(System.currentTimeMillis() - inTime));
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.INFO, "unable to close Import reader handle");
                    }
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ImportAppLogTask.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (formatId != null) {
                    LOGGER.log(Level.INFO, "releasing lock for ID {0}", formatId);
                    if (isSupported) {
                        ImportAppLogManager.get_instance().release(formatId);
                    }
                }
                Object timeInterval = this.hash.get("TIME_INTERVAL");
                if ((((String)this.hash.get("REMOTE_CLIENT")).equals("127.0.0.1") || ((String)this.hash.get("REMOTE_CLIENT")).equals("0:0:0:0:0:0:0:1")) && (Long)timeInterval < 0L) {
                    if (location.getName().startsWith("import_upload")) {
                        location.delete();
                    }
                } else if (!importType.equalsIgnoreCase("local")) {
                    location.delete();
                }
                if (tempGZFileName.exists()) {
                    tempGZFileName.delete();
                }
                if (importedGZFile.exists()) {
                    importedGZFile.delete();
                }
                if (importedZipFile.exists()) {
                    importedZipFile.delete();
                }
            }
        } else {
            this.updateStatus(1005, "MESSAGE", "Unable to import log file. Sorry!");
            LOGGER.log(Level.FINE, "ImportLogTask: location is null...");
        }
    }

    private BufferedReader getReaderObj(File location) {
        boolean isUTF16 = this.isUTF16(location);
        BufferedReader reader = null;
        try {
            reader = isUTF16 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(location), "UTF16")) : new BufferedReader(new FileReader(location));
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return reader;
    }

    private BufferedReader getReaderObj(Enumeration enu, ZipFile zipFile) {
        BufferedReader readerObj = null;
        try {
            while (enu.hasMoreElements()) {
                Object entry;
                if (zipFile != null) {
                    entry = (ZipEntry)enu.nextElement();
                    if (((ZipEntry)entry).getName().equals("archivedesc.properties") || ((ZipEntry)entry).getName().endsWith(".sgn")) continue;
                    readerObj = new BufferedReader(new InputStreamReader(zipFile.getInputStream((ZipEntry)entry), "UTF8"));
                    LOGGER.log(Level.INFO, "Data is null, opening new file :: " + ((ZipEntry)entry).getName());
                    if (((ZipEntry)entry).getName().endsWith("_enc")) {
                        this.isEncryptedFile = true;
                        this.encryptionBaseObj = ((ZipEntry)entry).getName().endsWith("_256_enc") ? Encryption256Bit.getInstance(((ZipEntry)entry).getName()) : EncryptionAPI.getInstance(((ZipEntry)entry).getName());
                    } else {
                        this.isEncryptedFile = false;
                    }
                } else {
                    entry = (File)enu.nextElement();
                    readerObj = new BufferedReader(new FileReader((File)entry));
                }
                if (!readerObj.ready()) {
                    this.isEncryptedFile = false;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return readerObj;
    }

    private void closeReaderObj(BufferedReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isEncryptedFile = false;
    }

    private String getRecord(BufferedReader br) throws Exception {
        String record = null;
        if (br == null) {
            return record;
        }
        if (this.isEncryptedFile) {
            record = this.encryptionBaseObj.readEncryptedLine(br);
            if (record != null) {
                record = this.encryptionBaseObj.decryptLog(record, false);
            }
        } else {
            record = br.readLine();
        }
        return record;
    }

    private String getHostName(Long appId) {
        Table table = new Table("AppResources");
        SelectQueryImpl query = new SelectQueryImpl(table);
        query.addSelectColumn(new Column("AppResources", "*"));
        query.addSelectColumn(new Column("Hosts", "*"));
        query.addJoin(new Join("AppResources", "Hosts", new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 2));
        query.setCriteria(new Criteria(new Column("AppResources", "APPID"), (Object)appId, 0));
        String hostName = null;
        try {
            DataObject dataObject = DataAccess.get((SelectQuery)query);
            hostName = (String)dataObject.getFirstValue("Hosts", "DNS_NAME");
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return hostName;
    }

    private String getArchiveSuffix(String importedTime) {
        String date_format = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat df = new SimpleDateFormat(date_format);
        try {
            Date date = df.parse(importedTime);
            df.applyPattern("yyyy_MM_dd_HH_mm_ss");
            return df.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateStatus(int type) {
        this.updateStatus(type, null);
    }

    private void updateStatus(int type, HashMap hash) {
        ImportAppLogManager.get_instance().updateStatus(this.il_id, type, hash);
    }

    private void updateStatus(int type, Object key, Object value) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, value);
        this.updateStatus(type, map);
    }

    private String getImportedTime() {
        String date_format = "yyyy-MM-dd HH:mm:ss";
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(System.currentTimeMillis());
        SimpleDateFormat df = new SimpleDateFormat(date_format);
        return df.format(cal.getTime());
    }

    private String getFormatGroup(Long formatId, Long appId) {
        String fgroup = "";
        try {
            Table table = new Table("AppResources");
            SelectQueryImpl query = new SelectQueryImpl(table);
            Column hostIdCol = new Column("AppResources", "APPID");
            Column formatIdCol = new Column("AppResources", "FORMATID");
            Criteria cri = new Criteria(hostIdCol, (Object)appId, 0).and(formatIdCol, (Object)formatId, 0);
            query.setCriteria(cri);
            query.addSelectColumn(new Column("AppResources", "*"));
            DataObject dObj = DataAccess.get((SelectQuery)query);
            fgroup = (String)dObj.getFirstValue("AppResources", "FGROUP");
        }
        catch (DataAccessException e) {
            LOGGER.log(Level.INFO, "Caught exception while retrieving format group");
            e.printStackTrace();
        }
        return fgroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUTF16(File location) {
        FileInputStream fis = null;
        boolean isUTF16 = false;
        try {
            fis = new FileInputStream(location);
            byte[] buffer = new byte[128];
            fis.read(buffer);
            isUTF16 = buffer[0] == -1 && buffer[1] == -2 || buffer[0] == -2 && buffer[1] == -1;
            LOGGER.info("UTF-16");
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        return isUTF16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyFileToLocalDir(File currentFile, File newFile) {
        if (!newFile.getParentFile().exists()) {
            newFile.getParentFile().mkdirs();
        }
        FileInputStream in = null;
        OutputStream out = null;
        LOGGER.log(Level.FINE, "About to copy to local");
        long startTime = System.currentTimeMillis();
        try {
            int len;
            in = new FileInputStream(currentFile);
            out = new FileOutputStream(newFile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            ((InputStream)in).close();
            out.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Problem while saving currentFile locally");
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return newFile;
    }
}

