/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.imp;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.QueryUtil;
import com.adventnet.la.util.TransactionHandler;
import com.adventnet.la.util.dm.MssqlProcessHandler;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportDMCrunch {
    private static final Logger LOGGER = Logger.getLogger(ImportDMCrunch.class.getName());
    private static ImportDMCrunch _instance = null;
    private static boolean dbType = "mysql".equals(System.getProperty("DBType", "mysql"));
    private static boolean isPostgres = "postgres".equals(System.getProperty("DBType", "postgres"));
    private static String sumQuery1 = dbType ? "SUM(FIELD" : "SUM(CAST(FIELD";
    private static String sumQuery2 = dbType ? ")" : " as bigint))";
    private static MssqlProcessHandler mssqlhandler = new MssqlProcessHandler();
    private TransactionHandler txn = null;
    private LinkedList reportTableQueries = new LinkedList();
    private LinkedList sevTableQueries = new LinkedList();

    public static synchronized ImportDMCrunch get_instance() {
        if (_instance == null) {
            _instance = new ImportDMCrunch();
        }
        return _instance;
    }

    private ImportDMCrunch() {
        try {
            this.txn = TransactionHandler.getInstance();
            this.init();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error occured while getting transaction handler");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCrunch(String tableName, Long formatId) {
        Connection con = null;
        Statement stmt = null;
        LinkedList sqls = this.getSqls(tableName, formatId);
        try {
            this.txn.begin();
            RelationalAPI rAPI = RelationalAPI.getInstance();
            con = rAPI.getConnection();
            stmt = con.createStatement();
            for (String sql : sqls) {
                if (!dbType && !isPostgres) {
                    sql = mssqlhandler.handleSQL(sql);
                }
                QueryUtil.executeUpdate((String)"App_Log_Hr_Trend_Crunch", (Statement)stmt, (String)sql);
            }
            this.txn.commit();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Error occured while executing cruncher task");
            e.printStackTrace();
            try {
                this.txn.rollback();
                LOGGER.log(Level.INFO, "Transaction rolled back");
            }
            catch (Exception e1) {
                LOGGER.log(Level.INFO, "Problem in rolling back");
                e1.printStackTrace();
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private LinkedList getSqls(String tableName, Long formatId) {
        LOGGER.log(Level.INFO, "generating sqls for table " + tableName);
        LinkedList<String> sqls = new LinkedList<String>();
        int numFields = 0;
        numFields = tableName.indexOf("_longreports_hr_trend_sa") > 0 ? 10 : 6;
        if (tableName.indexOf("reports_hr_trend_sa") > 0) {
            for (String query : this.reportTableQueries) {
                if ((query = query.replaceAll("\\$#tableName#", tableName)).indexOf("$#fields#") > 0 || query.indexOf("$#reportid#") > 0) {
                    Table table = new Table("FormatToReportMapping");
                    Table table2 = new Table("ReportToFieldMapping");
                    SelectQueryImpl impl = new SelectQueryImpl(table);
                    impl.addSelectColumn(new Column("FormatToReportMapping", "*"));
                    SortColumn sortColumn = new SortColumn("FormatToReportMapping", "REPORTID", true);
                    impl.setCriteria(new Criteria(new Column("FormatToReportMapping", "FORMATID"), (Object)formatId, 0));
                    impl.addSortColumn(sortColumn);
                    try {
                        DataObject dataObject = DataAccess.get((SelectQuery)impl);
                        Iterator iterator2 = dataObject.getRows("FormatToReportMapping");
                        while (iterator2.hasNext()) {
                            StringBuffer fields = new StringBuffer();
                            StringBuffer postgresFields = new StringBuffer();
                            StringBuffer groupByFields = new StringBuffer();
                            int i = 0;
                            Long reportId = (Long)((Row)iterator2.next()).get("REPORTID");
                            Criteria criteria = new Criteria(new Column("ReportToFieldMapping", "REPORTID"), (Object)reportId, 0);
                            impl = new SelectQueryImpl(table2);
                            impl.addSelectColumn(new Column("ReportToFieldMapping", "*"));
                            impl.setCriteria(criteria);
                            sortColumn = new SortColumn("ReportToFieldMapping", "FIELDID", true);
                            impl.addSortColumn(sortColumn);
                            DataObject dataObject2 = DataAccess.get((SelectQuery)impl);
                            Iterator iterator3 = dataObject2.getRows("ReportToFieldMapping", criteria);
                            while (iterator3.hasNext()) {
                                Row row2 = (Row)iterator3.next();
                                if ("SIMPLE".equals(row2.get("TYPE"))) {
                                    fields.append("FIELD" + i + ", ");
                                    postgresFields.append("FIELD" + i + ", ");
                                    groupByFields.append("FIELD" + i + ", ");
                                } else {
                                    if (isPostgres) {
                                        sumQuery1 = "SUM(FIELD";
                                        sumQuery2 = "::bigint)";
                                    }
                                    fields.append(sumQuery1 + i + sumQuery2 + ", ");
                                    postgresFields.append("FIELD" + i + ", ");
                                }
                                ++i;
                            }
                            if (i >= numFields) continue;
                            while (i++ < numFields) {
                                if (isPostgres) continue;
                                fields.append("NULL, ");
                            }
                            if (fields.length() > 0) {
                                fields.delete(fields.lastIndexOf(","), fields.length());
                            }
                            if (postgresFields.length() > 0) {
                                postgresFields.delete(postgresFields.lastIndexOf(","), postgresFields.length());
                            }
                            String[] replacements = new String[]{"\\$#fields#", "\\$#selectfields#", "\\$#groupByFields#", "\\$#reportid#"};
                            if (isPostgres) {
                                if (fields.length() <= 0) {
                                    replacements[0] = replacements[0] + ",";
                                }
                                if (postgresFields.length() <= 0) {
                                    replacements[1] = replacements[1] + ",";
                                }
                            }
                            String reportQuery = query.replaceAll(replacements[0], fields.toString());
                            if (isPostgres) {
                                reportQuery = reportQuery.replaceAll(replacements[1], postgresFields.toString());
                            }
                            reportQuery = reportQuery.replaceAll(replacements[2], groupByFields.toString());
                            reportQuery = reportQuery.replaceAll(replacements[3], reportId.toString());
                            reportQuery = reportQuery.substring(0, reportQuery.lastIndexOf(","));
                            sqls.add(reportQuery);
                        }
                        continue;
                    }
                    catch (DataAccessException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                sqls.add(query);
            }
        } else {
            for (String query : this.sevTableQueries) {
                query = query.replaceAll("\\$#tableName#", tableName);
                sqls.add(query);
            }
        }
        return sqls;
    }

    private void init() {
        String dropTmpTableQuery = "drop TABLE IF EXISTS $#tableName#_Tmp";
        String dropTableQuery = "drop TABLE IF EXISTS $#tableName#";
        String renameTableQuery = "RENAME TABLE $#tableName#_Tmp TO $#tableName#";
        String nullString = " NULL , ";
        if (!dbType && !isPostgres) {
            dropTmpTableQuery = "IF EXISTS(select * from sysobjects where name='$#tableName#_Tmp') DROP TABLE $#tableName#_Tmp";
            dropTableQuery = "IF EXISTS(select * from sysobjects where name='$#tableName#') DROP TABLE $#tableName#";
            renameTableQuery = "EXEC sp_rename $#tableName#_Tmp , $#tableName#";
            nullString = "";
        }
        String createTableQuery = "CREATE TABLE $#tableName#_Tmp LIKE $#tableName#";
        String insertQuery = "INSERT INTO $#tableName#_Tmp select " + nullString + " APPID, REPORTID, HOUROFDAY, HOUR, $#fields#, " + "SUM(EVTCOUNT) as EVTCOUNT from $#tableName# where REPORTID = $#reportid# " + "group by APPID, REPORTID, HOUROFDAY, HOUR, $#groupByFields#";
        if (isPostgres) {
            renameTableQuery = "ALTER TABLE $#tableName#_Tmp RENAME TO $#tableName#";
            createTableQuery = "CREATE TABLE $#tableName#_Tmp (LIKE $#tableName# including all)";
            insertQuery = "INSERT INTO $#tableName#_Tmp (APPID, REPORTID, HOUROFDAY, HOUR,$#selectfields#,EVTCOUNT)select APPID, REPORTID, HOUROFDAY, HOUR, $#fields#, SUM(EVTCOUNT) as EVTCOUNT from $#tableName# where REPORTID = $#reportid# group by APPID, REPORTID, HOUROFDAY, HOUR, $#groupByFields#";
        }
        this.reportTableQueries.add(dropTmpTableQuery);
        this.reportTableQueries.add(createTableQuery);
        this.reportTableQueries.add(insertQuery);
        this.reportTableQueries.add(dropTableQuery);
        this.reportTableQueries.add(renameTableQuery);
        insertQuery = "INSERT INTO $#tableName#_Tmp select " + nullString + " APPID, HOUROFDAY, HOUR, " + "SUM(CRITICAL_CNT) as CRITICAL_CNT,  SUM(ERROR_CNT) as ERROR_CNT, " + "SUM(WARNING_CNT) as WARNING_CNT, SUM(INFORMATION_CNT) as INFORMATION_CNT, " + "SUM(TOTAL_CNT) as TOTAL_CNT from $#tableName# " + "group by APPID, HOUROFDAY, HOUR";
        if (isPostgres) {
            insertQuery = "INSERT INTO $#tableName#_Tmp (APPID,HOUROFDAY,HOUR,CRITICAL_CNT,ERROR_CNT,WARNING_CNT,INFORMATION_CNT,TOTAL_CNT)select APPID, HOUROFDAY, HOUR, SUM(CRITICAL_CNT) as CRITICAL_CNT,  SUM(ERROR_CNT) as ERROR_CNT, SUM(WARNING_CNT) as WARNING_CNT, SUM(INFORMATION_CNT) as INFORMATION_CNT, SUM(TOTAL_CNT) as TOTAL_CNT from $#tableName# group by APPID, HOUROFDAY, HOUR";
        }
        this.sevTableQueries.add(dropTmpTableQuery);
        this.sevTableQueries.add(createTableQuery);
        this.sevTableQueries.add(insertQuery);
        this.sevTableQueries.add(dropTableQuery);
        this.sevTableQueries.add(renameTableQuery);
    }
}

