/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.imp;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.imp.ImportLogTask;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportLogManager {
    private static final Logger LOGGER = Logger.getLogger(ImportLogManager.class.getName());
    private static ImportLogManager logMgr = null;
    private ClockDaemon scheduler = null;

    private ImportLogManager() {
        this.startScheduler();
    }

    public static ImportLogManager getInstance() {
        LOGGER.log(Level.INFO, "Inside ImportLogManager getInstance()");
        if (logMgr != null) {
            return logMgr;
        }
        logMgr = new ImportLogManager();
        return logMgr;
    }

    private void startScheduler() {
        LOGGER.log(Level.FINER, "Inside ImportLogManager startscheduler()");
        try {
            this.scheduler = new ClockDaemon();
            SelectQueryImpl selectquery = new SelectQueryImpl(new Table("ImportedLogs"));
            Criteria crt = new Criteria(new Column("ImportedLogs", "IMPORT_TYPE"), (Object)"remote", 0).and(new Column("ImportedLogs", "TYPE"), (Object)"EVT", 0);
            selectquery.setCriteria(crt);
            selectquery.addSelectColumn(new Column("ImportedLogs", "*"));
            DataObject dataOb = DataAccess.get((SelectQuery)selectquery);
            Iterator iter = dataOb.getRows("ImportedLogs");
            HashMap<String, Object> hmap = null;
            ImportLogTask task = null;
            while (iter.hasNext()) {
                String[] params = new String[]{"FILE_NAME", "IMPORT_TYPE", "PROTOCOL", "REMOTE_HOSTNAME", "REMOTE_USERNAME", "REMOTE_PASSWORD", "REMOTE_DIR", "LOCATION"};
                Row row = (Row)iter.next();
                hmap = new HashMap<String, Object>();
                hmap.put("IL_ID", (Long)row.get("IL_ID"));
                hmap.put("logType", (String)row.get("LOG_TYPE"));
                for (int i = 0; i < params.length; ++i) {
                    hmap.put(params[i], (String)row.get(params[i]));
                }
                if (row.get("TIME_INTERVAL") == null || new Long(0L).equals(row.get("TIME_INTERVAL")) || "".equals(row.get("TIME_INTERVAL"))) continue;
                task = new ImportLogTask(hmap);
                long timeInMilliSec = (Long)row.get("TIME_INTERVAL") * 60000L;
                this.scheduler.executePeriodically(timeInMilliSec, (Runnable)task, true);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Exception while starting the scheduled imported tasks:" + e);
            e.printStackTrace();
        }
    }
}

