/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.imp;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.MetaTableCache;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ResourceCheckerUtil;
import com.adventnet.la.util.dm.MssqlProcessHandler;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.imp.FTPUtil;
import com.adventnet.sa.server.imp.ImportEvtLogs;
import com.enterprisedt.net.ftp.FTPClient;
import com.manageengine.ela.server.common.device.management.AddOrUpdateEventlogDevice;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ImportLogTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ImportLogTask.class.getName());
    private Persistence persistence = null;
    private HashMap hash = null;
    private long batch_size = 20000L;
    private Long il_id = null;
    private DataObject dobj = null;
    public boolean abort = false;
    private String binPath = System.getProperty("server.home") + File.separator + "bin";
    private HashMap map = new HashMap();
    Connection conn = null;
    Statement stat = null;
    ResultSet rs = null;
    List archiveFiles = null;
    String errMessage = null;
    MetaTableCache cache = MetaTableCache.getInstance();
    int threadId = 0;
    String dbserver = "";
    String dbname = "";
    String dbuser = "";
    String dbpass = "";
    boolean isMssql = false;
    boolean isWinAuthType = false;
    String commandToExecute = "";
    String timestampString = "";
    String nullString = "";

    public ImportLogTask(HashMap hash) {
        LOGGER.log(Level.FINE, "ImportLogTask: new task created...");
        this.hash = hash;
        this.il_id = (Long)hash.get("IL_ID");
        if (System.getProperty("batch_size") != null) {
            try {
                this.batch_size = Long.valueOf(System.getProperty("batch_size"));
            }
            catch (Exception e) {
                this.batch_size = 20000L;
                LOGGER.log(Level.INFO, "Invalid parameter resetting to default<->{0}", new Long(this.batch_size));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String osName;
            this.persistence = PersistenceDBUtil.getPersistence();
            this.isMssql = "true".equals(System.getProperty("DBType", "mysql"));
            this.isWinAuthType = "true".equals(System.getProperty("isWinAuthType", "false"));
            this.timestampString = " FROM_UNIXTIME(TIMESTAMP/1000) ";
            this.nullString = " NULL , ";
            if (this.isMssql) {
                this.timestampString = " DATEADD(ss, cast(TIMESTAMP as bigint)/1000+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101') ";
                this.nullString = "";
                String xmlFilePath = System.getProperty("server.home") + File.separator + "conf" + File.separator + "database_params.conf";
                HashMap DBParams = ResourceCheckerUtil.getConstraints((String)xmlFilePath, (String)"eventlog");
                if (DBParams != null) {
                    this.dbserver = (String)DBParams.get("DBServer");
                    this.dbname = (String)DBParams.get("DBName");
                    this.dbuser = (String)DBParams.get("DBUser");
                    this.dbpass = (String)DBParams.get("DBPass");
                    this.dbpass = EnDecryptImplSingleton.getInstance().decrypt(this.dbpass);
                    if (this.dbpass == null) {
                        this.dbpass = "";
                    }
                }
            }
            if ((osName = System.getProperty("os.name")).equalsIgnoreCase("windows nt") || osName.equalsIgnoreCase("windows 2000") || osName.equalsIgnoreCase("windows xp") || osName.equalsIgnoreCase("Windows 2003") || osName.equalsIgnoreCase("windows vista")) {
                this.commandToExecute = "cmd  /c ";
            } else if (osName.indexOf("95") >= 0 || osName.indexOf("98") >= 0) {
                this.commandToExecute = "command.com /c ";
            }
            this.conn = RelationalAPI.getInstance().getConnection();
            this.stat = this.conn.createStatement();
            this.archiveFiles = new ArrayList();
            ArrayList<Long> startTime = new ArrayList<Long>();
            ArrayList<Long> endTime = new ArrayList<Long>();
            LOGGER.log(Level.INFO, "mymap:" + this.hash + " map:" + this.map);
            String protocol = (String)this.hash.get("PROTOCOL");
            String importType = (String)this.hash.get("IMPORT_TYPE");
            File ftpFile = null;
            String filePath = null;
            String filename = null;
            if ("local".equals(importType)) {
                filePath = (String)this.hash.get("LOCATION");
            } else {
                ftpFile = this.getFileThruFTP(this.hash);
                filePath = ftpFile.getAbsolutePath();
                filename = ftpFile.getName();
                LOGGER.log(Level.INFO, "ftpFile:" + filePath);
            }
            ImportEvtLogs imp = new ImportEvtLogs();
            long dws = this.getDataOlderThanDWS();
            LOGGER.log(Level.INFO, "dws in java:" + dws);
            List details = imp.getDetails(filePath, (String)this.hash.get("LOG_TYPE"), this.isMssql ? 1 : 0);
            LOGGER.log(Level.INFO, "hostname details in import task:" + details);
            if (details.isEmpty()) {
                UpdateQueryImpl query = new UpdateQueryImpl("ImportedLogs");
                query.setCriteria(new Criteria(new Column("ImportedLogs", "IL_ID"), (Object)((Long)this.hash.get("IL_ID")), 0));
                if ("remote".equals((String)this.hash.get("IMPORT_TYPE"))) {
                    query.setUpdateColumn("FILE_NAME", (Object)filename);
                }
                query.setUpdateColumn("MESSAGE", (Object)"Could not open the given Evt File");
                this.persistence.update((UpdateQuery)query);
                return;
            }
            String hostName = (String)details.get(0);
            Long hstid = this.getHostId(hostName);
            int hostid = hstid.intValue();
            this.threadId = new LogRecord(Level.INFO, "").getThreadID();
            Table table = new Table("MetaTable");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            Column col = new Column("MetaTable", "LOOKUP_TABLENAME");
            Criteria cri = new Criteria(col, (Object)"EventLog", 0);
            sql.setCriteria(cri);
            sql.addSelectColumn(new Column("MetaTable", "*"));
            DataObject dob = DataAccess.constructDataObject();
            dob = DataAccess.get((SelectQuery)sql);
            Row row = dob.getFirstRow("MetaTable");
            Timestamp sTime = (Timestamp)row.get("START_TIME");
            Timestamp eTime = (Timestamp)row.get("END_TIME");
            String lookupTable = (String)row.get("LOOKUP_TABLENAME");
            if (sTime != null) {
                startTime.add(new Long(sTime.getTime()));
                this.map.put(hostid + "-" + this.threadId + "-file0", lookupTable);
            } else {
                startTime.add(new Long(0L));
            }
            if (eTime != null) {
                endTime.add(new Long(eTime.getTime()));
            } else {
                endTime.add(new Long(0L));
            }
            Long minTime = (Long)details.get(1);
            Long maxTime = (Long)details.get(2);
            Timestamp recStartTime = null;
            Timestamp recEndTime = null;
            if (minTime != null) {
                if (minTime.intValue() == 0) {
                    UpdateQueryImpl query = new UpdateQueryImpl("ImportedLogs");
                    query.setCriteria(new Criteria(new Column("ImportedLogs", "IL_ID"), (Object)((Long)this.hash.get("IL_ID")), 0));
                    if ("remote".equals((String)this.hash.get("IMPORT_TYPE"))) {
                        query.setUpdateColumn("FILE_NAME", (Object)filename);
                    }
                    query.setUpdateColumn("MESSAGE", (Object)"The given evt file is empty");
                    this.persistence.update((UpdateQuery)query);
                    return;
                }
                recStartTime = new Timestamp(minTime);
                recEndTime = new Timestamp(maxTime);
                UpdateQueryImpl query = new UpdateQueryImpl("ImportedLogs");
                query.setCriteria(new Criteria(new Column("ImportedLogs", "IL_ID"), (Object)((Long)this.hash.get("IL_ID")), 0));
                if ("remote".equals((String)this.hash.get("IMPORT_TYPE"))) {
                    query.setUpdateColumn("FILE_NAME", (Object)filename);
                }
                query.setUpdateColumn("HOST_ID", (Object)hstid);
                query.setUpdateColumn("START_TIME", (Object)recStartTime);
                query.setUpdateColumn("END_TIME", (Object)recEndTime);
                this.persistence.update((UpdateQuery)query);
            }
            int i = 1;
            this.rs = this.stat.executeQuery("Select START_TIME,END_TIME,LOOKUP_TABLENAME from MetaTable where TABLE_NAME='EventLog' and LOOKUP_TABLENAME!='EventLog' and ((START_TIME between '" + recStartTime + "' and '" + recEndTime + "') or (END_TIME between '" + recStartTime + "' and '" + recEndTime + "') or (START_TIME <= '" + recStartTime + "' and END_TIME >= '" + recStartTime + "') or (START_TIME <= '" + recEndTime + "' and END_TIME >= '" + recEndTime + "')) order by START_TIME desc");
            while (this.rs.next()) {
                LOGGER.log(Level.INFO, "endtime:" + this.rs.getObject(2));
                if (this.rs.getObject(1) == null || this.rs.getObject(2) == null) continue;
                startTime.add(new Long(((Timestamp)this.rs.getObject(1)).getTime()));
                endTime.add(new Long(((Timestamp)this.rs.getObject(2)).getTime()));
                lookupTable = this.rs.getString(3);
                this.map.put(hostid + "-" + this.threadId + "-file" + i, lookupTable);
                ++i;
            }
            int size = startTime.size();
            String dumpFile = null;
            Boolean throwAwayReport = (Boolean)this.hash.get("throwReport");
            long mnTime = minTime;
            long mxTime = maxTime;
            boolean isSingleFile = false;
            int fileid = -1;
            LOGGER.log(Level.INFO, "STARTTIME:" + startTime + " ENDTIME:" + endTime + " --st(size-1):" + startTime.get(size - 1));
            if (mxTime <= dws || throwAwayReport.booleanValue()) {
                LOGGER.log(Level.INFO, "insert into a throw away table");
                dumpFile = hostid + "-" + this.threadId + "-file-1";
                throwAwayReport = true;
            } else if (mxTime < (Long)startTime.get(size - 1) && mxTime > dws) {
                LOGGER.log(Level.INFO, "insert into a new splitted table");
                dumpFile = hostid + "-" + this.threadId + "-file-1";
                isSingleFile = true;
                fileid = -1;
            } else if (mnTime >= (Long)startTime.get(0)) {
                LOGGER.log(Level.INFO, "insert into base table eventlog");
                dumpFile = hostid + "-" + this.threadId + "-file0";
                isSingleFile = true;
                fileid = 0;
            } else if (mnTime < (Long)startTime.get(size - 1)) {
                LOGGER.log(Level.INFO, "insert few records, whose time is less than start time of the first splitted table, into a new table and rest into the base tables");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                String date = sdf.format(new Date(System.currentTimeMillis()));
                String newTable = "EventLog_" + date;
                Timestamp edTime = new Timestamp((Long)startTime.get(size - 1));
                this.stat.execute(this.dropTableQuery(newTable));
                this.stat.execute(this.createTableQuery(newTable, "EventLog"));
                this.stat.execute("insert into MetaTable(TABLE_NAME,START_TIME,END_TIME,START_INDEX,END_INDEX,LOOKUP_TABLENAME,STATUS) values('EventLog', '" + recStartTime + "', '" + edTime + "', -1, -1,'" + newTable + "','SUCCESS')");
                this.cache.add("EventLog", newTable, String.valueOf(recStartTime.getTime()), String.valueOf(edTime.getTime()));
                endTime.add((Long)startTime.get(size - 1));
                startTime.add(minTime);
                this.map.put(hostid + "-" + this.threadId + "-file" + i, newTable);
                dumpFile = "";
            } else {
                LOGGER.log(Level.INFO, "insert into multiple tables");
                dumpFile = "";
            }
            ArrayList timeCrit = new ArrayList();
            LOGGER.log(Level.INFO, "hostid in import task:" + hostid + " lookuptable map:" + this.map);
            String fcount = imp.importEvt(filePath, startTime, endTime, (String)this.hash.get("LOG_TYPE"), hostid, dumpFile, this.threadId, this.isMssql ? 1 : 0, timeCrit);
            LOGGER.log(Level.INFO, "fcount:" + fcount);
            StringTokenizer st = new StringTokenizer(fcount, ",");
            if (st.hasMoreTokens()) {
                fcount = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                this.errMessage = st.nextToken();
            }
            int fileCount = -2;
            if (fcount != null) {
                if ("ThrowAwayFile".equals(fcount)) {
                    throwAwayReport = true;
                } else {
                    fileCount = new Integer(fcount);
                }
            }
            boolean createNewTable = false;
            if (throwAwayReport.booleanValue()) {
                LOGGER.log(Level.INFO, "ThrowAwayReport");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                String date = sdf.format(new Date(System.currentTimeMillis()));
                String importedTable = "import_" + date;
                if (this.dumpFilesToDB(fileCount, importedTable, true, hstid, filename, minTime, maxTime) && hostName != null) {
                    this.archiveFiles(hostName, hstid);
                }
            } else {
                if (isSingleFile) {
                    fileCount = fileid;
                    LOGGER.log(Level.INFO, "single file count:" + fileCount);
                }
                if (fileCount == -1) {
                    this.dumpNewTable(hstid, filename, minTime, maxTime);
                    createNewTable = true;
                } else if (fileCount > -1) {
                    this.dumpFilesToDB(fileCount, "temp", false, hstid, filename, minTime, maxTime);
                }
                if (hostName != null) {
                    this.archiveFiles(hostName, hstid);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.stat != null) {
                    this.stat.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Exception while closing the connection:" + e);
            }
        }
    }

    private Long getHostId(String hostName) {
        try {
            SelectQueryImpl hostSql = new SelectQueryImpl(new Table("Hosts"));
            hostSql.addSelectColumn(new Column("Hosts", "*"));
            hostSql.setCriteria(new Criteria(new Column("Hosts", "DNS_NAME"), (Object)hostName, 0));
            DataObject hostDO = DataAccess.get((SelectQuery)hostSql);
            SelectQueryImpl groupSql = new SelectQueryImpl(new Table("HostGroup"));
            groupSql.addSelectColumn(new Column("HostGroup", "*"));
            groupSql.setCriteria(new Criteria(new Column("HostGroup", "NAME"), (Object)"WindowsGroup", 0));
            DataObject groupDO = DataAccess.get((SelectQuery)groupSql);
            Long hostId = null;
            hostId = !hostDO.isEmpty() ? (Long)hostDO.getFirstValue("Hosts", "HOST_ID") : AddOrUpdateEventlogDevice.addUnverifiedDevice(hostName).get(0);
            return hostId;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while retrieving hostid:" + e);
            e.printStackTrace();
            return new Long(0L);
        }
    }

    private boolean dumpFilesToDB(int fileCount, String tmpTable, boolean isThrowAway, Long hostid, String filename, Long minTime, Long maxTime) {
        try {
            String filepath = null;
            File f = null;
            String tableName = null;
            this.stat.execute(this.dropTableQuery(tmpTable));
            this.stat.execute(this.createTableQuery(tmpTable, "EventLog"));
            Timestamp impLogStartTime = null;
            Timestamp impLogEndTime = null;
            if (!isThrowAway) {
                for (int i = 0; i <= fileCount; ++i) {
                    tableName = (String)this.map.get(hostid.intValue() + "-" + this.threadId + "-file" + i);
                    filepath = this.binPath + File.separator + hostid + "-" + this.threadId + "-file" + i;
                    f = new File(filepath);
                    LOGGER.log(Level.INFO, "filepath::" + filepath + " file exists::" + f.exists());
                    if (!f.exists()) continue;
                    filepath = f.getCanonicalPath();
                    this.archiveFiles.add(f);
                    filepath = filepath.replace('\\', '/');
                    this.loadData(filepath, tableName);
                    this.loadData(filepath, tmpTable);
                }
            } else {
                filepath = this.binPath + File.separator + hostid + "-" + this.threadId + "-file-1";
                f = new File(filepath);
                LOGGER.log(Level.INFO, "throwaway filepath::" + filepath + " file exists:" + f.exists());
                if (f.exists()) {
                    filepath = f.getCanonicalPath();
                    this.archiveFiles.add(f);
                    filepath = filepath.replace('\\', '/');
                    this.loadData(filepath, tmpTable);
                }
            }
            impLogStartTime = new Timestamp(minTime);
            impLogEndTime = new Timestamp(maxTime);
            LOGGER.log(Level.INFO, "impLogStartTime:" + impLogStartTime + " impLogEndTime:" + impLogEndTime + " filepath:" + filepath);
            if (!isThrowAway) {
                this.trendTableQueries(tmpTable);
                this.populateCompTables(fileCount, tmpTable, impLogStartTime, impLogEndTime);
                this.stat.execute(this.dropTableQuery(tmpTable));
            }
            try {
                UpdateQueryImpl query = new UpdateQueryImpl("ImportedLogs");
                query.setCriteria(new Criteria(new Column("ImportedLogs", "IL_ID"), (Object)((Long)this.hash.get("IL_ID")), 0));
                if ("remote".equals((String)this.hash.get("IMPORT_TYPE"))) {
                    query.setUpdateColumn("FILE_NAME", (Object)filename);
                }
                query.setUpdateColumn("ERROR_MESSAGE", (Object)this.errMessage);
                query.setUpdateColumn("IMPORTED_TIME", (Object)new Timestamp(System.currentTimeMillis()));
                if (isThrowAway) {
                    query.setUpdateColumn("REPORT_STATUS", (Object)"ThrowAway");
                    query.setUpdateColumn("THROW_AWAY_TABLE", (Object)tmpTable);
                } else {
                    query.setUpdateColumn("REPORT_STATUS", (Object)"Active");
                }
                query.setUpdateColumn("MESSAGE", (Object)"Importing of Evt File is over");
                this.persistence.update((UpdateQuery)query);
            }
            catch (Exception ex) {
                LOGGER.log(Level.INFO, "Exception while updating ImportedLogs table");
                ex.printStackTrace();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    void dumpNewTable(Long hostid, String filename, long minTime, long maxTime) {
        try {
            String newTable = null;
            Timestamp sttime = null;
            Timestamp edtime = null;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String date = sdf.format(new Date(System.currentTimeMillis()));
            newTable = "EventLog_" + date;
            this.stat.execute(this.dropTableQuery(newTable));
            this.stat.execute(this.createTableQuery(newTable, "EventLog"));
            String filepath = this.binPath + File.separator + hostid + "-" + this.threadId + "-file-1";
            File f = new File(filepath);
            if (f.exists()) {
                filepath = f.getCanonicalPath();
                this.archiveFiles.add(f);
                filepath = filepath.replace('\\', '/');
                this.loadData(filepath, newTable);
                sttime = new Timestamp(minTime);
                edtime = new Timestamp(maxTime);
                LOGGER.log(Level.INFO, "sttime:" + sttime + " EndTime:" + edtime + " filepath:" + filepath);
                this.stat.execute("insert into MetaTable(TABLE_NAME,START_TIME,END_TIME,START_INDEX,END_INDEX,LOOKUP_TABLENAME,STATUS) values('EventLog','" + sttime + "', '" + edtime + "', -1, -1,'" + newTable + "','SUCCESS')");
                this.cache.add("EventLog", newTable, String.valueOf(minTime), String.valueOf(maxTime));
                LOGGER.log(Level.FINE, "metatable cache after updation-----:" + this.cache.getTableListFrmMemory("EventLog", String.valueOf(minTime), String.valueOf(maxTime)));
                LOGGER.log(Level.FINE, "cruncher done for a new table:::");
                this.trendTableQueries(newTable);
                this.populateCompTables(0, newTable, sttime, edtime);
            }
            try {
                UpdateQueryImpl query = new UpdateQueryImpl("ImportedLogs");
                query.setCriteria(new Criteria(new Column("ImportedLogs", "IL_ID"), (Object)((Long)this.hash.get("IL_ID")), 0));
                if ("remote".equals((String)this.hash.get("IMPORT_TYPE"))) {
                    query.setUpdateColumn("FILE_NAME", (Object)filename);
                }
                query.setUpdateColumn("ERROR_MESSAGE", (Object)this.errMessage);
                query.setUpdateColumn("IMPORTED_TIME", (Object)new Timestamp(System.currentTimeMillis()));
                query.setUpdateColumn("REPORT_STATUS", (Object)"Active");
                query.setUpdateColumn("MESSAGE", (Object)"Importing of Evt File is over");
                this.persistence.update((UpdateQuery)query);
            }
            catch (Exception ee) {
                LOGGER.log(Level.INFO, "Exception while updating ImportedLogs table");
                ee.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long getDataOlderThanDWS() {
        try {
            Table table = new Table("DataManagementTiming");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            Column col = new Column("DataManagementTiming", "TIMER_NAME");
            Criteria cri = new Criteria(col, (Object)"SYS_DATA_WINDOW", 0);
            sql.setCriteria(cri);
            sql.addSelectColumn(new Column("DataManagementTiming", "*"));
            DataObject doo = DataAccess.constructDataObject();
            doo = DataAccess.get((SelectQuery)sql);
            long days = 1L;
            if (!doo.isEmpty()) {
                days = new Long((String)doo.getFirstValue("DataManagementTiming", "TIMESTAMP")).intValue();
            }
            long olderTime = System.currentTimeMillis() - days * 86400000L;
            LOGGER.log(Level.INFO, "current time:" + System.currentTimeMillis() + " days:" + days + " olderTime:" + olderTime);
            return olderTime;
        }
        catch (Exception e) {
            return 1L;
        }
    }

    public DataObject getConfiguration(Long il_id) {
        if (il_id == null) {
            return null;
        }
        try {
            DataObject dobj = null;
            Row row = new Row("ImportedLogs");
            row.set("IL_ID", (Object)il_id);
            dobj = DataAccess.get((String)"ImportedLogs", (Row)row);
            return dobj;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.INFO, "Failed to get RECORD_MARKER");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveFiles(String hostName, Long hostid) {
        LOGGER.log(Level.INFO, "*******Archiving of imported files Started********");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String date = sdf.format(new Date(System.currentTimeMillis()));
        String archiveDir = null;
        String zipFileName = null;
        File directory = null;
        try {
            Table table = new Table("SystemConfigurations");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            Column col = new Column("SystemConfigurations", "CONF_NAME");
            Criteria cri = new Criteria(col, (Object)"sysArchiveLocation", 0);
            sql.setCriteria(cri);
            sql.addSelectColumn(new Column("SystemConfigurations", "*"));
            DataObject dob = DataAccess.get((SelectQuery)sql);
            archiveDir = (String)dob.getFirstValue("SystemConfigurations", "CONF_VALUE");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while getting the archive location");
            e.printStackTrace();
        }
        if ("archive".equals(archiveDir)) {
            archiveDir = System.getProperty("server.home") + "\\archive";
            zipFileName = archiveDir + "\\" + hostName + "_" + date + ".zip";
        } else {
            zipFileName = archiveDir + "\\" + hostName + "_" + date + ".zip";
        }
        directory = new File(archiveDir);
        if (!directory.exists()) {
            directory.mkdirs();
            System.out.println("New directory:" + directory + " created for archive ");
        }
        FileOutputStream dest = null;
        BufferedInputStream origin = null;
        ZipOutputStream out = null;
        FileInputStream fi = null;
        try {
            dest = new FileOutputStream(zipFileName);
            out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[1000];
            LOGGER.log(Level.INFO, "archiveFiles:" + this.archiveFiles + " size:" + this.archiveFiles.size());
            for (int i = 0; i < this.archiveFiles.size(); ++i) {
                int count;
                String filename = ((File)this.archiveFiles.get(i)).getName();
                fi = new FileInputStream((File)this.archiveFiles.get(i));
                origin = new BufferedInputStream(fi, 1000);
                ZipEntry entry = new ZipEntry(filename);
                LOGGER.log(Level.INFO, "zipped file:" + filename);
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 1000)) != -1) {
                    out.write(data, 0, count);
                }
                fi.close();
                origin.close();
            }
            out.close();
            dest.close();
            File archivedFile = new File(zipFileName);
            try {
                DataObject dObject = DataAccess.constructDataObject();
                Row row = new Row("SysArchivedFiles");
                row.set("HOST_ID", (Object)hostid);
                row.set("START_TIME", (Object)new Long(System.currentTimeMillis()));
                row.set("ARCHIVED_TIME", (Object)new Long(System.currentTimeMillis()));
                row.set("SIZE", (Object)new Long(archivedFile.length()));
                row.set("FILE_NAME", (Object)archivedFile.getAbsolutePath());
                row.set("STATUS", (Object)new Long(0L));
                row.set("TABLE_NAME", (Object)("ArchivedTable_" + System.currentTimeMillis()));
                row.set("TYPE", (Object)"IMPORT");
                dObject.addRow(row);
                DataAccess.add((DataObject)dObject);
                UpdateQueryImpl query = new UpdateQueryImpl("ImportedLogs");
                query.setCriteria(new Criteria(new Column("ImportedLogs", "IL_ID"), (Object)((Long)this.hash.get("IL_ID")), 0));
                query.setUpdateColumn("AF_ID", row.get("AFID"));
                this.persistence.update((UpdateQuery)query);
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Exception while inserting the archived file entries into SysArchivedFiles");
                e.printStackTrace();
            }
            LOGGER.log(Level.INFO, "******* Archiving Completed *******");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            try {
                if (origin != null) {
                    origin.close();
                }
                if (out != null) {
                    out.close();
                }
                if (fi != null) {
                    fi.close();
                }
                if (dest != null) {
                    dest.close();
                }
                for (int i = 0; i < this.archiveFiles.size(); ++i) {
                    ((File)this.archiveFiles.get(i)).delete();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private File getFileThruFTP(HashMap hash) {
        String fileName;
        block20: {
            FTPClient client;
            String remoteHost;
            block19: {
                String f;
                long intime = System.currentTimeMillis();
                boolean runSplitter = false;
                String protocol = (String)hash.get("PROTOCOL");
                File location = null;
                Object host = null;
                fileName = (String)hash.get("FILE_NAME");
                LOGGER.log(Level.FINE, "ImportLogTask HASHMAP IS {0}  ", hash);
                LOGGER.log(Level.FINE, "ImportLogTask FILE NAME IS {0}  ", fileName);
                remoteHost = URLDecoder.decode((String)hash.get("REMOTE_HOSTNAME"));
                String remoteUser = URLDecoder.decode((String)hash.get("REMOTE_USERNAME"));
                String remotePwd = URLDecoder.decode((String)hash.get("REMOTE_PASSWORD"));
                String remoteDir = (String)hash.get("REMOTE_DIR");
                int ftpPort = Integer.parseInt((String)hash.get("FTPPORT"));
                LOGGER.log(Level.INFO, "remoteDir" + remoteDir);
                if (fileName == null) {
                    int atIndex;
                    int indexOfSlash;
                    String loc = (String)hash.get("remotefilelocation");
                    int n = indexOfSlash = loc != null ? loc.lastIndexOf("/") : -1;
                    if (indexOfSlash > 0) {
                        fileName = loc.substring(indexOfSlash + 1, loc.length());
                    }
                    if (remoteDir == null && (atIndex = loc.indexOf("@")) > 0) {
                        int remoteDirStartIndex = atIndex + remoteHost.length() + 2;
                        if (remoteDirStartIndex < indexOfSlash) {
                            remoteDir = loc.substring(remoteDirStartIndex, loc.length());
                        } else if (remoteDirStartIndex == indexOfSlash) {
                            remoteDir = "";
                        }
                    }
                }
                LOGGER.log(Level.FINE, "ImportLogTask  FILE_NAME is  {0} and REMOTE_DIR is {1}  ", new String[]{fileName, remoteDir});
                if (!"ftp".equalsIgnoreCase(protocol)) {
                    LOGGER.log(Level.INFO, "Unsupported protocol{0}", hash);
                    location = null;
                }
                client = null;
                client = FTPUtil.getFTPClient(remoteHost, remoteUser, remotePwd, true, ftpPort);
                if (client == null || (f = FTPUtil.doFTP(client, null, remoteDir, fileName)) == null) break block19;
                location = new File(f);
                long sizeInBytes = location.length();
                if (sizeInBytes > 0x80000000L) {
                    runSplitter = true;
                }
                String size = null;
                size = sizeInBytes > 524288L ? (float)(sizeInBytes * 100L / 0x100000L) / 100.0f + " MB" : (sizeInBytes > 1024L ? (float)(sizeInBytes * 100L / 1024L) / 100.0f + " KB" : sizeInBytes + " Bytes");
            }
            try {
                FTPUtil.logOut(client);
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Exception while FTP logout");
            }
            break block20;
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    LOGGER.log(Level.INFO, "ImportLogTask:unable to ftp{0}", remoteHost);
                }
                catch (Throwable throwable) {
                    try {
                        FTPUtil.logOut(client);
                    }
                    catch (Exception e2) {
                        LOGGER.log(Level.INFO, "Exception while FTP logout");
                    }
                    throw throwable;
                }
                try {
                    FTPUtil.logOut(client);
                }
                catch (Exception e3) {
                    LOGGER.log(Level.INFO, "Exception while FTP logout");
                }
            }
        }
        File ftpFile = new File(System.getProperty("server.home") + "\\server\\imported_files\\" + fileName + "\\" + fileName);
        if (!ftpFile.exists()) {
            LOGGER.log(Level.FINE, "ImportLogTask:failed to fetch file<->{0}", hash);
        }
        return ftpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateCompTables(int fcount, String tableName, Timestamp logStartTime, Timestamp logEndTime) {
        LOGGER.log(Level.INFO, "Inside populateCompTables()");
        Statement compstat = null;
        try {
            compstat = this.conn.createStatement();
            ArrayList<Timestamp> startTime = new ArrayList<Timestamp>();
            ArrayList<Timestamp> endTime = new ArrayList<Timestamp>();
            ArrayList<String> tables = new ArrayList<String>();
            this.stat.execute(this.dropTableQuery("compliance"));
            this.stat.execute(this.createTableQuery("compliance", "Comp_EventLog"));
            if (this.isMssql) {
                this.stat.execute("insert into compliance select HOST_ID, EVENTID, TIMESTAMP, CASE when EVENTID IN (672,677) and MESSAGE LIKE 'Supplied Realm Name:' then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('User Name:', MESSAGE)+11, CHARINDEX('Supplied', MESSAGE)-CHARINDEX('User Name', MESSAGE)-16),char(9),''),char(13),'') when EVENTID = 677 and MESSAGE LIKE 'User Domain:' then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('User Name:', MESSAGE)+11, CHARINDEX('User Domain:', MESSAGE)-CHARINDEX('User Name:', MESSAGE)-13),char(10),''),char(13),'') when EVENTID=675 then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('User Name:', MESSAGE)+11, CHARINDEX('User ID:', MESSAGE)-CHARINDEX('User Name:', MESSAGE)-13),char(10),''),char(13),'') when EVENTID in (627,628,629,630,642) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Target Account Name:', MESSAGE)+21, CHARINDEX('Target Domain:', MESSAGE)-CHARINDEX('Target Account Name:', MESSAGE)-26),char(13),'') when EVENTID=680 and MESSAGE like '%Account Name%' then REPLACE(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Name:', MESSAGE)+18, CHARINDEX('Workstation', MESSAGE)-CHARINDEX('Account Name:', MESSAGE)-20),char(9),''),char(10),''),char(13),'') when EVENTID=680 and MESSAGE like '%attempt by%' then LTRIM(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('account:', MESSAGE)+9, CHARINDEX('Source', MESSAGE)-CHARINDEX('account:', MESSAGE)-13),char(13),'')) when EVENTID=681 then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('account:', MESSAGE)+9, CHARINDEX('by:', MESSAGE)-CHARINDEX('account:', MESSAGE)-13),char(13),'') when EVENTID in (517,560,563,565,566,595) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Primary User Name:', MESSAGE)+19, CHARINDEX('Primary Domain:', MESSAGE)-CHARINDEX('Primary User Name:', MESSAGE)-24),char(13),'') when (EVENTID between 528 and 540) or (EVENTID between 609 and 612) or EVENTID in (552,576,592,593,617,618,619,682,683) then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('User Name:', MESSAGE)+11, CHARINDEX('Domain', MESSAGE)-CHARINDEX('User Name:', MESSAGE)-16),char(13),''),char(10),'') when ((EVENTID between 4722 and 4726) or EVENTID in (4624,4625,4648,4720,4738,4742)) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Name:', MESSAGE,CHARINDEX('Logon ID:',MESSAGE))+13, CHARINDEX('Account Domain:', MESSAGE,CHARINDEX('Logon ID:',MESSAGE))-CHARINDEX('Account Name', MESSAGE,CHARINDEX('Logon ID:',MESSAGE))-17),char(9),'') when (EVENTID in (4634,4672,4719,4656,4688,4689,4740,4779,4778) or (EVENTID between 4658 and 4664)) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Name:', MESSAGE)+13, CHARINDEX('Account Domain:', MESSAGE)-CHARINDEX('Account Name', MESSAGE)-17),char(9),'') when EVENTID in (4776,4777) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Logon Account:', MESSAGE)+15, CHARINDEX('Source', MESSAGE)-CHARINDEX('Logon Account:', MESSAGE)-17),char(13),'') when EVENTID in (4768) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Name:', MESSAGE)+14, CHARINDEX('Supplied', MESSAGE)-CHARINDEX('Account Name:', MESSAGE)-16),char(9),'') when EVENTID in (4771) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Name:', MESSAGE)+14, CHARINDEX('Service', MESSAGE)-CHARINDEX('Account Name:', MESSAGE)-16),char(9),'') else '-' end as USER_NAME, CASE when ((EVENTID between 529 and 537) or EVENTID=539) then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Domain:', MESSAGE)+8, CHARINDEX('Logon Type:', MESSAGE)-CHARINDEX('Domain:', MESSAGE)-13),char(9),''),char(13),'') when EVENTID IN (528,538,540) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Domain:', MESSAGE)+8, CHARINDEX('Logon ID:', MESSAGE)-CHARINDEX('Domain:', MESSAGE)-13),char(9),'')  when EVENTID in (4634,4719) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Domain:', MESSAGE)+16, CHARINDEX('Logon ID:', MESSAGE)-CHARINDEX('Account Domain:', MESSAGE)-20),char(9),'') when ((EVENTID between 4722 and 4726) or (EVENTID in (4648,4720,4738,4740,4742))) then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Domain:', MESSAGE)+16, CHARINDEX('Logon ID:', MESSAGE)-CHARINDEX('Account Domain:', MESSAGE)-18),char(9),''),char(13),'') when EVENTID=4625 then REPLACE(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Domain:', MESSAGE,CHARINDEX('Logon ID:',MESSAGE))+16, CHARINDEX('Failure Information:',MESSAGE)-CHARINDEX('Account Domain:', MESSAGE,CHARINDEX('Logon ID:',MESSAGE))-18),char(9),''),char(10),''),char(13),'') when EVENTID=4624 then REPLACE(SUBSTRING(MESSAGE,CHARINDEX('Account Domain:', MESSAGE,CHARINDEX('New Logon:',MESSAGE))+17, CHARINDEX('Logon ID:', MESSAGE,CHARINDEX('New Logon:',MESSAGE))-CHARINDEX('Account Domain:', MESSAGE,CHARINDEX('New Logon:',MESSAGE))-21),char(9),'') else '-' end as DOMAIN, CASE when EVENTID = 672 and MESSAGE like '%Certificate Issuer Name:%' then REPLACE(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Client Address:', MESSAGE)+16, CHARINDEX('Certificate Issuer Name:', MESSAGE)-CHARINDEX('Client Address:', MESSAGE)-19),char(9),''),char(10),''),char(13),'') when (EVENTID = 672 and MESSAGE not like '%Certificate Issuer Name:%') or EVENTID IN (675,677) then REPLACE(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Client Address:', MESSAGE)+16, LEN(MESSAGE)-CHARINDEX('Client Address:', MESSAGE)-19),char(9),''),char(10),''),char(13),'') when ((EVENTID between 528 and 537) or EVENTID IN (539,540)) then LTRIM(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Logon Type:', MESSAGE)+11, CHARINDEX('Logon Process', MESSAGE)-CHARINDEX('Logon Type:', MESSAGE)-16),char(9),''),char(13),'')) when EVENTID = 538 then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Logon Type:', MESSAGE)+12, 4),char(13),''),char(10),'') when EVENTID in (4768,4771) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Client Address:', MESSAGE)+17, CHARINDEX('Client Port:', MESSAGE)-CHARINDEX('Client Address:', MESSAGE)-19),char(9),'') when EVENTID=4624 then REPLACE(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Logon Type:', MESSAGE)+12, CHARINDEX('New Logon:', MESSAGE)-CHARINDEX('Logon Type:', MESSAGE)-12),char(9),''),char(10),''),char(13),'') when EVENTID=4625 then REPLACE(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Logon Type:', MESSAGE)+12, CHARINDEX('Account For Which Logon Failed:', MESSAGE)-CHARINDEX('Logon Type', MESSAGE)-14),char(9),''),char(10),''),char(13),'') else '-' end as CLIENT, SOURCE, MESSAGE from " + tableName + " where (EVENTID in (552,560,576,592,593,595,617,618,619,672,675,676,677,680,681,682,683) or (EVENTID between 512 and 520) or (EVENTID between 528 and 540) or (EVENTID between 562 and 568) or (EVENTID between 624 and 666) or (EVENTID between 609 and 612) or (EVENTID between 4608 and 4612) or EVENTID in (4614,4615,4616,4624,4625,4634,4648,4656,4672,4688,4689,4691,4705,4706,4713,4714,4715,4719,4720,4768,4771,4772) or (EVENTID between 4658 and 4664)  or (EVENTID between 4722 and 4762) or (EVENTID between 4776 and 4779)) and TYPE='Security'");
            } else {
                this.stat.execute("insert into compliance select NULL, HOST_ID, EVENTID, TIMESTAMP, CASE when EVENTID IN (672,677) and MESSAGE LIKE 'Supplied Realm Name:' then TRIM(BOTH 0x09 FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('User Name:', MESSAGE)+11), (LOCATE('Supplied', MESSAGE))-(LOCATE('User Name', MESSAGE)+15)-1))) when EVENTID = 677 and MESSAGE LIKE 'User Domain:' then TRIM(BOTH 0x09 FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('User Name:', MESSAGE)+11), (LOCATE('User Domain:', MESSAGE))-(LOCATE('User Name', MESSAGE)+15)-1))) when EVENTID=675 then TRIM(BOTH 0x0A FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('User Name:', MESSAGE)+11), (LOCATE('User ID:', MESSAGE))-(LOCATE('User Name:', MESSAGE)+12)-1))) when EVENTID in (627,628,629,630,642,644,646) then TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Target Account Name:', MESSAGE)+21), (LOCATE('Target Domain:', MESSAGE))-(LOCATE('Target Account Name:', MESSAGE)+25)-1)) when EVENTID=680 and MESSAGE like '%Account Name%' then TRIM(BOTH 0x0A09 FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Account Name:', MESSAGE)+18), (LOCATE('Workstation', MESSAGE))-(LOCATE('Account Name:', MESSAGE)+21)-1))) when EVENTID=680 and MESSAGE like '%attempt by%' then TRIM(TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('account:', MESSAGE)+9), (LOCATE('Source', MESSAGE))-(LOCATE('account:', MESSAGE)+12)-1))) when EVENTID=681 then TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('account:', MESSAGE)+9), (LOCATE('by:', MESSAGE))-(LOCATE('account:', MESSAGE)+12)-1)) when EVENTID in (517,560,563,565,566,595) then TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Primary User Name:', MESSAGE)+19), (LOCATE('Primary Domain:', MESSAGE))-(LOCATE('Primary User Name:', MESSAGE)+23)-1)) when (EVENTID between 528 and 540) or (EVENTID between 609 and 612) or EVENTID in (552,576,592,593,617,618,619,682,683) then TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('User Name:', MESSAGE)+11), (LOCATE('Domain', MESSAGE))-(LOCATE('User Name:', MESSAGE)+15)-1)) when ((EVENTID between 4722 and 4726) or (EVENTID in (4624,4625,4648,4720,4738,4742))) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Name:', MESSAGE,LOCATE('Logon ID:',MESSAGE))+13), (LOCATE('Account Domain:', MESSAGE,LOCATE('Logon ID:',MESSAGE)))-(LOCATE('Account Name', MESSAGE,LOCATE('Logon ID:',MESSAGE))+16)-1)) when (EVENTID in (4634,4656,4672,4688,4689,4719,4740,4778,4779) or (EVENTID between 4658 and 4664)) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Name:', MESSAGE)+14), (LOCATE('Account Domain:', MESSAGE))-(LOCATE('Account Name', MESSAGE)+17)-1))when EVENTID in (4776,4777) then TRIM(BOTH 0x0D FROM TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Logon Account:', MESSAGE)+15), (LOCATE('Source', MESSAGE))-(LOCATE('Logon Account:', MESSAGE)+16)-1))) when EVENTID in (4768) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Name:', MESSAGE)+14), (LOCATE('Supplied', MESSAGE))-(LOCATE('Account Name:', MESSAGE)+15)-1)) when EVENTID in (4771) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Name:', MESSAGE)+14), (LOCATE('Service', MESSAGE))-(LOCATE('Account Name:', MESSAGE)+15)-1)) else '-' end as USER_NAME, CASE when ((EVENTID between 529 and 537) or EVENTID=539) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Domain:', MESSAGE)+8), (LOCATE('Logon Type:', MESSAGE))-(LOCATE('Domain:', MESSAGE)+12)-1)) when EVENTID IN (528,538,540) then TRIM(TRIM(BOTH 0x09 FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Domain:', MESSAGE)+8), (LOCATE('Logon ID:', MESSAGE))-(LOCATE('Domain:', MESSAGE)+12)-1))))  when EVENTID in (4634,4719) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Domain:', MESSAGE)+16), (LOCATE('Logon ID:', MESSAGE))-(LOCATE('Account Domain:', MESSAGE)+17)-1)) when ((EVENTID between 4722 and 4726) or (EVENTID in (4648,4720,4738,4740,4742))) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Domain:', MESSAGE)+16), (LOCATE('Logon ID:', MESSAGE))-(LOCATE('Account Domain:', MESSAGE)+17)-1)) when EVENTID=4625 then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Domain:', MESSAGE,LOCATE('Logon ID:',MESSAGE))+17), (LOCATE('Failure Information:',MESSAGE))-(LOCATE('Account Domain:', MESSAGE,LOCATE('Logon ID:',MESSAGE))+23))) when EVENTID=4624 then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE,(LOCATE('Account Domain:', MESSAGE,LOCATE('New Logon:',MESSAGE))+17), (LOCATE('Logon ID:', MESSAGE,LOCATE('New Logon:',MESSAGE)))-(LOCATE('Account Domain:', MESSAGE,LOCATE('New Logon:',MESSAGE))+20)-1)) else '-' end as DOMAIN, CASE when EVENTID = 672 and MESSAGE like '%Certificate Issuer Name:%' then TRIM(BOTH 0x09 FROM TRIM(BOTH 0x0A FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Client Address:', MESSAGE)+17), (LOCATE('Certificate Issuer Name:', MESSAGE))-(LOCATE('Client Address:', MESSAGE)+18)-1)))) when EVENTID = 672 and MESSAGE not like '%Certificate Issuer Name:%' then TRIM(BOTH 0x09 FROM TRIM(BOTH 0x0A FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Client Address:', MESSAGE)+17))))) when EVENTID in (675,677) then TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Client Address:', MESSAGE)+17))) when ((EVENTID between 528 and 537) or EVENTID IN (539,540)) then TRIM(TRIM(BOTH 0x09 from TRIM(BOTH 0x0D from SUBSTRING(MESSAGE, (LOCATE('Logon Type:', MESSAGE)+11), (LOCATE('Logon Process', MESSAGE))-(LOCATE('Logon Type:', MESSAGE)+15)-1)))) when EVENTID = 538 then TRIM(TRAILING 0x0D0D0A  FROM SUBSTRING(MESSAGE, (LOCATE('Logon Type:', MESSAGE)+12), 4)) when EVENTID in (4768,4771) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Client Address:', MESSAGE)+17), (LOCATE('Client Port:', MESSAGE))-(LOCATE('Client Address:', MESSAGE)+18)-1)) when EVENTID=4624 then TRIM(BOTH 0x09 from TRIM(BOTH 0x0A from TRIM(BOTH 0x0D from TRIM(BOTH 0x0D from SUBSTRING(MESSAGE, (LOCATE('Logon Type:', MESSAGE)+12), (LOCATE('New Logon:', MESSAGE))-(LOCATE('Logon Type:', MESSAGE)+11)-1))))) when EVENTID=4625 then TRIM(BOTH 0x09 from TRIM(BOTH 0x0A FROM TRIM(BOTH 0x0D from SUBSTRING(MESSAGE, (LOCATE('Logon Type:', MESSAGE)+12), (LOCATE('Account For Which Logon Failed:', MESSAGE))-(LOCATE('Logon Type:', MESSAGE)+13)-1)))) else '-' end as CLIENT, SOURCE, MESSAGE from " + tableName + " where (EVENTID in (552,560,576,592,593,595,617,618,619,672,675,676,677,680,681,682,683) or (EVENTID between 512 and 520) or (EVENTID between 528 and 540) or (EVENTID between 562 and 568) or (EVENTID between 624 and 666) or (EVENTID between 609 and 612) or (EVENTID between 4608 and 4612) or EVENTID in (4614,4615,4616,4624,4625,4634,4648,4656,4672,4688,4689,4691,4705,4706,4713,4714,4715,4719,4720,4768,4771,4772) or (EVENTID between 4658 and 4664)  or (EVENTID between 4722 and 4762) or (EVENTID between 4776 and 4779)) and TYPE='Security'");
            }
            this.rs = this.stat.executeQuery("Select START_TIME,END_TIME from MetaTable where LOOKUP_TABLENAME='Comp_EventLog'");
            if (this.rs.next()) {
                startTime.add((Timestamp)this.rs.getObject(1));
                endTime.add((Timestamp)this.rs.getObject(2));
                this.stat.execute("insert into Comp_EventLog select " + this.nullString + " HOST_ID, EVENTID, TIMESTAMP, USER_NAME, DOMAIN, CLIENT, SOURCE, MESSAGE from compliance where " + this.timestampString + " >= '" + (Timestamp)this.rs.getObject(1) + "'");
            }
            this.rs = this.stat.executeQuery("Select START_TIME,END_TIME,LOOKUP_TABLENAME from MetaTable where TABLE_NAME='Comp_EventLog' and LOOKUP_TABLENAME!='Comp_EventLog' and ((START_TIME between '" + logStartTime + "' and '" + logEndTime + "') or (END_TIME between '" + logStartTime + "' and '" + logEndTime + "') or (START_TIME <= '" + logStartTime + "' and END_TIME >= '" + logStartTime + "') or (START_TIME <= '" + logEndTime + "' and END_TIME >= '" + logEndTime + "'))");
            while (this.rs.next()) {
                startTime.add((Timestamp)this.rs.getObject(1));
                endTime.add((Timestamp)this.rs.getObject(2));
                tables.add(this.rs.getString(3));
                compstat.execute("insert into " + this.rs.getObject(3) + " select " + this.nullString + " HOST_ID, EVENTID, TIMESTAMP, USER_NAME, DOMAIN, CLIENT, SOURCE, MESSAGE from compliance where " + this.timestampString + " >= '" + (Timestamp)this.rs.getObject(1) + "' and " + this.timestampString + " <= '" + (Timestamp)this.rs.getObject(2) + "'");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String date = sdf.format(new Date(System.currentTimeMillis()));
            String newTable = "Comp_EventLog_" + date;
            int size = startTime.size();
            this.stat.execute(this.dropTableQuery(newTable));
            this.stat.execute(this.createTableQuery(newTable, "Comp_EventLog"));
            this.stat.execute(" insert into " + newTable + " select " + this.nullString + " HOST_ID, EVENTID, TIMESTAMP, USER_NAME, DOMAIN, CLIENT, SOURCE, MESSAGE from compliance where " + this.timestampString + " < '" + startTime.get(size - 1) + "'");
            String time = "TIMESTAMP";
            if (this.isMssql) {
                time = "cast(TIMESTAMP as bigint)";
            }
            this.rs = this.stat.executeQuery("select min(" + time + "), max(" + time + ") from " + newTable);
            if (this.rs.next()) {
                Timestamp sttime = null;
                Timestamp edtime = null;
                if (this.rs.getObject(1) != null) {
                    try {
                        sttime = new Timestamp(new Long(this.rs.getObject(1).toString()));
                        edtime = new Timestamp(new Long(this.rs.getObject(2).toString()));
                    }
                    catch (Exception ex) {
                        sttime = new Timestamp(0L);
                        edtime = new Timestamp(0L);
                    }
                    this.stat.execute("insert into MetaTable(TABLE_NAME,START_TIME,END_TIME,START_INDEX,END_INDEX,LOOKUP_TABLENAME,STATUS) values('Comp_EventLog', '" + sttime + "', '" + edtime + "', -1, -1,'" + newTable + "','SUCCESS')");
                    this.cache.add("Comp_EventLog", newTable, String.valueOf(sttime.getTime()), String.valueOf(edtime.getTime()));
                } else {
                    this.stat.execute(this.dropTableQuery(newTable));
                }
            }
            if (this.isMssql) {
                this.stat.execute("insert into Comp_EventLog_Hr_Trend select HOUROFDAY, HOUR, HOSTID, EVENTID, USER_NAME, DOMAIN, CLIENT, SOURCE, SUM(EVT_CNT) as EVT_CNT from (select DATEPART(HOUR, DATEADD(ss, cast(TIMESTAMP as bigint)/1000+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101')) as HOUROFDAY, CONVERT(datetime, SUBSTRING(CONVERT(VARCHAR(26), DATEADD(ss, cast(TIMESTAMP as bigint)/1000+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101'), 121),0,15) + '00:00:00') as HOUR, HOST_ID as HOSTID, EVENTID, CASE when EVENTID IN (672,677) and MESSAGE LIKE 'Supplied Realm Name:' then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('User Name:', MESSAGE)+11, CHARINDEX('Supplied', MESSAGE)-CHARINDEX('User Name', MESSAGE)-16),char(9),''),char(13),'') when EVENTID = 677 and MESSAGE LIKE 'User Domain:' then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('User Name:', MESSAGE)+11, CHARINDEX('User Domain:', MESSAGE)-CHARINDEX('User Name:', MESSAGE)-13),char(10),''),char(13),'') when EVENTID=675 then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('User Name:', MESSAGE)+11, CHARINDEX('User ID:', MESSAGE)-CHARINDEX('User Name:', MESSAGE)-13),char(10),''),char(13),'') when EVENTID in (627,628,629,630,642) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Target Account Name:', MESSAGE)+21, CHARINDEX('Target Domain:', MESSAGE)-CHARINDEX('Target Account Name:', MESSAGE)-26),char(13),'') when EVENTID=680 and MESSAGE like '%Account Name%' then REPLACE(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Name:', MESSAGE)+18, CHARINDEX('Workstation', MESSAGE)-CHARINDEX('Account Name:', MESSAGE)-20),char(9),''),char(10),''),char(13),'') when EVENTID=680 and MESSAGE like '%attempt by%' then LTRIM(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('account:', MESSAGE)+9, CHARINDEX('Source', MESSAGE)-CHARINDEX('account:', MESSAGE)-13),char(13),'')) when EVENTID=681 then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('account:', MESSAGE)+9, CHARINDEX('by:', MESSAGE)-CHARINDEX('account:', MESSAGE)-13),char(13),'') when EVENTID in (517,560,563,565,566,595) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Primary User Name:', MESSAGE)+19, CHARINDEX('Primary Domain:', MESSAGE)-CHARINDEX('Primary User Name:', MESSAGE)-24),char(13),'') when (EVENTID between 528 and 540) or (EVENTID between 609 and 612) or EVENTID in (552,576,592,593,617,618,619,682,683) then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('User Name:', MESSAGE)+11, CHARINDEX('Domain', MESSAGE)-CHARINDEX('User Name:', MESSAGE)-16),char(13),''),char(10),'') when ((EVENTID between 4722 and 4726) or EVENTID in (4624,4625,4648,4720,4738,4742)) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Name:', MESSAGE,CHARINDEX('Logon ID:',MESSAGE))+13, CHARINDEX('Account Domain:', MESSAGE,CHARINDEX('Logon ID:',MESSAGE))-CHARINDEX('Account Name', MESSAGE,CHARINDEX('Logon ID:',MESSAGE))-17),char(9),'') when (EVENTID in (4634,4672,4719,4656,4688,4689,4740,4779,4778) or (EVENTID between 4658 and 4664)) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Name:', MESSAGE)+13, CHARINDEX('Account Domain:', MESSAGE)-CHARINDEX('Account Name', MESSAGE)-17),char(9),'') when EVENTID in (4776,4777) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Logon Account:', MESSAGE)+15, CHARINDEX('Source', MESSAGE)-CHARINDEX('Logon Account:', MESSAGE)-17),char(13),'') when EVENTID in (4768) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Name:', MESSAGE)+14, CHARINDEX('Supplied', MESSAGE)-CHARINDEX('Account Name:', MESSAGE)-16),char(9),'') when EVENTID in (4771) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Name:', MESSAGE)+14, CHARINDEX('Service', MESSAGE)-CHARINDEX('Account Name:', MESSAGE)-16),char(9),'') else '-' end as USER_NAME, CASE when ((EVENTID between 529 and 537) or EVENTID=539) then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Domain:', MESSAGE)+8, CHARINDEX('Logon Type:', MESSAGE)-CHARINDEX('Domain:', MESSAGE)-13),char(9),''),char(13),'') when EVENTID IN (528,538,540) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Domain:', MESSAGE)+8, CHARINDEX('Logon ID:', MESSAGE)-CHARINDEX('Domain:', MESSAGE)-13),char(9),'')  when EVENTID in (4634,4719) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Domain:', MESSAGE)+16, CHARINDEX('Logon ID:', MESSAGE)-CHARINDEX('Account Domain:', MESSAGE)-20),char(9),'') when ((EVENTID between 4722 and 4726) or (EVENTID in (4648,4720,4738,4740,4742))) then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Domain:', MESSAGE)+16, CHARINDEX('Logon ID:', MESSAGE)-CHARINDEX('Account Domain:', MESSAGE)-18),char(9),''),char(13),'') when EVENTID=4625 then REPLACE(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Account Domain:', MESSAGE,CHARINDEX('Logon ID:',MESSAGE))+16, CHARINDEX('Failure Information:',MESSAGE)-CHARINDEX('Account Domain:', MESSAGE,CHARINDEX('Logon ID:',MESSAGE))-18),char(9),''),char(10),''),char(13),'') when EVENTID=4624 then REPLACE(SUBSTRING(MESSAGE,CHARINDEX('Account Domain:', MESSAGE,CHARINDEX('New Logon:',MESSAGE))+17, CHARINDEX('Logon ID:', MESSAGE,CHARINDEX('New Logon:',MESSAGE))-CHARINDEX('Account Domain:', MESSAGE,CHARINDEX('New Logon:',MESSAGE))-21),char(9),'') else '-' end as DOMAIN, CASE when EVENTID = 672 and MESSAGE like '%Certificate Issuer Name:%' then REPLACE(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Client Address:', MESSAGE)+16, CHARINDEX('Certificate Issuer Name:', MESSAGE)-CHARINDEX('Client Address:', MESSAGE)-19),char(9),''),char(10),''),char(13),'') when (EVENTID = 672 and MESSAGE not like '%Certificate Issuer Name:%') or EVENTID IN (675,677) then REPLACE(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Client Address:', MESSAGE)+16, LEN(MESSAGE)-CHARINDEX('Client Address:', MESSAGE)-19),char(9),''),char(10),''),char(13),'') when ((EVENTID between 528 and 537) or EVENTID IN (539,540)) then LTRIM(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Logon Type:', MESSAGE)+11, CHARINDEX('Logon Process', MESSAGE)-CHARINDEX('Logon Type:', MESSAGE)-16),char(9),''),char(13),'')) when EVENTID = 538 then REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Logon Type:', MESSAGE)+12, 4),char(13),''),char(10),'') when EVENTID in (4768,4771) then REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Client Address:', MESSAGE)+17, CHARINDEX('Client Port:', MESSAGE)-CHARINDEX('Client Address:', MESSAGE)-19),char(9),'') when EVENTID=4624 then REPLACE(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Logon Type:', MESSAGE)+12, CHARINDEX('New Logon:', MESSAGE)-CHARINDEX('Logon Type:', MESSAGE)-12),char(9),''),char(10),''),char(13),'') when EVENTID=4625 then REPLACE(REPLACE(REPLACE(SUBSTRING(MESSAGE, CHARINDEX('Logon Type:', MESSAGE)+12, CHARINDEX('Account For Which Logon Failed:', MESSAGE)-CHARINDEX('Logon Type', MESSAGE)-14),char(9),''),char(10),''),char(13),'') else '-' end as CLIENT, SOURCE, count(*) as EVT_CNT from " + tableName + " where (EVENTID in (552,560,576,592,593,595,617,618,619,672,675,676,677,680,681,682,683) or (EVENTID between 512 and 520) or (EVENTID between 528 and 540) or (EVENTID between 562 and 568) or (EVENTID between 624 and 666) or (EVENTID between 609 and 612) or (EVENTID between 4608 and 4612) or EVENTID in (4614,4615,4616,4624,4625,4634,4648,4656,4672,4688,4689,4691,4705,4706,4713,4714,4715,4719,4720,4768,4771,4772) or (EVENTID between 4658 and 4664)  or (EVENTID between 4722 and 4762) or (EVENTID between 4776 and 4779)) and TYPE='Security' group by HOST_ID, EVENTID, SOURCE, MESSAGE, TIMESTAMP)as CompEventLogHrTrend group by HOSTID, HOUR, EVENTID, SOURCE, HOUROFDAY, USER_NAME, DOMAIN, CLIENT");
            } else {
                this.stat.execute("insert into Comp_EventLog_Hr_Trend select NULL, DATE_FORMAT(FROM_UNIXTIME(TIMESTAMP/1000), '%H') as HOUROFDAY, DATE_FORMAT(FROM_UNIXTIME(TIMESTAMP/1000), '%Y-%m-%d %H:00:00') as HOUR, HOST_ID as HOSTID, EVENTID, CASE when EVENTID IN (672,677) and MESSAGE LIKE 'Supplied Realm Name:' then TRIM(BOTH 0x09 FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('User Name:', MESSAGE)+11), (LOCATE('Supplied', MESSAGE))-(LOCATE('User Name', MESSAGE)+15)-1))) when EVENTID = 677 and MESSAGE LIKE 'User Domain:' then TRIM(BOTH 0x09 FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('User Name:', MESSAGE)+11), (LOCATE('User Domain:', MESSAGE))-(LOCATE('User Name', MESSAGE)+15)-1))) when EVENTID=675 then TRIM(BOTH 0x0A FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('User Name:', MESSAGE)+11), (LOCATE('User ID:', MESSAGE))-(LOCATE('User Name:', MESSAGE)+12)-1))) when EVENTID in (627,628,629,630,642,644,646) then TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Target Account Name:', MESSAGE)+21), (LOCATE('Target Domain:', MESSAGE))-(LOCATE('Target Account Name:', MESSAGE)+25)-1)) when EVENTID=680 and MESSAGE like '%Account Name%' then TRIM(BOTH 0x0A09 FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Account Name:', MESSAGE)+18), (LOCATE('Workstation', MESSAGE))-(LOCATE('Account Name:', MESSAGE)+21)-1))) when EVENTID=680 and MESSAGE like '%attempt by%' then TRIM(TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('account:', MESSAGE)+9), (LOCATE('Source', MESSAGE))-(LOCATE('account:', MESSAGE)+12)-1))) when EVENTID=681 then TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('account:', MESSAGE)+9), (LOCATE('by:', MESSAGE))-(LOCATE('account:', MESSAGE)+12)-1)) when EVENTID in (517,560,563,565,566,595) then TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Primary User Name:', MESSAGE)+19), (LOCATE('Primary Domain:', MESSAGE))-(LOCATE('Primary User Name:', MESSAGE)+23)-1)) when (EVENTID between 528 and 540) or (EVENTID between 609 and 612) or EVENTID in (552,576,592,593,617,618,619,682,683) then TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('User Name:', MESSAGE)+11), (LOCATE('Domain', MESSAGE))-(LOCATE('User Name:', MESSAGE)+15)-1)) when ((EVENTID between 4722 and 4726) or (EVENTID in (4624,4625,4648,4720,4738,4742))) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Name:', MESSAGE,LOCATE('Logon ID:',MESSAGE))+13), (LOCATE('Account Domain:', MESSAGE,LOCATE('Logon ID:',MESSAGE)))-(LOCATE('Account Name', MESSAGE,LOCATE('Logon ID:',MESSAGE))+16)-1)) when (EVENTID in (4634,4656,4672,4688,4689,4719,4740,4778,4779) or (EVENTID between 4658 and 4664)) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Name:', MESSAGE)+14), (LOCATE('Account Domain:', MESSAGE))-(LOCATE('Account Name', MESSAGE)+17)-1))when EVENTID in (4776,4777) then TRIM(BOTH 0x0D FROM TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Logon Account:', MESSAGE)+15), (LOCATE('Source', MESSAGE))-(LOCATE('Logon Account:', MESSAGE)+16)-1))) when EVENTID in (4768) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Name:', MESSAGE)+14), (LOCATE('Supplied', MESSAGE))-(LOCATE('Account Name:', MESSAGE)+15)-1)) when EVENTID in (4771) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Name:', MESSAGE)+14), (LOCATE('Service', MESSAGE))-(LOCATE('Account Name:', MESSAGE)+15)-1)) else '-' end as USER_NAME, CASE when ((EVENTID between 529 and 537) or EVENTID=539) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Domain:', MESSAGE)+8), (LOCATE('Logon Type:', MESSAGE))-(LOCATE('Domain:', MESSAGE)+12)-1)) when EVENTID IN (528,538,540) then TRIM(TRIM(BOTH 0x09 FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Domain:', MESSAGE)+8), (LOCATE('Logon ID:', MESSAGE))-(LOCATE('Domain:', MESSAGE)+12)-1))))  when EVENTID in (4634,4719) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Domain:', MESSAGE)+16), (LOCATE('Logon ID:', MESSAGE))-(LOCATE('Account Domain:', MESSAGE)+17)-1)) when ((EVENTID between 4722 and 4726) or (EVENTID in (4648,4720,4738,4740,4742))) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Domain:', MESSAGE)+16), (LOCATE('Logon ID:', MESSAGE))-(LOCATE('Account Domain:', MESSAGE)+17)-1)) when EVENTID=4625 then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Account Domain:', MESSAGE,LOCATE('Logon ID:',MESSAGE))+17), (LOCATE('Failure Information:',MESSAGE))-(LOCATE('Account Domain:', MESSAGE,LOCATE('Logon ID:',MESSAGE))+23))) when EVENTID=4624 then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE,(LOCATE('Account Domain:', MESSAGE,LOCATE('New Logon:',MESSAGE))+17), (LOCATE('Logon ID:', MESSAGE,LOCATE('New Logon:',MESSAGE)))-(LOCATE('Account Domain:', MESSAGE,LOCATE('New Logon:',MESSAGE))+20)-1)) else '-' end as DOMAIN, CASE when EVENTID = 672 and MESSAGE like '%Certificate Issuer Name:%' then TRIM(BOTH 0x09 FROM TRIM(BOTH 0x0A FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Client Address:', MESSAGE)+17), (LOCATE('Certificate Issuer Name:', MESSAGE))-(LOCATE('Client Address:', MESSAGE)+18)-1)))) when EVENTID = 672 and MESSAGE not like '%Certificate Issuer Name:%' then TRIM(BOTH 0x09 FROM TRIM(BOTH 0x0A FROM TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Client Address:', MESSAGE)+17))))) when EVENTID in (675,677) then TRIM(BOTH 0x0D FROM SUBSTRING(MESSAGE, (LOCATE('Client Address:', MESSAGE)+17))) when ((EVENTID between 528 and 537) or EVENTID IN (539,540)) then TRIM(TRIM(BOTH 0x09 from TRIM(BOTH 0x0D from SUBSTRING(MESSAGE, (LOCATE('Logon Type:', MESSAGE)+11), (LOCATE('Logon Process', MESSAGE))-(LOCATE('Logon Type:', MESSAGE)+15)-1)))) when EVENTID = 538 then TRIM(TRAILING 0x0D0D0A  FROM SUBSTRING(MESSAGE, (LOCATE('Logon Type:', MESSAGE)+12), 4)) when EVENTID in (4768,4771) then TRIM(BOTH 0x09 FROM SUBSTRING(MESSAGE, (LOCATE('Client Address:', MESSAGE)+17), (LOCATE('Client Port:', MESSAGE))-(LOCATE('Client Address:', MESSAGE)+18)-1)) when EVENTID=4624 then TRIM(BOTH 0x09 from TRIM(BOTH 0x0A from TRIM(BOTH 0x0D from TRIM(BOTH 0x0D from SUBSTRING(MESSAGE, (LOCATE('Logon Type:', MESSAGE)+12), (LOCATE('New Logon:', MESSAGE))-(LOCATE('Logon Type:', MESSAGE)+11)-1))))) when EVENTID=4625 then TRIM(BOTH 0x09 from TRIM(BOTH 0x0A FROM TRIM(BOTH 0x0D from SUBSTRING(MESSAGE, (LOCATE('Logon Type:', MESSAGE)+12), (LOCATE('Account For Which Logon Failed:', MESSAGE))-(LOCATE('Logon Type:', MESSAGE)+13)-1)))) else '-' end as CLIENT, SOURCE, count(*) as EVT_CNT from " + tableName + " where (EVENTID in (552,560,576,592,593,595,617,618,619,672,675,676,677,680,681,682,683) or (EVENTID between 512 and 520) or (EVENTID between 528 and 540) or (EVENTID between 562 and 568) or (EVENTID between 624 and 666) or (EVENTID between 609 and 612) or (EVENTID between 4608 and 4612) or EVENTID in (4614,4615,4616,4624,4625,4634,4648,4656,4672,4688,4689,4691,4705,4706,4713,4714,4715,4719,4720,4768,4771,4772) or (EVENTID between 4658 and 4664)  or (EVENTID between 4722 and 4762) or (EVENTID between 4776 and 4779)) and TYPE='Security' group by HOST_ID, HOUR, EVENTID, SOURCE, HOUROFDAY, USER_NAME, DOMAIN, CLIENT");
            }
            this.stat.execute(this.dropTableQuery("compliance"));
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while populating compliance tables:::");
            e.printStackTrace();
        }
        finally {
            try {
                if (compstat != null) {
                    compstat.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private String dropTableQuery(String tableName) {
        String dropQuery = "drop table if exists " + tableName;
        if (this.isMssql) {
            dropQuery = "IF EXISTS(select * from sysobjects where name='" + tableName + "') DROP TABLE " + tableName;
        }
        return dropQuery;
    }

    private String createTableQuery(String newTableName, String oldTableName) throws Exception {
        String createQuery = "create table " + newTableName + " like " + oldTableName;
        if (this.isMssql) {
            createQuery = new MssqlProcessHandler().constructQuery(oldTableName, newTableName);
        }
        return createQuery;
    }

    private void loadData(String filepath, String tableName) throws Exception {
        if (this.isMssql) {
            if (this.isWinAuthType) {
                this.executeCommand(this.commandToExecute + " ..\\bin\\bcp.exe [" + this.dbname + "].dbo." + tableName + " in \"" + filepath + "\" -S " + this.dbserver + " -T -t \"|**|\" -r \"|**|**|\\n\" -e ..\\server\\default\\log\\impevterr.txt -c");
            } else {
                this.executeCommand(this.commandToExecute + " ..\\bin\\bcp.exe [" + this.dbname + "].dbo." + tableName + " in \"" + filepath + "\" -S " + this.dbserver + " -U " + this.dbuser + " -P \"" + this.dbpass + "\" -t \"|**|\" -r \"|**|**|\\n\" -e ..\\server\\default\\log\\impevterr.txt -c");
            }
        } else {
            this.stat.execute("load data local infile '" + filepath + "' into table " + tableName + " fields terminated by '|**|' lines terminated by '|**|**|' starting by '|**|'");
        }
    }

    private void trendTableQueries(String tableName) throws Exception {
        if (this.isMssql) {
            this.stat.execute("insert into EventLog_Hr_Trend select HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, EVENTID, SUM(ERROR_CNT) as ERROR_CNT, SUM(WARNING_CNT) as WARNING_CNT, SUM(INFORMATION_CNT) as INFORMATION_CNT, SUM(SUCCESS_CNT) as SUCCESS_CNT, SUM(FAILURE_CNT) as FAILURE_CNT from (select DATEPART(HOUR, DATEADD(ss, cast(TIMESTAMP as bigint)/1000+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101')) as HOUROFDAY, CONVERT(datetime, SUBSTRING(CONVERT(VARCHAR(26), DATEADD(ss, cast(TIMESTAMP as bigint)/1000+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101'), 121),0,15) + '00:00:00') as HOUR, HOST_ID as HOSTID, SOURCE, TYPE, EVENTID, count(CASE when SEVERITY='Error' THEN 1 ELSE NULL END) as ERROR_CNT, count(CASE when SEVERITY='Warning' THEN 1 ELSE NULL END) as WARNING_CNT, count(CASE when SEVERITY='Information' THEN 1 ELSE NULL END) as INFORMATION_CNT, count(CASE when SEVERITY='Success' THEN 1 ELSE NULL END) as SUCCESS_CNT, count(CASE when SEVERITY='Failure' THEN 1 ELSE NULL END) as FAILURE_CNT from " + tableName + " group by HOST_ID, SOURCE, TYPE, EVENTID, TIMESTAMP)as EventLogHrTrend group by HOSTID, HOUR, HOUROFDAY, EVENTID, SOURCE, TYPE");
            this.stat.execute("insert into Log_Hr_Trend select HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, SUM(ERR_CNT) as ERR_CNT, SUM(WAR_CNT) as WAR_CNT, SUM(INF_CNT) as INF_CNT, SUM(SUC_CNT) as SUC_CNT, SUM(FAIL_CNT) as FAIL_CNT from (select DATEPART(HOUR, DATEADD(ss, cast(TIMESTAMP as bigint)/1000+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101')) as HOUROFDAY, CONVERT(datetime, SUBSTRING(CONVERT(VARCHAR(26), DATEADD(ss, cast(TIMESTAMP as bigint)/1000+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101'), 121),0,15) + '00:00:00') as HOUR, HOST_ID as HOSTID, SOURCE, TYPE, count(CASE when SEVERITY='Error' THEN 1 ELSE NULL END) as ERR_CNT, count(CASE when SEVERITY='Warning' THEN 1 ELSE NULL END) as WAR_CNT, count(CASE when SEVERITY='Information' THEN 1 ELSE NULL END) as INF_CNT, count(CASE when SEVERITY='Success' THEN 1 ELSE NULL END) as SUC_CNT, count(CASE when SEVERITY='Failure' THEN 1 ELSE NULL END) as FAIL_CNT from " + tableName + " group by HOST_ID, SOURCE, TYPE, EVENTID, TIMESTAMP)as LogHrTrend group by HOSTID, HOUR,SOURCE,HOUROFDAY,TYPE");
        } else {
            this.stat.execute("insert into EventLog_Hr_Trend select NULL, DATE_FORMAT(FROM_UNIXTIME(TIMESTAMP/1000), '%H') as HOUROFDAY, DATE_FORMAT(FROM_UNIXTIME(TIMESTAMP/1000), '%Y-%m-%d %H:00:00') as HOUR, HOST_ID as HOSTID, SOURCE, TYPE, EVENTID, count(CASE when SEVERITY='Error' THEN 1 ELSE NULL END) as ERROR_CNT, count(CASE when SEVERITY='Warning' THEN 1 ELSE NULL END) as WARNING_CNT, count(CASE when SEVERITY='Information' THEN 1 ELSE NULL END) as INFORMATION_CNT, count(CASE when SEVERITY='Success' THEN 1 ELSE NULL END) as SUCCESS_CNT, count(CASE when SEVERITY='Failure' THEN 1 ELSE NULL END) as FAILURE_CNT from " + tableName + " group by HOST_ID, HOUR, SOURCE,HOUROFDAY,TYPE, EVENTID");
            this.stat.execute("insert into Log_Hr_Trend select NULL, DATE_FORMAT(FROM_UNIXTIME(TIMESTAMP/1000), '%H') as HOUROFDAY, DATE_FORMAT(FROM_UNIXTIME(TIMESTAMP/1000), '%Y-%m-%d %H:00:00') as HOUR, HOST_ID as HOSTID, SOURCE, TYPE, count(CASE when SEVERITY='Error' THEN 1 ELSE NULL END) as ERR_CNT, count(CASE when SEVERITY='Warning' THEN 1 ELSE NULL END) as WAR_CNT, count(CASE when SEVERITY='Information' THEN 1 ELSE NULL END) as INF_CNT, count(CASE when SEVERITY='Success' THEN 1 ELSE NULL END) as SUC_CNT, count(CASE when SEVERITY='Failure' THEN 1 ELSE NULL END) as FAIL_CNT from " + tableName + " group by HOST_ID, HOUR, SOURCE,HOUROFDAY,TYPE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(String command) throws Exception {
        BufferedReader in = null;
        FileOutputStream fos = new FileOutputStream(System.getProperty("server.home") + File.separator + "logs" + File.separator + "evtImport.log");
        Process p = Runtime.getRuntime().exec(command);
        try {
            int c;
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((c = in.read()) != -1) {
                fos.write(c);
            }
        }
        catch (IOException ioex) {
            System.out.println("Problem in importing the evt file");
            ioex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

