/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.imp;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.imp.ImportSysEvtLogTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportSysEvtLogManager {
    private static final Logger LOGGER = Logger.getLogger(ImportSysEvtLogManager.class.getName());
    private static ImportSysEvtLogManager _instance = null;
    private Persistence persistence = null;
    private ClockDaemon scheduler = null;
    private HashMap taskHash = new HashMap();
    public ArrayList locks = new ArrayList();
    public Hashtable lock = new Hashtable();
    private static boolean isPostgres = "postgres".equals(System.getProperty("DBType", "postgres"));
    private static boolean isSuspended = false;

    public static synchronized ImportSysEvtLogManager get_instance() {
        if (_instance == null) {
            _instance = new ImportSysEvtLogManager();
        }
        return _instance;
    }

    private ImportSysEvtLogManager() {
        this.scheduler = new ClockDaemon();
        this.persistence = PersistenceDBUtil.getPersistence();
        this.initializeTasks();
    }

    private void initializeTasks() {
        try {
            Table table = new Table("ImportedLogs");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            Criteria cri = new Criteria(new Column("ImportedLogs", "TIME_INTERVAL"), (Object)new Long(0L), 5);
            sql.addSelectColumn(new Column("ImportedLogs", "*"));
            sql.setCriteria(cri);
            DataObject dObj = this.persistence.get((SelectQuery)sql);
            Iterator iterator = dObj.getRows("ImportedLogs");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                LOGGER.log(Level.INFO, "Initializing task {0}", row);
                this.importLog((Long)row.get("IL_ID"), row.get("TIME_INTERVAL"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int disableImport(Long il_id) {
        if (!this.taskHash.containsKey(il_id)) {
            return 1012;
        }
        Object taskHandle = this.taskHash.remove(il_id);
        ClockDaemon.cancel(taskHandle);
        this.updateStatus(il_id, 1011, "MESSAGE", "Successfully Disabled");
        return 0;
    }

    public int enableImport(Long il_id) throws DataAccessException {
        if (this.taskHash.containsKey(il_id)) {
            return 1013;
        }
        DataObject dObj = this.getConfiguration(il_id);
        if (dObj == null) {
            return 1014;
        }
        Row row = dObj.getRow("ImportedLogs");
        this.importLog((Long)row.get("IL_ID"), row.get("TIME_INTERVAL"));
        this.updateStatus(il_id, 1010, "MESSAGE", "Successfully Enabled");
        return 1010;
    }

    private void importLog(Long il_Id, Object timeInterval) {
        Long timeLong = null;
        long timeInMillis = -1L;
        if (timeInterval != null) {
            if (timeInterval instanceof Long) {
                timeLong = (Long)timeInterval;
            } else if (!"-".equals(timeInterval)) {
                timeLong = Long.valueOf((String)timeInterval);
            }
        }
        if (timeLong != null) {
            timeInMillis = timeLong * 60L * 1000L;
        }
        ImportSysEvtLogTask task = new ImportSysEvtLogTask(il_Id);
        Object taskHandle = null;
        LOGGER.log(Level.INFO, "About to import ::: " + task);
        if (timeInMillis <= 0L) {
            this.scheduler.executeAfterDelay(1L, (Runnable)task);
        } else {
            taskHandle = this.scheduler.executePeriodically(timeInMillis, (Runnable)task, true);
            this.taskHash.put(il_Id, taskHandle);
        }
    }

    public void importLog(Hashtable hash) {
        this.updateDB(hash);
        this.importLog((Long)hash.get("IL_ID"), hash.get("TIME_INTERVAL"));
    }

    private void updateDB(Hashtable hash) {
        Row row = new Row("ImportedLogs");
        String[] params = new String[]{"FILE_NAME", "LOG_TYPE", "REMOTE_CLIENT", "IMPORT_TYPE", "PROTOCOL", "REMOTE_HOSTNAME", "REMOTE_USERNAME", "REMOTE_PASSWORD", "TIME_INTERVAL", "REMOTE_DIR", "START_TIME", "END_TIME", "REPORT_STATUS"};
        row.set("MESSAGE", (Object)"Importing of log records started...");
        Object afid = hash.get("AF_ID");
        if (afid != null) {
            row.set("AF_ID", afid);
        }
        if (hash.containsKey("FTPPORT")) {
            row.set("FTPPORT", (Object)new Integer((String)hash.get("FTPPORT")));
        }
        for (int i = 0; i < params.length; ++i) {
            String key = params[i];
            String val = (String)hash.get(key);
            if (!(val != null || key.equals("TIME_INTERVAL") || key.equals("REMOTE_DIR") || key.equals("START_TIME") || key.equals("END_TIME"))) {
                val = "-";
            }
            if (val == null) continue;
            if (key.equals("START_TIME") && "".equals(val) || key.equals("END_TIME") && "".equals(val)) {
                val = isPostgres ? "1970-01-01 00:00:00" : ("mysql".equals(System.getProperty("DBType").toString()) ? "0000-00-00 00:00:00" : "1900-01-01 00:00:00.000");
            }
            row.set(key, (Object)val);
        }
        if (hash.containsKey("THROW_AWAY_TABLE")) {
            row.set("THROW_AWAY_TABLE", hash.get("THROW_AWAY_TABLE"));
        }
        row.set("TYPE", hash.get("TYPE"));
        row.set("FORMATID", hash.get("FORMATID"));
        row.set("LOCATION", hash.get("LOCATION"));
        row.set("HOST_ID", hash.get("HOST_ID"));
        LOGGER.log(Level.FINER, " IMPORTED_TIME :: {0}", hash.get("IMPORTED_TIME"));
        try {
            DataObject dobj = DataAccess.constructDataObject();
            dobj.addRow(row);
            dobj = DataAccess.add((DataObject)dobj);
            hash.put("IL_ID", dobj.getFirstValue("ImportedLogs", "IL_ID"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.log(Level.INFO, "Failed to get IL_ID");
        }
    }

    public void shutdown() {
        if (_instance != null) {
            _instance.shutdownScheduler();
        }
    }

    private void shutdownScheduler() {
        LOGGER.log(Level.INFO, "Cancelling scheduled sys/evt imports and initiating shutdown");
        for (Object taskHandle : this.taskHash.values()) {
            ClockDaemon.cancel(taskHandle);
        }
        this.scheduler.shutDown();
    }

    public DataObject getConfiguration(Long il_id) {
        if (il_id == null) {
            return null;
        }
        try {
            DataObject dObj = null;
            Row row = new Row("ImportedLogs");
            row.set("IL_ID", (Object)il_id);
            dObj = this.persistence.get("ImportedLogs", row);
            return dObj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isSuspended() {
        return isSuspended;
    }

    public static void setSuspendImport(boolean status) {
        isSuspended = status;
    }

    private void updateStatus(Long il_id, int type, Object key, Object value) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, value);
        this.updateStatus(il_id, type, map);
    }

    public boolean updateStatus(Long il_id, int type, HashMap hash) {
        try {
            DataObject dObj;
            Row row;
            if (this.persistence == null) {
                this.persistence = PersistenceDBUtil.getPersistence();
            }
            if ((row = (dObj = this.getConfiguration(il_id)).getRow("ImportedLogs")) == null) {
                LOGGER.log(Level.INFO, "no row with il_id " + il_id + " in ImportedLogs");
                return false;
            }
            if (hash != null) {
                Long l = (Long)hash.remove("RECORDS");
                if (l != null) {
                    Long rowLong = (Long)row.get("RECORDS");
                    if (type == 1003) {
                        row.set("RECORDS", (Object)new Long(0L));
                    } else {
                        Long long1 = null;
                        long1 = new Long(rowLong == null ? 1L : l + rowLong);
                        row.set("RECORDS", (Object)long1);
                    }
                }
                for (String key : hash.keySet()) {
                    row.set(key, hash.get(key));
                }
                if (!hash.containsKey("MESSAGE")) {
                    row.set("MESSAGE", (Object)"");
                }
            }
            dObj.updateRow(row);
            this.persistence.update(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

