/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.imp;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.MetaTableCache;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ResourceCheckerUtil;
import com.adventnet.la.util.dm.MssqlProcessHandler;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.imp.AbstractEncryptionHandler;
import com.adventnet.sa.server.imp.Encryption256Bit;
import com.adventnet.sa.server.imp.EncryptionAPI;
import com.adventnet.sa.server.imp.FTPUtil;
import com.adventnet.sa.server.imp.ImportAppLogTask;
import com.adventnet.sa.server.imp.ImportEvtLogs;
import com.adventnet.sa.server.imp.ImportSysEvtLogManager;
import com.adventnet.sa.server.imp.SFTPUtil;
import com.adventnet.sa.server.lc.Log;
import com.adventnet.sa.server.lc.LogDataIndexer;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.parser.DbUtil;
import com.adventnet.sa.server.parser.LogFormat;
import com.adventnet.sa.server.parser.ParserRulesPopulator;
import com.adventnet.sa.server.parser.SysEvtRecordParser;
import com.enterprisedt.net.ftp.FTPClient;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.management.AddOrUpdateEventlogDevice;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilter;
import com.sshtools.sftp.SftpClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ImportSysEvtLogTask
implements Runnable {
    private static Logger logger = Logger.getLogger(ImportSysEvtLogTask.class.getName());
    private static final String BASEDIR = System.getProperty("server.home") + File.separator + "data";
    private Persistence persistence = null;
    private Hashtable hash = null;
    private Long il_id = null;
    private DataObject dObj = null;
    private Long hostId = null;
    private String hName = null;
    private String importType = null;
    private Hashtable tableNames = new Hashtable();
    private List<String> tableNameColumns = new ArrayList<String>();
    private String basePopFileName = null;
    private PrintWriter basepWriter;
    private String compPopFileName = null;
    private FileWriter compfWriter;
    private PrintWriter comppWriter;
    private String iePopFileName = null;
    private FileOutputStream fOut;
    private OutputStreamWriter osw;
    private FileWriter iefWriter;
    private PrintWriter iepWriter;
    private List archFiles = new ArrayList();
    private String archFileName = null;
    private FileWriter archfWriter;
    private PrintWriter archpWriter;
    private Long minLogTime = new Long(System.currentTimeMillis());
    private Long maxLogTime = new Long(0L);
    private String formatName = null;
    private String hostName = null;
    private String hostType = null;
    private String dateFormat = "";
    Connection conn = null;
    Statement stat = null;
    boolean isEvt = false;
    private boolean isThrowAway = false;
    private long timeIncrement = 0L;
    private static boolean dbType = "mysql".equals(System.getProperty("DBType", "mysql"));
    private static boolean isMssql = "mssql".equals(System.getProperty("DBType", "mssql"));
    private static boolean isPostgres = "postgres".equals(System.getProperty("DBType", "postgres"));
    private static boolean isWinAuthType = "true".equals(System.getProperty("isWinAuthType", "false"));
    private static final String DELIMITER = isPostgres ? "~" : "|**|";
    private static final String RECORDDELIMITER = "|**|**|";
    private static String nullString = "NULL, ";
    private static String bcpParams = null;
    private static MssqlProcessHandler mssqlHandler = new MssqlProcessHandler();
    private List recordBuffer = new ArrayList();
    private int fileCount = 0;
    private ArrayList luceneFileList = new ArrayList();
    private boolean isLoadArchive = false;
    private DbUtil dbUtil = null;
    private boolean isEncryptedFile = false;
    private AbstractEncryptionHandler encryptionBaseObj = null;
    private static String defaultFolder = System.getProperty("server.home") + File.separator + "server" + File.separator;
    private static HashMap dbParams = null;

    public ImportSysEvtLogTask(Long il_Id) {
        this.il_id = il_Id;
    }

    private String getFileName(String fileName, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        String currentFormat = format.format(new Date());
        if (fileName.indexOf(currentFormat) < 0) {
            int length = pattern.length();
            StringBuffer regex = new StringBuffer();
            block4: for (int i = 0; i < length; ++i) {
                char c = pattern.charAt(i);
                switch (c) {
                    case 'E': 
                    case 'M': {
                        regex.append("[A-Za-z0-9]");
                        continue block4;
                    }
                    case 'D': 
                    case 'F': 
                    case 'H': 
                    case 'K': 
                    case 'S': 
                    case 'W': 
                    case 'd': 
                    case 'h': 
                    case 'k': 
                    case 'm': 
                    case 's': 
                    case 'w': 
                    case 'y': {
                        regex.append("\\d");
                        continue block4;
                    }
                    default: {
                        regex.append(c);
                    }
                }
            }
            return fileName.replaceAll(regex.toString(), currentFormat);
        }
        return fileName;
    }

    private Hashtable getProperties(Row row) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        List list = row.getColumns();
        for (String key : list) {
            if (row.get(key) == null) continue;
            hash.put(key, row.get(key));
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGUNZipContent(File inputGZFile, File tempZipFile) {
        GZIPInputStream in = null;
        OutputStream out = null;
        try {
            in = new GZIPInputStream(new FileInputStream(inputGZFile));
            out = new FileOutputStream(tempZipFile);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        String currentFileName;
        if (ImportSysEvtLogManager.isSuspended()) {
            logger.log(Level.INFO, "Low Disk Space Import Task Temporarily Suspended.");
            return;
        }
        this.persistence = PersistenceDBUtil.getPersistence();
        this.dObj = ImportSysEvtLogManager.get_instance().getConfiguration(this.il_id);
        if (this.dObj == null) {
            logger.log(Level.INFO, "No dataObject exists for il_id : " + this.il_id);
            return;
        }
        try {
            this.hash = this.getProperties(this.dObj.getRow("ImportedLogs"));
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception while fetching row for il_id :" + this.il_id);
            return;
        }
        String fileName = (String)this.hash.get("FILE_NAME");
        Object timeInterval = this.hash.get("TIME_INTERVAL");
        this.processFile(fileName, false);
        if (this.hash.get("DYNAMIC_PATTERN") != null && timeInterval != null && (Long)timeInterval > 0L && !(currentFileName = this.getFileName(fileName, (String)this.hash.get("DYNAMIC_PATTERN"))).equals(fileName)) {
            logger.log(Level.INFO, "Updating filename-- Old filename =  " + fileName + ", New filename = " + currentFileName);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("FILE_NAME", currentFileName);
            this.updateStatus(1013, map);
            this.processFile(currentFileName, true);
        }
        this.dObj = null;
    }

    private Vector convertToArchiveType(String file) {
        Long dws;
        ImportEvtLogs imp = new ImportEvtLogs();
        List details = imp.getDetails(file, (String)this.hash.get("LOG_TYPE"), 0);
        if (details.isEmpty()) {
            String importType;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("MESSAGE", "Could not open the given Evt File");
            String string = importType = this.hash.containsKey("IMPORT_TYPE") ? this.hash.get("IMPORT_TYPE") : "";
            if ("remote".equals(importType)) {
                map.put("FILE_NAME", file);
            }
            this.updateStatus(1005, map);
            return null;
        }
        if (this.hash.containsKey("THROW_AWAY_TABLE") && "THROWAWAY".equals(this.hash.get("THROW_AWAY_TABLE"))) {
            this.isThrowAway = true;
        }
        String hostName = (String)details.get(0);
        Long minTime = (Long)details.get(1);
        Long maxTime = (Long)details.get(2);
        if (maxTime.compareTo(dws = this.getDateOlderThanDWS()) <= 0) {
            this.hash.put("throwReport", Boolean.TRUE);
            this.isThrowAway = true;
        }
        Long hostId = this.getHostId(hostName);
        this.hash.put("HOST_ID", hostId);
        this.updateStatus(1000, "HOST_ID", hostId);
        String fName = "evt_" + hostId + "_" + System.currentTimeMillis();
        Timestamp startTime = (Timestamp)this.hash.get("START_TIME");
        Timestamp endTime = (Timestamp)this.hash.get("END_TIME");
        Long fromTime = startTime != null && startTime.getYear() <= 70 ? minTime.longValue() : startTime.getTime();
        Long toTime = endTime != null && endTime.getYear() <= 70 ? maxTime.longValue() : endTime.getTime();
        ArrayList<Long> timeCrit = new ArrayList<Long>();
        timeCrit.add(0, fromTime);
        timeCrit.add(1, toTime);
        String result = imp.importEvt(file, new ArrayList(), new ArrayList(), (String)this.hash.get("LOG_TYPE"), hostId.intValue(), fName, 0, 0, timeCrit);
        logger.log(Level.INFO, "Evt Import result :::::: " + result);
        int commaIndex = result.indexOf(44);
        int fcount = Integer.parseInt(result.substring(0, commaIndex));
        String errMessage = result.substring(commaIndex + 1);
        this.updateStatus(1000, "ERROR_MESSAGE", errMessage);
        Vector<File> vect = new Vector<File>();
        StringBuffer tempBuf = new StringBuffer();
        tempBuf.append(System.getProperty("server.home"));
        tempBuf.append(File.separator);
        tempBuf.append("bin");
        tempBuf.append(File.separator);
        tempBuf.append(fName);
        tempBuf.append('_');
        for (int i = 0; i <= fcount; ++i) {
            vect.add(new File(tempBuf.toString() + i));
        }
        return vect;
    }

    private String getHostName(Long id) throws Exception {
        Row hosts = new Row("Hosts");
        hosts.set("HOST_ID", (Object)id);
        DataObject hostDO = this.persistence.get("Hosts", hosts);
        return (String)hostDO.getFirstValue("Hosts", "HOST_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processFile(String fileName, boolean isDynamic) {
        File location;
        block122: {
            block123: {
                block118: {
                    String size;
                    long sizeInBytes;
                    String f;
                    int ftpPort;
                    String protocol;
                    String remoteDir;
                    String remotePwd;
                    String remoteUser;
                    String remoteHost;
                    block124: {
                        SftpClient client1;
                        block117: {
                            block121: {
                                this.importType = this.hash.containsKey("IMPORT_TYPE") ? this.hash.get("IMPORT_TYPE") : "";
                                this.isLoadArchive = "archive".equals(this.importType);
                                location = new File((String)this.hash.get("LOCATION"));
                                boolean bl = this.isEvt = this.getType((Long)this.hash.get("HOST_ID")) || this.isEvtFile(fileName);
                                if (!this.importType.equalsIgnoreCase("local")) break block121;
                                Object timeInterval = this.hash.get("TIME_INTERVAL");
                                if (timeInterval != null && (Long)timeInterval > 0L) {
                                    File currentFile = new File((String)this.hash.get("LOCATION"));
                                    File newFile = new File(defaultFolder + "imported_localfiles" + File.separator + currentFile.getName());
                                    location = ImportAppLogTask.copyFileToLocalDir(currentFile, newFile);
                                }
                                break block122;
                            }
                            if (!this.importType.equalsIgnoreCase("remote")) break block123;
                            remoteHost = URLDecoder.decode((String)this.hash.get("REMOTE_HOSTNAME"));
                            remoteUser = URLDecoder.decode((String)this.hash.get("REMOTE_USERNAME"));
                            remotePwd = URLDecoder.decode((String)this.hash.get("REMOTE_PASSWORD"));
                            remoteDir = (String)this.hash.get("REMOTE_DIR");
                            protocol = (String)this.hash.get("PROTOCOL");
                            ftpPort = (Integer)this.hash.get("FTPPORT");
                            if (!protocol.equals("SFTP")) break block124;
                            client1 = null;
                            client1 = fileName.endsWith(".gz") || fileName.endsWith(".zip") || this.isEvtFile(fileName) ? SFTPUtil.getSFTPClient(remoteHost, remoteUser, remotePwd, true, ftpPort) : SFTPUtil.getSFTPClient(remoteHost, remoteUser, remotePwd, false, ftpPort);
                            if (client1 == null) break block117;
                            f = SFTPUtil.doSFTP(client1, null, remoteDir, fileName);
                            logger.log(Level.FINE, f);
                            if (f == null) break block117;
                            location = new File(f);
                            sizeInBytes = location.length();
                            size = null;
                            size = sizeInBytes > 524288L ? (float)(sizeInBytes * 100L / 0x100000L) / 100.0f + " MB" : (sizeInBytes > 1024L ? (float)(sizeInBytes * 100L / 1024L) / 100.0f + " KB" : sizeInBytes + " Bytes");
                            logger.log(Level.INFO, "got file with size" + size);
                        }
                        try {
                            SFTPUtil.logOut(client1);
                        }
                        catch (Exception e) {
                            logger.log(Level.INFO, "Exception while SFTP logout");
                        }
                        break block118;
                        catch (Exception e) {
                            try {
                                e.printStackTrace();
                                logger.log(Level.INFO, "Unable to Sftp {0}", remoteHost);
                            }
                            catch (Throwable throwable) {
                                try {
                                    SFTPUtil.logOut(client1);
                                    throw throwable;
                                }
                                catch (Exception e2) {
                                    logger.log(Level.INFO, "Exception while SFTP logout");
                                }
                                throw throwable;
                            }
                            try {
                                SFTPUtil.logOut(client1);
                            }
                            catch (Exception e3) {
                                logger.log(Level.INFO, "Exception while SFTP logout");
                            }
                            break block118;
                        }
                    }
                    if (protocol.equals("FTP")) {
                        FTPClient client;
                        block119: {
                            client = null;
                            client = fileName.endsWith(".gz") || fileName.endsWith(".zip") || this.isEvtFile(fileName) ? FTPUtil.getFTPClient(remoteHost, remoteUser, remotePwd, true, ftpPort) : FTPUtil.getFTPClient(remoteHost, remoteUser, remotePwd, false, ftpPort);
                            if (client == null) break block119;
                            f = FTPUtil.doFTP(client, null, remoteDir, fileName);
                            logger.log(Level.FINE, f);
                            if (f == null) break block119;
                            location = new File(f);
                            sizeInBytes = location.length();
                            size = null;
                            size = sizeInBytes > 524288L ? (float)(sizeInBytes * 100L / 0x100000L) / 100.0f + " MB" : (sizeInBytes > 1024L ? (float)(sizeInBytes * 100L / 1024L) / 100.0f + " KB" : sizeInBytes + " Bytes");
                            logger.log(Level.INFO, "got file with size" + size);
                        }
                        try {
                            FTPUtil.logOut(client);
                        }
                        catch (Exception e) {
                            logger.log(Level.INFO, "Exception while FTP logout");
                        }
                        break block118;
                        catch (Exception e) {
                            try {
                                e.printStackTrace();
                                logger.log(Level.INFO, "Unable to Ftp {0}", remoteHost);
                            }
                            catch (Throwable throwable) {
                                try {
                                    FTPUtil.logOut(client);
                                    throw throwable;
                                }
                                catch (Exception e4) {
                                    logger.log(Level.INFO, "Exception while FTP logout");
                                }
                                throw throwable;
                            }
                            try {
                                FTPUtil.logOut(client);
                            }
                            catch (Exception e5) {
                                logger.log(Level.INFO, "Exception while FTP logout");
                            }
                        }
                    }
                }
                if (location == null) {
                    logger.log(Level.FINE, "ImportLogTask:failed to fetch file<->{0}", this.hash);
                }
                break block122;
            }
            if (this.isLoadArchive) {
                String locationStr = (String)this.hash.get("FILE_NAME");
                if (locationStr.startsWith("archive/")) {
                    locationStr = System.getProperty("server.home") + "\\" + locationStr;
                    locationStr = locationStr.replaceAll("\\\\", "/");
                }
                location = new File(locationStr);
            } else {
                logger.log(Level.FINE, "No log type mentioned for Import{0}", this.hash);
            }
        }
        logger.log(Level.INFO, "File location <-> {0}", location);
        Object formatId = null;
        Vector vect = null;
        Enumeration<Object> en = null;
        ZipFile zipFile = null;
        if (location != null && location.exists()) {
            logger.log(Level.INFO, "File Exists");
            this.dbUtil = DbUtil.get_instance();
            BufferedReader reader = null;
            Object writer = null;
            boolean markReached = false;
            Object markFile = null;
            StringBuffer tempBuf = new StringBuffer();
            tempBuf.append(System.getProperty("server.home"));
            tempBuf.append(File.separator);
            tempBuf.append("server");
            tempBuf.append(File.separator);
            tempBuf.append("tmp");
            tempBuf.append(File.separator);
            File tempGZFileName = new File(tempBuf.toString() + "importFile.zip");
            try {
                boolean updateStatusFlag;
                String tName;
                int recMarkerLen;
                HashMap<String, Object> hashMap;
                Long logTime;
                if (this.isEvtFile(fileName) && location != null && location.exists()) {
                    vect = this.convertToArchiveType(location.getAbsolutePath());
                    if (vect == null) {
                        return;
                    }
                    en = vect.elements();
                    reader = this.getReaderObj(en, null);
                } else if (fileName.endsWith(".gz")) {
                    this.loadGUNZipContent(location, tempGZFileName);
                    zipFile = new ZipFile(tempGZFileName);
                } else if (fileName.endsWith(".zip")) {
                    zipFile = new ZipFile(location);
                } else {
                    if (fileName.endsWith("_enc")) {
                        this.isEncryptedFile = true;
                        this.encryptionBaseObj = fileName.endsWith("_256_enc") ? Encryption256Bit.getInstance(fileName) : EncryptionAPI.getInstance(fileName);
                    } else {
                        this.isEncryptedFile = false;
                    }
                    boolean isUTF16 = this.isUTF16File(location);
                    reader = isUTF16 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(location), "UTF-16")) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(location), "UTF-8"));
                }
                if (zipFile != null) {
                    en = zipFile.entries();
                    reader = this.getReaderObj(en, zipFile);
                }
                int recordCount = 0;
                String rtype = "0";
                String recordMarker = (String)this.dObj.getFirstValue("ImportedLogs", "RECORD_MARKER");
                boolean fileNo = false;
                this.conn = RelationalAPI.getInstance().getConnection();
                this.stat = this.conn.createStatement();
                this.tableNames.put("logTrendTableName", "Log_Hr_Trend");
                this.tableNameColumns.add("(HOUROFDAY,HOUR,HOSTID,SOURCE,TYPE,ERR_CNT,WAR_CNT,INF_CNT,SUC_CNT,FAIL_CNT)");
                if (this.isLoadArchive) {
                    if (this.isEvt) {
                        this.tableNames.put("baseTableName", "EventLog");
                        rtype = "4";
                    } else {
                        this.tableNames.put("baseTableName", "SysLog");
                        rtype = "3";
                    }
                } else if (this.isEvt) {
                    this.tableNames.put("baseTableName", "EventLog");
                    this.tableNames.put("trendTableName", "EventLog_Hr_Trend");
                    this.tableNames.put("compTableName", "Comp_EventLog");
                    this.tableNames.put("compTrendTableName", "Comp_EventLog_Hr_Trend");
                    this.tableNameColumns.add("(HOST_ID,TIMESTAMP,EVENTID,SEVERITY,TYPE,SOURCE,MESSAGE,SYSTEM_TIME)");
                    this.tableNameColumns.add("(HOUROFDAY,HOUR,HOSTID,SOURCE,TYPE,EVENTID,ERROR_CNT,WARNING_CNT,INFORMATION_CNT,SUCCESS_CNT,FAILURE_CNT)");
                    this.tableNameColumns.add("(HOST_ID,EVENTID,TIMESTAMP,USER_NAME,DOMAIN,CLIENT,SOURCE,MESSAGE)");
                    this.tableNameColumns.add("(HOUROFDAY, HOUR, HOSTID, EVENTID, USER_NAME, DOMAIN, CLIENT, SOURCE,EVT_CNT)");
                } else {
                    this.tableNames.put("baseTableName", "SysLog");
                    this.tableNames.put("trendTableName", "SysLog_Hr_Trend");
                    this.tableNames.put("compTableName", "Comp_SysLog");
                    this.tableNames.put("compTrendTableName", "Comp_SysLog_Hr_Trend");
                    this.tableNames.put("impEventsTableName", "ImportantEvents");
                    this.tableNameColumns.add("(HOST_ID,TIMESTAMP,SEVERITY,FACILITY,SOURCE,MESSAGE,SYSTEM_TIME)");
                    this.tableNameColumns.add("(HOUROFDAY,HOUR,HOSTID,SOURCE,TYPE,ERROR_CNT,WARNING_CNT,INFORMATION_CNT,EMERGENCY_CNT,ALERT_CNT,CRITICAL_CNT,NOTICE_CNT,DEBUG_CNT)");
                    this.tableNameColumns.add("(HOST_ID,TIMESTAMP,USER_NAME,CLIENT,TYPE_SEVERITY,TYPE_FACILITY,TYPE_SOURCE,SEVERITY,FACILITY,SOURCE,FIELD1,FIELD2,FIELD3,FIELD4,FIELD5,FIELD6,MESSAGE,SYSTEM_TIME)");
                    this.tableNameColumns.add("(HOUROFDAY,HOUR,HOSTID, USER_NAME, CLIENT, TYPE_SEVERITY, TYPE_FACILITY, TYPE_SOURCE, FIELD1, FIELD2,EVT_CNT)");
                    this.tableNameColumns.add("(HOUROFDAY,HOUR,HOSTID,IE_NAME,USER_NAME,EVENT_CNT)");
                }
                this.hostId = (Long)this.hash.get("HOST_ID");
                if (this.isLoadArchive) {
                    this.hName = this.getHostName(this.hostId);
                } else {
                    this.prepareImportTables();
                }
                this.initTempFile();
                this.initNewArchFile();
                this.formatName = this.dbUtil.getFormatName((Long)this.hash.get("FORMATID"));
                logger.log(Level.INFO, "Format Name :::::: " + this.formatName);
                LogFormat format = ParserRulesPopulator.get_instance().getParserRules(this.formatName);
                this.getHostDetails();
                long startTime = System.currentTimeMillis();
                Object var22_43 = null;
                Timestamp adjustedTime = new Timestamp(System.currentTimeMillis() - 600000L);
                SysEvtRecordParser parser = new SysEvtRecordParser(format, this.hostId);
                if ("ibm_as400".equals(this.formatName)) {
                    Hashtable<String, String> dateFormatMap = new Hashtable<String, String>();
                    if (this.dateFormat != null && !"".equals(this.dateFormat)) {
                        String[] arr = this.dateFormat.split(",");
                        this.dateFormat = arr[0].substring(0, 2) + arr[1] + arr[0].substring(2, 4) + arr[1] + arr[0].substring(4, 6);
                        this.dateFormat = this.dateFormat + " HH:mm:ss";
                        logger.fine("AS400 DateFormat :::::: " + this.dateFormat);
                        dateFormatMap.put("LOG_DATE_FORMAT", this.dateFormat);
                    }
                    String[] dataArray = new String[]{};
                    int i = 0;
                    while (reader != null) {
                        void var22_53;
                        String string = this.getRecord(reader);
                        Hashtable paramMap = null;
                        if (dataArray.length == 0) {
                            if (i == 0) {
                                logger.info("Analyzing the logs for the first time");
                                String string2 = string.replaceAll("\\w* V\\w* \\d*\\s*\\w* \\w*\\s*P\\w*\\W*\\w*\\s*\\w*\\s*\\w*\\s*\\w*\\s*\\w*\\s*", "");
                                dataArray = string2.replaceAll("CP\\w{5}  \\d{2}", "\n$0").split("\n");
                                logger.info("Length of Array :::::: " + dataArray.length);
                                if (dataArray.length == 1 || dataArray.length == 2) {
                                    logger.info("Multiline AS400 log");
                                    dataArray = new String[]{};
                                } else {
                                    logger.info("Singleline AS400 log");
                                    String string3 = dataArray[0];
                                }
                            } else if (string != null) {
                                String newData;
                                paramMap = parser.parseRecord(string, dateFormatMap);
                                while (paramMap == null && (newData = this.getRecord(reader)) != null) {
                                    void var22_48;
                                    String string4 = (String)var22_48 + newData;
                                    paramMap = parser.parseRecord(string4, dateFormatMap);
                                }
                            }
                            ++i;
                        } else if (i == dataArray.length) {
                            Object var22_51 = null;
                        } else {
                            String string5 = dataArray[i++];
                        }
                        if (var22_53 == null) {
                            this.closeReaderObj(reader);
                            if (zipFile != null) {
                                reader = this.getReaderObj(en, zipFile);
                                continue;
                            }
                            if (vect != null) {
                                reader = this.getReaderObj(en, null);
                                continue;
                            }
                            break;
                        }
                        if (paramMap == null) {
                            paramMap = parser.parseRecord((String)var22_53, dateFormatMap);
                        }
                        if (paramMap != null) {
                            ++recordCount;
                            recordMarker = var22_53;
                            logTime = (Long)paramMap.get("TIME");
                            if (logTime.compareTo(this.maxLogTime) > 0) {
                                this.maxLogTime = new Long(logTime);
                            }
                            if (logTime.compareTo(this.minLogTime) < 0) {
                                this.minLogTime = new Long(logTime);
                            }
                            paramMap.put("ADJTIME", adjustedTime);
                            this.addSysToFile(paramMap, (String)var22_53);
                            if (recordCount % 5000 == 0) {
                                this.store();
                            }
                            if (recordCount % 20000 != 0) continue;
                            hashMap = new HashMap<String, Object>();
                            hashMap.put("RECORDS", new Long(recordCount));
                            recMarkerLen = recordMarker.length();
                            if (recMarkerLen > 1024) {
                                recordMarker = recordMarker.substring(recMarkerLen - 1024, recMarkerLen);
                            }
                            hashMap.put("RECORD_MARKER", recordMarker);
                            this.closeFiles();
                            if (this.isLoadArchive) {
                                tName = (String)this.hash.get("LOCATION");
                                this.dumpArchiveTable(tName, rtype);
                            } else {
                                this.dumpToDatabase(hashMap, false);
                            }
                            this.updateStatus(1015, hashMap);
                            this.initNewArchFile();
                            this.deleteTempFile();
                            this.initTempFile();
                            continue;
                        }
                        logger.info("Unparsed record: " + (String)var22_53);
                    }
                } else if (!"win_archive".equals(this.formatName)) {
                    while (reader != null) {
                        String string = this.getRecord(reader);
                        if (string == null) {
                            this.closeReaderObj(reader);
                            if (zipFile != null) {
                                reader = this.getReaderObj(en, zipFile);
                                continue;
                            }
                            if (vect != null) {
                                reader = this.getReaderObj(en, null);
                                continue;
                            }
                            break;
                        }
                        if (string.matches("^\\s*$")) continue;
                        Hashtable paramMap = parser.parseRecord(string);
                        if (paramMap != null) {
                            ++recordCount;
                            recordMarker = string;
                            Long logTime2 = (Long)paramMap.get("TIME");
                            if (logTime2.compareTo(this.maxLogTime) > 0) {
                                this.maxLogTime = new Long(logTime2);
                            }
                            if (logTime2.compareTo(this.minLogTime) < 0) {
                                this.minLogTime = new Long(logTime2);
                            }
                            paramMap.put("ADJTIME", adjustedTime);
                            if (this.isEvt) {
                                this.addEvtToFile(paramMap);
                            } else {
                                this.addSysToFile(paramMap, string);
                            }
                            if (recordCount % 5000 == 0) {
                                this.store();
                            }
                            if (recordCount % 20000 != 0) continue;
                            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                            hashMap2.put("RECORDS", new Long(recordCount));
                            int recMarkerLen2 = recordMarker.length();
                            if (recMarkerLen2 > 1024) {
                                recordMarker = recordMarker.substring(recMarkerLen2 - 1024, recMarkerLen2);
                            }
                            hashMap2.put("RECORD_MARKER", recordMarker);
                            this.closeFiles();
                            if (this.isLoadArchive) {
                                String tName2 = (String)this.hash.get("LOCATION");
                                this.dumpArchiveTable(tName2, rtype);
                            } else {
                                this.dumpToDatabase(hashMap2, false);
                            }
                            this.updateStatus(1015, hashMap2);
                            this.initNewArchFile();
                            this.deleteTempFile();
                            this.initTempFile();
                            continue;
                        }
                        logger.info("Unparsed record: " + string);
                    }
                } else {
                    Pattern pattern = Pattern.compile("('|\"),? \"}$");
                    Matcher matcher = pattern.matcher("");
                    while (reader != null) {
                        void var22_58;
                        String string = this.getRecord(reader);
                        if (string == null) {
                            this.closeReaderObj(reader);
                            if (zipFile != null) {
                                reader = this.getReaderObj(en, zipFile);
                                continue;
                            }
                            if (vect != null) {
                                reader = this.getReaderObj(en, null);
                                continue;
                            }
                            break;
                        }
                        String tempData = "";
                        matcher.reset(string);
                        while (!matcher.find() && (tempData = this.getRecord(reader)) != null) {
                            String string6 = (String)var22_58 + " " + tempData;
                            matcher.reset(tempData);
                        }
                        Hashtable paramMap = parser.parseRecord((String)var22_58);
                        if (paramMap != null) {
                            ++recordCount;
                            recordMarker = var22_58;
                            logTime = (Long)paramMap.get("TIME");
                            if (logTime.compareTo(this.maxLogTime) > 0) {
                                this.maxLogTime = logTime;
                            }
                            if (logTime.compareTo(this.minLogTime) < 0) {
                                this.minLogTime = logTime;
                            }
                            paramMap.put("ADJTIME", adjustedTime);
                            this.addEvtToFile(paramMap);
                            if (recordCount % 5000 == 0) {
                                this.store();
                            }
                            if (recordCount % 20000 != 0) continue;
                            hashMap = new HashMap();
                            hashMap.put("RECORDS", new Long(recordCount));
                            recMarkerLen = recordMarker.length();
                            if (recMarkerLen > 1024) {
                                recordMarker = recordMarker.substring(recMarkerLen - 1024, recMarkerLen);
                            }
                            hashMap.put("RECORD_MARKER", recordMarker);
                            this.closeFiles();
                            if (this.isLoadArchive) {
                                tName = (String)this.hash.get("LOCATION");
                                this.dumpArchiveTable(tName, rtype);
                            } else {
                                this.dumpToDatabase(hashMap, false);
                            }
                            this.updateStatus(1015, hashMap);
                            this.initNewArchFile();
                            this.deleteTempFile();
                            this.initTempFile();
                            continue;
                        }
                        logger.info("Unparsed record: " + (String)var22_58);
                    }
                }
                this.closeReaderObj(reader);
                logger.log(Level.INFO, "Time taken for parsing: " + (System.currentTimeMillis() - startTime) + " ms");
                logger.log(Level.INFO, "max log time ::::" + this.maxLogTime + " min log time :::" + this.minLogTime);
                this.closeFiles();
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (this.isLoadArchive) {
                    String tName3 = (String)this.hash.get("LOCATION");
                    this.dumpArchiveTable(tName3, rtype);
                    this.updateArchiveStatus(tName3, (String)this.hash.get("REPORT_STATUS"));
                } else {
                    this.store();
                    this.dumpToDatabase(map, true);
                }
                map.put("RECORDS", new Long(recordCount));
                map.put("MESSAGE", "Importing of Evt File is over");
                int recMarkerLen3 = recordMarker.length();
                if (recMarkerLen3 > 1024) {
                    recordMarker = recordMarker.substring(recMarkerLen3 - 1024, recMarkerLen3);
                }
                map.put("RECORD_MARKER", recordMarker);
                map.put("IMPORTED_TIME", new Timestamp(System.currentTimeMillis()));
                Timestamp minTime = new Timestamp(this.minLogTime);
                minTime.setMinutes(0);
                minTime.setSeconds(0);
                Timestamp maxTime = new Timestamp(this.maxLogTime);
                maxTime.setMinutes(59);
                maxTime.setSeconds(59);
                map.put("START_TIME", minTime);
                map.put("END_TIME", maxTime);
                if (!this.isLoadArchive && !(updateStatusFlag = this.updateStatus(1004, map))) {
                    String tmpBaseTable = this.getTableName("tmpBaseTable");
                    String tmpCompTable = this.getTableName("tmpCompTable");
                    RelationalAPI.getInstance().dropTable(tmpBaseTable, false, null);
                    RelationalAPI.getInstance().dropTable(tmpCompTable, false, null);
                    logger.log(Level.INFO, "dropped unreferred-import-tempTables:" + tmpBaseTable + "," + tmpCompTable);
                }
                this.deleteTempFile();
                this.deleteArchTempFile();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.INFO, "ImportLogTask:unable to parse file{0}", location);
            }
            finally {
                try {
                    this.stat.close();
                    this.conn.close();
                }
                catch (Exception exp) {
                    this.stat = null;
                    this.conn = null;
                }
                if (tempGZFileName.exists()) {
                    tempGZFileName.delete();
                }
                if (vect == null) return;
                en = vect.elements();
                while (en.hasMoreElements()) {
                    File file = (File)en.nextElement();
                    boolean delStatus = file.delete();
                    logger.info("Deleting file " + file.getName() + " Status:" + delStatus);
                }
                return;
            }
        }
        this.updateStatus(1005, "MESSAGE", "Unable to import log file. Sorry!");
        logger.log(Level.FINE, "ImportLogTask: location is null...");
    }

    private void prepareImportTables() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String timeStamp = sdf.format(new Date(System.currentTimeMillis()));
        String tmpBaseTable = "import_" + timeStamp;
        String tmpTrendTable = "import_hr_trend_" + timeStamp;
        String tmpLogTrendTable = "import_log_hr_trend_" + timeStamp;
        String tmpCompTable = "import_comp_" + timeStamp;
        String tmpCompTrendTable = "import_comp_hr_trend_" + timeStamp;
        String tmpImpEventsTable = null;
        this.tableNames.put("tmpBaseTable", tmpBaseTable);
        this.tableNames.put("tmpTrendTable", tmpTrendTable);
        this.tableNames.put("tmpLogTrendTable", tmpLogTrendTable);
        this.tableNames.put("tmpCompTable", tmpCompTable);
        this.tableNames.put("tmpCompTrendTable", tmpCompTrendTable);
        if (this.tableNames.containsKey("impEventsTableName")) {
            tmpImpEventsTable = "import_importantevents_" + timeStamp;
            this.tableNames.put("tmpImpEventsTable", tmpImpEventsTable);
        }
        try {
            if (dbType) {
                this.stat.execute("create table " + tmpBaseTable + " like " + this.getTableName("baseTableName"));
                this.stat.execute("create table " + tmpTrendTable + " like " + this.getTableName("trendTableName"));
                this.stat.execute("create table " + tmpLogTrendTable + " like " + this.getTableName("logTrendTableName"));
                this.stat.execute("create table " + tmpCompTable + " like " + this.getTableName("compTableName"));
                this.stat.execute("create table " + tmpCompTrendTable + " like " + this.getTableName("compTrendTableName"));
                if (tmpImpEventsTable != null) {
                    this.stat.execute("create table " + tmpImpEventsTable + " like " + this.getTableName("impEventsTableName"));
                }
            } else if (isMssql) {
                this.stat.execute("select * into " + tmpBaseTable + " from " + this.getTableName("baseTableName") + " where 1=2");
                this.stat.execute("select * into " + tmpTrendTable + " from " + this.getTableName("trendTableName") + " where 1=2");
                this.stat.execute("select * into " + tmpLogTrendTable + " from " + this.getTableName("logTrendTableName") + " where 1=2");
                this.stat.execute("select * into " + tmpCompTable + " from " + this.getTableName("compTableName") + " where 1=2");
                this.stat.execute("select * into " + tmpCompTrendTable + " from " + this.getTableName("compTrendTableName") + " where 1=2");
                if (tmpImpEventsTable != null) {
                    this.stat.execute("select * into " + tmpImpEventsTable + " from " + this.getTableName("impEventsTableName") + " where 1=2");
                }
            } else {
                this.stat.execute("create table " + tmpBaseTable + " (like " + this.getTableName("baseTableName") + " including all)");
                this.stat.execute("create table " + tmpTrendTable + " (like " + this.getTableName("trendTableName") + " including all)");
                this.stat.execute("create table " + tmpLogTrendTable + " (like " + this.getTableName("logTrendTableName") + " including all)");
                this.stat.execute("create table " + tmpCompTable + " (like " + this.getTableName("compTableName") + " including all)");
                this.stat.execute("create table " + tmpCompTrendTable + " (like " + this.getTableName("compTrendTableName") + " including all)");
                if (tmpImpEventsTable != null) {
                    this.stat.execute("create table " + tmpImpEventsTable + " (like " + this.getTableName("impEventsTableName") + " including all)");
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void getHostDetails() {
        try {
            Table table = new Table("Hosts");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            Column column = new Column("Hosts", "HOST_ID");
            Criteria criteria = new Criteria(column, (Object)this.hostId, 0);
            sql.setCriteria(criteria);
            Join join = new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2);
            sql.addJoin(join);
            sql.addSelectColumn(new Column("Hosts", "*"));
            sql.addSelectColumn(new Column("HostDetails", "*"));
            DataObject doo = this.persistence.constructDataObject();
            doo = this.persistence.get((SelectQuery)sql);
            this.hostName = (String)doo.getFirstValue("Hosts", "HOST_NAME");
            this.hostType = (String)doo.getFirstValue("HostDetails", "TYPE");
            this.dateFormat = (String)doo.getFirstValue("HostDetails", "DOMAIN_NAME");
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception while retrieving host details :" + e);
        }
    }

    private void deleteTempFile() {
        String path = System.getProperty("server.home") + File.separator + "data" + File.separator;
        File file = new File(path + this.basePopFileName);
        file.delete();
        file = new File(path + this.compPopFileName);
        file.delete();
        file = new File(path + this.iePopFileName);
        file.delete();
    }

    private void deleteArchTempFile() {
        String path = System.getProperty("server.home") + File.separator + "data" + File.separator;
        File file = null;
        for (String fileName : this.archFiles) {
            file = new File(path + fileName);
            file.delete();
        }
        for (String fileName : this.luceneFileList) {
            file = new File(fileName);
            file.delete();
        }
    }

    private void addEvtToFile(Hashtable paramMap) {
        StringBuffer logData = new StringBuffer();
        String eventid = (String)paramMap.get("EVENTID");
        String message = (String)paramMap.get("MESSAGE");
        String userName = (String)paramMap.get("USERNAME");
        String domain = (String)paramMap.get("DOMAIN");
        if (isPostgres) {
            if (eventid == null) {
                eventid = "0";
            }
            if (message != null) {
                message = message.replaceAll("\\\\\\.", "\\\\\\\\\\ .");
                message = message.replaceAll("\\\\", "\\\\\\\\");
                message = message.replaceAll("~", "");
                message = message.replaceAll("\\u000A", " ");
                message = message.replaceAll("\\u0009", "\\\\t");
                message = message.replaceAll("\\u000D", "\\r");
                message = Matcher.quoteReplacement(message);
            }
            userName = userName != null ? userName.replaceAll("\\u000D", "\\r") : "-";
            String string = domain = domain != null ? domain.replaceAll("\\u000D", "\\r") : "-";
        }
        if (this.isLoadArchive) {
            if (dbType) {
                logData.append(DELIMITER + this.hName);
            } else {
                logData.append(this.hName);
            }
        } else if (dbType) {
            logData.append(DELIMITER + "''" + DELIMITER + this.hostId);
        } else if (isPostgres) {
            logData.append(this.hostId);
        } else {
            logData.append(DELIMITER + this.hostId);
        }
        logData.append(DELIMITER + paramMap.get("TIME"));
        logData.append(DELIMITER + eventid);
        logData.append(DELIMITER + paramMap.get("SEVERITY"));
        logData.append(DELIMITER + paramMap.get("TYPE"));
        logData.append(DELIMITER + paramMap.get("SOURCE"));
        logData.append(DELIMITER + message);
        logData.append(DELIMITER);
        logData.append(paramMap.get("ADJTIME"));
        if (!isPostgres) {
            logData.append(RECORDDELIMITER);
        } else {
            logData = this.getReplacedStringBuffer(logData.toString());
        }
        this.basepWriter.println(logData.toString());
        if (!this.isLoadArchive && paramMap.containsKey("isCompliance")) {
            logData = dbType ? new StringBuffer(DELIMITER + "''") : new StringBuffer();
            if (isPostgres) {
                logData.append(this.hostId);
            } else {
                logData.append(DELIMITER + this.hostId);
            }
            logData.append(DELIMITER + eventid);
            logData.append(DELIMITER + paramMap.get("TIME"));
            logData.append(DELIMITER + userName);
            logData.append(DELIMITER + domain);
            logData.append(DELIMITER + (paramMap.containsKey("CLIENT") && !"".equals(paramMap.get("CLIENT")) ? paramMap.get("CLIENT") : "-"));
            logData.append(DELIMITER + (paramMap.containsKey("SOURCE") ? paramMap.get("SOURCE") : "-"));
            logData.append(DELIMITER + message + RECORDDELIMITER);
            this.comppWriter.println(logData.toString());
        }
        if (!(this.formatName.matches("(win|sys|cisco)_archive") && this.formatName.equals("syslog") && !this.isEvt || this.isLoadArchive)) {
            logData = new StringBuffer("{\"");
            logData.append(paramMap.get("TIME") + ", ");
            logData.append(eventid + ", ");
            logData.append("\"" + paramMap.get("SEVERITY") + "\", ");
            logData.append("\"" + paramMap.get("TYPE") + "\", ");
            logData.append("\"" + paramMap.get("SOURCE") + "\", ");
            logData.append("\"" + message + "\" \"}");
            this.archpWriter.println(logData.toString());
        }
        if (!this.isThrowAway && !this.isLoadArchive) {
            Log log = new Log();
            paramMap.put("HOSTID", this.hostId);
            paramMap.put("HOSTNAME", this.hostName);
            paramMap.put("HOSTTYPE", this.hostType);
            paramMap.put("SEVERITY", this.getWinSeverity((String)paramMap.get("SEVERITY")));
            paramMap.put("DATE", new Integer(((Calendar)paramMap.get("DAY_FOR_LUCENE")).get(5)));
            log.parseLog(this.hostType, paramMap);
            this.recordBuffer.add(log);
        }
    }

    private Integer getWinSeverity(String severity) {
        if ("Error".equalsIgnoreCase(severity)) {
            return new Integer(0);
        }
        if ("Warning".equalsIgnoreCase(severity)) {
            return new Integer(1);
        }
        if ("Information".equalsIgnoreCase(severity)) {
            return new Integer(2);
        }
        if ("Success".equalsIgnoreCase(severity)) {
            return new Integer(3);
        }
        return new Integer(4);
    }

    private Integer getSysSeverity(String severity) {
        if ("Emergency".equalsIgnoreCase(severity)) {
            return new Integer(0);
        }
        if ("Alert".equalsIgnoreCase(severity)) {
            return new Integer(1);
        }
        if ("Critical".equalsIgnoreCase(severity)) {
            return new Integer(2);
        }
        if ("Error".equalsIgnoreCase(severity)) {
            return new Integer(3);
        }
        if ("Warning".equalsIgnoreCase(severity)) {
            return new Integer(4);
        }
        if ("Notice".equalsIgnoreCase(severity)) {
            return new Integer(5);
        }
        if ("Information".equalsIgnoreCase(severity)) {
            return new Integer(6);
        }
        return new Integer(7);
    }

    private boolean getType(Long hostId) {
        try {
            DataObject dataObject = this.persistence.get("HostDetails", new Criteria(new Column("HostDetails", "HOST_ID"), (Object)hostId, 0));
            if ("Windows".equals(dataObject.getFirstValue("HostDetails", "TYPE"))) {
                return true;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "New Host Import");
        }
        return false;
    }

    private void initTempFile() {
        this.basePopFileName = this.getTableName("baseTableName") + System.currentTimeMillis() + ".txt";
        String fileName = null;
        if (!this.isLoadArchive) {
            this.compPopFileName = this.getTableName("compTableName") + System.currentTimeMillis() + ".txt";
        }
        if (this.tableNames.containsKey("impEventsTableName")) {
            this.iePopFileName = this.getTableName("impEventsTableName") + System.currentTimeMillis() + ".txt";
        }
        try {
            fileName = System.getProperty("server.home") + File.separator + "data" + File.separator + this.basePopFileName;
            this.fOut = new FileOutputStream(new File(fileName));
            this.osw = isMssql ? new OutputStreamWriter((OutputStream)this.fOut, "UTF-16LE") : new OutputStreamWriter((OutputStream)this.fOut, "UTF8");
            this.basepWriter = new PrintWriter((Writer)this.osw, false);
            this.compfWriter = new FileWriter(System.getProperty("server.home") + File.separator + "data" + File.separator + this.compPopFileName);
            this.comppWriter = new PrintWriter((Writer)new BufferedWriter(this.compfWriter), false);
            if (this.tableNames.containsKey("impEventsTableName")) {
                this.iefWriter = new FileWriter(System.getProperty("server.home") + File.separator + "data" + File.separator + this.iePopFileName);
                this.iepWriter = new PrintWriter((Writer)new BufferedWriter(this.iefWriter), false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initNewArchFile() {
        this.archFileName = new SimpleDateFormat("dd_MM_yyyyMMddHHmmss").format(new Date(System.currentTimeMillis()));
        this.archFiles.add(this.archFileName);
        try {
            this.archfWriter = new FileWriter(System.getProperty("server.home") + File.separator + "data" + File.separator + this.archFileName);
            this.archpWriter = new PrintWriter((Writer)new BufferedWriter(this.archfWriter), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void closeFiles() throws IOException {
        if (this.archFileName != null) {
            this.archpWriter.flush();
            this.archpWriter.close();
            this.archfWriter.close();
        }
        this.osw.close();
        this.fOut.close();
        this.basepWriter.flush();
        this.basepWriter.close();
        this.comppWriter.flush();
        this.comppWriter.close();
        this.compfWriter.close();
        if (this.tableNames.containsKey("impEventsTableName")) {
            this.iepWriter.flush();
            this.iepWriter.close();
            this.iefWriter.close();
        }
    }

    private String getPostgresSeverity(String severity) {
        String[] severityArray = new String[]{"Error", "Critical", "Emergency", "Alert", "Warning", "Notice", "Information", "Debug"};
        for (int sev = 0; sev < 8; ++sev) {
            if (!severity.equalsIgnoreCase(severityArray[sev])) continue;
            severity = severityArray[sev];
            break;
        }
        return severity;
    }

    private String getPostgresFacility(String facility) {
        String[] facilityArray = new String[]{"Auth", "AuthPriv", "User", "FTP", "Daemon", "Info", "Kernel", "Mail"};
        for (int i = 0; i < 8; ++i) {
            if (!facility.equalsIgnoreCase(facilityArray[i])) continue;
            facility = facilityArray[i];
            break;
        }
        return facility;
    }

    private void addSysToFile(Hashtable paramMap, String data) {
        paramMap.put("DATE", paramMap.get("DAY_FOR_LUCENE"));
        StringBuffer logData = new StringBuffer();
        String message = (String)paramMap.get("MESSAGE");
        if (this.isLoadArchive) {
            if (dbType) {
                logData.append(DELIMITER + this.hName);
            } else {
                logData.append(this.hName);
            }
        } else if (dbType) {
            logData.append(DELIMITER + this.hostId);
        } else {
            logData.append(this.hostId);
        }
        long currTime = (Long)paramMap.get("TIME") + this.timeIncrement;
        ++this.timeIncrement;
        if (this.timeIncrement >= 1000L) {
            this.timeIncrement = 0L;
        }
        paramMap.put("TIME", new Long(currTime));
        logData.append(DELIMITER + currTime);
        String severity = "";
        if (paramMap.containsKey("SEVERITY")) {
            severity = paramMap.get("SEVERITY");
            if (isPostgres) {
                severity = this.getPostgresSeverity(severity);
                if (message != null) {
                    message = message.replaceAll("\\\\\\.", "\\\\\\\\\\ .");
                    message = message.replaceAll("~", "");
                    message = message.replaceAll("\\u000A", " ");
                    message = message.replaceAll("\\u0009", "\\\\t");
                    message = message.replaceAll("\\u000D", "\\r");
                }
            }
        } else {
            severity = "Information";
            paramMap.put("SEVERITY", "Information");
        }
        String facility = "";
        if (paramMap.containsKey("FACILITY")) {
            facility = paramMap.get("FACILITY");
            if (isPostgres) {
                facility = this.getPostgresFacility(facility);
            }
        } else {
            facility = "Local0";
            paramMap.put("FACILITY", "Local0");
        }
        logData.append(DELIMITER + severity);
        logData.append(DELIMITER + facility);
        logData.append(DELIMITER + (paramMap.containsKey("SOURCE") && !"".equals(paramMap.get("SOURCE")) ? paramMap.get("SOURCE") : paramMap.get("JOBNAME")));
        logData.append(DELIMITER + message);
        logData.append(DELIMITER);
        logData.append(paramMap.get("ADJTIME"));
        if (!isPostgres) {
            logData.append(RECORDDELIMITER);
        } else {
            logData = this.getReplacedStringBuffer(logData.toString());
        }
        this.basepWriter.println(logData.toString().replaceAll("\\\\", "\\\\\\\\"));
        if (!this.isLoadArchive) {
            if (paramMap.containsKey("isCompliance")) {
                logData = new StringBuffer();
                if (dbType) {
                    logData = new StringBuffer(DELIMITER + "''");
                }
                if (isPostgres) {
                    logData.append(this.hostId);
                } else {
                    logData.append(DELIMITER + this.hostId);
                }
                logData.append(DELIMITER + paramMap.get("TIME"));
                logData.append(DELIMITER + (paramMap.containsKey("USERNAME") && !"".equals(paramMap.get("USERNAME")) ? paramMap.get("USERNAME") : ""));
                logData.append(DELIMITER + (paramMap.containsKey("CLIENT") && !"".equals(paramMap.get("CLIENT")) ? paramMap.get("CLIENT") : ""));
                logData.append(DELIMITER + (paramMap.containsKey("TYPESEVERITY") ? paramMap.get("TYPESEVERITY") : ""));
                logData.append(DELIMITER + (paramMap.containsKey("TYPEFACILITY") ? paramMap.get("TYPEFACILITY") : ""));
                logData.append(DELIMITER + (paramMap.containsKey("TYPESOURCE") ? paramMap.get("TYPESOURCE") : ""));
                logData.append(DELIMITER + (paramMap.containsKey("SEVERITY") ? paramMap.get("SEVERITY") : ""));
                logData.append(DELIMITER + (paramMap.containsKey("FACILITY") ? paramMap.get("FACILITY") : ""));
                logData.append(DELIMITER + (paramMap.containsKey("SOURCE") ? paramMap.get("SOURCE") : ""));
                for (int i = 1; i < 7; ++i) {
                    logData.append(DELIMITER + (paramMap.containsKey("FIELD" + i) ? paramMap.get("FIELD" + i) : ""));
                }
                logData.append(DELIMITER + message);
                logData.append(DELIMITER);
                logData.append(paramMap.get("ADJTIME"));
                if (!isPostgres) {
                    logData.append(RECORDDELIMITER);
                }
                this.comppWriter.println(logData.toString().replaceAll("\\\\", "\\\\\\\\"));
            }
            if (paramMap.containsKey("isImpEvent") && "true".equals(paramMap.get("isImpEvent"))) {
                StringBuffer ielogData = new StringBuffer();
                if (dbType) {
                    ielogData = new StringBuffer(DELIMITER + "''");
                }
                if (isPostgres) {
                    ielogData.append(paramMap.get("HOUROFDAY"));
                } else {
                    ielogData.append(DELIMITER + paramMap.get("HOUROFDAY"));
                }
                ielogData.append(DELIMITER + paramMap.get("HOUR"));
                ielogData.append(DELIMITER + this.hostId);
                ielogData.append(DELIMITER + paramMap.get("IENAME"));
                ielogData.append(DELIMITER + (paramMap.containsKey("USERNAME") && !"".equals(paramMap.get("USERNAME")) ? paramMap.get("USERNAME") : "-"));
                ielogData.append(DELIMITER + "1");
                if (!isPostgres) {
                    ielogData.append(RECORDDELIMITER);
                }
                this.iepWriter.println(ielogData.toString().replaceAll("\\\\", "\\\\\\\\"));
            }
        }
        if (!this.formatName.matches("(win|sys|cisco)_archive") || !this.formatName.equals("syslog")) {
            this.archpWriter.println(data);
        }
        if (!this.isThrowAway && !this.isLoadArchive) {
            Log log = new Log();
            paramMap.put("HOSTID", this.hostId);
            paramMap.put("HOSTNAME", this.hostName);
            paramMap.put("HOSTTYPE", this.hostType);
            paramMap.put("SEVERITY", this.getSysSeverity((String)paramMap.get("SEVERITY")));
            paramMap.put("DATE", new Integer(((Calendar)paramMap.get("DAY_FOR_LUCENE")).get(5)));
            log.parseLog(this.hostType, paramMap);
            LogIndexingAPI.getInstance().generateLogUniqueID((Map)log);
            this.recordBuffer.add(log);
            if (!this.formatName.endsWith("_archive")) {
                Log logToNotifier = (Log)log.clone();
                logToNotifier.put("UUID", log.get("$id$"));
                logToNotifier.remove("$id$");
                NotificationManager.getInstance().notify(logToNotifier);
            }
        }
    }

    private StringBuffer getReplacedStringBuffer(String tmp) {
        tmp = tmp.replaceAll("\\u000A", " ").replaceAll("\\u0009", "\\\\t").replaceAll("\\u000D", "\\r");
        return new StringBuffer(tmp);
    }

    private void dumpArchiveTable(String tmpBaseTable, String rtype) {
        try {
            if (rtype == "3") {
                if (dbType) {
                    this.stat.execute("CREATE TABLE IF NOT EXISTS " + tmpBaseTable + "  (`HOST_NAME` varchar(75) NOT NULL default '', `TIMESTAMP` varchar(25) NOT NULL default '', `SEVERITY` varchar(250) NOT NULL default '', `FACILITY` varchar(250) NOT NULL default '', `SOURCE` varchar(250) NOT NULL default '', `MESSAGE` varchar(250) default NULL, `SYSTEM_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP)");
                } else if (isPostgres) {
                    this.stat.execute("CREATE TABLE IF NOT EXISTS " + tmpBaseTable + " (HOST_NAME varchar(75) NOT NULL default '', TIMESTAMP varchar(25) NOT NULL default '', SEVERITY varchar(250) NOT NULL default '', FACILITY varchar(250) NOT NULL default '', SOURCE varchar(250) NOT NULL default '', MESSAGE text default NULL, SYSTEM_TIME timestamp NOT NULL default localtimestamp(0) NOT NULL)");
                } else {
                    this.stat.execute("IF NOT EXISTS(select * from sysobjects where name='" + tmpBaseTable + "' and xtype='U') CREATE TABLE " + tmpBaseTable + " (\tHOST_NAME varchar (75) DEFAULT  '' NOT NULL, TIMESTAMP varchar (25) DEFAULT  '' NOT NULL, SEVERITY varchar (250) DEFAULT  '' NOT NULL, FACILITY varchar (250) DEFAULT  '' NOT NULL, SOURCE varchar (250) DEFAULT  '' NOT NULL, MESSAGE nvarchar(4000), SYSTEM_TIME DATETIME  DEFAULT  GETDATE() NOT NULL)");
                }
            } else if (rtype == "4") {
                if (dbType) {
                    this.stat.execute("CREATE TABLE IF NOT EXISTS " + tmpBaseTable + " ( `HOST_NAME` varchar(75) NOT NULL default '', `TIMESTAMP` varchar(25) NOT NULL default '', `EVENTID` int(10) NOT NULL default '0', `SEVERITY` varchar(50) NOT NULL default '', `TYPE` varchar(50) NOT NULL default '', `SOURCE` varchar(100) NOT NULL default '', `MESSAGE` text, `SYSTEM_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP)");
                } else if (isPostgres) {
                    this.stat.execute("CREATE TABLE IF NOT EXISTS " + tmpBaseTable + " ( HOST_NAME varchar(75) NOT NULL default '', TIMESTAMP varchar(25) NOT NULL default '', EVENTID int NOT NULL default 0, SEVERITY varchar(50) NOT NULL default '', TYPE varchar(50) NOT NULL default '', SOURCE varchar(100) NOT NULL default '', MESSAGE text, SYSTEM_TIME timestamp NOT NULL default localtimestamp(0) NOT NULL)");
                } else {
                    this.stat.execute("IF NOT EXISTS(select * from sysobjects where name='" + tmpBaseTable + "' and xtype='U') CREATE TABLE " + tmpBaseTable + " (HOST_NAME varchar (75) DEFAULT  '' NOT NULL, TIMESTAMP varchar (25) DEFAULT  '' NOT NULL, EVENTID int DEFAULT  '0' NOT NULL, SEVERITY varchar (50) DEFAULT  '' NOT NULL, TYPE varchar (50) DEFAULT  '' NOT NULL, SOURCE varchar (100) DEFAULT  '' NOT NULL, MESSAGE nvarchar(4000), SYSTEM_TIME DATETIME  DEFAULT  GETDATE() NOT NULL)");
                }
            }
            File tmpBaseFile = new File(System.getProperty("server.home") + File.separator + "data" + File.separator + this.basePopFileName);
            String baseFilePath = tmpBaseFile.getCanonicalPath();
            baseFilePath = baseFilePath.replace('\\', '/');
            logger.log(Level.INFO, "Loading the file " + baseFilePath);
            if (dbType) {
                this.loadToMysql(baseFilePath, tmpBaseTable);
            } else if (isPostgres) {
                String columns = "";
                columns = rtype == "3" ? "(host_name,timestamp,severity,facility,source,message,system_time)" : "(host_name,timestamp,eventid,severity,type,source,message,system_time)";
                this.loadToPostgres(baseFilePath, tmpBaseTable, columns);
            } else {
                this.loadToMssql(baseFilePath, tmpBaseTable);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private void updateArchiveStatus(String tmpBaseTable, String signStatus) {
        try {
            DataObject archiveDO = this.persistence.get("SysArchivedFiles", new Criteria(new Column("SysArchivedFiles", "TABLE_NAME"), (Object)tmpBaseTable, 0));
            if (archiveDO.size("SysArchivedFiles") > 0) {
                Row archiveRow = archiveDO.getFirstRow("SysArchivedFiles");
                long status = (Long)archiveRow.get("STATUS");
                long dbStatus = 2L;
                dbStatus = status == 0L || status == 1L ? ("Verified".equals(signStatus) ? 3L : 2L) : ("Verified".equals(signStatus) ? 13L : 12L);
                archiveRow.set("STATUS", (Object)new Long(dbStatus));
                archiveDO.updateRow(archiveRow);
            }
            this.persistence.update(archiveDO);
            DataObject importDO = this.persistence.get("ImportedLogs", new Criteria(new Column("ImportedLogs", "IL_ID"), (Object)this.il_id, 0));
            if (importDO.size("ImportedLogs") > 0) {
                this.persistence.delete(importDO.getRow("ImportedLogs"));
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private void dumpToDatabase(HashMap map, boolean isLast) {
        try {
            String tmpBaseTable = this.getTableName("tmpBaseTable");
            String tmpTrendTable = this.getTableName("tmpTrendTable");
            String tmpLogTrendTable = this.getTableName("tmpLogTrendTable");
            String tmpCompTable = this.getTableName("tmpCompTable");
            String tmpCompTrendTable = this.getTableName("tmpCompTrendTable");
            boolean hasIE = this.tableNames.containsKey("impEventsTableName");
            String tmpImpEventsTable = this.getTableName("tmpImpEventsTable");
            File tmpBaseFile = new File(System.getProperty("server.home") + File.separator + "data" + File.separator + this.basePopFileName);
            String baseFilePath = tmpBaseFile.getCanonicalPath();
            baseFilePath = baseFilePath.replace('\\', '/');
            File tmpCompFile = new File(System.getProperty("server.home") + File.separator + "data" + File.separator + this.compPopFileName);
            String compFilePath = tmpCompFile.getCanonicalPath();
            compFilePath = compFilePath.replace('\\', '/');
            File tmpIEFile = null;
            String ieFilePath = null;
            if (hasIE) {
                tmpIEFile = new File(System.getProperty("server.home") + File.separator + "data" + File.separator + this.iePopFileName);
                ieFilePath = tmpIEFile.getCanonicalPath();
                ieFilePath = ieFilePath.replace('\\', '/');
            }
            if (dbType) {
                this.loadToMysql(baseFilePath, tmpBaseTable);
                this.loadToMysql(compFilePath, tmpCompTable);
                if (hasIE) {
                    this.loadToMysql(ieFilePath, tmpImpEventsTable);
                }
            } else if (isPostgres) {
                this.loadToPostgres(baseFilePath, tmpBaseTable, this.tableNameColumns.get(1));
                this.loadToPostgres(compFilePath, tmpCompTable, this.tableNameColumns.get(3));
                if (hasIE) {
                    this.loadToPostgres(ieFilePath, tmpImpEventsTable, this.tableNameColumns.get(5));
                }
            } else {
                this.loadToMssql(baseFilePath, tmpBaseTable);
                this.loadToMssql(compFilePath, tmpCompTable);
                if (hasIE) {
                    this.loadToMssql(ieFilePath, tmpImpEventsTable);
                }
            }
            if (!isLast) {
                return;
            }
            Long dws = this.getDateOlderThanDWS();
            if (this.maxLogTime.compareTo(dws) < 0) {
                this.isThrowAway = true;
            }
            String hour = "DATE_FORMAT(FROM_UNIXTIME(TIMESTAMP/1000), '%Y-%m-%d %H:00:00')";
            String hourOfDay = "DATE_FORMAT(FROM_UNIXTIME(TIMESTAMP/1000), '%H')";
            String groupByCols = "HOUR, HOUROFDAY";
            String sysGroupByCols = "HOUR, HOUROFDAY, IE_NAME, USER_NAME ";
            String pos = "LOCATE";
            String trimStart = "TRIM(TRAILING 0x0D0A FROM ";
            String trimEnd = " ) ";
            String len = "LENGTH";
            String brace = " \\(";
            if (isMssql) {
                hour = "CONVERT(datetime, SUBSTRING(CONVERT(VARCHAR(26), DATEADD(ss, cast (TIMESTAMP as bigint)/1000 + DATEDIFF(ss, getUTCDate(), getDate()), '19700101'), 121),0,15) + '00:00:00')";
                hourOfDay = "DATEPART(HOUR, DATEADD(ss, cast (TIMESTAMP as bigint)/1000 + DATEDIFF(ss, getUTCDate(), getDate()), '19700101'))";
                groupByCols = "TIMESTAMP";
                sysGroupByCols = "MESSAGE, TIMESTAMP ";
                pos = "CHARINDEX";
                trimStart = "REPLACE(";
                trimEnd = ",char(13)+char(10),'')";
                len = "LEN";
                brace = " (";
            }
            if (isPostgres) {
                hour = "to_char(TO_TIMESTAMP(TIMESTAMP::bigint/1000), 'YYYY-mm-dd,HH24:00:00')::timestamp";
                hourOfDay = "to_char(TO_TIMESTAMP(TIMESTAMP::bigint/1000), 'HH24')::integer";
                groupByCols = "TIMESTAMP";
                sysGroupByCols = "MESSAGE, TIMESTAMP ";
                pos = "POSITION";
                trimStart = "TRIM(TRAILING 0x0D0A FROM ";
                trimEnd = ")";
                len = "char_length";
                brace = " (";
                nullString = "";
            }
            if (!this.isThrowAway) {
                long startTime = System.currentTimeMillis();
                this.dumpToLucene();
                logger.log(Level.INFO, "Time taken for lucene dump " + (System.currentTimeMillis() - startTime));
                String queryColumns = "";
                if (this.isEvt) {
                    queryColumns = isPostgres ? tmpTrendTable + this.tableNameColumns.get(2) : tmpTrendTable;
                    String query = "insert into " + queryColumns + " select " + nullString + "HOUROFDAY, HOUR, " + "HOSTID, SOURCE, TYPE, EVENTID, " + "SUM(ERROR_CNT) as ERROR_CNT, SUM(WARNING_CNT) as WARNING_CNT, SUM(INFORMATION_CNT) as INFORMATION_CNT, " + "SUM(SUCCESS_CNT) as SUCCESS_CNT, SUM(FAILURE_CNT) as FAILURE_CNT from " + " (select " + hourOfDay + " as HOUROFDAY, " + hour + " as HOUR, " + "HOST_ID as HOSTID, SOURCE, TYPE, EVENTID, " + "count(CASE when SEVERITY='Error' THEN 1 ELSE NULL END) as ERROR_CNT, " + "count(CASE when SEVERITY='Warning' THEN 1 ELSE NULL END) as WARNING_CNT, " + "count(CASE when SEVERITY='Information' THEN 1 ELSE NULL END) as INFORMATION_CNT, " + "count(CASE when SEVERITY='Success' THEN 1 ELSE NULL END) as SUCCESS_CNT, " + "count(CASE when SEVERITY='Failure' THEN 1 ELSE NULL END) as FAILURE_CNT from " + tmpBaseTable + " group by HOST_ID, SOURCE, TYPE, EVENTID, " + groupByCols + ") as temp" + " group by HOSTID, HOUR, HOUROFDAY, SOURCE, TYPE, EVENTID";
                    logger.log(Level.FINE, query);
                    int ret = this.stat.executeUpdate(query);
                    logger.log(Level.INFO, ret + "Records written in temp trend table");
                    queryColumns = isPostgres ? tmpLogTrendTable + this.tableNameColumns.get(0) : tmpLogTrendTable;
                    query = "insert into " + queryColumns + " select " + nullString + " HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, " + "SUM(ERROR_CNT) as ERR_CNT, SUM(WARNING_CNT) as WAR_CNT, " + "SUM(INFORMATION_CNT) as INF_CNT, SUM(SUCCESS_CNT) as SUC_CNT, " + "SUM(FAILURE_CNT) as FAIL_CNT  from " + tmpTrendTable + " group by HOSTID, HOUR, SOURCE, HOUROFDAY, TYPE";
                    ret = this.stat.executeUpdate(query);
                    logger.log(Level.INFO, ret + "Records written in temp log trend table");
                    queryColumns = isPostgres ? tmpCompTrendTable + this.tableNameColumns.get(4) : tmpCompTrendTable;
                    query = "insert into " + queryColumns + " select " + nullString + "HOUROFDAY, HOUR, HOSTID, EVENTID, USER_NAME, DOMAIN, CLIENT, SOURCE, SUM(EVT_CNT) as EVT_CNT from" + " (select " + hourOfDay + " as HOUROFDAY, " + hour + " as HOUR, " + "HOST_ID as HOSTID, EVENTID, USER_NAME, DOMAIN, CLIENT, SOURCE, " + "count(*) as EVT_CNT from " + tmpCompTable + " group by HOST_ID, EVENTID, USER_NAME, DOMAIN, CLIENT, SOURCE, " + groupByCols + ") as temp" + " group by HOSTID, HOUR, EVENTID, SOURCE, HOUROFDAY, USER_NAME, DOMAIN, CLIENT";
                    logger.log(Level.FINE, query);
                    ret = this.stat.executeUpdate(query);
                    logger.log(Level.INFO, ret + "Records written in temp comp log trend table");
                    this.hourTrendTableInsertion(tmpTrendTable, this.getTableName("trendTableName"), this.tableNameColumns.get(2));
                    this.hourTrendTableInsertion(tmpLogTrendTable, this.getTableName("logTrendTableName"), this.tableNameColumns.get(0));
                    this.hourTrendTableInsertion(tmpCompTrendTable, this.getTableName("compTrendTableName"), this.tableNameColumns.get(4));
                } else {
                    queryColumns = isPostgres ? tmpTrendTable + this.tableNameColumns.get(2) : tmpTrendTable;
                    String query = "insert into " + queryColumns + " select " + nullString + "HOUROFDAY, HOUR, " + "HOSTID, SOURCE, TYPE, " + "SUM(ERROR_CNT) as ERROR_CNT, SUM(WARNING_CNT) as WARNING_CNT, SUM(INFORMATION_CNT) as INFORMATION_CNT, " + "SUM(EMERGENCY_CNT) as EMERGENCY_CNT, SUM(ALERT_CNT) as ALERT_CNT, SUM(CRITICAL_CNT) as CRITICAL_CNT, " + "SUM(NOTICE_CNT) as NOTICE_CNT, SUM(DEBUG_CNT) as DEBUG_CNT from " + " (select " + hourOfDay + " as HOUROFDAY, " + hour + " as HOUR, " + "HOST_ID as HOSTID, SOURCE, FACILITY as TYPE, " + "count(CASE when Severity='Error' THEN 1 ELSE NULL END) as ERROR_CNT, " + "count(CASE when Severity='Warning' THEN 1 ELSE NULL END) as WARNING_CNT, " + "count(CASE when Severity='Information' THEN 1 ELSE NULL END) as INFORMATION_CNT, " + "count(CASE when Severity='Emergency' THEN 1 ELSE NULL END) as EMERGENCY_CNT, " + "count(CASE when Severity='Alert' THEN 1 ELSE NULL END) as ALERT_CNT, " + "count(CASE when Severity='Critical' THEN 1 ELSE NULL END) as CRITICAL_CNT, " + "count(CASE when Severity='Notice' THEN 1 ELSE NULL END) as NOTICE_CNT, " + "count(CASE when Severity='Debug' THEN 1 ELSE NULL END) as DEBUG_CNT from " + tmpBaseTable + " group by HOST_ID, SOURCE, FACILITY, " + groupByCols + ") as temp " + " group by HOSTID, HOUR, HOUROFDAY, SOURCE, TYPE";
                    logger.log(Level.FINE, query);
                    int ret = this.stat.executeUpdate(query);
                    logger.log(Level.INFO, ret + "Records written in temp trend table");
                    queryColumns = isPostgres ? tmpLogTrendTable + this.tableNameColumns.get(0) : tmpLogTrendTable;
                    query = "insert into " + queryColumns + " select " + nullString + " HOUROFDAY, HOUR, HOSTID, SOURCE, 'Application' as TYPE, " + "SUM(ERROR_CNT+CRITICAL_CNT+EMERGENCY_CNT+ALERT_CNT) as ERR_CNT, " + "SUM(WARNING_CNT+NOTICE_CNT) as WAR_CNT, SUM(INFORMATION_CNT+DEBUG_CNT) as INF_CNT, " + "0 as SUC_CNT ,0 as FAIL_CNT  from " + tmpTrendTable + " where TYPE NOT IN ('Daemon','Kernel', 'User', 'Auth', 'Authpriv')  group by HOSTID, HOUR, SOURCE, HOUROFDAY, TYPE " + "union " + "select " + nullString + " HOUROFDAY, HOUR, HOSTID, SOURCE, 'System' as TYPE, " + "SUM(ERROR_CNT+CRITICAL_CNT+EMERGENCY_CNT+ALERT_CNT) as ERR_CNT, " + "SUM(WARNING_CNT+NOTICE_CNT) as WAR_CNT, SUM(INFORMATION_CNT+DEBUG_CNT) as INF_CNT, " + "0 as SUC_CNT ,0 as FAIL_CNT from " + tmpTrendTable + " where TYPE IN ('Daemon','Kernel', 'User') " + "group by HOSTID, HOUR, SOURCE, HOUROFDAY, TYPE " + "union " + "select " + nullString + " HOUROFDAY, HOUR, HOSTID, SOURCE, 'Security' as TYPE, " + "SUM(ERROR_CNT+CRITICAL_CNT+EMERGENCY_CNT+ALERT_CNT) as ERR_CNT, " + "SUM(WARNING_CNT+NOTICE_CNT) as WAR_CNT, SUM(INFORMATION_CNT+DEBUG_CNT) as INF_CNT, " + "0 as SUC_CNT ,0 as FAIL_CNT from " + tmpTrendTable + " where TYPE IN ('Auth', 'Authpriv') " + "group by HOSTID, HOUR, SOURCE, HOUROFDAY, TYPE";
                    logger.log(Level.FINE, query);
                    ret = this.stat.executeUpdate(query);
                    logger.log(Level.INFO, ret + "Records written in temp log trend table");
                    queryColumns = isPostgres ? tmpCompTrendTable + this.tableNameColumns.get(4) : tmpCompTrendTable;
                    query = "insert into " + queryColumns + " select " + nullString + "HOUROFDAY, HOUR, HOSTID, USER_NAME, CLIENT, TYPE_SEVERITY, TYPE_FACILITY, TYPE_SOURCE, FIELD1, FIELD2, SUM(EVT_CNT) as EVT_CNT from " + " (select " + hourOfDay + " as HOUROFDAY, " + hour + " as HOUR, " + "HOST_ID as HOSTID, USER_NAME, CLIENT, TYPE_SEVERITY, TYPE_FACILITY, TYPE_SOURCE, " + "FIELD1, FIELD2, count(*) as EVT_CNT from " + tmpCompTable + " group by HOST_ID, USER_NAME, CLIENT, " + "TYPE_SOURCE, TYPE_FACILITY, TYPE_SEVERITY, FIELD2, FIELD1, " + groupByCols + ") as temp" + " group by HOUROFDAY, HOUR, HOSTID, USER_NAME, CLIENT, TYPE_SEVERITY, TYPE_FACILITY, TYPE_SOURCE, FIELD1, FIELD2";
                    logger.log(Level.FINE, query);
                    ret = this.stat.executeUpdate(query);
                    logger.log(Level.INFO, ret + "Records written in temp comp trend table");
                    this.hourTrendTableInsertion(tmpTrendTable, this.getTableName("trendTableName"), this.tableNameColumns.get(2));
                    this.hourTrendTableInsertion(tmpLogTrendTable, this.getTableName("logTrendTableName"), this.tableNameColumns.get(0));
                    this.hourTrendTableInsertion(tmpCompTrendTable, this.getTableName("compTrendTableName"), this.tableNameColumns.get(4));
                    queryColumns = isPostgres ? this.tableNameColumns.get(5) : "";
                    query = "insert into ImportantEvents " + this.tableNameColumns.get(5) + " select " + nullString + "HOUROFDAY, HOUR, HOSTID, IE_NAME, USER_NAME, SUM(EVENT_CNT) as EVENT_CNT from " + tmpImpEventsTable + " group by HOSTID, HOUR, HOUROFDAY, IE_NAME, USER_NAME";
                    logger.log(Level.FINE, query);
                    ret = this.stat.executeUpdate(query);
                    logger.log(Level.INFO, ret + "Records written in IE table");
                }
                map.put("REPORT_STATUS", "Active");
                if (isMssql) {
                    this.stat.execute("IF EXISTS(select * from sysobjects where name='" + tmpBaseTable + "') DROP TABLE " + tmpBaseTable);
                } else {
                    this.stat.execute("drop table if exists " + tmpBaseTable);
                }
            } else {
                map.put("THROW_AWAY_TABLE", tmpBaseTable.substring(tmpBaseTable.lastIndexOf("_") + 1));
                map.put("REPORT_STATUS", "ThrowAway");
            }
            if (isMssql) {
                this.stat.execute("IF EXISTS(select * from sysobjects where name='" + tmpTrendTable + "') DROP TABLE " + tmpTrendTable);
                this.stat.execute("IF EXISTS(select * from sysobjects where name='" + tmpLogTrendTable + "') DROP TABLE " + tmpLogTrendTable);
                if (!this.isThrowAway) {
                    this.stat.execute("IF EXISTS(select * from sysobjects where name='" + tmpCompTable + "') DROP TABLE " + tmpCompTable);
                }
                this.stat.execute("IF EXISTS(select * from sysobjects where name='" + tmpCompTrendTable + "') DROP TABLE " + tmpCompTrendTable);
                if (hasIE) {
                    this.stat.execute("IF EXISTS(select * from sysobjects where name='" + tmpImpEventsTable + "') DROP TABLE " + tmpImpEventsTable);
                }
            } else {
                this.stat.execute("drop table if exists " + tmpTrendTable);
                this.stat.execute("drop table if exists " + tmpLogTrendTable);
                if (!this.isThrowAway) {
                    this.stat.execute("drop table if exists " + tmpCompTable);
                }
                this.stat.execute("drop table if exists " + tmpCompTrendTable);
                if (hasIE) {
                    this.stat.execute("drop table if exists " + tmpImpEventsTable);
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private void dumpToLucene() {
        for (String fileName : this.luceneFileList) {
            List recordsList = this.loadRecords(fileName);
            for (Log log : recordsList) {
                try {
                    SystemCustomPatternHandler.getInstance().parse((Hashtable)log);
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
                LogDataIndexer.getInstance().indexLogData(log);
                try {
                    LogForwarderFilter.getInstance().filterAndForward(log);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        LogIndexingAPI.getInstance().fflush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadRecords(String fName) {
        List recordsFromFile = new ArrayList();
        logger.log(Level.INFO, "Loading from files : " + fName);
        File toLoad = new File(fName);
        FileInputStream fis = null;
        if (toLoad.exists()) {
            try {
                fis = new FileInputStream(toLoad);
                try (ObjectInputStream ois = null;){
                    ois = new ObjectInputStream(fis);
                    recordsFromFile = (List)ois.readObject();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
        logger.log(Level.INFO, "Number of records : " + recordsFromFile.size());
        return recordsFromFile;
    }

    private void hourTrendTableInsertion(String tmpTable, String tableName, String columns) {
        ArrayList<Timestamp> startTimes = new ArrayList<Timestamp>();
        ArrayList<Timestamp> endTimes = new ArrayList<Timestamp>();
        ArrayList<String> tableNames = new ArrayList<String>();
        Timestamp minStartTime = null;
        Table table = new Table("MetaTable");
        SelectQueryImpl sql = new SelectQueryImpl(table);
        Column col = new Column("MetaTable", "TABLE_NAME");
        Criteria cri = new Criteria(col, (Object)tableName, 0);
        sql.setCriteria(cri);
        sql.addSelectColumn(new Column("MetaTable", "*"));
        try {
            DataObject dob = this.persistence.constructDataObject();
            dob = this.persistence.get((SelectQuery)sql);
            Iterator iterator = dob.getRows("MetaTable");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Timestamp startTime = (Timestamp)row.get("START_TIME");
                startTimes.add(startTime);
                Object endTime = row.get("END_TIME");
                if (endTime != null) {
                    endTimes.add((Timestamp)endTime);
                } else {
                    endTimes.add(new Timestamp(0L));
                }
                tableNames.add((String)row.get("LOOKUP_TABLENAME"));
                if (minStartTime == null) {
                    minStartTime = startTime;
                    continue;
                }
                if (minStartTime.compareTo(startTime) <= 0) continue;
                minStartTime = startTime;
            }
            Long dws = this.getDateOlderThanDWS();
            boolean throwAway = false;
            if (this.maxLogTime.compareTo(dws) < 0) {
                throwAway = true;
            } else if (this.minLogTime.compareTo(new Long(minStartTime.getTime())) < 0) {
                String alteredTableName = tableName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis()));
                if (dbType) {
                    this.stat.execute("create table " + alteredTableName + " like " + tableName);
                } else if (isPostgres) {
                    this.stat.execute("create table " + alteredTableName + " (like " + tableName + " including all)");
                } else {
                    this.stat.execute(mssqlHandler.constructQuery(tableName, alteredTableName));
                }
                this.stat.execute("insert into MetaTable(TABLE_NAME,START_TIME,END_TIME,START_INDEX,END_INDEX,LOOKUP_TABLENAME,STATUS) values('" + tableName + "','" + new Timestamp(this.minLogTime) + "', '" + minStartTime + "', -1, -1,'" + alteredTableName + "','DEFAULT')");
                MetaTableCache cache = MetaTableCache.getInstance();
                cache.add(tableName, alteredTableName, this.minLogTime.toString(), "" + minStartTime.getTime());
                startTimes.add(new Timestamp(this.minLogTime));
                endTimes.add(minStartTime);
                tableNames.add(alteredTableName);
            }
            if (!throwAway) {
                for (int i = 0; i < tableNames.size(); ++i) {
                    int ret = this.stat.executeUpdate(this.getTrendTableQuery((Timestamp)startTimes.get(i), (Timestamp)endTimes.get(i), (String)tableNames.get(i), tmpTable, tableName, columns));
                    logger.log(Level.INFO, ret + "Records written in hr trend table " + tableNames.get(i));
                    ret = this.stat.executeUpdate(this.getTrendUpdateQuery((Timestamp)startTimes.get(i), (Timestamp)endTimes.get(i), (String)tableNames.get(i), tmpTable, tableName));
                    logger.log(Level.INFO, ret + " Records deleted from tmpTable " + tmpTable);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getTrendUpdateQuery(Timestamp start, Timestamp end, String lookupTable, String tmpTable, String trendTable) {
        start.setMinutes(0);
        start.setSeconds(0);
        end.setMinutes(59);
        end.setSeconds(59);
        end.setHours(end.getHours());
        String sqlString = " delete from " + tmpTable + " where HOUR ";
        sqlString = !lookupTable.equals(trendTable) ? sqlString + "between '" + start + "' and '" + end + "'" : sqlString + ">= '" + start + "'";
        logger.log(Level.INFO, sqlString);
        return sqlString;
    }

    private String getTrendTableQuery(Timestamp start, Timestamp end, String lookupTable, String tmpTable, String trendTable, String columns) {
        String selectQuery = null;
        start.setMinutes(0);
        start.setSeconds(0);
        end.setMinutes(59);
        end.setSeconds(59);
        end.setHours(end.getHours());
        if ("SysLog_Hr_Trend".equals(trendTable)) {
            selectQuery = " select " + nullString + " HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, ERROR_CNT, WARNING_CNT, INFORMATION_CNT, EMERGENCY_CNT, ALERT_CNT, CRITICAL_CNT, NOTICE_CNT, DEBUG_CNT from " + tmpTable + " where HOUR ";
        } else if ("EventLog_Hr_Trend".equals(trendTable)) {
            selectQuery = " select " + nullString + " HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, EVENTID, ERROR_CNT, WARNING_CNT, INFORMATION_CNT, SUCCESS_CNT, FAILURE_CNT from " + tmpTable + " where HOUR ";
        } else if ("Comp_SysLog_Hr_Trend".equals(trendTable)) {
            selectQuery = " select " + nullString + " HOUROFDAY, HOUR, HOSTID, USER_NAME, CLIENT, TYPE_SEVERITY, TYPE_FACILITY, TYPE_SOURCE, FIELD1, FIELD2, EVT_CNT from " + tmpTable + " where HOUR ";
        } else if ("Comp_EventLog_Hr_Trend".equals(trendTable)) {
            selectQuery = " select " + nullString + " HOUROFDAY, HOUR, HOSTID, EVENTID, USER_NAME, DOMAIN, CLIENT, SOURCE, EVT_CNT from " + tmpTable + " where HOUR ";
        } else if ("Log_Hr_Trend".equals(trendTable)) {
            selectQuery = " select " + nullString + " HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, ERR_CNT, WAR_CNT, INF_CNT, SUC_CNT, FAIL_CNT from " + tmpTable + " where HOUR ";
        }
        String sqlString = "insert into " + lookupTable;
        if (isPostgres) {
            sqlString = sqlString + columns;
        }
        sqlString = !lookupTable.equals(trendTable) ? sqlString + selectQuery + "between '" + start + "' and '" + end + "'" : sqlString + selectQuery + ">= '" + start + "'";
        logger.log(Level.FINE, sqlString);
        return sqlString;
    }

    private boolean baseTableInsertion(String tmpTable, String tableName) {
        boolean throwAway = false;
        ArrayList<Long> startTimes = new ArrayList<Long>();
        ArrayList<Long> endTimes = new ArrayList<Long>();
        ArrayList<String> tableNames = new ArrayList<String>();
        Long minStartTime = null;
        Table table = new Table("MetaTable");
        SelectQueryImpl sql = new SelectQueryImpl(table);
        Column col = new Column("MetaTable", "TABLE_NAME");
        Criteria cri = new Criteria(col, (Object)tableName, 0);
        sql.setCriteria(cri);
        sql.addSelectColumn(new Column("MetaTable", "*"));
        try {
            DataObject dob = this.persistence.constructDataObject();
            dob = this.persistence.get((SelectQuery)sql);
            Iterator iterator = dob.getRows("MetaTable");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long startTime = new Long(((Timestamp)row.get("START_TIME")).getTime());
                startTimes.add(startTime);
                Object endTime = row.get("END_TIME");
                if (endTime != null) {
                    endTimes.add(new Long(((Timestamp)endTime).getTime()));
                } else {
                    endTimes.add(new Long(-1L));
                }
                tableNames.add((String)row.get("LOOKUP_TABLENAME"));
                if (minStartTime == null) {
                    minStartTime = startTime;
                    continue;
                }
                if (minStartTime.compareTo(startTime) <= 0) continue;
                minStartTime = startTime;
            }
            Long dws = this.getDateOlderThanDWS();
            if (this.maxLogTime.compareTo(dws) < 0) {
                throwAway = true;
            } else if (this.minLogTime.compareTo(minStartTime) < 0) {
                String alteredTableName = tableName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis()));
                if (dbType) {
                    this.stat.execute("create table " + alteredTableName + " like " + tableName);
                } else if (isPostgres) {
                    this.stat.execute("create table " + alteredTableName + " (like " + tableName + " including all)");
                } else {
                    this.stat.execute(mssqlHandler.constructQuery(tableName, alteredTableName));
                }
                this.stat.execute("insert into MetaTable(TABLE_NAME,START_TIME,END_TIME,START_INDEX,END_INDEX,LOOKUP_TABLENAME,STATUS) values('" + tableName + "','" + new Timestamp(this.minLogTime) + "', '" + new Timestamp(minStartTime) + "', -1, -1,'" + alteredTableName + "','DEFAULT')");
                MetaTableCache cache = MetaTableCache.getInstance();
                cache.add(tableName, alteredTableName, this.minLogTime.toString(), minStartTime.toString());
                startTimes.add(this.minLogTime);
                endTimes.add(minStartTime);
                tableNames.add(alteredTableName);
            }
            if (!throwAway) {
                for (int i = 0; i < tableNames.size(); ++i) {
                    int ret = this.stat.executeUpdate(this.getBaseTableQuery((Long)startTimes.get(i), (Long)endTimes.get(i), (String)tableNames.get(i), tmpTable, tableName));
                    logger.log(Level.INFO, ret + "Records written in base table " + tableNames.get(i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return throwAway;
    }

    private String getBaseTableQuery(Long start, Long end, String lookupTable, String tmpTable, String baseTable) {
        String selectQuery = null;
        if ("SysLog".equals(baseTable)) {
            selectQuery = " select HOST_ID, TIMESTAMP, SEVERITY, FACILITY, SOURCE, MESSAGE, SYSTEM_TIME from " + tmpTable + " where TIMESTAMP ";
        } else if ("EventLog".equals(baseTable)) {
            selectQuery = " select " + nullString + " HOST_ID, TIMESTAMP, EVENTID, SEVERITY, TYPE, SOURCE, MESSAGE, SYSTEM_TIME from " + tmpTable + " where TIMESTAMP ";
        } else if ("Comp_SysLog".equals(baseTable)) {
            selectQuery = " select " + nullString + " HOST_ID, TIMESTAMP, USER_NAME, CLIENT, TYPE_SEVERITY, TYPE_FACILITY, TYPE_SOURCE, SEVERITY, FACILITY, SOURCE, FIELD1, FIELD2, FIELD3, FIELD4, FIELD5, FIELD6, MESSAGE, SYSTEM_TIME from " + tmpTable + " where TIMESTAMP ";
        } else if ("Comp_EventLog".equals(baseTable)) {
            selectQuery = " select " + nullString + " HOST_ID, EVENTID, TIMESTAMP, USER_NAME, DOMAIN, CLIENT, SOURCE, MESSAGE from " + tmpTable + " where TIMESTAMP ";
        }
        String sqlString = "insert into " + lookupTable;
        sqlString = end.compareTo(new Long(0L)) > 0 ? sqlString + selectQuery + "between '" + start + "' and '" + end + "'" : sqlString + selectQuery + ">= '" + start + "'";
        logger.log(Level.FINE, sqlString);
        return sqlString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            String fileName = BASEDIR + File.separator + "IMPORT_" + System.currentTimeMillis() + "_" + this.fileCount + ".dat";
            logger.log(Level.INFO, "Writing data to file : " + fileName);
            File dest = new File(fileName);
            dest.createNewFile();
            fos = new FileOutputStream(dest);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this.recordBuffer);
            this.recordBuffer.clear();
            this.addToFileList(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                oos.close();
                fos.close();
                oos = null;
                fos = null;
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
    }

    private void addToFileList(String name) {
        this.luceneFileList.add(name);
        ++this.fileCount;
    }

    private void updateStatus(int type) {
        this.updateStatus(type, null);
    }

    private boolean updateStatus(int type, HashMap hash) {
        return ImportSysEvtLogManager.get_instance().updateStatus(this.il_id, type, hash);
    }

    private void updateStatus(int type, Object key, Object value) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, value);
        this.updateStatus(type, map);
    }

    private Long getDateOlderThanDWS() {
        try {
            Table table = new Table("DataManagementTiming");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            Column col = new Column("DataManagementTiming", "TIMER_NAME");
            Criteria cri = new Criteria(col, (Object)"SYS_DATA_WINDOW", 0);
            sql.setCriteria(cri);
            sql.addSelectColumn(new Column("DataManagementTiming", "*"));
            DataObject doo = this.persistence.constructDataObject();
            doo = this.persistence.get((SelectQuery)sql);
            long days = 1L;
            if (!doo.isEmpty()) {
                days = new Long((String)doo.getFirstValue("DataManagementTiming", "TIMESTAMP")).intValue();
            }
            long olderTime = System.currentTimeMillis() - days * 86400000L;
            logger.log(Level.INFO, "current time:" + System.currentTimeMillis() + " days:" + days + " olderTime:" + olderTime);
            return new Long(olderTime);
        }
        catch (Exception e) {
            return new Long(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadToMssql(String fileName, String tableName) throws Exception {
        String command = String.format("..\\bin\\bcp.exe [%s].dbo.%s in \"%s\" %s", (String)dbParams.get("DBName"), tableName, fileName, bcpParams);
        BufferedReader in = null;
        FileOutputStream fos = new FileOutputStream(System.getProperty("server.home") + File.separator + "logs" + File.separator + "appImport.log");
        Process p = Runtime.getRuntime().exec(command);
        try {
            int c;
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((c = in.read()) != -1) {
                fos.write(c);
            }
        }
        catch (IOException ioex) {
            logger.log(Level.INFO, "Problem in importing the application file");
            ioex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    private Long getHostId(String hostName) {
        try {
            DataObject doo = DataAccess.get((String)"Hosts", (Criteria)new Criteria(new Column("Hosts", "DNS_NAME"), (Object)hostName, 0));
            Long hostId = null;
            hostId = !doo.isEmpty() ? (Long)doo.getFirstValue("Hosts", "HOST_ID") : (this.isEvt ? AddOrUpdateEventlogDevice.addUnverifiedDevice(hostName, LogSourceCategoryContainer.DeviceCategory.WINDOWS).get(0) : AddOrUpdateEventlogDevice.addUnverifiedDevice(hostName, LogSourceCategoryContainer.DeviceCategory.UNIX).get(0));
            return hostId;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception while retrieving hostid:" + e);
            return new Long(0L);
        }
    }

    private String getTableName(String key) {
        return (String)this.tableNames.get(key);
    }

    private BufferedReader getReaderObj(Enumeration enu, ZipFile zipFile) {
        BufferedReader readerObj = null;
        try {
            while (enu.hasMoreElements()) {
                Object entry;
                if (zipFile != null) {
                    entry = (ZipEntry)enu.nextElement();
                    if (((ZipEntry)entry).getName().equals("archivedesc.properties") || ((ZipEntry)entry).getName().endsWith(".sgn")) continue;
                    readerObj = new BufferedReader(new InputStreamReader(zipFile.getInputStream((ZipEntry)entry), "UTF8"));
                    logger.log(Level.INFO, "Data is null, opening new file :: " + ((ZipEntry)entry).getName());
                    if (((ZipEntry)entry).getName().endsWith("_enc")) {
                        this.isEncryptedFile = true;
                        this.encryptionBaseObj = ((ZipEntry)entry).getName().endsWith("_256_enc") ? Encryption256Bit.getInstance(((ZipEntry)entry).getName()) : EncryptionAPI.getInstance(((ZipEntry)entry).getName());
                    } else {
                        this.isEncryptedFile = false;
                    }
                } else {
                    entry = (File)enu.nextElement();
                    readerObj = new BufferedReader(new FileReader((File)entry));
                }
                if (!readerObj.ready()) {
                    this.isEncryptedFile = false;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return readerObj;
    }

    private void closeReaderObj(BufferedReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isEncryptedFile = false;
    }

    private String getRecord(BufferedReader br) throws Exception {
        String record = null;
        if (br == null) {
            return record;
        }
        if (this.isEncryptedFile) {
            record = this.encryptionBaseObj.readEncryptedLine(br);
            if (record != null) {
                record = this.encryptionBaseObj.decryptLog(record, this.isLoadArchive);
            }
        } else {
            record = br.readLine();
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUTF16File(File location) {
        FileInputStream fis = null;
        boolean isUTF16 = false;
        try {
            fis = new FileInputStream(location);
            byte[] buffer = new byte[128];
            fis.read(buffer);
            isUTF16 = buffer[0] == -1 && buffer[1] == -2 || buffer[0] == -2 && buffer[1] == -1;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return isUTF16;
    }

    private boolean isEvtFile(String fileName) {
        boolean isEvtFile = (fileName = fileName.toLowerCase()).endsWith(".evt") || fileName.endsWith(".evtx");
        logger.log(Level.INFO, "in isEvtFile Method ::: " + isEvtFile);
        return isEvtFile;
    }

    private void loadToMysql(String fileName, String tableName) throws Exception {
        String loadQuery = String.format("load data local infile '%s' into table %s fields terminated by '|**|' lines terminated by '|**|**|' starting by '|**|'", fileName, tableName);
        logger.info("Query to be executed : " + loadQuery);
        int ret = this.stat.executeUpdate(loadQuery);
        logger.info(ret + "Records written");
    }

    private void loadToPostgres(String fileName, String tableName, String columns) throws Exception {
        File file = new File(fileName);
        file.setReadable(true, false);
        String loadQuery = "copy " + tableName + columns + " from  '" + fileName + "' with DELIMITER '~'";
        logger.info("Query to be executed : " + loadQuery);
        int ret = this.stat.executeUpdate(loadQuery);
        logger.info(ret + "Records written");
    }

    static {
        if (isMssql) {
            String dbserver = "";
            String dbuser = "";
            String dbpass = "";
            String xmlFilePath = System.getProperty("server.home") + File.separator + "conf" + File.separator + "database_params.conf";
            dbParams = ResourceCheckerUtil.getConstraints((String)xmlFilePath, (String)"eventlog");
            dbpass = (String)dbParams.get("DBPass");
            dbpass = EnDecryptImplSingleton.getInstance().decrypt(dbpass);
            bcpParams = String.format(" -S %s -t \"|**|\" -r \"|**|**|\\n\" -e ..\\logs\\imparcherr.txt -w", (String)dbParams.get("DBServer"));
            bcpParams = bcpParams + (isWinAuthType ? " -T" : String.format(" -U %s -P \"%s\"", (String)dbParams.get("DBUser"), dbpass));
            nullString = "";
        }
    }
}

