/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.imp;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.RunQuery;
import com.adventnet.la.util.QueryGenerator;
import com.adventnet.la.util.QueryGeneratorFactory;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportTempTableCleaner
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ImportTempTableCleaner.class.getName());
    private Persistence persistence = null;

    @Override
    public void run() {
        try {
            Criteria c1 = new Criteria(Column.getColumn((String)"ImportedLogs", (String)"MESSAGE"), (Object)"Importing of log records started...", 0);
            Criteria c2 = new Criteria(Column.getColumn((String)"ImportedLogs", (String)"MESSAGE"), (Object)"", 0);
            UpdateQueryImpl uq = new UpdateQueryImpl("ImportedLogs");
            uq.setCriteria(c1.or(c2));
            uq.setUpdateColumn("MESSAGE", (Object)"Unable to import log file. Sorry!");
            this.getPersistence().update((UpdateQuery)uq);
            ArrayList<Long> linkedTempTablesNumber = new ArrayList<Long>();
            ArrayList<String> droppedTablesName = new ArrayList<String>();
            ArrayList<String> skippedTablesName = new ArrayList<String>();
            Row row = new Row("ImportedLogs");
            DataObject dObj = this.getPersistence().get("ImportedLogs", row);
            Iterator iterator = dObj.getRows("ImportedLogs");
            while (iterator.hasNext()) {
                Row curRow = (Row)iterator.next();
                try {
                    linkedTempTablesNumber.add(Long.valueOf(curRow.get("THROW_AWAY_TABLE").toString()));
                }
                catch (Exception exception) {}
            }
            LOGGER.log(Level.INFO, "linkedTempTablesNumber:" + linkedTempTablesNumber);
            QueryGenerator qGen = QueryGeneratorFactory.getInstance().getQueryGenerator();
            Hashtable hash = RunQuery.getInstance().queryDB(qGen.getTablesLike("import\\_%"));
            Vector tabular = (Vector)hash.get("tabular");
            for (int i = 0; i < tabular.size(); ++i) {
                Vector oneRow = (Vector)tabular.get(i);
                for (int k = 0; k < oneRow.size(); ++k) {
                    String tableName = oneRow.get(k).toString();
                    try {
                        int last_index = tableName.lastIndexOf("_");
                        if (last_index == -1) continue;
                        Long tableNumber = Long.parseLong(tableName.substring(last_index + 1));
                        if (linkedTempTablesNumber.contains(tableNumber)) {
                            skippedTablesName.add(tableName);
                            continue;
                        }
                        RelationalAPI.getInstance().dropTable(tableName, false, null);
                        droppedTablesName.add(tableName);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            LOGGER.log(Level.INFO, "skippedTempTables:" + skippedTablesName);
            LOGGER.log(Level.INFO, "droppedTempTables:" + droppedTablesName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Persistence getPersistence() {
        if (this.persistence == null) {
            try {
                this.persistence = (Persistence)BeanUtil.lookup((String)"Persistence");
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.persistence;
    }
}

