/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.imp;

import com.adventnet.sa.server.univlogparser.CustomFileTransferUtil;
import com.maverick.sftp.SftpFile;
import com.maverick.ssh.HostKeyVerification;
import com.maverick.ssh.LicenseManager;
import com.maverick.ssh.PasswordAuthentication;
import com.maverick.ssh.SshAuthentication;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshConnector;
import com.maverick.ssh.SshTransport;
import com.maverick.ssh.components.SshPublicKey;
import com.maverick.ssh1.Ssh1Client;
import com.maverick.ssh2.Ssh2Client;
import com.maverick.ssh2.Ssh2Context;
import com.sshtools.net.SocketTransport;
import com.sshtools.sftp.SftpClient;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SFTPUtil {
    private static final Logger LOGGER;
    private static Logger log;

    public static SftpClient getSFTPClient(String hostName, String userName, String password, boolean binaryFile) throws Exception {
        return SFTPUtil.getSFTPClient(hostName, userName, password, binaryFile, 22);
    }

    public static SftpClient getSFTPClient(String hostName, String userName, String password, boolean binaryFile, int sftpPort) throws Exception {
        log.info("Connecting");
        try {
            SshConnector con = SshConnector.getInstance();
            HostKeyVerification hkv = new HostKeyVerification(){

                public boolean verifyHost(String hostName, SshPublicKey key) {
                    try {
                        log.info("In SFTPUtil The connected host's key (" + key.getAlgorithm() + ") is" + key.getFingerprint());
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            };
            Ssh2Context ssh2Context = (Ssh2Context)con.getContext(2);
            ssh2Context.setHostKeyVerification(hkv);
            ssh2Context.setPreferredPublicKey("ssh-dss");
            SocketTransport t = new SocketTransport(hostName, sftpPort);
            t.setTcpNoDelay(true);
            SshClient ssh = con.connect((SshTransport)t, userName);
            if (ssh instanceof Ssh1Client) {
                log.info(hostName + " is an SSH1 server!! SFTP is not supported");
                ssh.disconnect();
                return null;
            }
            log.info(hostName + " is an SSH2 server");
            Ssh2Client ssh2 = (Ssh2Client)ssh;
            PasswordAuthentication pwd = new PasswordAuthentication();
            pwd.setPassword(password);
            if (ssh2.authenticate((SshAuthentication)pwd) == 1 && ssh2.isConnected()) {
                if (ssh.isAuthenticated()) {
                    SftpClient sftp = new SftpClient((SshClient)ssh2);
                    if (binaryFile) {
                        log.info("Setting up BINARY MODE transfers");
                        sftp.setTransferMode(1);
                    } else {
                        log.info("Setting up TEXT MODE transfers");
                        sftp.setRemoteEOL(2);
                        sftp.setTransferMode(2);
                    }
                    return sftp;
                }
                log.info("SSH is not Authenticated");
                return null;
            }
            if (ssh2.authenticate((SshAuthentication)pwd) == 2) {
                log.info("Authentication Failed");
                return null;
            }
            log.info("Authentication Not Succeeded");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String doSFTP(SftpClient sftp, String baseDirectory, String remoteDir, String fileName) throws Exception {
        return SFTPUtil.doSFTP(sftp, baseDirectory, remoteDir, fileName, false);
    }

    public static String doSFTP(SftpClient sftp, String baseDirectory, String remoteDir, String fileName, boolean transferNLines) throws Exception {
        String remoteFile;
        log.info("Change the dir");
        if (remoteDir != null) {
            sftp.cd(remoteDir);
        }
        log.info("Getting file");
        StringBuffer tmpBuf = new StringBuffer();
        if (baseDirectory == null) {
            tmpBuf.append(System.getProperty("server.dir"));
            tmpBuf.append(File.separator);
            tmpBuf.append("server");
            tmpBuf.append(File.separator);
            tmpBuf.append("imported_files");
            tmpBuf.append(File.separator);
        } else {
            tmpBuf.append(baseDirectory);
        }
        tmpBuf.append(fileName);
        tmpBuf.append(File.separator);
        LOGGER.log(Level.FINER, "creating directory<->{0}", tmpBuf);
        File wd = new File(tmpBuf.toString());
        if (!wd.exists()) {
            wd.mkdirs();
        }
        tmpBuf.append(File.separator);
        tmpBuf.append(fileName);
        String string = remoteFile = remoteDir != null ? remoteDir : fileName;
        if (remoteDir != null && !remoteDir.endsWith(fileName)) {
            if (remoteDir.indexOf("/") >= 0) {
                remoteFile = remoteFile + "/";
            } else if (remoteDir.indexOf("\\") >= 0) {
                remoteFile = remoteFile + "\\";
            }
            remoteFile = remoteFile + fileName;
            LOGGER.log(Level.FINER, "remoteFile <->{0}", remoteFile);
        }
        try {
            if (transferNLines) {
                String s = SFTPUtil.handleNLinesTransfer(sftp, fileName, remoteFile, tmpBuf.toString(), 100);
                return s;
            }
            sftp.get(remoteFile, tmpBuf.toString());
            return tmpBuf.toString();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                return null;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
        }
    }

    public static SftpFile[] getList(String dir, SftpClient sftp) throws Exception {
        LOGGER.log(Level.FINER, " Getting list for  {0}", sftp);
        if (dir != null) {
            sftp.cd(dir);
        }
        try {
            String currentDir = sftp.pwd();
            SftpFile[] list = sftp.ls(currentDir);
            return list;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void logOut(SftpClient sftp) throws Exception {
        if (sftp == null) {
            return;
        }
        log.info("Quitting client");
        sftp.quit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getParentDir(String origDir, SftpClient sftp) throws Exception {
        String parentDir = null;
        try {
            sftp.cd("..");
            parentDir = sftp.pwd();
        }
        catch (Exception e) {
            try {
                parentDir = sftp.pwd();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        finally {
            try {
                sftp.cd(origDir);
            }
            catch (Exception eee) {
                eee.printStackTrace();
            }
        }
        return parentDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String handleNLinesTransfer(SftpClient sftp, String remoteFile, String remoteFilePath, String localFile, int maxLinesTobeTransferred) {
        CustomFileTransferUtil cftUtil = null;
        InputStream in = null;
        BufferedInputStream bis = null;
        BufferedReader lin = null;
        BufferedWriter writer = null;
        FileOutputStream fos = null;
        String localFilePath = null;
        try {
            in = sftp.getInputStream(remoteFilePath);
            cftUtil = new CustomFileTransferUtil(remoteFile, in);
            bis = new BufferedInputStream(in);
            lin = cftUtil.getInputReaderObj(bis);
            File l = new File(localFile);
            localFilePath = l.getName().equals(remoteFile) ? new File(l.getParentFile(), cftUtil.getLocalFileName()).getPath() : localFile;
            fos = new FileOutputStream(localFilePath);
            writer = cftUtil.isUTF16File() ? new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF16")) : new BufferedWriter(new OutputStreamWriter(fos));
            int alreadyReadLines = 0;
            String line = null;
            while (lin != null && alreadyReadLines++ < maxLinesTobeTransferred && (line = cftUtil.readLineFromReader(lin)) != null) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        finally {
            if (lin != null) {
                try {
                    lin.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SFTPUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SFTPUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SFTPUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SFTPUtil.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (localFilePath == null) {
            return localFile;
        }
        return localFilePath;
    }

    static {
        LicenseManager.addLicense((String)"----BEGIN 3SP LICENSE----\r\nProduct : J2SSH Maverick\r\nLicensee: Zoho Corporation Private Limited\r\nComments: None\r\nType    : OEM License\r\nCreated : 01-Feb-2015\r\n\r\n378720420626DFDBA600F3CF9CCEF4C802A97AD72B3CD756\r\n51825ECA5A0FAB7A9D50148C3D03458138ED230311C1DF44\r\n86A4598A41447783A438030C30E10FA031853876D2356499\r\n33CA93678E8BF0143E4FA3924C4391B9587924E0389475F9\r\n87AEBDF4A1FFEC4736302126F41D22FE78E9E273C9AD72A9\r\n0D117B46DE452200A74F772B290809B0BD66B63B52CB2C49\r\n----END 3SP LICENSE----\r\n");
        LOGGER = Logger.getLogger(SFTPUtil.class.getName());
        log = Logger.getLogger(SFTPUtil.class.getName());
    }
}

