/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.lc;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.QueryUtil;
import com.adventnet.la.util.ResourceCheckerUtil;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.AS400LogArchiver;
import com.adventnet.sa.server.AS400LogPreProcessor;
import com.adventnet.sa.server.lc.Log;
import com.adventnet.sa.server.lc.LogDataIndexer;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.SecureAS400;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AS400ScheduleTask
implements Task {
    private static final Logger LOGGER = Logger.getLogger(AS400ScheduleTask.class.getName());
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static boolean mysqlDB = "mysql".equals(System.getProperty("DBType", "mysql"));
    private static boolean isPostgres = "postgres".equals(System.getProperty("DBType", "postgres"));
    private static final String DELIMITER = isPostgres ? "~" : "|**|";
    private static final String RECORDDELIMITER = "|**|**|";
    private StringBuffer logjrndata = new StringBuffer();
    private String delim = "~~";
    private String split = ":";
    private FileInputStream fstream;
    private BufferedReader br;
    private FileOutputStream jrn = null;
    private PrintWriter jrnWriter = null;
    private boolean isWinAuthType = "true".equals(System.getProperty("isWinAuthType", "false"));
    private String hostName = null;
    private String dnsName = null;
    private String hostType = null;
    private String userName = null;
    private Boolean isSSL = false;
    private String password = null;
    private String str_last_msg_time = null;
    private String str_journal_last_msg_time = null;
    private String dateFormat = null;
    private String dateDelim = null;
    private String jobname = null;
    private String separator = File.separator;
    private String dataDir = System.getProperty("server.dir") + this.separator + "data" + this.separator;
    private String binDir = System.getProperty("server.dir") + this.separator + "bin" + this.separator;
    private String[] jrnfields = new String[]{"AFENTT,AFTSTP,AFJOB,AFNBR,AFUSER,AFPGM,AFPGMLIB,AFUSPF,AFRADR,AFVIOL,AFONAM,AFOLIB,AFOTYP,AFJNME,AFUNME,AFJNBR,AFPNAM,AFPLIB,AFUSEP,AFWSNT,AFFLDN,AFOPVL,AFPNM", "CAENTT,CATSTP,CAJOB,CANBR,CAUSER,CAPGM,CAPGMLIB,CAUSPF,CARADR,CAETYP,CAONAM,CAOLIB,CAOTYP,CAUNAM,CAAUTL,CAOBJE,CAOBJM,CAOBJO,CAAUTM,CAALST,CAREAD,CAADD,CAUPD,CADLT,CAEXCL,CAEXEC,CAOBJA,CAOBJR,CAATTR,CAOACC,CAPNM,CACMDT", "CPENTT,CPTSTP,CPJOB,CPNBR,CPUSER,CPPGM,CPPGMLIB,CPUSPF,CPRADR,CPETYP,CPONAM,CPOLIB,CPOTYP,CPCMDN,CPPCHG,CPPNON,CPPEXP,CPSALO,CPSJBC,CPSSVS,CPSSEC,CPSSPL,CPSSRV,CPSAUD,CPSIOS,CPGPRF,CPGOWN,CPCURL,CPSTAT,CPUID,CPGID", "DOENTT,DOTSTP,DOJOB,DONBR,DOUSER,DOPGM,DOPGMLIB,DOUSPF,DORADR,DOETYP,DOONAM,DOOLIB,DOOTYP,DOPNM", "JSENTT,JSTSTP,JSJOB,JSNBR,JSUSER,JSPGM,JSPGMLIB,JSUSPF,JSRADR,JSETYP,JSJTYP,JSSTYP,JSJNAM,JSJUSR,JSJNUM,JSDEVD,JSUSRP,JSJBD,JSJBQ,JSOTQ,JSEJNUMB", "OWENTT,OWTSTP,OWJOB,OWNBR,OWUSER,OWPGM,OWPGMLIB,OWUSPF,OWRADR,OWETYP,OWONAM,OWOLIB,OWOTYP,OWOOWN,OWNOWN,OWPNM", "PWENTT,PWTSTP,PWJOB,PWNBR,PWUSER,PWPGM,PWPGMLIB,PWUSPF,PWRADR,PWTYPE,PWUSRN,PWDEVN", "SVENTT,SVTSTP,SVJOB,SVNBR,SVUSER,SVPGM,SVPGMLIB,SVUSPF,SVRADR,SVETYP,SVSYSV,SVNVAL,SVOVAL,SVNCVL,SVOCVL"};
    private List jrnlength = Arrays.asList(23, 32, 31, 14, 21, 16, 12, 15);
    private String[] logtypes = new String[]{"AF", "CA", "CP", "DO", "JS", "OW", "PW", "SV"};
    private Long hostId = null;
    private Long mon_interval = null;
    private Pattern logPattern = null;
    private Matcher logMatcher = null;
    private Pattern logBRMSPattern = null;
    private Matcher logBRMSMatcher = null;
    private SimpleDateFormat logDF = null;
    private SimpleDateFormat hourDf = new SimpleDateFormat("yyyy-MM-dd HH:00:00");
    private FileWriter sysFWriter = null;
    private FileWriter compSysFWriter = null;
    private FileWriter unparsedLogFWriter = null;
    private PrintWriter sysWriter = null;
    private PrintWriter compSysWriter = null;
    private PrintWriter unparsedLogPWriter = null;
    private int recordCount = 0;
    private AS400LogArchiver as400LogArchiver = null;
    private AS400LogPreProcessor as400LogPreProcessor = null;
    private static HashMap jobNameMap = new HashMap();
    private boolean filterBeforeArchive = false;
    private String dsplogLibrary = null;
    private String dspjrnLibrary = null;
    private int dsplogCCSID = 37;
    private String dsplog_file = null;
    private String brmslog_file = null;

    public void executeTask(TaskContext context) {
        try {
            if ("false".equals(System.getProperty("isPremium", "false"))) {
                LOGGER.log(Level.INFO, "AS400 Scheduled Task is not started reason not a premium license");
                return;
            }
            LOGGER.log(Level.INFO, "AS400 Scheduled Task is Started");
            DataObject taskInputDO = context.getTaskInputDO();
            if (taskInputDO != null) {
                Long scheduleId = (Long)taskInputDO.getFirstValue("Task_Input", "SCHEDULE_ID");
                DataObject scheduleDO = DataAccess.get((String)"Schedule", (Criteria)new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0));
                LOGGER.log(Level.FINER, "AS400 ScheduledDO ::::::: {0}", scheduleDO);
                String scheduleName = (String)scheduleDO.getFirstValue("Schedule", "SCHEDULE_NAME");
                this.fetchAS400Logs(scheduleName.substring(0, scheduleName.indexOf("_AS400Schedule")));
            } else {
                LOGGER.log(Level.INFO, "Unable to run the schedule <->{0}", context);
            }
            LOGGER.info("AS400 Scheduled Task is finished for Host <-> " + this.hostName);
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Exception occured during the AS400 schedule task");
            exp.printStackTrace();
        }
    }

    public void stopTask() {
    }

    public void fetchAS400Logs(String hostName) throws Exception {
        try {
            this.hostName = hostName;
            this.filterBeforeArchive = "true".equals(System.getProperty("filtBeforeArch"));
            LOGGER.log(Level.INFO, "Fetch Logs for the AS400 host ::::::: {0}", this.hostName);
            DataObject hostDO = null;
            try {
                ArrayList<String> tableList = new ArrayList<String>();
                tableList.add("Hosts");
                tableList.add("HostDetails");
                tableList.add("IBMDeviceConfigurations");
                Criteria criteria = new Criteria(Column.getColumn((String)"Hosts", (String)"DNS_NAME"), (Object)this.hostName, 0);
                hostDO = PERSISTENCELITE.get(tableList, criteria);
            }
            catch (Exception exp) {
                LOGGER.info("Exception occurred while fetchAS400Logs , exception details : " + exp.getMessage());
            }
            LOGGER.log(Level.FINER, "AS400 hostDO ::::::: {0}", hostDO);
            Row hostRow = hostDO.getFirstRow("Hosts");
            Row hostDetailsRow = hostDO.getFirstRow("HostDetails");
            Row ibmDeviceDetailsRow = hostDO.getFirstRow("IBMDeviceConfigurations");
            this.hostId = (Long)hostRow.get("HOST_ID");
            this.dnsName = (String)hostRow.get("DNS_NAME");
            this.hostType = (String)hostDetailsRow.get("TYPE");
            this.userName = (String)hostDetailsRow.get("USERNAME");
            this.isSSL = (Boolean)hostDetailsRow.get("ENABLESSL");
            this.password = EnDecryptImplSingleton.getInstance().decrypt((String)hostDetailsRow.get("PASSWORD"));
            this.mon_interval = (Long)hostDetailsRow.get("MON_INTERVAL");
            this.str_last_msg_time = (String)hostDetailsRow.get("LAST_MSG_TIME");
            String[] formats = ((String)hostDetailsRow.get("DOMAIN_NAME")).split(",");
            this.dateFormat = formats[0];
            this.dateDelim = formats[1];
            LOGGER.log(Level.FINER, "Date Format ::::::: {0} Delimiter ::::::::: {1} last_msg_time :::::::::: {2}", new Object[]{this.dateFormat, this.dateDelim, this.str_last_msg_time});
            if (!jobNameMap.containsKey(this.hostName)) {
                jobNameMap.put(this.hostName, (String)hostDetailsRow.get("USERNAME") + "/QPRTJOB");
                LOGGER.log(Level.INFO, "jobNameMap is getting updated ---> jobNameMap : " + jobNameMap);
            } else {
                String tempjob = (String)jobNameMap.get(hostName);
                jobNameMap.put(this.hostName, tempjob.indexOf((String)hostDetailsRow.get("USERNAME")) != -1 ? tempjob : (String)hostDetailsRow.get("USERNAME"));
                LOGGER.log(Level.INFO, " ---> jobNameMap : " + jobNameMap);
            }
            this.jobname = (String)jobNameMap.get(this.hostName);
            this.dsplogLibrary = (String)ibmDeviceDetailsRow.get("DSPLOG_LIB");
            this.dspjrnLibrary = (String)ibmDeviceDetailsRow.get("JOURNALLOG_LIB");
            this.dsplogCCSID = (Integer)ibmDeviceDetailsRow.get("CCSID");
            this.dsplog_file = (String)ibmDeviceDetailsRow.get("DSPLOG_FILE");
            this.brmslog_file = (String)ibmDeviceDetailsRow.get("BRMSLOG_FILE");
            DataObject dobj = DataAccess.get((String)"ExtendedHostDetails", (Criteria)new Criteria(Column.getColumn((String)"ExtendedHostDetails", (String)"HOST_ID"), (Object)this.hostId, 0));
            if (dobj.isEmpty()) {
                Row row = new Row("ExtendedHostDetails");
                row.set("HOST_ID", (Object)this.hostId);
                row.set("CONF_NAME", (Object)"AUDIT_LAST_MESSAGE_TIME");
                row.set("CONF_VALUE", (Object)"0");
                dobj.addRow(row);
                DataAccess.update((DataObject)dobj);
            }
            SelectQueryImpl exthostSql = new SelectQueryImpl(Table.getTable((String)"ExtendedHostDetails"));
            exthostSql.addSelectColumn(Column.getColumn((String)"ExtendedHostDetails", (String)"*"));
            Criteria cri1 = new Criteria(Column.getColumn((String)"ExtendedHostDetails", (String)"HOST_ID"), (Object)this.hostId, 0);
            cri1 = cri1.and(new Criteria(Column.getColumn((String)"ExtendedHostDetails", (String)"CONF_NAME"), (Object)"AUDIT_LAST_MESSAGE_TIME", 0));
            exthostSql.setCriteria(cri1);
            DataObject exthostSqlhostDO = DataAccess.get((SelectQuery)exthostSql);
            this.str_journal_last_msg_time = (String)exthostSqlhostDO.getFirstValue("ExtendedHostDetails", "CONF_VALUE");
            long current_time = System.currentTimeMillis();
            long next_scan_time = current_time + this.mon_interval * 60000L;
            Long hostStatus = new Long(0L);
            this.as400LogPreProcessor = AS400LogPreProcessor.getInstance();
            this.as400LogPreProcessor.initialize(this.hostName, this.hostId);
            if ("true".equals(System.getProperty("sysEnableArchiving", "true"))) {
                LOGGER.fine("Archive is Enabled");
                this.as400LogArchiver = AS400LogArchiver.getInstance();
                this.as400LogArchiver.initialize(this.hostName);
            }
            try {
                if ("false".equals(System.getProperty("demo", "false"))) {
                    this.storeLogsToDB();
                }
                this.createTempTable();
                this.parseLogs();
                this.parseBRMSLogs();
                if (this.str_last_msg_time == null || "".equals(this.str_last_msg_time)) {
                    this.str_last_msg_time = "" + System.currentTimeMillis();
                }
                LOGGER.info("Last Message time : " + this.str_last_msg_time);
                LOGGER.info("Last Message time : " + new Date(Long.parseLong(this.str_last_msg_time)));
                if (this.str_journal_last_msg_time == null || "".equals(this.str_journal_last_msg_time)) {
                    this.str_journal_last_msg_time = "" + System.currentTimeMillis();
                }
                LOGGER.info("Last Audit Log Message time : " + this.str_journal_last_msg_time);
                LOGGER.info("Last Audit Log Message time : " + new Date(Long.parseLong(this.str_journal_last_msg_time)));
                this.dumpToTrendTable();
            }
            catch (Exception e) {
                hostStatus = BaseStatusCode.getBaseStatusCode(9002).getOrgStatusCode();
                e.printStackTrace();
            }
            UpdateQueryImpl query = new UpdateQueryImpl("HostDetails");
            query.setCriteria(new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)this.hostId, 0));
            query.setUpdateColumn("STATUS", (Object)hostStatus);
            query.setUpdateColumn("LOG_COLLECTION_STATUS", (Object)new Integer(1));
            query.setUpdateColumn("NEXT_SCAN_TIME", (Object)("" + next_scan_time));
            query.setUpdateColumn("LAST_MSG_TIME", (Object)this.str_last_msg_time);
            DataAccess.update((UpdateQuery)query);
            UpdateQueryImpl jrnquery = new UpdateQueryImpl("ExtendedHostDetails");
            Criteria cri2 = new Criteria(Column.getColumn((String)"ExtendedHostDetails", (String)"HOST_ID"), (Object)this.hostId, 0);
            cri2 = cri2.and(new Criteria(Column.getColumn((String)"ExtendedHostDetails", (String)"CONF_NAME"), (Object)"AUDIT_LAST_MESSAGE_TIME", 0));
            jrnquery.setCriteria(cri2);
            jrnquery.setUpdateColumn("CONF_VALUE", (Object)this.str_journal_last_msg_time);
            DataAccess.update((UpdateQuery)jrnquery);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while fetching logs from AS400 :::::: {0}", e);
            e.printStackTrace();
        }
    }

    private void storeLogsToDB() throws Exception {
        LOGGER.log(Level.FINER, "Fetching the logs from AS400 and storing to AS400 Database");
        long logTimeOut = Long.parseLong(System.getProperty("logTimeOut", "1")) * 3600000L;
        long last_msg_time = 0L;
        if (this.str_last_msg_time != null && !"".equals(this.str_last_msg_time)) {
            last_msg_time = Long.parseLong(this.str_last_msg_time);
            last_msg_time = System.currentTimeMillis() - last_msg_time > logTimeOut ? 0L : last_msg_time;
        }
        long journal_last_msg_time = 0L;
        if (this.str_journal_last_msg_time != null && !"".equals(this.str_journal_last_msg_time)) {
            journal_last_msg_time = Long.parseLong(this.str_journal_last_msg_time);
            journal_last_msg_time = System.currentTimeMillis() - journal_last_msg_time > logTimeOut ? 0L : journal_last_msg_time;
        }
        long start_time = last_msg_time != 0L ? last_msg_time : System.currentTimeMillis() - logTimeOut;
        long journal_start_time = journal_last_msg_time != 0L ? journal_last_msg_time : System.currentTimeMillis() - logTimeOut;
        SimpleDateFormat fromDateFormat = new SimpleDateFormat(this.dateFormat);
        String from_date = fromDateFormat.format(new Date(start_time));
        SimpleDateFormat journal_dateFormat = new SimpleDateFormat(this.dateFormat);
        SimpleDateFormat journal_timeFormat = new SimpleDateFormat("HHmmss");
        String from_jrndate = journal_dateFormat.format(new Date(journal_start_time));
        String from_jrntime = journal_timeFormat.format(new Date(journal_start_time));
        SimpleDateFormat fromTimeFormat = new SimpleDateFormat("HHmmss");
        String from_time = fromTimeFormat.format(new Date(start_time));
        LOGGER.log(Level.INFO, "start_time : {0} {1}", new Object[]{from_date, from_time});
        LOGGER.log(Level.INFO, "journal start_time : {0} {1}", new Object[]{from_jrndate, from_jrntime});
        Object as400 = null;
        as400 = this.isSSL != false ? new SecureAS400(this.hostName, this.userName, this.password) : new AS400(this.hostName, this.userName, this.password);
        as400.setGuiAvailable(false);
        try {
            as400.validateSignon();
        }
        catch (AS400SecurityException ase1) {
            LOGGER.log(Level.INFO, "First Validation failed and AS400SecurityException Code :::::::: " + ase1.getReturnCode());
            as400.authenticate(this.userName, this.password);
        }
        LOGGER.log(Level.FINER, "Successfully connected to the IBM AS400 Server");
        CommandCall command = new CommandCall((AS400)as400);
        this.as400Command(command, "DSPLOG PERIOD((" + from_time + " " + from_date + ")) OUTPUT(*PRTWRAP)");
        this.as400Command(command, "CRTPF FILE(" + this.dsplogLibrary + "/eventlog) RCDLEN(256) SIZE(*NOMAX) IGCDTA(*YES)");
        this.as400Command(command, "CPYSPLF FILE(" + this.dsplog_file + ") TOFILE(" + this.dsplogLibrary + "/eventlog) JOB(" + this.jobname + ") SPLNBR(*LAST) MBROPT(*REPLACE)");
        this.as400Command(command, "DLTSPLF FILE(" + this.dsplog_file + ") JOB(" + this.jobname + ") SPLNBR(*LAST)");
        this.as400Command(command, "DSPLOGBRM PERIOD((" + from_time + " " + from_date + ")) OUTPUT(*PRINT)");
        this.as400Command(command, "CRTPF FILE(" + this.dsplogLibrary + "/eventbrm) RCDLEN(256) SIZE(*NOMAX) IGCDTA(*YES)");
        this.as400Command(command, "CPYSPLF FILE(" + this.brmslog_file + ") TOFILE(" + this.dsplogLibrary + "/eventbrm) JOB(" + this.jobname + ") SPLNBR(*LAST) MBROPT(*REPLACE)");
        this.as400Command(command, "DLTSPLF FILE(" + this.brmslog_file + ") JOB(" + this.jobname + ") SPLNBR(*LAST)");
        this.fetchLogsFromDB();
        this.as400Command(command, "DLTF FILE(" + this.dsplogLibrary + "/eventlog)");
        this.as400Command(command, "DLTF FILE(" + this.dsplogLibrary + "/eventbrm)");
        for (int i = 0; i < this.logtypes.length; ++i) {
            String jrntyp = this.logtypes[i];
            this.as400Command(command, "CRTDUPOBJ  OBJ(QASY" + jrntyp + "J5) FROMLIB(QSYS) OBJTYPE(*FILE)  TOLIB(" + this.dspjrnLibrary + ") NEWOBJ(" + jrntyp + "_ELA)");
            this.as400Command(command, "DSPJRN JRN(QAUDJRN) RCVRNG(*CURRENT) ENTTYP(" + jrntyp + ") FROMTIME('" + from_jrndate + "' '" + from_jrntime + "') OUTPUT(*OUTFILE) OUTFILFMT(*TYPE5) OUTFILE(" + this.dspjrnLibrary + "/" + jrntyp + "_ELA) OUTMBR(*FIRST *REPLACE)");
            this.journallogs(jrntyp, i);
            this.as400Command(command, "DLTF FILE(" + this.dspjrnLibrary + "/" + jrntyp + "_ELA)");
        }
        as400.disconnectService(2);
        LOGGER.log(Level.FINER, "Disconnecting the IBM AS400 Server");
        this.ProcessJournalLogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void journallogs(String jrntyp, int val) throws Exception {
        LOGGER.log(Level.FINER, "Fetching stored journal from AS400 database and writing to a file");
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        String cols = this.jrnfields[val];
        int len = (Integer)this.jrnlength.get(val);
        FileOutputStream as400File = null;
        try {
            DriverManager.registerDriver((Driver)new AS400JDBCDriver());
            String secureText = "";
            if (this.isSSL.booleanValue()) {
                secureText = "secure=true;";
            }
            con = DriverManager.getConnection("jdbc:as400://" + this.hostName + ";user=" + this.userName + ";password=" + this.password + ";prompt=false;errors=full;" + secureText);
            st = con.createStatement();
            LOGGER.log(Level.FINER, "Connection to the DB is successfull");
            rs = st.executeQuery("SELECT " + cols + " from " + this.dspjrnLibrary + "." + jrntyp + "_ELA");
            as400File = new FileOutputStream(this.dataDir + this.hostId + "dspjrn" + jrntyp + ".txt");
            OutputStreamWriter as400Writer = new OutputStreamWriter((OutputStream)as400File, "UTF8");
            PrintWriter as400PWriter = new PrintWriter((Writer)as400Writer, false);
            while (rs.next()) {
                for (int i = 1; i <= len; ++i) {
                    as400PWriter.print(rs.getString(i) + "~~");
                }
                as400PWriter.print("\n");
            }
            rs.close();
            st.close();
            as400PWriter.flush();
            as400PWriter.close();
            as400Writer.close();
            as400File.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Unable to load IBM Toolbox for Java JDBC driver ::::::: {0}", e);
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
                if (con != null) {
                    con.close();
                }
                if (as400File != null) {
                    as400File.close();
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.INFO, "Exception while closing the DB connections ::::::: {0}", e);
            }
        }
    }

    private void as400Command(CommandCall command, String commandString) {
        try {
            if (command.run(commandString)) {
                LOGGER.log(Level.FINER, commandString + " <-> Command successful");
            } else {
                LOGGER.log(Level.INFO, commandString + " <-> Command failed");
                AS400Message[] messagelist = command.getMessageList();
                ArrayList<String> msgIDList = new ArrayList<String>();
                for (int i = 0; i < messagelist.length; ++i) {
                    String errorMsgID = messagelist[i].getID();
                    String errorMsg = messagelist[i].getText();
                    LOGGER.log(Level.INFO, "{0} : {1}", new Object[]{errorMsgID, errorMsg});
                    if (msgIDList.contains(errorMsgID)) continue;
                    msgIDList.add(errorMsgID);
                    if (!"CPF0906".equals(errorMsgID)) continue;
                    Pattern errorPattern = Pattern.compile("(\\d*)/\\w*/\\w*");
                    Matcher errorMatcher = errorPattern.matcher("");
                    errorMatcher.reset(errorMsg);
                    if (!errorMatcher.find()) continue;
                    this.jobname = errorMatcher.group(1) + "/" + this.jobname;
                    jobNameMap.put(this.hostName, this.jobname);
                    LOGGER.info("Fully qualified jobname is created <-> " + this.jobname);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Command {0} didn't run", command.getCommand());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchLogsFromDB() throws Exception {
        LOGGER.log(Level.FINER, "Fetching stored logs from AS400 database and writing to a file");
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        FileOutputStream as400File = null;
        FileOutputStream as400BRMSFile = null;
        try {
            DriverManager.registerDriver((Driver)new AS400JDBCDriver());
            String secureText = "";
            if (this.isSSL.booleanValue()) {
                secureText = "secure=true;";
            }
            con = DriverManager.getConnection("jdbc:as400://" + this.hostName + ";user=" + this.userName + ";password=" + this.password + ";prompt=false;errors=full;" + secureText);
            st = con.createStatement();
            LOGGER.log(Level.FINER, "Connection to the DB is successfull");
            rs = st.executeQuery("SELECT cast(eventlog as varchar(256) CCSID " + this.dsplogCCSID + ") FROM " + this.dsplogLibrary + ".eventlog");
            as400File = new FileOutputStream(this.dataDir + this.hostId + "dsplog.txt");
            OutputStreamWriter as400Writer = new OutputStreamWriter((OutputStream)as400File, "UTF8");
            PrintWriter as400PWriter = new PrintWriter((Writer)as400Writer, false);
            while (rs.next()) {
                as400PWriter.print(rs.getString(1));
            }
            rs = st.executeQuery("SELECT cast(eventbrm as varchar(256) CCSID " + this.dsplogCCSID + ") FROM " + this.dsplogLibrary + ".eventbrm");
            as400BRMSFile = new FileOutputStream(this.dataDir + this.hostId + "dsplogbrm.txt");
            OutputStreamWriter as400BRMSWriter = new OutputStreamWriter((OutputStream)as400BRMSFile, "UTF8");
            PrintWriter as400BRMSPWriter = new PrintWriter((Writer)as400BRMSWriter, false);
            while (rs.next()) {
                as400BRMSPWriter.print(rs.getString(1));
            }
            rs.close();
            st.close();
            as400PWriter.flush();
            as400PWriter.close();
            as400Writer.close();
            as400File.close();
            as400BRMSPWriter.flush();
            as400BRMSPWriter.close();
            as400BRMSWriter.close();
            as400BRMSFile.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Unable to load IBM Toolbox for Java JDBC driver ::::::: {0}", e);
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
                if (con != null) {
                    con.close();
                }
                if (as400File != null) {
                    as400File.close();
                }
                if (as400BRMSFile != null) {
                    as400BRMSFile.close();
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.INFO, "Exception while closing the DB connections ::::::: {0}", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLogs() throws Exception {
        LOGGER.log(Level.FINER, "Parsing the AS400 logs and dumping to Eventlog Analyzer DB");
        this.logPattern = Pattern.compile("(\\w+)\\s+(\\d{2})\\s+(\\S+)\\s+(.+)\\s+(\\S+)\\s+(\\S+)\\s+(\\d+)\\s+(\\d{2}[/\\.-]\\d{2}[/\\.-]\\d{2}\\s\\d{2}:\\d{2}:\\d{2})(?:[\\.,]\\d+)?\\s(\\S+)?");
        this.logMatcher = this.logPattern.matcher("");
        this.logBRMSPattern = Pattern.compile(".*?(\\d{1,2}\\/\\d{2}\\/\\d{2})\\s+(\\d{1,2}:\\d{2}:\\d{2})\\s+(\\S+)\\s+(\\d+)\\s+(.*?)\\s+(\\S+)\\s+(\\S+)\\s+\\*(\\S+).*");
        this.logBRMSMatcher = this.logBRMSPattern.matcher("");
        String[] index = new String[3];
        if (this.dateFormat.length() == 8) {
            index = this.dateFormat.split(this.dateDelim);
        } else if (this.dateFormat.length() == 6) {
            index[0] = this.dateFormat.substring(0, 2);
            index[1] = this.dateFormat.substring(2, 4);
            index[2] = this.dateFormat.substring(4, 6);
        }
        LOGGER.fine("DATE FORMAT for logs: " + index[0] + this.dateDelim + index[1] + this.dateDelim + index[2] + " HH:mm:ss");
        this.logDF = new SimpleDateFormat(index[0] + this.dateDelim + index[1] + this.dateDelim + index[2] + " HH:mm:ss");
        BufferedReader dsplogfile = null;
        BufferedReader bread = null;
        FileInputStream fstr = null;
        LOGGER.log(Level.FINER, "Writing the content of AS400 database to the file :::::: {0}{1}dsplog.txt", new Object[]{this.dataDir, this.hostId});
        try {
            this.createDumpFiles();
            this.openArchiveFile();
            boolean dspl = true;
            boolean isUTF16 = this.isUTF16File(new File(this.dataDir + this.hostId + "dsplog.txt"));
            LOGGER.log(Level.FINE, "isUTF16 :::  " + isUTF16);
            dsplogfile = isUTF16 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataDir + this.hostId + "dsplog.txt"), "UTF-16")) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataDir + this.hostId + "dsplog.txt"), "UTF8"));
            Hashtable map = new Hashtable();
            Hashtable jrnmap = new Hashtable();
            this.recordCount = 0;
            String dspLog = dsplogfile.readLine();
            if (dspLog == null || "".equals(dspLog)) {
                LOGGER.info("No records retrived for the host <-> " + this.hostName);
                dspl = false;
            }
            String[] logs = new String[500000];
            if (dspl) {
                dspLog = dspLog.replaceAll("\\w* V\\w* \\d*\\s*\\w* \\w*\\s*P\\w*\\W*\\w*\\s*\\w*\\s*\\w*\\s*\\w*\\s*\\w*\\s*", "");
                logs = dspLog.replaceAll("CP\\w{5}  \\d{2}", "\n$0").split("\n");
            }
            ArrayList<String> archiveLogs = new ArrayList<String>();
            String data = null;
            long date2 = 0L;
            long date1 = 0L;
            String path = this.dataDir + this.hostId + "dspjrn.txt";
            fstr = new FileInputStream(path);
            bread = new BufferedReader(new InputStreamReader(fstr));
            while ((data = bread.readLine()) != null) {
                jrnmap = this.processJournal(data);
                LogIndexingAPI.getInstance().generateLogUniqueID((Map)jrnmap);
                this.as400LogPreProcessor.doAlert(jrnmap);
                if (this.filterBeforeArchive && this.as400LogPreProcessor.doFilter(jrnmap)) {
                    jrnmap = new Hashtable();
                    continue;
                }
                date1 = (Long)jrnmap.get("TIME");
                if (date1 > date2) {
                    this.str_journal_last_msg_time = jrnmap.get("TIME") + "";
                    date2 = (Long)jrnmap.get("TIME");
                }
                if (!this.filterBeforeArchive && this.as400LogPreProcessor.doFilter(jrnmap)) {
                    jrnmap = new Hashtable();
                    continue;
                }
                this.addLogToFile(jrnmap);
            }
            if (logs.length >= 1 && dspl) {
                for (int i = 0; i < logs.length; ++i) {
                    if (logs[i].length() <= 0) continue;
                    LOGGER.log(Level.FINEST, "RAW LOG :: {0}", new Object[]{logs[i]});
                    map = this.getParams(logs[i]);
                    if (map.isEmpty()) {
                        if (logs[i].trim().length() <= 0) continue;
                        this.unparsedLog(logs[i]);
                        continue;
                    }
                    LogIndexingAPI.getInstance().generateLogUniqueID((Map)map);
                    this.as400LogPreProcessor.doAlert(map);
                    if (this.filterBeforeArchive && this.as400LogPreProcessor.doFilter(map)) {
                        map = new Hashtable();
                        continue;
                    }
                    this.str_last_msg_time = map.get("TIME") + "";
                    archiveLogs.add(logs[i] + " " + this.str_last_msg_time);
                    if (archiveLogs.size() == 100 || i == logs.length - 1) {
                        LOGGER.info("Threshold reached flushing to file");
                        this.writeToArchiveFile(archiveLogs);
                        archiveLogs = new ArrayList();
                    }
                    if (!this.filterBeforeArchive && this.as400LogPreProcessor.doFilter(map)) {
                        map = new Hashtable();
                        continue;
                    }
                    this.addLogToFile(map);
                    if (this.recordCount <= 0 || this.recordCount % 20000 != 0) continue;
                    this.closeDumpFiles();
                    this.dumpLogsToDB();
                    this.deleteTempFiles();
                    this.closeArchiveFile();
                    this.createDumpFiles();
                    this.openArchiveFile();
                }
            }
            LOGGER.info("Total Number of Logs: " + this.recordCount);
            this.closeDumpFiles();
            this.dumpLogsToDB();
            this.deleteTempFiles();
            this.closeArchiveFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dsplogfile != null) {
                    dsplogfile.close();
                }
                if (bread != null) {
                    bread.close();
                }
                if (fstr != null) {
                    fstr.close();
                }
                this.deleteTempFiles();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBRMSLogs() throws Exception {
        File f = new File(this.dataDir + this.hostId + "dsplogbrm.txt");
        if (!f.exists()) {
            LOGGER.log(Level.INFO, "BRMS Logs not collected for host : {0}", this.hostId);
            return;
        }
        BufferedReader dsplogfile = null;
        LOGGER.log(Level.FINER, "Writing the content of AS400 database to the file :::::: {0}{1}dsplogbrm.txt", new Object[]{this.dataDir, this.hostId});
        try {
            this.createDumpFiles();
            this.openArchiveFile();
            boolean dspl = true;
            boolean isUTF16 = this.isUTF16File(f);
            LOGGER.log(Level.FINE, "isUTF16 :::  " + isUTF16);
            dsplogfile = isUTF16 ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataDir + this.hostId + "dsplogbrm.txt"), "UTF-16")) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.dataDir + this.hostId + "dsplogbrm.txt"), "UTF8"));
            ArrayList<String> archiveLogs = new ArrayList<String>();
            Hashtable map = new Hashtable();
            Hashtable jrnmap = new Hashtable();
            this.recordCount = 0;
            String dspLog = dsplogfile.readLine();
            if (dspLog == null || "".equals(dspLog)) {
                LOGGER.info("No records retrived for the host <-> " + this.hostName);
                dspl = false;
            }
            String[] logs = new String[500000];
            if (dspl) {
                dspLog = dspLog.replaceAll("\\w* V\\w* \\d*\\s*\\w* \\w*\\s*P\\w*\\W*\\w*\\s*\\w*\\s*\\w*\\s*\\w*\\s*\\w*\\s*", "");
                logs = dspLog.replaceAll("\\d{1,2}\\/\\d{2}\\/\\d{2}", "\n$0").split("\n");
            }
            if (logs.length >= 1 && dspl) {
                for (int i = 0; i < logs.length; ++i) {
                    if (logs[i].length() <= 0) continue;
                    map = this.getBRMSParams(logs[i]);
                    if (map.isEmpty()) {
                        if (logs[i].trim().length() <= 0) continue;
                        this.unparsedLog(logs[i]);
                        continue;
                    }
                    LogIndexingAPI.getInstance().generateLogUniqueID((Map)map);
                    this.as400LogPreProcessor.doAlert(map);
                    if (this.filterBeforeArchive && this.as400LogPreProcessor.doFilter(map)) {
                        map = new Hashtable();
                        continue;
                    }
                    this.str_last_msg_time = map.get("TIME") + "";
                    archiveLogs.add(logs[i] + " " + this.str_last_msg_time);
                    if (archiveLogs.size() == 100 || i == logs.length - 1) {
                        LOGGER.info("Threshold reached flushing to file");
                        this.writeToArchiveFile(archiveLogs);
                        archiveLogs = new ArrayList();
                    }
                    if (!this.filterBeforeArchive && this.as400LogPreProcessor.doFilter(map)) {
                        map = new Hashtable();
                        continue;
                    }
                    this.addLogToFile(map);
                    if (this.recordCount <= 0 || this.recordCount % 20000 != 0) continue;
                    this.closeDumpFiles();
                    this.dumpLogsToDB();
                    this.deleteTempFiles();
                    this.closeArchiveFile();
                    this.createDumpFiles();
                    this.openArchiveFile();
                }
            }
            LOGGER.info("Total Number of BRMS Logs: " + this.recordCount);
            this.closeDumpFiles();
            this.dumpLogsToDB();
            this.deleteTempFiles();
            this.closeArchiveFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dsplogfile != null) {
                    dsplogfile.close();
                }
                this.deleteTempFiles();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Hashtable processJournal(String dat) throws ParseException {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        String[] jrnData = dat.split("~~");
        for (int i = 0; i < jrnData.length; ++i) {
            jrnData[i] = jrnData[i].trim();
        }
        map.put("MSGID", jrnData[4]);
        this.getSeverity("ESCAPE", map);
        map.put("FACILITY", "00");
        String msg = jrnData[5];
        map.put("TYPESOURCE", this.getSource(jrnData[4]));
        map.put("MESSAGE", msg);
        map.put("JOBNAME", jrnData[1]);
        map.put("USERNAME", jrnData[2]);
        map.put("JOBNUMBER", jrnData[0]);
        map.put("SOURCE", jrnData[3]);
        if (jrnData[4].equals("AF")) {
            map.put("TYPEENTRY", jrnData[7]);
            map.put("OBJECTLIB", jrnData[9] + "/" + jrnData[8]);
            map.put("OBJECTTYPE", jrnData[10]);
        } else if (jrnData[4].equals("DO")) {
            map.put("TYPEENTRY", jrnData[7]);
            map.put("OBJECTLIB", jrnData[9] + "/" + jrnData[8]);
            map.put("OBJECTTYPE", jrnData[10]);
        } else if (jrnData[4].equals("OW")) {
            map.put("TYPEENTRY", jrnData[7]);
            map.put("OBJECTLIB", jrnData[9] + "/" + jrnData[8]);
            map.put("OBJECTTYPE", jrnData[10]);
            map.put("OLDOWN", jrnData[11]);
            map.put("NEWOWN", jrnData[12]);
        } else if (jrnData[4].equals("PW")) {
            map.put("TYPEENTRY", jrnData[7]);
            map.put("DEVICENAME", jrnData[8]);
        } else if (jrnData[4].equals("SV")) {
            map.put("TYPEENTRY", jrnData[7]);
            map.put("SYSTEMVALUE", jrnData[8]);
            map.put("OLDVALUE", jrnData[10]);
            map.put("NEWVALUE", jrnData[9]);
        } else if (jrnData[4].equals("CA")) {
            map.put("TYPEENTRY", jrnData[7]);
            map.put("OBJECTLIB", jrnData[9] + "/" + jrnData[8]);
            map.put("OBJECTTYPE", jrnData[10]);
            map.put("TARGETUSER", jrnData[11]);
            map.put("OBJEXIST", jrnData[12]);
            map.put("OBJMGMT", jrnData[13]);
            map.put("OBJOPER", jrnData[14]);
            map.put("AUTLM", jrnData[15]);
            map.put("AUTLAUTH", jrnData[16]);
            map.put("READ", jrnData[17]);
            map.put("ADD", jrnData[18]);
            map.put("UPDATE", jrnData[19]);
            map.put("DELETE", jrnData[20]);
            map.put("EXCLUDE", jrnData[21]);
            map.put("EXECUTE", jrnData[22]);
            map.put("OBJALT", jrnData[23]);
            map.put("OBJREF", jrnData[24]);
            map.put("OBJATTR", jrnData[25]);
            map.put("ACCESSCODE", jrnData[26]);
            map.put("AUTLNAME", jrnData[27]);
            map.put("CMDNAME", jrnData[28]);
        } else if (jrnData[4].equals("CP")) {
            map.put("TYPEENTRY", jrnData[7]);
            map.put("TARGETUSER", jrnData[8]);
            map.put("LIBRARY", jrnData[9]);
            map.put("OBJECTTYPE", jrnData[10]);
            map.put("CMDNAME", jrnData[11]);
            map.put("PWDCHG", jrnData[12]);
            map.put("PWDNONE", jrnData[13]);
            map.put("PWDEXP", jrnData[14]);
            map.put("ALLOBJ", jrnData[15]);
            map.put("JOBCTL", jrnData[16]);
            map.put("SAVSYS", jrnData[17]);
            map.put("SECADM", jrnData[18]);
            map.put("SPLCTL", jrnData[19]);
            map.put("SERVICE", jrnData[20]);
            map.put("AUDIT", jrnData[21]);
            map.put("IOSYSCFG", jrnData[22]);
            map.put("STAT", jrnData[23]);
        } else if (jrnData[4].equals("JS")) {
            map.put("TYPEENTRY", jrnData[7]);
            map.put("TYPEJOB", jrnData[8]);
            map.put("SUBTYPEJOB", jrnData[9]);
            map.put("JOBDESC", jrnData[15]);
        }
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat dd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        cal.setTime(dd.parse(jrnData[6]));
        map.put("TIME", cal.getTimeInMillis());
        map.put("HOUROFDAY", "" + cal.get(11));
        map.put("HOUR", this.hourDf.format(cal.getTime()));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpLogsToDB() throws Exception {
        Connection con = null;
        Statement st = null;
        FileOutputStream logFile = null;
        FileOutputStream jrnFile = null;
        try {
            LOGGER.log(Level.FINER, "Dumping AS400 logs to database");
            LOGGER.log(Level.FINER, "Database Type is Postgres <-> {0}", isPostgres);
            String DBServer = "";
            String DBName = "";
            String DBUser = "";
            String DBPass = "";
            if (mysqlDB || isPostgres) {
                con = RelationalAPI.getInstance().getConnection();
                st = con.createStatement();
            } else {
                String xmlFilePath = System.getProperty("server.dir") + File.separator + "conf" + File.separator + "database_params.conf";
                HashMap DBParams = ResourceCheckerUtil.getConstraints((String)xmlFilePath, (String)"eventlog");
                if (DBParams != null) {
                    DBServer = (String)DBParams.get("DBServer");
                    DBName = (String)DBParams.get("DBName");
                    DBUser = (String)DBParams.get("DBUser");
                    DBPass = (String)DBParams.get("DBPass");
                    DBPass = EnDecryptImplSingleton.getInstance().decrypt(DBPass);
                    if (DBPass == null) {
                        DBPass = "";
                    }
                }
            }
            String[] dataFiles = new String[]{this.hostId + "dsplog_sys.txt", this.hostId + "dsplog_compsys.txt"};
            String[] tables = new String[]{"AS400_SysLog_Hr_Trend_" + this.hostId, "AS400_Comp_SysLog_Hr_Trend_" + this.hostId};
            String[] columns = new String[]{"(hourofday,hour,hostid,source,type,error_cnt,warning_cnt,information_cnt,emergency_cnt,alert_cnt,critical_cnt,notice_cnt,debug_cnt)", "(hourofday,hour,hostid,user_name,client,type_severity,type_facility,type_source,field1,field2,evt_cnt)"};
            for (int i = 0; i < dataFiles.length; ++i) {
                String filePath = this.dataDir + dataFiles[i];
                filePath = filePath.replace('\\', '/');
                String tableName = tables[i];
                String col = columns[i];
                if (isPostgres) {
                    st.execute("copy " + tableName + col + " from  '" + filePath + "' with DELIMITER '~'");
                    continue;
                }
                if (mysqlDB) {
                    st.execute("load data local infile '" + filePath + "' into table " + tableName + " fields terminated by '|**|' lines terminated by '|**|**|' starting by '|**|'");
                    continue;
                }
                if (this.isWinAuthType) {
                    this.bcpCommand("cmd /c " + this.binDir + "bcp.exe " + DBName + ".dbo." + tableName + " in \"" + filePath + "\" -S " + DBServer + " -T -t \"|**|\" -r \"|**|**|\\n\" -c");
                    continue;
                }
                this.bcpCommand("cmd /c " + this.binDir + "bcp.exe " + DBName + ".dbo." + tableName + " in \"" + filePath + "\" -S " + DBServer + " -U " + DBUser + " -P \"" + DBPass + "\" -t \"|**|\" -r \"|**|**|\\n\" -c");
            }
            logFile = new FileOutputStream(new File(this.dataDir + this.hostId + "dsplog.txt"));
            logFile.write("".getBytes());
            logFile.close();
            jrnFile = new FileOutputStream(new File(this.dataDir + this.hostId + "dspjrn.txt"));
            jrnFile.write("".getBytes());
            jrnFile.close();
            LOGGER.log(Level.FINER, "Dumped AS400 logs to Database");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception dumping AS400 logs", e);
            e.printStackTrace();
        }
        finally {
            if (logFile != null) {
                logFile.close();
            }
            if (jrnFile != null) {
                jrnFile.close();
            }
            if (st != null) {
                st.close();
            }
            if (con != null) {
                con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bcpCommand(String command) throws Exception {
        LOGGER.log(Level.FINER, "BCP Command to Execute <-> {0}", QueryUtil.formatMSSQLQuery((String)command));
        BufferedReader in = null;
        FileOutputStream fos = new FileOutputStream(System.getProperty("server.dir") + this.separator + "logs" + this.separator + "dsplog.log");
        Process p = Runtime.getRuntime().exec(command);
        try {
            int c;
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((c = in.read()) != -1) {
                fos.write(c);
            }
        }
        catch (IOException ioex) {
            LOGGER.log(Level.INFO, "Problem in loading the as400 logs");
            ioex.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUTF16File(File location) {
        FileInputStream fis = null;
        boolean isUTF16 = false;
        try {
            fis = new FileInputStream(location);
            byte[] buffer = new byte[128];
            fis.read(buffer);
            isUTF16 = buffer[0] == -1 && buffer[1] == -2 || buffer[0] == -2 && buffer[1] == -1;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        return isUTF16;
    }

    private Hashtable getParams(String log) throws ParseException {
        this.logMatcher.reset(log);
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (this.logMatcher.find()) {
            map.put("MSGID", this.logMatcher.group(1));
            this.getSeverity(this.logMatcher.group(3), map);
            map.put("FACILITY", this.logMatcher.group(2));
            String msg = this.logMatcher.group(4).trim().toLowerCase();
            map.put("TYPESOURCE", this.getSource(this.logMatcher.group(1)));
            map.put("MESSAGE", msg);
            map.put("JOBNAME", this.logMatcher.group(5));
            map.put("USERNAME", this.logMatcher.group(9) == null ? this.logMatcher.group(6).trim() : this.logMatcher.group(9).trim());
            map.put("JOBNUMBER", this.logMatcher.group(7));
            map.put("SOURCE", this.logMatcher.group(6).trim());
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(this.logDF.parse(this.logMatcher.group(8)));
            map.put("TIME", cal.getTimeInMillis());
            map.put("HOUROFDAY", "" + cal.get(11));
            map.put("HOUR", this.hourDf.format(cal.getTime()));
        }
        LOGGER.finest("MAP:: " + map.toString());
        return map;
    }

    private Hashtable getBRMSParams(String log) throws ParseException {
        this.logBRMSMatcher.reset(log);
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (this.logBRMSMatcher.find()) {
            map.put("MSGID", this.logBRMSMatcher.group(3));
            map.put("FACILITY", this.logBRMSMatcher.group(8));
            this.getSeverity(this.logBRMSMatcher.group(4), map);
            map.put("TYPESOURCE", this.getSource(this.logBRMSMatcher.group(3)));
            String msg = this.logBRMSMatcher.group(5).trim().toLowerCase();
            map.put("MESSAGE", msg);
            map.put("JOBNAME", this.logBRMSMatcher.group(6));
            map.put("USERNAME", this.logBRMSMatcher.group(7).trim());
            map.put("JOBNUMBER", this.logBRMSMatcher.group(8));
            map.put("SOURCE", "BRMS");
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(this.logDF.parse(this.logBRMSMatcher.group(1) + " " + this.logBRMSMatcher.group(2)));
            map.put("TIME", cal.getTimeInMillis());
            map.put("HOUROFDAY", "" + cal.get(11));
            map.put("HOUR", this.hourDf.format(cal.getTime()));
        }
        LOGGER.finest("MAP:: " + map.toString());
        return map;
    }

    private String getSource(String msgId) {
        String source = " ";
        if (msgId.matches("(CPF1124)")) {
            source = "Successful Logons";
        } else if (msgId.matches("(CPC1125)|(CPC1126)|(CPF1164)")) {
            source = "Successful Logoffs";
        } else if (msgId.matches("(CPF2234)")) {
            source = "Unsuccessful Logons";
        } else if (msgId.matches("(CPC116[23])|(CPC1236)|(CPC1611)|(CPI1127)|(CPI2417)|(CPI3E34)|(CPIAD0[9B])|(CPF1240)|(CPF2528)|(CPFAF98)")) {
            source = "Job Logs";
        } else if (msgId.matches("(CPC260[25679])|(CPC261[03])|(CPC262[12])|(CPC2630)|(CPF5140)|(CPF5418)|(CPF590A)|(CPD2609)|(CPD2639)|(CPD26D6)|(CPD2896)")) {
            source = "Device Configuration";
        } else if (msgId.matches("(CPD1689)")) {
            source = "System Time Changed";
        } else if (msgId.matches("(CPC7011)|(CPF7020)|(CPC2191)|(CPF7010)|(CPI70E3)")) {
            source = "Journal Logs";
        } else if (msgId.matches("(CPPEA02)|(CPP8988)")) {
            source = "Hardware Errors";
        } else if (msgId.equals("AF")) {
            source = "Authorization Failure";
        } else if (msgId.equals("CA")) {
            source = "Change Authority";
        } else if (msgId.equals("CP")) {
            source = "Change User Profile";
        } else if (msgId.equals("DO")) {
            source = "Delete Object";
        } else if (msgId.equals("JS")) {
            source = "Job Change";
        } else if (msgId.equals("OW")) {
            source = "Ownership Change";
        } else if (msgId.equals("PW")) {
            source = "Invalid Password";
        } else if (msgId.equals("SV")) {
            source = "System Value Changes";
        } else if (msgId.equals("SI")) {
            source = "User Logons as400";
        } else if (msgId.equals("EI")) {
            source = "User Logoffs as400";
        }
        return source;
    }

    private void createDumpFiles() throws IOException {
        this.sysFWriter = new FileWriter(this.dataDir + this.hostId + "dsplog_sys.txt");
        this.sysWriter = new PrintWriter((Writer)new BufferedWriter(this.sysFWriter), false);
        this.compSysFWriter = new FileWriter(this.dataDir + this.hostId + "dsplog_compsys.txt");
        this.compSysWriter = new PrintWriter((Writer)new BufferedWriter(this.compSysFWriter), false);
        this.unparsedLogFWriter = new FileWriter(this.dataDir + this.hostId + "unparseddsplog.txt", true);
        this.unparsedLogPWriter = new PrintWriter((Writer)new BufferedWriter(this.unparsedLogFWriter), false);
    }

    private void addLogToFile(Hashtable paramMap) {
        if (paramMap.isEmpty()) {
            return;
        }
        ++this.recordCount;
        StringBuffer logData = new StringBuffer();
        if (mysqlDB) {
            logData.append(DELIMITER + "NULL");
        }
        if (isPostgres) {
            logData.append(paramMap.get("HOUROFDAY"));
        } else {
            logData.append(DELIMITER + paramMap.get("HOUROFDAY"));
        }
        logData.append(DELIMITER + paramMap.get("HOUR"));
        logData.append(DELIMITER + this.hostId);
        logData.append(DELIMITER + paramMap.get("SOURCE"));
        logData.append(DELIMITER + paramMap.get("FACILITY"));
        logData.append(paramMap.get("SEVERITY_CNT"));
        if (!isPostgres) {
            logData.append(RECORDDELIMITER);
        }
        this.sysWriter.println(logData.toString());
        logData = new StringBuffer();
        if (mysqlDB) {
            logData = new StringBuffer(DELIMITER + "NULL");
        }
        if (isPostgres) {
            logData.append(paramMap.get("HOUROFDAY"));
        } else {
            logData.append(DELIMITER + paramMap.get("HOUROFDAY"));
        }
        logData.append(DELIMITER + paramMap.get("HOUR"));
        logData.append(DELIMITER + this.hostId);
        logData.append(DELIMITER + paramMap.get("USERNAME"));
        logData.append(DELIMITER + " ");
        logData.append(DELIMITER + " ");
        logData.append(DELIMITER + paramMap.get("MSGID"));
        logData.append(DELIMITER + paramMap.get("TYPESOURCE"));
        logData.append(DELIMITER + paramMap.get("JOBNUMBER"));
        logData.append(DELIMITER + paramMap.get("JOBNAME"));
        logData.append(DELIMITER + "1");
        if (!isPostgres) {
            logData.append(RECORDDELIMITER);
        }
        this.compSysWriter.println(logData.toString());
        LOGGER.finest("COMP_SYSDATA:::" + logData.toString());
        Log log = new Log();
        paramMap.put("HOSTID", this.hostId);
        paramMap.put("HOSTNAME", this.dnsName);
        paramMap.put("HOSTTYPE", this.hostType);
        paramMap.put("DATE", new Integer((String)paramMap.get("HOUROFDAY")));
        log.parseLog(this.hostType, paramMap);
        SystemCustomPatternHandler.getInstance().parse((Hashtable)log);
        if (paramMap.containsKey("$id$")) {
            log.put("$id$", paramMap.get("$id$"));
        }
        LogDataIndexer.getInstance().indexLogData(log);
    }

    private void getSeverity(String as400Sev, Hashtable paramMap) {
        LOGGER.finest("SEV::" + as400Sev);
        if ("ESCAPE".equals(as400Sev)) {
            paramMap.put("SEVERITY_CNT", this.getSeverityCountString(5));
            paramMap.put("SEVERITY", "2");
        } else if ("DIAGNOSTIC".equals(as400Sev)) {
            paramMap.put("SEVERITY_CNT", this.getSeverityCountString(0));
            paramMap.put("SEVERITY", "3");
        } else if ("INQUIRY".equals(as400Sev) || "NOTIFY".equals(as400Sev) || "REPLY".equals(as400Sev)) {
            paramMap.put("SEVERITY_CNT", this.getSeverityCountString(6));
            paramMap.put("SEVERITY", "5");
        } else if ("REQUEST".equals(as400Sev)) {
            paramMap.put("SEVERITY_CNT", this.getSeverityCountString(7));
            paramMap.put("SEVERITY", "7");
        } else {
            paramMap.put("SEVERITY_CNT", this.getSeverityCountString(2));
            paramMap.put("SEVERITY", "6");
        }
    }

    private String getSeverityCountString(int sev) {
        String sevString = "";
        int i = 0;
        for (i = 0; i < sev; ++i) {
            sevString = sevString + DELIMITER + "0";
        }
        sevString = sevString + DELIMITER + "1";
        ++i;
        while (i < 8) {
            sevString = sevString + DELIMITER + "0";
            ++i;
        }
        return sevString;
    }

    private void closeDumpFiles() throws IOException {
        this.sysWriter.flush();
        this.sysWriter.close();
        this.sysFWriter.close();
        this.compSysWriter.flush();
        this.compSysWriter.close();
        this.compSysFWriter.close();
        this.unparsedLogPWriter.flush();
        this.unparsedLogPWriter.close();
        this.unparsedLogFWriter.close();
    }

    private void deleteTempFiles() throws IOException {
        File file = new File(this.dataDir + this.hostId + "dsplog_sys.txt");
        file.delete();
        file = new File(this.dataDir + this.hostId + "dsplog_compsys.txt");
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempTable() {
        Connection conn = null;
        Statement stat = null;
        try {
            conn = RelationalAPI.getInstance().getConnection();
            stat = conn.createStatement();
            LOGGER.fine("Creating table : AS400_SysLog_Hr_Trend_" + this.hostId);
            if (isPostgres) {
                stat.execute("create table if not exists AS400_SysLog_Hr_Trend_" + this.hostId + " (like SysLog_Hr_Trend including all) ");
                stat.execute("create table if not exists AS400_Comp_SysLog_Hr_Trend_" + this.hostId + " (like Comp_SysLog_Hr_Trend including all) ");
            } else if (mysqlDB) {
                stat.execute("create table if not exists AS400_SysLog_Hr_Trend_" + this.hostId + " like SysLog_Hr_Trend");
                stat.execute("create table if not exists AS400_Comp_SysLog_Hr_Trend_" + this.hostId + " like Comp_SysLog_Hr_Trend");
            } else {
                stat.execute("IF NOT EXISTS (select * from sysobjects where name='AS400_SysLog_Hr_Trend_" + this.hostId + "' and xtype='U') select * into AS400_SysLog_Hr_Trend_" + this.hostId + " from SysLog_Hr_Trend where 1=0");
                stat.execute("IF NOT EXISTS (select * from sysobjects where name='AS400_Comp_SysLog_Hr_Trend_" + this.hostId + "' and xtype='U') select * into AS400_Comp_SysLog_Hr_Trend_" + this.hostId + " from Comp_SysLog_Hr_Trend where 1=0");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception dumping AS400 logs", e);
            e.printStackTrace();
        }
        finally {
            try {
                stat.close();
                conn.close();
            }
            catch (Exception exp) {
                stat = null;
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpToTrendTable() {
        Connection conn = null;
        Statement stat = null;
        try {
            String nullString;
            conn = RelationalAPI.getInstance().getConnection();
            stat = conn.createStatement();
            String string = nullString = mysqlDB ? "NULL," : "";
            if (isPostgres) {
                stat.execute("insert into SysLog_Hr_Trend(hourofday,hour,hostid,source,type,error_cnt,warning_cnt,information_cnt,emergency_cnt,alert_cnt,critical_cnt,notice_cnt,debug_cnt) select  HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, SUM(ERROR_CNT), SUM(WARNING_CNT), SUM(INFORMATION_CNT), SUM(EMERGENCY_CNT), SUM(ALERT_CNT), SUM(CRITICAL_CNT), SUM(NOTICE_CNT), SUM(DEBUG_CNT) from AS400_SysLog_Hr_Trend_" + this.hostId + " group by HOSTID, HOUR, SOURCE, HOUROFDAY, TYPE");
                stat.execute("insert into Log_Hr_Trend(hourofday,hour,hostid,source,type,err_cnt,war_cnt,inf_cnt,suc_cnt,fail_cnt) select  HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, SUM(ERROR_CNT + CRITICAL_CNT + EMERGENCY_CNT + ALERT_CNT) as ERR_CNT, SUM(WARNING_CNT+NOTICE_CNT) as WAR_CNT, SUM(INFORMATION_CNT+DEBUG_CNT) as INF_CNT, '0' as SUC_CNT ,'0' as FAIL_CNT from AS400_SysLog_Hr_Trend_" + this.hostId + " group by HOSTID, HOUR, SOURCE, HOUROFDAY, TYPE");
                stat.execute("insert into Comp_SysLog_Hr_Trend(hourofday,hour,hostid,user_name,client,type_severity,type_facility,type_source,field1,field2,evt_cnt) select  HOUROFDAY, HOUR, HOSTID, USER_NAME, '', '', '', TYPE_SOURCE, FIELD1, FIELD2, SUM(EVT_CNT) from AS400_Comp_SysLog_Hr_Trend_" + this.hostId + " group by HOSTID, HOUR, HOUROFDAY, USER_NAME, CLIENT, TYPE_SOURCE, TYPE_FACILITY, TYPE_SEVERITY, FIELD2, FIELD1");
            } else {
                stat.execute("insert into SysLog_Hr_Trend select " + nullString + " HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, SUM(ERROR_CNT), SUM(WARNING_CNT), SUM(INFORMATION_CNT), SUM(EMERGENCY_CNT), SUM(ALERT_CNT), SUM(CRITICAL_CNT), SUM(NOTICE_CNT), SUM(DEBUG_CNT) from AS400_SysLog_Hr_Trend_" + this.hostId + " group by HOSTID, HOUR, SOURCE, HOUROFDAY, TYPE");
                stat.execute("insert into Log_Hr_Trend select " + nullString + " HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, SUM(ERROR_CNT + CRITICAL_CNT + EMERGENCY_CNT + ALERT_CNT) as ERR_CNT, SUM(WARNING_CNT+NOTICE_CNT) as WAR_CNT, SUM(INFORMATION_CNT+DEBUG_CNT) as INF_CNT, '0' as SUC_CNT ,'0' as FAIL_CNT from AS400_SysLog_Hr_Trend_" + this.hostId + " group by HOSTID, HOUR, SOURCE, HOUROFDAY, TYPE");
                stat.execute("insert into Comp_SysLog_Hr_Trend select " + nullString + " HOUROFDAY, HOUR, HOSTID, USER_NAME, '', '', '', TYPE_SOURCE, FIELD1, FIELD2, SUM(EVT_CNT) from AS400_Comp_SysLog_Hr_Trend_" + this.hostId + " group by HOSTID, HOUR, HOUROFDAY, USER_NAME, CLIENT, TYPE_SOURCE, TYPE_FACILITY, TYPE_SEVERITY, FIELD2, FIELD1");
            }
            stat.execute("delete from AS400_SysLog_Hr_Trend_" + this.hostId);
            stat.execute("delete from AS400_Comp_SysLog_Hr_Trend_" + this.hostId);
            LOGGER.fine("DUMPED TO TABLE:::");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception dumping AS400 logs", e);
            e.printStackTrace();
        }
        finally {
            try {
                stat.close();
                conn.close();
            }
            catch (Exception exp) {
                stat = null;
                conn = null;
            }
        }
    }

    private void openArchiveFile() {
        if (this.as400LogArchiver != null) {
            this.as400LogArchiver.openFile();
        }
    }

    private void writeToArchiveFile(ArrayList archiveLogs) {
        if (this.as400LogArchiver != null) {
            this.as400LogArchiver.writeLog(archiveLogs);
        }
    }

    private void closeArchiveFile() {
        if (this.as400LogArchiver != null) {
            this.as400LogArchiver.closeFile();
        }
    }

    private void unparsedLog(String log) {
        this.unparsedLogPWriter.println(log);
    }

    public static void clearCache(String hostname) {
        jobNameMap.remove(hostname);
    }

    public void ProcessJournalLogs() {
        this.JournalAF();
        this.JournalCA();
        this.JournalCP();
        this.JournalDO();
        this.JournalJS();
        this.JournalOW();
        this.JournalPW();
        this.JournalSV();
        this.WriteFile();
        this.ClearBuff();
        this.deletejrnTempFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void JournalAF() {
        try {
            int l = 0;
            String[] logs = new String[50000];
            String path = this.dataDir + this.hostId + "dspjrnAF.txt";
            this.fstream = new FileInputStream(path);
            this.br = new BufferedReader(new InputStreamReader(this.fstream));
            String data = null;
            while ((data = this.br.readLine()) != null) {
                logs[l] = data.trim();
                ++l;
            }
            for (int i = 0; i < l; ++i) {
                String[] jlogs = logs[i].split("~~");
                this.logjrndata.append(jlogs[3] + this.delim);
                this.logjrndata.append(jlogs[2] + this.delim);
                this.logjrndata.append(jlogs[18] + this.delim);
                this.logjrndata.append(jlogs[6] + this.delim);
                this.logjrndata.append(jlogs[0] + this.delim);
                String msg = jlogs[9] + this.split + jlogs[10] + this.split + jlogs[11] + this.split + jlogs[12] + this.delim;
                this.logjrndata.append(msg);
                this.logjrndata.append(jlogs[1] + this.delim);
                this.logjrndata.append(jlogs[9] + this.delim);
                this.logjrndata.append(jlogs[10] + this.delim);
                this.logjrndata.append(jlogs[11] + this.delim);
                this.logjrndata.append(jlogs[12] + this.delim);
                this.logjrndata.append("\n");
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, "Journal AF File not found::::::: {0}");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while appending journal logs AF AS400 :::::: {0}", e);
            e.printStackTrace();
        }
        finally {
            try {
                if (this.fstream != null) {
                    this.fstream.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Exception while Closing AF file  :::::: {0}", e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void JournalCA() {
        try {
            int l = 0;
            String[] logs = new String[50000];
            String path = this.dataDir + this.hostId + "dspjrnCA.txt";
            this.fstream = new FileInputStream(path);
            this.br = new BufferedReader(new InputStreamReader(this.fstream));
            String data = null;
            while ((data = this.br.readLine()) != null) {
                logs[l] = data.trim();
                ++l;
            }
            for (int i = 0; i < l; ++i) {
                String[] jlogs = logs[i].split("~~");
                this.logjrndata.append(jlogs[3] + this.delim);
                this.logjrndata.append(jlogs[2] + this.delim);
                this.logjrndata.append(jlogs[4] + this.delim);
                this.logjrndata.append(jlogs[6] + this.delim);
                this.logjrndata.append(jlogs[0] + this.delim);
                String msg = jlogs[9] + this.split + jlogs[10] + this.split + jlogs[11] + this.split + jlogs[12] + this.split + jlogs[13] + this.split + jlogs[14] + this.split + jlogs[15] + this.split + jlogs[16] + this.split + jlogs[17] + this.split + jlogs[18] + this.split + jlogs[19] + this.split + jlogs[20] + this.split + jlogs[21] + this.split + jlogs[22] + this.split + jlogs[23] + this.split + jlogs[24] + this.split + jlogs[25] + this.split + jlogs[26] + this.split + jlogs[27] + this.split + jlogs[28] + this.split + jlogs[29] + this.split + jlogs[31] + this.delim;
                this.logjrndata.append(msg);
                this.logjrndata.append(jlogs[1] + this.delim);
                this.logjrndata.append(jlogs[9] + this.delim);
                this.logjrndata.append(jlogs[10] + this.delim);
                this.logjrndata.append(jlogs[11] + this.delim);
                this.logjrndata.append(jlogs[12] + this.delim);
                this.logjrndata.append(jlogs[13] + this.delim);
                for (int j = 15; j <= 27; ++j) {
                    jlogs[j] = jlogs[j].equals(" ") ? "-" : jlogs[j];
                }
                this.logjrndata.append(jlogs[15] + this.delim);
                this.logjrndata.append(jlogs[16] + this.delim);
                this.logjrndata.append(jlogs[17] + this.delim);
                this.logjrndata.append(jlogs[18] + this.delim);
                this.logjrndata.append(jlogs[19] + this.delim);
                this.logjrndata.append(jlogs[20] + this.delim);
                this.logjrndata.append(jlogs[21] + this.delim);
                this.logjrndata.append(jlogs[22] + this.delim);
                this.logjrndata.append(jlogs[23] + this.delim);
                this.logjrndata.append(jlogs[24] + this.delim);
                this.logjrndata.append(jlogs[25] + this.delim);
                this.logjrndata.append(jlogs[26] + this.delim);
                this.logjrndata.append(jlogs[27] + this.delim);
                this.logjrndata.append(jlogs[28] + this.delim);
                this.logjrndata.append(jlogs[29] + this.delim);
                this.logjrndata.append(jlogs[14] + this.delim);
                this.logjrndata.append(jlogs[31] + this.delim);
                this.logjrndata.append("\n");
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, "Journal CA File not found::::::: {0}");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while appending journal logs CA AS400 :::::: {0}", e);
            e.printStackTrace();
        }
        finally {
            try {
                if (this.fstream != null) {
                    this.fstream.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Exception while Closing CA file  :::::: {0}", e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void JournalCP() {
        try {
            int l = 0;
            String[] logs = new String[50000];
            String path = this.dataDir + this.hostId + "dspjrnCP.txt";
            this.fstream = new FileInputStream(path);
            this.br = new BufferedReader(new InputStreamReader(this.fstream));
            String data = null;
            while ((data = this.br.readLine()) != null) {
                logs[l] = data.trim();
                ++l;
            }
            for (int i = 0; i < l; ++i) {
                String[] jlogs = logs[i].split("~~");
                this.logjrndata.append(jlogs[3] + this.delim);
                this.logjrndata.append(jlogs[2] + this.delim);
                this.logjrndata.append(jlogs[4] + this.delim);
                this.logjrndata.append(jlogs[6] + this.delim);
                this.logjrndata.append(jlogs[0] + this.delim);
                String msg = jlogs[9] + this.split + jlogs[10] + this.split + jlogs[11] + this.split + jlogs[12] + this.split + jlogs[13] + this.split + jlogs[14] + this.split + jlogs[15] + this.split + jlogs[16] + this.split + jlogs[17] + this.split + jlogs[18] + this.split + jlogs[19] + this.split + jlogs[20] + this.split + jlogs[21] + this.split + jlogs[22] + this.split + jlogs[23] + this.split + jlogs[24] + this.split + jlogs[28] + this.delim;
                this.logjrndata.append(msg);
                this.logjrndata.append(jlogs[1] + this.delim);
                this.logjrndata.append(jlogs[9] + this.delim);
                this.logjrndata.append(jlogs[10] + this.delim);
                this.logjrndata.append(jlogs[11] + this.delim);
                this.logjrndata.append(jlogs[12] + this.delim);
                this.logjrndata.append(jlogs[13] + this.delim);
                for (int j = 14; j <= 24; ++j) {
                    jlogs[j] = jlogs[j].equals(" ") ? "-" : jlogs[j];
                }
                this.logjrndata.append(jlogs[14] + this.delim);
                this.logjrndata.append(jlogs[15] + this.delim);
                this.logjrndata.append(jlogs[16] + this.delim);
                this.logjrndata.append(jlogs[17] + this.delim);
                this.logjrndata.append(jlogs[18] + this.delim);
                this.logjrndata.append(jlogs[19] + this.delim);
                this.logjrndata.append(jlogs[20] + this.delim);
                this.logjrndata.append(jlogs[21] + this.delim);
                this.logjrndata.append(jlogs[22] + this.delim);
                this.logjrndata.append(jlogs[23] + this.delim);
                this.logjrndata.append(jlogs[24] + this.delim);
                this.logjrndata.append(jlogs[28] + this.delim);
                this.logjrndata.append("\n");
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, "Journal CP File not found::::::: {0}");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while appending journal logs CP AS400 :::::: {0}", e);
            e.printStackTrace();
        }
        finally {
            try {
                if (this.fstream != null) {
                    this.fstream.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Exception while Closing CP file  :::::: {0}", e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void JournalDO() {
        try {
            int l = 0;
            String[] logs = new String[50000];
            String path = this.dataDir + this.hostId + "dspjrnDO.txt";
            this.fstream = new FileInputStream(path);
            this.br = new BufferedReader(new InputStreamReader(this.fstream));
            String data = null;
            while ((data = this.br.readLine()) != null) {
                logs[l] = data.trim();
                ++l;
            }
            for (int i = 0; i < l; ++i) {
                String[] jlogs = logs[i].split("~~");
                this.logjrndata.append(jlogs[3] + this.delim);
                this.logjrndata.append(jlogs[2] + this.delim);
                this.logjrndata.append(jlogs[7] + this.delim);
                this.logjrndata.append(jlogs[6] + this.delim);
                this.logjrndata.append(jlogs[0] + this.delim);
                String msg = jlogs[9] + this.split + jlogs[10] + this.split + jlogs[11] + this.split + jlogs[12] + this.delim;
                this.logjrndata.append(msg);
                this.logjrndata.append(jlogs[1] + this.delim);
                this.logjrndata.append(jlogs[9] + this.delim);
                this.logjrndata.append(jlogs[10] + this.delim);
                this.logjrndata.append(jlogs[11] + this.delim);
                this.logjrndata.append(jlogs[12] + this.delim);
                this.logjrndata.append("\n");
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, "Journal DO File not found::::::: {0}");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while appending journal logs DO AS400 :::::: {0}", e);
            e.printStackTrace();
        }
        finally {
            try {
                if (this.fstream != null) {
                    this.fstream.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Exception while Closing DO file  :::::: {0}", e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void JournalJS() {
        try {
            int l = 0;
            String[] logs = new String[50000];
            String path = this.dataDir + this.hostId + "dspjrnJS.txt";
            this.fstream = new FileInputStream(path);
            this.br = new BufferedReader(new InputStreamReader(this.fstream));
            String data = null;
            while ((data = this.br.readLine()) != null) {
                logs[l] = data.trim();
                ++l;
            }
            for (int i = 0; i < l; ++i) {
                String[] jlogs = logs[i].split("~~");
                if (!"S".equals(jlogs[9]) && !"E".equals(jlogs[9])) continue;
                this.logjrndata.append(jlogs[3] + this.delim);
                this.logjrndata.append(jlogs[2] + this.delim);
                this.logjrndata.append(jlogs[7] + this.delim);
                this.logjrndata.append(jlogs[6] + this.delim);
                if ("S".equals(jlogs[9]) && "I".equals(jlogs[10])) {
                    this.logjrndata.append("SI" + this.delim);
                } else if ("E".equals(jlogs[9]) && "I".equals(jlogs[10])) {
                    this.logjrndata.append("EI" + this.delim);
                } else {
                    this.logjrndata.append(jlogs[0] + this.delim);
                }
                jlogs[11] = jlogs[11].replaceAll("[^a-zA-Z0-9]", "");
                String msg = jlogs[9] + this.split + jlogs[10] + this.split + jlogs[11] + this.split + jlogs[12] + this.split + jlogs[13] + this.split + jlogs[14] + this.split + jlogs[15] + this.split + jlogs[16] + this.split + jlogs[17] + this.delim;
                this.logjrndata.append(msg);
                this.logjrndata.append(jlogs[1] + this.delim);
                this.logjrndata.append(jlogs[9] + this.delim);
                this.logjrndata.append(jlogs[10] + this.delim);
                this.logjrndata.append(jlogs[11] + this.delim);
                this.logjrndata.append(jlogs[12] + this.delim);
                this.logjrndata.append(jlogs[13] + this.delim);
                this.logjrndata.append(jlogs[14] + this.delim);
                this.logjrndata.append(jlogs[15] + this.delim);
                this.logjrndata.append(jlogs[16] + this.delim);
                this.logjrndata.append(jlogs[17] + this.delim);
                this.logjrndata.append("\n");
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, "Journal JS File not found::::::: {0}");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while appending journal logs JS AS400 :::::: {0}", e);
            e.printStackTrace();
        }
        finally {
            try {
                if (this.fstream != null) {
                    this.fstream.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Exception while Closing JS file  :::::: {0}");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void JournalOW() {
        try {
            int l = 0;
            String[] logs = new String[50000];
            String path = this.dataDir + this.hostId + "dspjrnOW.txt";
            this.fstream = new FileInputStream(path);
            this.br = new BufferedReader(new InputStreamReader(this.fstream));
            String data = null;
            while ((data = this.br.readLine()) != null) {
                logs[l] = data.trim();
                ++l;
            }
            for (int i = 0; i < l; ++i) {
                String[] jlogs = logs[i].split("~~");
                this.logjrndata.append(jlogs[3] + this.delim);
                this.logjrndata.append(jlogs[2] + this.delim);
                this.logjrndata.append(jlogs[4] + this.delim);
                this.logjrndata.append(jlogs[6] + this.delim);
                this.logjrndata.append(jlogs[0] + this.delim);
                String msg = jlogs[9] + this.split + jlogs[10] + this.split + jlogs[11] + this.split + jlogs[12] + this.split + jlogs[13] + this.split + jlogs[14] + this.delim;
                this.logjrndata.append(msg);
                this.logjrndata.append(jlogs[1] + this.delim);
                this.logjrndata.append(jlogs[9] + this.delim);
                this.logjrndata.append(jlogs[10] + this.delim);
                this.logjrndata.append(jlogs[11] + this.delim);
                this.logjrndata.append(jlogs[12] + this.delim);
                this.logjrndata.append(jlogs[13] + this.delim);
                this.logjrndata.append(jlogs[14] + this.delim);
                this.logjrndata.append("\n");
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, "Journal OW File not found::::::: {0}");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while appending journal logs OW AS400 :::::: {0}", e);
            e.printStackTrace();
        }
        finally {
            try {
                if (this.fstream != null) {
                    this.fstream.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Exception while Closin OW file  :::::: {0}", e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void JournalPW() {
        try {
            int l = 0;
            String[] logs = new String[50000];
            String path = this.dataDir + this.hostId + "dspjrnPW.txt";
            this.fstream = new FileInputStream(path);
            this.br = new BufferedReader(new InputStreamReader(this.fstream));
            String data = null;
            while ((data = this.br.readLine()) != null) {
                logs[l] = data.trim();
                ++l;
            }
            for (int i = 0; i < l; ++i) {
                String[] jlogs = logs[i].split("~~");
                this.logjrndata.append(jlogs[3] + this.delim);
                this.logjrndata.append(jlogs[2] + this.delim);
                this.logjrndata.append(jlogs[10] + this.delim);
                this.logjrndata.append(jlogs[6] + this.delim);
                this.logjrndata.append(jlogs[0] + this.delim);
                String msg = jlogs[9] + this.split + jlogs[11] + this.delim;
                this.logjrndata.append(msg);
                this.logjrndata.append(jlogs[1] + this.delim);
                this.logjrndata.append(jlogs[9] + this.delim);
                this.logjrndata.append(jlogs[11] + this.delim);
                this.logjrndata.append("\n");
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, "Journal PW File not found::::::: {0}");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while appending journal logs PW AS400 :::::: {0}", e);
            e.printStackTrace();
        }
        finally {
            try {
                if (this.fstream != null) {
                    this.fstream.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Exception while Closing PW file  :::::: {0}", e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void JournalSV() {
        try {
            int l = 0;
            String[] logs = new String[50000];
            String path = this.dataDir + this.hostId + "dspjrnSV.txt";
            this.fstream = new FileInputStream(path);
            this.br = new BufferedReader(new InputStreamReader(this.fstream));
            String data = null;
            while ((data = this.br.readLine()) != null) {
                logs[l] = data.trim();
                ++l;
            }
            for (int i = 0; i < l; ++i) {
                String[] jlogs = logs[i].split("~~");
                this.logjrndata.append(jlogs[3] + this.delim);
                this.logjrndata.append(jlogs[2] + this.delim);
                this.logjrndata.append(jlogs[4] + this.delim);
                this.logjrndata.append(jlogs[6] + this.delim);
                this.logjrndata.append(jlogs[0] + this.delim);
                String msg = jlogs[9] + this.split + jlogs[10] + this.split + jlogs[11] + this.split + jlogs[12] + this.delim;
                this.logjrndata.append(msg);
                this.logjrndata.append(jlogs[1] + this.delim);
                this.logjrndata.append(jlogs[9] + this.delim);
                this.logjrndata.append(jlogs[10] + this.delim);
                this.logjrndata.append(jlogs[11] + this.delim);
                this.logjrndata.append(jlogs[12] + this.delim);
                this.logjrndata.append("\n");
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, "Journal SV File not found::::::: {0}");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while appending journal logs SV AS400 :::::: {0}", e);
            e.printStackTrace();
        }
        finally {
            try {
                if (this.fstream != null) {
                    this.fstream.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Exception while Closing SV file  :::::: {0}", e);
                e.printStackTrace();
            }
        }
    }

    private void WriteFile() {
        try {
            LOGGER.log(Level.INFO, " writing dspjrn.txt :::::::");
            this.jrn = new FileOutputStream(this.dataDir + this.hostId + "dspjrn.txt");
            OutputStreamWriter as400Writer = new OutputStreamWriter((OutputStream)this.jrn, "UTF8");
            PrintWriter as400jrn = new PrintWriter((Writer)as400Writer, false);
            as400jrn.print(this.logjrndata.toString());
            as400Writer.flush();
            as400Writer.close();
            as400jrn.close();
            this.jrn.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while writing dspjrn.txt ::::::: {0}", e);
            e.printStackTrace();
        }
        finally {
            try {
                if (this.jrn != null) {
                    this.jrn.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Exception while closing dspjrn.txt ::::::: {0}", e);
                e.printStackTrace();
            }
        }
    }

    private void ClearBuff() {
        this.logjrndata = new StringBuffer();
    }

    private void deletejrnTempFiles() {
        try {
            for (int i = 0; i < this.logtypes.length; ++i) {
                File file = new File(this.dataDir + this.hostId + "dspjrn" + this.logtypes[i] + ".txt");
                file.delete();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while deleting temp files ::::::: {0}", e);
            e.printStackTrace();
        }
    }
}

