/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.lc;

import com.adventnet.nba.engine.NbaEngine;
import com.adventnet.nba.engine.NbaSession;
import com.adventnet.sa.server.NbaServiceUtil;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.lc.CollectiveLogEnumerator;
import com.adventnet.sa.server.lc.Log;
import com.adventnet.sa.server.lc.LogDataIndexer;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.univlogparser.SyslogHandler;
import com.adventnet.sa.server.univlogparser.SyslogHandlerInitializer;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatThreadManager {
    private static final Logger LOGGER = Logger.getLogger(DatThreadManager.class.getName());
    private LinkedBlockingQueue<String> recordQueue = new LinkedBlockingQueue();
    private ArchiveFileManager afManager = null;
    private NotificationManager nfManager = null;
    private LogForwarderFilter logforwarder = null;
    private SyslogHandler sHandler = null;
    private static DatThreadManager instance = null;
    private Object lock = new Object();
    private int limit = Integer.parseInt(System.getProperty("datlimit", "1000"));
    private int maxThreadLimit = 2;
    private int runningThreads = 0;

    private DatThreadManager() {
        this.afManager = ArchiveFileManager.getInstance();
        this.nfManager = NotificationManager.getInstance();
        this.logforwarder = LogForwarderFilter.getInstance();
        this.sHandler = SyslogHandlerInitializer.getInstance().getNewSyslogHandler();
        if ("true".equals(System.getProperty("handleHighFlow", "false"))) {
            this.maxThreadLimit = 3;
        }
    }

    public static synchronized DatThreadManager getInstance() {
        if (instance == null) {
            instance = new DatThreadManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(LinkedBlockingQueue recordQueue) {
        this.addRecordQueue(recordQueue);
        boolean startNewThread = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.runningThreads < this.maxThreadLimit) {
                this.setThreadFlag(true);
                startNewThread = true;
            }
        }
        if (startNewThread) {
            new Thread(new DatThread()).start();
        }
    }

    private void addRecordQueue(LinkedBlockingQueue recordQueue) {
        this.recordQueue.addAll(recordQueue);
    }

    private void setThreadFlag(boolean start) {
        this.runningThreads = start ? ++this.runningThreads : --this.runningThreads;
    }

    public synchronized boolean canAddDatFiles() {
        return this.recordQueue.size() < this.limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList getRecords(String fileName) {
        LOGGER.log(Level.FINER, "Loading from File: {0}", fileName);
        File file = new File(fileName);
        ArrayList records = null;
        if (!file.exists()) {
            LOGGER.log(Level.WARNING, "File : {0} is not exist while deserializing", fileName);
            return records;
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            records = (ArrayList)ois.readObject();
            LOGGER.log(Level.FINER, "Number of records in File: {0}", records.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                ois.close();
                fis.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            file.delete();
        }
        return records;
    }

    private void processLogs(ArrayList rawlogs, Log reusableLog) {
        if (rawlogs == null || rawlogs.isEmpty()) {
            return;
        }
        int objectType = 0;
        for (Object rawlog : rawlogs) {
            if (objectType == 0) {
                objectType = rawlog instanceof Log ? 1 : 2;
                Log log = reusableLog = objectType == 2 && reusableLog == null ? new Log() : reusableLog;
            }
            if (objectType == 1) {
                Log log = (Log)rawlog;
                this.processLogObject(log);
                continue;
            }
            if (reusableLog == null) {
                reusableLog = new Log();
            }
            reusableLog.clear();
            CollectiveLogEnumerator logEnum = new CollectiveLogEnumerator((byte[])rawlog);
            while (logEnum.hasNext()) {
                logEnum.loadLogdata(reusableLog);
                this.processLogObject(reusableLog);
                reusableLog.clear();
            }
        }
        rawlogs.clear();
        rawlogs = null;
    }

    private void processLogObject(Log log) {
        if (log.parseLog()) {
            try {
                LOGGER.log(Level.FINER, "Log : " + log.toString());
                this.sHandler.parseLog((String)log.get("HOSTNAME"), (String)log.get("SOURCEPORT"), log);
                LogDataIndexer.getInstance().indexLogData(log);
                try {
                    NbaSession sess = NbaEngine.getInstance().getSession(NbaServiceUtil.nbasession);
                    if (sess != null) {
                        sess.input((Object)log);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ee) {
                LOGGER.log(Level.INFO, "Log Print : " + log.toString());
                ee.printStackTrace();
            }
            try {
                this.logforwarder.filterAndForward(log);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            try {
                this.afManager.archiveLog(log);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            try {
                this.nfManager.notify((Log)log.clone());
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private void printProcessRate(long startTime, int datCount) {
        long endTime = System.currentTimeMillis();
        long duration = (endTime - startTime) / 1000L;
        LOGGER.log(Level.FINER, "Number of DAT files processed::: <->{0}<->Total Time Taken in Seconds:::<->{1}", new Object[]{datCount, duration});
    }

    private class DatThread
    implements Runnable {
        private DatThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.log(Level.FINER, "Dat Thread task invoked..");
            int datcount = 0;
            long start = System.currentTimeMillis();
            Log reusableLog = null;
            while (!DatThreadManager.this.recordQueue.isEmpty()) {
                String fileName = (String)DatThreadManager.this.recordQueue.poll();
                ++datcount;
                if (fileName == null) continue;
                DatThreadManager.this.processLogs(DatThreadManager.this.getRecords(fileName), reusableLog);
                if (datcount <= DatThreadManager.this.limit) continue;
                LOGGER.log(Level.FINER, "Processed {0} DAT Files", datcount);
            }
            Object object = DatThreadManager.this.lock;
            synchronized (object) {
                DatThreadManager.this.setThreadFlag(false);
            }
            DatThreadManager.this.printProcessRate(start, datcount);
        }
    }
}

