/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.lc;

import com.adventnet.logsearch.index.api.LogIndexer;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.sa.server.lc.CollectiveLogEnumerator;
import com.adventnet.sa.server.lc.Log;
import com.adventnet.sa.server.lc.LogDataIndexer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;

public class DatToIndexConverter {
    private static final Logger LOGGER = Logger.getLogger(DatToIndexConverter.class.getName());
    boolean isI18N = false;
    static String isDelete = null;
    private static PrintWriter log = null;
    private static SimpleDateFormat displayFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Date today = new Date();

    public static void main(String[] args) throws Exception {
        String datFileLoc = args[0];
        String indexFileLoc = args[1];
        String homeDir = args[2];
        DatToIndexConverter.writeLog(homeDir, "Dat to Index Conversion Starts...");
        DatToIndexConverter.writeLog(homeDir, "Provided Dat File Location : " + datFileLoc);
        DatToIndexConverter.writeLog(homeDir, "Provided Index File Location : " + indexFileLoc);
        DatToIndexConverter.writeLog(homeDir, "Provided Del Option [y/n] : " + args[3] + "\n");
        LOGGER.log(Level.INFO, "Dat to Index Conversion Starts...");
        Properties properties = new Properties();
        String[] keys = new String[]{"maxDocLimit", "archiveTime", "mergeFactor", "maxBuffDocs", "indexCleanupLimit", "indexPath", "maxDocLimit_Basic", "archiveTime_Basic", "mergeFactor_Basic", "maxBuffDocs_Basic"};
        String[] vals = new String[]{"5", "7", "10", "50", "0", indexFileLoc, "4000", "7", "100", "5000"};
        for (int i = 0; i < keys.length; ++i) {
            properties.setProperty(keys[i], vals[i]);
        }
        System.setProperty("isDBUsed", "false");
        LogIndexingAPI api = LogIndexingAPI.getInstance();
        System.setProperty("server.home", homeDir);
        api.setIndexDirPath(indexFileLoc);
        api.updateIndexConfigVals(properties);
        DatToIndexConverter rec = new DatToIndexConverter();
        rec.isI18N = DatToIndexConverter.getLanguage(homeDir);
        if (rec.isI18N) {
            api.setAnalyzer((Analyzer)new CJKAnalyzer());
        }
        int count = 0;
        isDelete = args[3];
        ArrayList<Object> list = new ArrayList();
        File f = new File(datFileLoc);
        String fileName = null;
        String[] files = f.list(new FileFilter("SAVEFILE_"));
        boolean maxFileCount = false;
        if (files.length > 0) {
            DatToIndexConverter.writeLog(homeDir, "Number of dat files found : " + files.length);
            LOGGER.log(Level.INFO, "Number of dat files found : {0}", files.length);
            for (String file : files) {
                ++count;
                fileName = datFileLoc + file;
                list = DatToIndexConverter.loadRecords(fileName, homeDir);
                rec.processLogs(list, null);
            }
        } else {
            DatToIndexConverter.writeLog(homeDir, "No dat files found");
            LOGGER.log(Level.INFO, "No dat files found");
        }
        DatToIndexConverter.writeLog(homeDir, "Total No of files processed in given Directory : " + count);
        LOGGER.log(Level.INFO, "Total No of files processed  in given Directory : {0}", count);
        DatToIndexConverter.writeLog(homeDir, "---------------------------Conversion Ends---------------------------\n");
        DatToIndexConverter.closeIndexes(api);
        while (!LogIndexer.isEmptyExecutorQueue()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<Log> loadRecords(String fileName, String homeDir) {
        File file = new File(fileName);
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        ArrayList records = null;
        try {
            DatToIndexConverter.writeLog(homeDir, "Loading from File : " + fileName);
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            records = (ArrayList)ois.readObject();
            DatToIndexConverter.writeLog(homeDir, "Number of records in File : " + records.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                ois.close();
                fis.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (isDelete.equalsIgnoreCase("y")) {
                file.delete();
            }
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getLanguage(String homeDir) {
        String fileName = homeDir + File.separator + "server" + File.separator + "conf" + File.separator + "install_lang.txt";
        File file = new File(fileName);
        String installedLang = null;
        if (file.exists()) {
            FileInputStream fi = null;
            Properties installProp = new Properties();
            try {
                fi = new FileInputStream(file);
                installProp.load(fi);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fi != null) {
                        fi.close();
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            installedLang = (String)installProp.get("language");
            if (installedLang == null) {
                installedLang = "en";
            }
        }
        return !"en".equals(installedLang = installedLang.toLowerCase());
    }

    private static void closeIndexes(LogIndexingAPI api) {
        Map indexerMap = api.getIndexerMap();
        for (LogIndexer indexer : indexerMap.values()) {
            indexer.closeAllWriters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLog(String homeDir, String fileLog) throws Exception {
        String currentDate = displayFormat.format(today.getTime());
        try {
            log = new PrintWriter(new FileOutputStream(homeDir + File.separator + "logs" + File.separator + "datToIndex.log", true), true);
            log.print(currentDate + "\t");
            log.println(fileLog);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.println(e.getMessage());
        }
        finally {
            if (log != null) {
                log.flush();
                log.close();
            }
        }
    }

    public void processLogs(ArrayList rawlogs, Log reusableLog) {
        if (rawlogs == null || rawlogs.isEmpty()) {
            return;
        }
        int objectType = 0;
        for (Object rawlog : rawlogs) {
            if (objectType == 0) {
                objectType = rawlog instanceof Log ? 1 : 2;
                Log log = reusableLog = objectType == 2 && reusableLog == null ? new Log() : reusableLog;
            }
            if (objectType == 1) {
                Log log = (Log)rawlog;
                this.processLogObject(log);
                continue;
            }
            if (reusableLog == null) {
                reusableLog = new Log();
            }
            reusableLog.clear();
            CollectiveLogEnumerator logEnum = new CollectiveLogEnumerator((byte[])rawlog);
            while (logEnum.hasNext()) {
                logEnum.loadLogdata(reusableLog);
                this.processLogObject(reusableLog);
                reusableLog.clear();
            }
        }
        rawlogs.clear();
        rawlogs = null;
    }

    private void processLogObject(Log log) {
        if (log.parseLog()) {
            try {
                LogDataIndexer.getInstance().indexLogData(log);
            }
            catch (Exception ee) {
                LOGGER.log(Level.INFO, "Log Print : " + log.toString());
                ee.printStackTrace();
            }
        }
    }

    private static class FileFilter
    implements FilenameFilter {
        private String fileName;

        public FileFilter(String fileName) {
            this.fileName = fileName.toLowerCase();
        }

        @Override
        public boolean accept(File dir, String name) {
            if (name.endsWith(".dat")) {
                String fileName = name.substring(0, name.lastIndexOf(".dat")).toLowerCase();
                return fileName.startsWith(this.fileName);
            }
            return false;
        }
    }
}

