/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.lc;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.LuceneUtil;
import com.adventnet.la.fieldgen.CustomLogTypePatterns;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.parser.DbUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONObject;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FieldRepository {
    private static FieldRepository instance = null;
    private Hashtable fields = new Hashtable();
    private Hashtable indexFields = new Hashtable();
    private Hashtable viewFields = new Hashtable();
    private static JSONObject fieldValues = null;
    private Set<String> distinctFields = new HashSet<String>();
    private Hashtable<String, String> hostTypeVsFormatName = new Hashtable();
    private TreeSet<String> formatNameList = new TreeSet();
    private HashMap<String, String> hostTypeCaseMap = new HashMap();
    private List<String> excludeFields = null;
    private HashMap<Integer, List<String>> ctgyValToFieldsMap = new HashMap();
    private HashMap<String, Integer> ctgyNameToValMap = new HashMap();
    private List<String> defaultFields = new ArrayList<String>();
    private List<String> logonFields = new ArrayList<String>();
    private List<String> acctmgmtFields = new ArrayList<String>();
    private List<String> dcFields = new ArrayList<String>();
    private List<String> fileMonFields = new ArrayList<String>();
    private List<String> netSvcFields = new ArrayList<String>();
    private List<String> policyChangesFields = new ArrayList<String>();
    private List<String> firewallFields = new ArrayList<String>();
    private List<String> winAppFields = new ArrayList<String>();
    public static final int LOGON_FIELDS = 1;
    public static final int ACCT_MGMT_FIELDS = 2;
    public static final int DC_FIELDS = 3;
    public static final int FILEMON_FIELDS = 4;
    public static final int NETWRKSVC_FIELDS = 5;
    public static final int POLICYCHANGES_FIELDS = 6;
    public static final int FIREWALL_FIELDS = 7;
    public static final int WINAPP_FIELDS = 8;
    public static final int DEFAULT_FIELDS = 9;
    private static final Logger LOGGER = Logger.getLogger(FieldRepository.class.getName());
    private List<String> unixLikeHostTypes = new ArrayList<String>();
    private List<String> defaultIndexedFields = Arrays.asList("TIME", "HOSTNAME");
    private List<String> defaultSearchFields = Arrays.asList("MESSAGE", "TIME", "HOSTNAME", "LOGTYPE");
    private LinkedHashSet defaultTypeIndexedFields = null;
    private LinkedHashSet allCustomPatternFields = null;
    private LinkedHashSet defaultTypeViewFields = null;

    private FieldRepository() {
        this.loadCategoryNameToCatgoryValMap();
        this.loadCategoryValToFieldsMap();
        this.loadFields();
        this.loadSearchExcludeFields();
    }

    private void loadCategoryNameToCatgoryValMap() {
        this.ctgyNameToValMap.put("DEFAULTFIELDS", 9);
        this.ctgyNameToValMap.put("LOGON", 1);
        this.ctgyNameToValMap.put("ACCTMGMT", 2);
        this.ctgyNameToValMap.put("DC", 3);
        this.ctgyNameToValMap.put("FILEMON", 4);
        this.ctgyNameToValMap.put("NETSVC", 5);
        this.ctgyNameToValMap.put("POLICYCHANGES", 6);
        this.ctgyNameToValMap.put("FIREWALL", 7);
        this.ctgyNameToValMap.put("WINDOWSAPP", 8);
    }

    private void loadCategoryValToFieldsMap() {
        this.ctgyValToFieldsMap.put(1, this.logonFields);
        this.ctgyValToFieldsMap.put(2, this.acctmgmtFields);
        this.ctgyValToFieldsMap.put(3, this.dcFields);
        this.ctgyValToFieldsMap.put(4, this.fileMonFields);
        this.ctgyValToFieldsMap.put(5, this.netSvcFields);
        this.ctgyValToFieldsMap.put(6, this.policyChangesFields);
        this.ctgyValToFieldsMap.put(7, this.firewallFields);
        this.ctgyValToFieldsMap.put(8, this.winAppFields);
        this.ctgyValToFieldsMap.put(9, this.defaultFields);
    }

    public void addIndexFields() {
        for (Map.Entry entry : this.indexFields.entrySet()) {
            LuceneUtil.addAppToColsMap((String)((String)entry.getKey()), (List)((List)entry.getValue()));
        }
        LOGGER.fine("View Fields ::::::: " + this.viewFields);
        for (Map.Entry entry : this.viewFields.entrySet()) {
            LinkedHashSet<String> set = new LinkedHashSet<String>((List)entry.getValue());
            set.addAll(this.defaultSearchFields);
            LuceneUtil.addViewColsMap((String)((String)entry.getKey()), new ArrayList(set));
        }
    }

    public static synchronized FieldRepository get_instance() {
        if (instance == null) {
            instance = new FieldRepository();
        }
        return instance;
    }

    public void updateFields() {
        try {
            HashSet defaultLogTypes = new HashSet(this.fields.keySet());
            defaultLogTypes.add("Application");
            String tableName = "HostDetails";
            SelectQueryImpl query = new SelectQueryImpl(new Table(tableName));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            Criteria cri = new Criteria(Column.getColumn((String)tableName, (String)"TYPE"), (Object)defaultLogTypes.toArray(), 9);
            query.setCriteria(cri);
            DataObject dob = DataAccess.get((SelectQuery)query);
            Iterator itr = dob.getRows(tableName);
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                String logTypeName = (String)r.get("TYPE");
                this.addUnixLikeLogType(logTypeName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadFields() {
        File file = new File(System.getProperty("server.home") + File.separator + "server" + File.separator + "conf" + File.separator + "ParserRules" + File.separator + "fields.xml");
        try {
            DocumentBuilderFactory dBuildFac = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuild = dBuildFac.newDocumentBuilder();
            Document doc = dBuild.parse(file);
            Element rootNode = doc.getDocumentElement();
            this.populateFields(rootNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateFields();
    }

    public boolean isNewUnixLikeLogType(String logTypeName) {
        if (logTypeName.equals("Windows") || logTypeName.equals("WINDOWS") || logTypeName.equals("windows")) {
            return false;
        }
        return !this.fields.keySet().contains(logTypeName);
    }

    public List<String> getUnixLikeHostTypes() {
        return Collections.unmodifiableList(this.unixLikeHostTypes);
    }

    public void addUnixLikeLogType(String logTypeName) {
        String mappedTtype = "Unix";
        LuceneUtil.addAppToColsMap((String)logTypeName, (List)((List)this.indexFields.get(mappedTtype)));
        LinkedHashSet<String> set = new LinkedHashSet<String>((List)this.viewFields.get(mappedTtype));
        set.addAll(this.defaultSearchFields);
        LuceneUtil.addViewColsMap((String)logTypeName, new ArrayList(set));
        this.unixLikeHostTypes.add(logTypeName);
    }

    private void loadSearchExcludeFields() {
        this.excludeFields = new ArrayList<String>();
        File file = new File(System.getProperty("server.home") + File.separator + "server" + File.separator + "conf" + File.separator + "ExcludeFields.txt");
        Properties props = new Properties();
        try {
            props.load(new BufferedInputStream(new FileInputStream(file)));
            String excludeListStr = props.getProperty("Exclude");
            if (excludeListStr != null) {
                List<String> l = Arrays.asList(excludeListStr.split(","));
                this.excludeFields.addAll(l);
                LuceneUtil.addFieldsToELAExcludeList(this.excludeFields);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void populateFields(Element element) {
        NodeList nodes = element.getElementsByTagName("Field-Set");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement = (Element)nodes.item(i);
            this.getFields(nodeElement);
        }
        try {
            SelectQueryImpl sqlLT = new SelectQueryImpl(new Table("Search_FormatFields"));
            sqlLT.addSelectColumn(Column.getColumn((String)"Search_FormatFields", (String)"*"));
            DataObject dobjLT = DataAccess.get((SelectQuery)sqlLT);
            if (dobjLT != null && !dobjLT.isEmpty()) {
                Iterator itrLT = dobjLT.getRows("Search_FormatFields");
                while (itrLT.hasNext()) {
                    String[] formatNames;
                    Row r = (Row)itrLT.next();
                    String logType = (String)r.get("LOGTYPE");
                    String formatName = (String)r.get("FORMAT_NAME");
                    String fields = (String)r.get("FIELDS");
                    String indexFields = (String)r.get("INDEX_FIELDS");
                    String viewFields = (String)r.get("VIEW_FIELDS");
                    for (String name : formatNames = formatName.split(",")) {
                        this.formatNameList.add(name);
                    }
                    this.fields.put(logType, Arrays.asList(fields.split(",")));
                    this.indexFields.put(logType, Arrays.asList(indexFields.split(",")));
                    this.viewFields.put(logType, Arrays.asList(viewFields.split(",")));
                    this.hostTypeVsFormatName.put(logType, formatName);
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private void getFields(Element element) {
        Attr ctgyAttr;
        NamedNodeMap attrs = element.getAttributes();
        String type = null;
        String formatName = null;
        String[] fields = null;
        String[] indexFields = null;
        String[] viewFields = null;
        Object categoryToFiledsMap = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String[] attr = (String[])attrs.item(i);
            if (attr.getName().equals("type")) {
                type = attr.getValue();
            }
            if (!attr.getName().equals("formatname")) continue;
            LOGGER.info("FieldRepository.getFields() ... inside formatname attribute check !! ");
            formatName = attr.getValue();
        }
        if (type != null && formatName != null) {
            String[] formatNames;
            LOGGER.info("FieldRepository.getFields() ... Type Value is  " + type + " and formatname is " + formatName);
            this.hostTypeVsFormatName.put(type.toLowerCase(), formatName);
            this.hostTypeCaseMap.put(type.toLowerCase(), type);
            for (String name : formatNames = formatName.split(",")) {
                this.formatNameList.add(name);
            }
        }
        NodeList nodes = null;
        NodeList ctgyNodes = null;
        Element ctgyElement = null;
        boolean flag = true;
        int loopIndex = 0;
        String ctgyName = null;
        if (type.equals("Windows")) {
            ctgyNodes = element.getElementsByTagName("Category");
            ctgyElement = (Element)ctgyNodes.item(loopIndex);
            NamedNodeMap ctgyAttrList = ctgyElement.getAttributes();
            ctgyAttr = (Attr)ctgyAttrList.item(0);
            ctgyName = ctgyAttr.getValue();
            nodes = ctgyElement.getElementsByTagName("Fields");
        } else {
            nodes = element.getElementsByTagName("Fields");
        }
        while (flag) {
            Element nodeElement;
            int i;
            if (!type.equals("Windows")) {
                flag = false;
            }
            for (i = 0; i < nodes.getLength(); ++i) {
                nodeElement = (Element)nodes.item(i);
                fields = this.getCDATA(nodeElement).split(",");
                if (!type.equals("Windows")) continue;
                ArrayList fieldList = (ArrayList)this.ctgyValToFieldsMap.get(this.ctgyNameToValMap.get(ctgyName));
                fieldList.addAll(Arrays.asList(fields));
                if (ctgyName.equals("DEFAULTFIELDS")) {
                    this.ctgyValToFieldsMap.put(this.ctgyNameToValMap.get(ctgyName), fieldList);
                } else {
                    ArrayList templist = new ArrayList();
                    templist.addAll(this.ctgyValToFieldsMap.get(this.ctgyNameToValMap.get("DEFAULTFIELDS")));
                    templist.addAll(fieldList);
                    this.ctgyValToFieldsMap.put(this.ctgyNameToValMap.get(ctgyName), templist);
                }
                this.distinctFields.addAll((Collection<String>)this.ctgyValToFieldsMap.get(this.ctgyNameToValMap.get(ctgyName)));
            }
            nodes = element.getElementsByTagName("IndexFields");
            for (i = 0; i < nodes.getLength(); ++i) {
                nodeElement = (Element)nodes.item(i);
                indexFields = this.getCDATA(nodeElement).split(",");
            }
            nodes = element.getElementsByTagName("ViewFields");
            for (i = 0; i < nodes.getLength(); ++i) {
                nodeElement = (Element)nodes.item(i);
                viewFields = this.getCDATA(nodeElement).split(",");
            }
            if (viewFields != null) {
                this.viewFields.put(type, Arrays.asList(viewFields));
            }
            if (!type.equals("Windows")) {
                this.fields.put(type, Arrays.asList(fields));
                this.indexFields.put(type, Arrays.asList(indexFields));
                continue;
            }
            if (++loopIndex == ctgyNodes.getLength()) break;
            ctgyNodes = element.getElementsByTagName("Category");
            ctgyElement = (Element)ctgyNodes.item(loopIndex);
            NamedNodeMap ctgyAttrList = ctgyElement.getAttributes();
            ctgyAttr = (Attr)ctgyAttrList.item(0);
            ctgyName = ctgyAttr.getValue();
            nodes = ctgyElement.getElementsByTagName("Fields");
        }
        if (type.equals("Windows")) {
            Object[] arr = this.distinctFields.toArray();
            List<Object> l = Arrays.asList(arr);
            this.indexFields.put(type, l);
            this.fields.put(type, l);
        }
    }

    private String getCDATA(Element element) {
        String cdata = null;
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 4) continue;
            cdata = ((CDATASection)node).getData().trim();
        }
        return cdata;
    }

    public List getFields(String type, int ctgy) {
        if (!type.equals("Windows")) {
            return (List)(this.fields.containsKey(type) ? this.fields.get(type) : this.fields.get("Unix"));
        }
        if (ctgy != -1) {
            return this.ctgyValToFieldsMap.get(ctgy);
        }
        return (List)(this.indexFields.containsKey(type) ? this.indexFields.get(type) : this.indexFields.get("Unix"));
    }

    public List getIndexFields(String type) {
        return (List)(this.indexFields.containsKey(type) ? this.indexFields.get(type) : this.indexFields.get("Unix"));
    }

    public List getDefaultLogTypes() {
        return new ArrayList(this.fields.keySet());
    }

    private String getLogTypeAsInFieldsXml(String formatName) {
        String matchingFormats;
        String logTypeAsInFieldsXml = formatName;
        if (formatName != null && !this.fields.containsKey(formatName) && (matchingFormats = this.getHostType(formatName)) != null) {
            String[] mFormats;
            LOGGER.log(Level.FINER, "FieldRepository.getIndexedFields() Value of matching formats for given formatname ::: {0} is ::::::::::::: {1}", new Object[]{formatName, matchingFormats});
            for (String mFormat : mFormats = matchingFormats.split(",")) {
                LOGGER.log(Level.FINER, "Inside for:loop ... format name to check is ::::::::::::: {0}", mFormat);
                String temp = this.hostTypeCaseMap.get(mFormat);
                String string = mFormat = temp == null ? mFormat : temp;
                if (!this.fields.containsKey(mFormat)) continue;
                LOGGER.log(Level.FINER, " Seems we have a potential match .... and corresponding host type is {0}", mFormat);
                logTypeAsInFieldsXml = mFormat;
                break;
            }
        }
        return logTypeAsInFieldsXml;
    }

    private LinkedHashSet<String> getCustomFieldsForLogType(String logtype) {
        CustomLogTypePatterns logTypePatternsObj = SystemCustomPatternHandler.getInstance().getCustomLogTypePatternsObj(logtype);
        LinkedHashSet indexedFields = null;
        if (logTypePatternsObj != null) {
            indexedFields = new LinkedHashSet(logTypePatternsObj.getAllFieldNames());
            indexedFields.addAll(logTypePatternsObj.getAllOpenAttributes());
        }
        return indexedFields;
    }

    public List getIndexedFields(String logTypeOrFormatId) {
        return this.getIndexedFields(logTypeOrFormatId, null, false);
    }

    public List getIndexedFields(String logTypeOrFormatId, boolean applyExcludeFields) {
        return this.getIndexedFields(logTypeOrFormatId, null, applyExcludeFields);
    }

    public List getIndexedFields(String logTypeOrFormatId, String formatName) {
        if (formatName.equals("Windows")) {
            return (List)this.indexFields.get(formatName);
        }
        return this.getIndexedFields(logTypeOrFormatId, formatName, true);
    }

    public List getIndexedFields(String logTypeOrFormatId, String formatName, boolean applyExcludeFields) {
        LOGGER.log(Level.FINER, " FieldRepository.getIndexedFields() Called with logtype/FormatId :::: {0} and format name as {1}", new Object[]{logTypeOrFormatId, formatName});
        String logTypeAsInFieldsXml = this.getLogTypeAsInFieldsXml(formatName);
        LOGGER.log(Level.FINER, "FieldRepository.getIndexedFields() LogType/FormatId passed is ::::::::::: {0} and its corresponding logtype defined in fields.xml file is {1}", new Object[]{logTypeOrFormatId, logTypeAsInFieldsXml});
        List defPatternFields = logTypeAsInFieldsXml != null && this.fields.containsKey(logTypeAsInFieldsXml) ? (List)this.fields.get(logTypeAsInFieldsXml) : (List)LuceneUtil.getAllColumnMap().get(logTypeOrFormatId);
        LinkedHashSet<String> customFields = null;
        if (logTypeAsInFieldsXml != null) {
            String matchingFormats;
            customFields = this.getCustomFieldsForLogType(logTypeAsInFieldsXml);
            if (customFields == null && logTypeOrFormatId != null) {
                customFields = this.getCustomFieldsForLogType(logTypeOrFormatId);
            }
            if ((matchingFormats = this.getHostType(formatName)) != null) {
                String[] matches;
                for (String matchingFormatName : matches = matchingFormats.split(",")) {
                    LinkedHashSet<String> customFieldsForMatches;
                    Long matchingFormatId = DbUtil.get_instance().getFormatId(matchingFormatName);
                    LOGGER.log(Level.INFO, "matchingFormatId got from DbUtil = {0} for matchingFormatName = {1}", new Object[]{matchingFormatId, matchingFormatName});
                    if (matchingFormatId == null || (customFieldsForMatches = this.getCustomFieldsForLogType(matchingFormatId.toString())) == null) continue;
                    LOGGER.log(Level.INFO, "Custom Fields for FormatId {0} is {1}", new Object[]{matchingFormatId, customFieldsForMatches});
                    customFields.addAll(customFieldsForMatches);
                }
            }
        } else {
            customFields = this.getCustomFieldsForLogType(logTypeOrFormatId);
            ArrayList<String> custList = new ArrayList<String>();
            if (customFields != null) {
                custList.addAll(customFields);
            }
        }
        if (defPatternFields != null) {
            HashSet resultSet = new HashSet();
            resultSet.addAll(defPatternFields);
            ArrayList<String> result = new ArrayList<String>(defPatternFields);
            result.add("HOSTNAME");
            if (customFields != null) {
                result.addAll(customFields);
            }
            if (applyExcludeFields) {
                result.removeAll(this.excludeFields);
                result.addAll(this.defaultSearchFields);
            }
            resultSet.addAll(result);
            ArrayList finalResult = new ArrayList();
            finalResult.addAll(resultSet);
            return finalResult;
        }
        if (customFields != null) {
            ArrayList<String> finalList = new ArrayList<String>(this.defaultIndexedFields);
            finalList.addAll(customFields);
            if (applyExcludeFields) {
                finalList.removeAll(this.excludeFields);
                finalList.addAll(this.defaultSearchFields);
            }
            return finalList;
        }
        return this.defaultIndexedFields;
    }

    public List getAllIndexedFields() {
        return this.getAllIndexedFields(false);
    }

    public List getAllIndexedFields(boolean applyExcludeFields) {
        if (this.defaultTypeIndexedFields == null) {
            ArrayList l = new ArrayList();
            l.addAll(LuceneUtil.getAllColumnMap().values());
            this.defaultTypeIndexedFields = new LinkedHashSet();
            for (int i = 0; i < l.size(); ++i) {
                this.defaultTypeIndexedFields.addAll((List)l.get(i));
            }
            if (this.allCustomPatternFields == null) {
                this.findAllCustomPatternFields();
            }
        } else if (SystemCustomPatternHandler.getInstance().isNeedToReloadFieldDetails()) {
            this.findAllCustomPatternFields();
        }
        LinkedHashSet all = new LinkedHashSet(this.defaultTypeIndexedFields);
        all.addAll(this.allCustomPatternFields);
        ArrayList finalList = new ArrayList(all);
        if (applyExcludeFields) {
            finalList.removeAll(this.excludeFields);
        }
        return finalList;
    }

    public String getFormatName(String hostType) {
        LOGGER.log(Level.FINER, "FieldRepository.getFormatDesc() Value of hostType passed is {0}", hostType);
        LOGGER.log(Level.FINER, "FieldRepository.getFormatDesc() Value of hostTypeVsFormatName Map is {0}", this.hostTypeVsFormatName);
        return this.hostTypeVsFormatName.get(hostType);
    }

    public String getHostType(String formatName) {
        LOGGER.log(Level.FINER, "FieldRepository.getHostType() Value of hostType is {0}", formatName);
        LOGGER.log(Level.FINER, "FieldRepository.getHostType() Value of hostTypeVsFormatName Map is {0}", this.hostTypeVsFormatName);
        String hostType = null;
        if (!this.formatNameList.contains(formatName.trim())) {
            return null;
        }
        block0: for (Map.Entry<String, String> e : this.hostTypeVsFormatName.entrySet()) {
            String[] valueArray;
            String value = e.getValue();
            if (value.equals(formatName)) {
                hostType = e.getKey();
                break;
            }
            if (value.indexOf(",") <= 0) continue;
            for (String val : valueArray = value.split(",")) {
                if (!val.equals(formatName)) continue;
                hostType = e.getKey() + "," + value;
                continue block0;
            }
        }
        return hostType;
    }

    public boolean isDefaultLogType(String logType) {
        return this.fields.containsKey(logType);
    }

    private void findAllCustomPatternFields() {
        this.allCustomPatternFields = new LinkedHashSet<String>(this.defaultIndexedFields);
        List patternsObjList = SystemCustomPatternHandler.getInstance().getAllCustomPatternsObjList();
        for (CustomLogTypePatterns logTypePatternsObj : patternsObjList) {
            this.allCustomPatternFields.addAll(logTypePatternsObj.getAllFieldNames());
            this.allCustomPatternFields.addAll(logTypePatternsObj.getAllOpenAttributes());
        }
    }

    public List getAllViewFields() {
        if (this.defaultTypeViewFields == null) {
            this.defaultTypeViewFields = new LinkedHashSet();
            ArrayList l = new ArrayList();
            l.addAll(LuceneUtil.getViewColsMap().values());
            for (List fldList : l) {
                this.defaultTypeViewFields.addAll(fldList);
            }
            if (this.allCustomPatternFields == null) {
                this.findAllCustomPatternFields();
            }
        } else if (this.allCustomPatternFields == null || SystemCustomPatternHandler.getInstance().isNeedToReloadFieldDetails()) {
            this.findAllCustomPatternFields();
        }
        LinkedHashSet<String> viewFlds = new LinkedHashSet<String>(this.defaultTypeViewFields);
        viewFlds.addAll(this.allCustomPatternFields);
        viewFlds.addAll(this.defaultSearchFields);
        ArrayList finalList = new ArrayList(viewFlds);
        return finalList;
    }

    public List getViewFieldsForType(String logType) {
        return this.getViewFieldsForType(null, logType);
    }

    public List getViewFieldsForType(String formatId, String formatName) {
        LOGGER.log(Level.FINER, " FieldRepository.getIndexedFields() Called with formatId :::: {0} and format name as {1}", new Object[]{formatId, formatName});
        String logTypeAsInFieldsXml = this.getLogTypeAsInFieldsXml(formatName);
        LOGGER.log(Level.FINER, "FieldRepository.getViewFields() formatId passed is ::::::::::: {0} and its corresponding log type defined in fields.xml file is {1}", new Object[]{formatId, logTypeAsInFieldsXml});
        List defPatternViewFields = logTypeAsInFieldsXml != null && this.viewFields.containsKey(logTypeAsInFieldsXml) ? (List)this.viewFields.get(logTypeAsInFieldsXml) : (List)LuceneUtil.getViewColsMap().get(formatId);
        LinkedHashSet<String> customFields = this.getCustomFieldsForLogType(formatId);
        if (defPatternViewFields != null) {
            LinkedHashSet<String> set = new LinkedHashSet<String>(defPatternViewFields);
            set.addAll(this.defaultSearchFields);
            set.removeAll(this.excludeFields);
            return new ArrayList(set);
        }
        if (customFields != null) {
            ArrayList<String> finalList = new ArrayList<String>();
            finalList.addAll(this.defaultSearchFields);
            finalList.addAll(customFields);
            return finalList;
        }
        return new ArrayList<String>(this.defaultSearchFields);
    }

    public HashSet getAllLogTypeNames() {
        List sysLogTypes = this.getDefaultLogTypes();
        ArrayList<String> allAppLogFormatNames = DbUtil.get_instance().getAllAppLogTypeNames();
        List allCustomLogTypeNames = CustomLogTypePatterns.getAllCustomLogTypeNames();
        HashSet<String> allLogTypeNames = new HashSet<String>();
        allLogTypeNames.addAll(sysLogTypes);
        allLogTypeNames.addAll(allAppLogFormatNames);
        allLogTypeNames.addAll(allCustomLogTypeNames);
        return allLogTypeNames;
    }

    public Map<String, List<List>> getAllTypeVsColsMap() {
        HashMap<String, List<List>> finalResult = new HashMap<String, List<List>>();
        Map viewColsMap = LuceneUtil.getAllDefaultTypeVsViewColsMap();
        Map indexedColsMap = LuceneUtil.getAllDefaultTypeVsIndexedColsMap();
        Iterator itr = indexedColsMap.entrySet().iterator();
        List<String> appExclCols = Arrays.asList("RAWLOG", "FORMATID", "HOSTTYPE");
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String key = (String)entry.getKey();
            LinkedHashSet<String> indexedCols = new LinkedHashSet<String>((Collection)entry.getValue());
            indexedCols.removeAll(this.excludeFields);
            indexedCols.addAll(this.defaultSearchFields);
            LinkedHashSet<String> customFieldsForType = this.getCustomFieldsForLogType(key);
            if (customFieldsForType != null) {
                indexedCols.addAll(customFieldsForType);
            }
            LinkedHashSet<String> viewCols = null;
            if (viewColsMap.get(key.toLowerCase()) == null) {
                viewCols = indexedCols;
            } else {
                viewCols = new LinkedHashSet((Collection)viewColsMap.get(key.toLowerCase()));
                viewCols.addAll(this.defaultSearchFields);
                viewCols.removeAll(appExclCols);
            }
            ArrayList<LinkedHashSet<String>> coll = new ArrayList<LinkedHashSet<String>>();
            coll.add(indexedCols);
            coll.add(viewCols);
            finalResult.put(key, coll);
        }
        List allCustomLogTypeNames = CustomLogTypePatterns.getAllCustomLogTypeNames();
        for (String formatName : allCustomLogTypeNames) {
            ArrayList<ArrayList<String>> coll;
            ArrayList<String> customFields;
            Long fId = DbUtil.get_instance().getFormatIdForLogType(formatName);
            if (fId == null) continue;
            LinkedHashSet<String> customFieldsSet = this.getCustomFieldsForLogType(fId.toString());
            if (customFieldsSet != null) {
                customFields = new ArrayList<String>(this.defaultSearchFields);
                coll = new ArrayList<ArrayList<String>>();
                customFields.addAll(customFieldsSet);
                coll.add(customFields);
                coll.add(customFields);
                finalResult.put(fId.toString(), coll);
                continue;
            }
            customFields = new ArrayList<String>(this.defaultSearchFields);
            coll = new ArrayList();
            coll.add(customFields);
            coll.add(customFields);
            finalResult.put(fId.toString(), coll);
        }
        return finalResult;
    }

    public static JSONObject populateFields(Long userID) {
        if (fieldValues == null) {
            fieldValues = new JSONObject();
            JSONObject fields = new JSONObject();
            try {
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"FieldDetails"));
                query.addSelectColumn(Column.getColumn((String)"FieldDetails", (String)"*"));
                Criteria c1 = new Criteria(Column.getColumn((String)"FieldDetails", (String)"LOGIN_ID"), (Object)userID, 0);
                query.setCriteria(c1);
                DataObject dObj = DataAccess.get((SelectQuery)query);
                Iterator i = dObj.getRows("FieldDetails");
                while (i.hasNext()) {
                    Row r = (Row)i.next();
                    String logFormat = (String)r.get("FORMAT_NAME");
                    String value = (String)r.get("VIEW_FIELDS");
                    fields.put(logFormat, (Object)value);
                }
                if (fields != null) {
                    fieldValues.put(userID.toString(), (Object)fields);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fieldValues;
    }

    public static JSONObject updateSelColumns(Long userID, String requestedColumns) {
        if (fieldValues == null) {
            fieldValues = new JSONObject();
        }
        JSONObject fields = new JSONObject();
        try {
            if (fieldValues != null && fieldValues.has(userID.toString())) {
                fields = (JSONObject)fieldValues.get(userID.toString());
            }
            JSONObject obj = new JSONObject(requestedColumns);
            Iterator itr = obj.keys();
            while (itr.hasNext()) {
                Row r;
                String key = (String)itr.next();
                String value = obj.getString(key);
                if (value.equals("") || value.isEmpty()) continue;
                fields.put(key, (Object)value);
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"FieldDetails"));
                query.addSelectColumn(Column.getColumn((String)"FieldDetails", (String)"*"));
                Criteria c1 = new Criteria(Column.getColumn((String)"FieldDetails", (String)"LOGIN_ID"), (Object)userID, 0);
                query.setCriteria(c1);
                DataObject dObj = DataAccess.get((SelectQuery)query);
                Iterator i = dObj.getRows("FieldDetails");
                boolean flag = false;
                while (i.hasNext()) {
                    r = (Row)i.next();
                    String logFormat = (String)r.get("FORMAT_NAME");
                    if (logFormat.equals(key)) {
                        r.set("VIEW_FIELDS", (Object)value);
                        flag = true;
                    }
                    dObj.updateRow(r);
                }
                if (!flag) {
                    r = new Row("FieldDetails");
                    r.set("LOGIN_ID", (Object)userID);
                    r.set("FORMAT_NAME", (Object)key);
                    r.set("VIEW_FIELDS", (Object)value);
                    dObj.addRow(r);
                }
                DataAccess.update((DataObject)dObj);
            }
            if (fieldValues != null) {
                fieldValues.put(userID.toString(), (Object)fields);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldValues;
    }

    public static void deleteMapValues(Long[] userIDS) {
        for (Long id : userIDS) {
            if (fieldValues == null || !fieldValues.has(id + "")) continue;
            fieldValues.remove(id + "");
        }
    }
}

