/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.lc;

import com.adventnet.sa.server.lc.FieldRepository;
import com.adventnet.sa.server.lc.MSSQLLog;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Log
extends Hashtable {
    private static final Logger LOGGER = Logger.getLogger(Log.class.getName());
    private short[] data;
    private int length = 0;
    private int category = -1;
    private static final short DATA_INT16 = 1;
    private static final short DATA_INT32 = 2;
    private static final short DATA_STR = 3;
    private static final short DATA_USTR = 4;
    private static final short DATA_INT64 = 8;

    public Log(byte[] data, int length) {
        this.data = new short[length];
        for (int i = 0; i < length; ++i) {
            this.data[i] = data[i];
        }
        this.length = length;
    }

    public Log() {
    }

    public int putData(byte[] inputData, int startPos) {
        int pktLen = (short)(0xFF & (short)inputData[startPos]) << 8 | (short)(0xFF & (short)inputData[startPos + 1]);
        if (startPos + pktLen > inputData.length) {
            return startPos + pktLen;
        }
        this.length = pktLen;
        this.data = new short[this.length];
        int i = 0;
        int j = startPos;
        while (i < this.length) {
            this.data[i] = inputData[j];
            ++i;
            ++j;
        }
        return startPos + pktLen;
    }

    @Override
    public void clear() {
        super.clear();
        this.data = null;
        this.length = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseLog() {
        int bytePtr = 0;
        int pktLen = this.unpacki16(this.data, bytePtr);
        LOGGER.log(Level.FINE, "Pkt length from packet : " + pktLen + ", from socket" + this.length);
        if (pktLen != this.length) {
            LOGGER.log(Level.INFO, "Stray packet. Returning false");
            return false;
        }
        short dType = this.data[bytePtr += 2];
        int typeLen = this.unpacki16(this.data, ++bytePtr);
        String type = new String(this.getByteArray(this.data, bytePtr += 2, typeLen), 0, typeLen);
        bytePtr += typeLen;
        if (type.equals("SysLog")) {
            return this.parseSysLog(bytePtr + 1, pktLen);
        }
        FieldRepository f = FieldRepository.get_instance();
        List fields = null;
        this.put("HOSTTYPE", type);
        if (type.equals("Windows")) {
            int category;
            this.category = category = this.unpacki16(this.data, ++bytePtr);
            fields = f.getFields(type, category);
            bytePtr += 2;
        } else {
            fields = f.getFields(type, -1);
        }
        LOGGER.log(Level.FINER, "Type : " + type);
        LOGGER.log(Level.FINER, "Format : " + type);
        LOGGER.log(Level.FINER, "Type : " + type);
        int i = 0;
        long lVal = 0L;
        int iVal = 0;
        while (bytePtr < this.length) {
            short dataType = this.data[bytePtr++];
            switch (dataType) {
                case 1: {
                    iVal = this.unpacki16(this.data, bytePtr);
                    LOGGER.log(Level.FINE, "Integer : " + iVal);
                    this.put(fields.get(i), new Integer(iVal));
                    bytePtr += 2;
                    break;
                }
                case 2: {
                    lVal = this.unpacki32(this.data, bytePtr);
                    LOGGER.log(Level.FINE, "Long : " + lVal);
                    if ("TIME".equals(fields.get(i))) {
                        this.put(fields.get(i), new Long(lVal * 1000L));
                    } else {
                        this.put(fields.get(i), new Long(lVal));
                    }
                    bytePtr += 4;
                    break;
                }
                case 8: {
                    lVal = this.unpacki64(this.data, bytePtr);
                    LOGGER.log(Level.FINE, "Long Long : " + lVal);
                    this.put(fields.get(i), new Long(lVal));
                    bytePtr += 8;
                    break;
                }
                case 3: {
                    int strLen = this.unpacki16(this.data, bytePtr);
                    LOGGER.log(Level.FINE, "String length : " + strLen);
                    bytePtr += 2;
                    if (strLen <= 0) break;
                    try {
                        String s = new String(this.getByteArray(this.data, bytePtr, strLen), 0, strLen, "UTF-8");
                        this.put(fields.get(i), s);
                        LOGGER.log(Level.FINE, "String : " + s);
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.info(e.toString());
                        String s = new String(this.getByteArray(this.data, bytePtr, strLen), 0, strLen);
                        this.put(fields.get(i), s);
                        LOGGER.log(Level.FINE, "String : " + s);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "Exception in data packet: " + Arrays.toString(this.data));
                        LOGGER.log(Level.INFO, "Index : " + bytePtr + " StrLen : " + strLen + " TotalLength : " + this.data.length);
                        e.printStackTrace();
                        break;
                    }
                    finally {
                        bytePtr += strLen;
                    }
                }
            }
            ++i;
        }
        this.checkForSQLServerCIM();
        return true;
    }

    public boolean parseSysLog(int bytePtr, int pktLen) {
        try {
            while (bytePtr < pktLen) {
                int strLen = this.unpacki16(this.data, bytePtr);
                String field = new String(this.getByteArray(this.data, bytePtr += 2, strLen), 0, strLen, "UTF-8");
                bytePtr += strLen + 1;
                strLen = this.unpacki16(this.data, bytePtr);
                String value = new String(this.getByteArray(this.data, bytePtr += 2, strLen), 0, strLen, "UTF-8");
                bytePtr += strLen + 1;
                this.put(field, value);
            }
            this.put("TIME", Long.parseLong(((String)this.get("TIME")).split("\\.")[0]));
            this.put("HOSTID", Long.parseLong((String)this.get("HOSTID")));
            try {
                this.put("SEVERITY", Integer.parseInt((String)this.get("SEVERITY")));
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(Level.INFO, "NumberFormatException SEVERITY Comming as : " + this.get("SEVERITY"));
                this.put("SEVERITY", 2);
            }
            if (this.containsKey("EVENTID")) {
                this.put("EVENTID", Integer.parseInt((String)this.get("EVENTID")));
            }
            if (this.containsKey("SLEVENTID")) {
                this.put("SLEVENTID", Integer.parseInt((String)this.get("SLEVENTID")));
            } else {
                this.put("SLEVENTID", 0);
            }
            if (this.containsKey("SOURCEPORT")) {
                this.put("SOURCEPORT", Integer.parseInt((String)this.get("SOURCEPORT")));
            } else {
                this.put("SOURCEPORT", 0);
            }
            if (this.containsKey("MESSAGE")) {
                String logValue = (String)this.get("MESSAGE");
                this.put("FULLLOG", logValue);
                if (this.containsKey("MESSAGESTART")) {
                    int msgStart = Integer.parseInt((String)this.get("MESSAGESTART"));
                    int msgLength = Integer.parseInt((String)this.get("MESSAGELEN"));
                    if (logValue.length() < msgStart + msgLength - 1) {
                        byte[] message = logValue.getBytes(Charset.forName("UTF-8"));
                        String messageStr = new String(message, msgStart - 1, msgLength, "UTF-8");
                        this.put("MESSAGE", messageStr);
                    } else {
                        logValue = logValue.substring(msgStart - 1, msgStart + msgLength - 1);
                        this.put("MESSAGE", logValue);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.INFO, "Exeption in Log : " + this);
        }
        this.checkForSQLServerCIM();
        return true;
    }

    public void parseLog(String type, Hashtable paramMap) {
        FieldRepository f = FieldRepository.get_instance();
        List fields = f.getFields(type, -1);
        this.put("HOSTTYPE", type);
        for (String fieldName : fields) {
            LOGGER.log(Level.FINE, "field " + fieldName + " " + paramMap.get(fieldName));
            this.put(fieldName, paramMap.containsKey(fieldName) ? paramMap.get(fieldName) : "-");
        }
        this.checkForSQLServerCIM();
    }

    public int getLogCategory() {
        return this.category;
    }

    public Long getEventId() {
        if (this.get("EVENTID") instanceof Integer) {
            return new Long(((Integer)this.get("EVENTID")).longValue());
        }
        if (this.get("EVENTID") instanceof String) {
            return new Long((String)this.get("EVENTID"));
        }
        return null;
    }

    public Long getSlEventId() {
        return new Long(((Integer)this.get("SLEVENTID")).longValue());
    }

    public String getHostName() {
        return (String)this.get("HOSTNAME");
    }

    public Long getTime() {
        return (Long)this.get("TIME");
    }

    public String getType() {
        return (String)this.get("HOSTTYPE");
    }

    public String getDomain() {
        String domain = (String)this.get("DOMAIN");
        return domain != null ? domain : null;
    }

    public String getTargetDomain() {
        String domain = (String)this.get("TARGETDOMAIN");
        return domain != null ? domain : null;
    }

    public String getSrcUser() {
        StringBuffer userNameWithDomain = new StringBuffer();
        String domain = (String)this.get("DOMAIN");
        if (domain == null || domain.equals("-")) {
            userNameWithDomain.append((String)this.get("USERNAME"));
        } else if (!domain.equals("-")) {
            userNameWithDomain.append((String)this.get("DOMAIN"));
            userNameWithDomain.append("\\");
            userNameWithDomain.append((String)this.get("USERNAME"));
        }
        return userNameWithDomain.toString();
    }

    public String getTgtUser() {
        StringBuffer userNameWithDomain = new StringBuffer();
        String domain = (String)this.get("TARGETDOMAIN");
        if (domain == null || domain.equals("-")) {
            userNameWithDomain.append((String)this.get("TARGETUSER"));
        } else if (!domain.equals("-")) {
            userNameWithDomain.append((String)this.get("TARGETDOMAIN"));
            userNameWithDomain.append("\\");
            userNameWithDomain.append((String)this.get("TARGETUSER"));
        }
        return userNameWithDomain.toString();
    }

    public String getGroupName() {
        return (String)this.get("GROUPNAME");
    }

    public String getSHost() {
        return (String)this.get("REMOTEHOST");
    }

    public String getDHost() {
        return this.getHostName();
    }

    public String getFile() {
        return (String)this.get("OBJECTNAME");
    }

    public String getObjectType() {
        return (String)this.get("OBJECTTYPE");
    }

    public String getSrcPort() {
        return (String)this.get("SOURCEPORT");
    }

    public String getLogonType() {
        return (String)this.get("LOGONTYPE");
    }

    public String getLogonId() {
        return (String)this.get("LOGONID");
    }

    public Long getHostId() {
        return (Long)this.get("HOSTID");
    }

    public String getDocId() {
        return (String)this.get("UUID");
    }

    public void setDocId(Long docId) {
        this.put("UUID", docId);
    }

    public String getIndexId() {
        return (String)this.get("INDEX_NAME");
    }

    public void setIndexId(String indexId) {
        this.put("INDEX_NAME", indexId);
    }

    public String getAccesses() {
        return (String)this.get("ACCESSES");
    }

    public String getProfile() {
        return (String)this.get("PROFILENAME");
    }

    public String getProfileType() {
        return (String)this.get("PROFILETYPE");
    }

    public String getProfileVal() {
        return (String)this.get("PROFILEVAL");
    }

    public String getRuleName() {
        return (String)this.get("RULENAME");
    }

    public String getRuleId() {
        return (String)this.get("RULEID");
    }

    public String getAccessRight() {
        return (String)this.get("ACCESSRIGHT");
    }

    public String getChanges() {
        return (String)this.get("CHANGES");
    }

    public String getCategory() {
        return (String)this.get("CATEGORY");
    }

    public String getSubCategory() {
        return (String)this.get("SUBCATEGORY");
    }

    public String getPrevVal() {
        return (String)this.get("PREVVAL");
    }

    public String getServiceName() {
        return (String)this.get("SERVICENAME");
    }

    public String getServiceType() {
        return (String)this.get("SERVICETYPE");
    }

    public String getServiceStartType() {
        return (String)this.get("SERVICESTARTTYPE");
    }

    public String getServiceAccount() {
        return (String)this.get("SERVICEACCOUNT");
    }

    private int unpacki16(short[] data, int index) {
        return (short)(0xFF & data[index]) << 8 | (short)(0xFF & data[index + 1]);
    }

    private long unpacki32(short[] data, int index) {
        return (0xFF & data[index]) << 24 | (0xFF & data[index + 1]) << 16 | (0xFF & data[index + 2]) << 8 | 0xFF & data[index + 3];
    }

    private long unpacki64(short[] data, int index) {
        long ret = 0L;
        for (int i = 7; i >= 0; --i) {
            ret |= (long)(0xFF & data[index + (7 - i)]) << 8 * i;
        }
        return ret;
    }

    private byte[] getByteArray(short[] data, int index, int length) {
        byte[] bArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            bArray[i] = (byte)data[i + index];
        }
        return bArray;
    }

    private void getFieldList(String hostType, int category) {
    }

    private void checkForSQLServerCIM() {
        String message;
        if (LogSourceCategoryContainer.DeviceCategory.WINDOWS == LogSourceCategoryContainer.DeviceCategory.getCategory(this.getType()) && this.getEventId() != null && this.getEventId() == 17061L && (message = (String)this.get("MESSAGE")) != null) {
            HashMap map = MSSQLLog.getAdditionalFieldsForMSSQLServer(message);
            this.putAll(map);
        }
    }
}

