/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.lc;

import com.adventnet.logsearch.LogSearchException;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.sa.server.lc.FieldRepository;
import com.adventnet.sa.server.lc.Log;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.Field;

public class LogBuffer {
    private static final Logger LOGGER = Logger.getLogger(LogBuffer.class.getName());
    private static final String FIELD_SEPARATOR = LogIndexingAPI.getInstance().getFieldDelimiter();
    private static final String RECORD_SEPARATOR = LogIndexingAPI.getInstance().getLineDelimiter();
    private static final String MSG_SEPARATOR = LogIndexingAPI.getInstance().getMsgDelimiter();
    private String type = null;
    private Long hostId = null;
    private String hostName = null;
    private Long appId = null;
    private Long formatId = null;
    private List indexFields = null;
    private int previousDate = 0;
    private Field[] luceneFields = null;
    private StringBuffer logBuffer = new StringBuffer();
    private StringBuffer msgBuffer = new StringBuffer();
    private LogIndexingAPI indexer = LogIndexingAPI.getInstance();
    private int recordCount = 0;
    private long batchStartTime = 0L;
    private long batchEndTime = 0L;
    private Object syncObj = new Object();

    public LogBuffer(String type, Long hostId, String hostName, Long appId, Long formatId) {
        this.type = type.toLowerCase();
        this.hostName = hostName.toLowerCase();
        this.indexFields = FieldRepository.get_instance().getIndexFields(type);
        if (type.equalsIgnoreCase("Oracle") || type.equalsIgnoreCase("Printer")) {
            this.appId = appId;
            this.formatId = formatId;
            this.initAppLuceneFields();
        } else {
            this.hostId = hostId;
            this.initLuceneFields();
        }
        this.indexer.getFieldDelimiter();
    }

    private void initLuceneFields() {
        Field hostId = new Field("HOSTID", this.hostId.toString(), Field.Store.YES, Field.Index.ANALYZED);
        Field hostName = new Field("HOSTNAME", this.hostName.toString(), Field.Store.YES, Field.Index.ANALYZED);
        Field hostType = new Field("HOSTTYPE", this.type, Field.Store.YES, Field.Index.ANALYZED);
        this.luceneFields = new Field[]{hostType, hostId, hostName, null};
    }

    private void initAppLuceneFields() {
        Field appId = new Field("APPID", this.appId.toString(), Field.Store.YES, Field.Index.ANALYZED);
        Field formatId = new Field("FORMATID", this.formatId.toString(), Field.Store.YES, Field.Index.ANALYZED);
        Field hostName = new Field("HOSTNAME", this.hostName.toString(), Field.Store.YES, Field.Index.ANALYZED);
        this.luceneFields = new Field[]{hostName, appId, formatId};
        this.luceneFields = this.type.equalsIgnoreCase("Printer") ? new Field[]{hostName, appId, formatId, null} : new Field[]{hostName, appId, formatId};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToBuffer(Log log) {
        LOGGER.log(Level.FINER, "Received Log" + log);
        int currentDate = (Integer)log.get("DATE");
        if (this.previousDate == 0) {
            this.previousDate = currentDate;
        }
        if (this.recordCount >= 250 || this.previousDate != currentDate) {
            this.updateIndex();
            this.previousDate = currentDate;
        }
        long timeInMillis = 0L;
        try {
            timeInMillis = (Long)log.get("TIME");
        }
        catch (ClassCastException e) {
            timeInMillis = Long.parseLong((String)log.get("TIME"));
        }
        if (this.batchStartTime == 0L) {
            this.batchStartTime = this.batchEndTime = timeInMillis;
        } else {
            this.batchEndTime = timeInMillis;
        }
        Object object = this.syncObj;
        synchronized (object) {
            for (int i = 0; i < this.indexFields.size(); ++i) {
                String field = (String)this.indexFields.get(i);
                this.logBuffer.append(log.get(field));
                this.logBuffer.append(FIELD_SEPARATOR);
            }
            this.logBuffer.append(RECORD_SEPARATOR);
        }
        if (!this.type.equalsIgnoreCase("oracle")) {
            this.msgBuffer.append(log.get("MESSAGE"));
            this.msgBuffer.append(MSG_SEPARATOR);
        }
        ++this.recordCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateIndex() {
        boolean isRecordPresent = false;
        if (this.recordCount > 0) {
            Object object = this.syncObj;
            synchronized (object) {
                try {
                    LOGGER.log(Level.FINE, "About to update index : " + this.batchStartTime + ", " + this.batchEndTime + ", " + this.recordCount);
                    if (this.recordCount > 0) {
                        if (this.type.equalsIgnoreCase("oracle")) {
                            this.indexer.updateDocToIndex(this.logBuffer.toString().toLowerCase(), "" + this.batchStartTime, "" + this.batchEndTime, this.luceneFields);
                        } else {
                            this.luceneFields[3] = new Field("MSGFIELD", this.msgBuffer.toString().toLowerCase(), Field.Store.YES, Field.Index.ANALYZED);
                            this.indexer.updateDocToIndex(this.logBuffer.toString().toLowerCase(), "" + this.batchStartTime, "" + this.batchEndTime, this.luceneFields);
                        }
                        isRecordPresent = true;
                    } else {
                        isRecordPresent = false;
                    }
                }
                catch (LogSearchException e) {
                    e.printStackTrace();
                    isRecordPresent = false;
                }
                finally {
                    this.init();
                }
            }
        }
        return isRecordPresent;
    }

    private void init() {
        this.logBuffer = null;
        this.logBuffer = new StringBuffer();
        this.batchStartTime = 0L;
        this.batchEndTime = 0L;
        this.recordCount = 0;
        if (!this.type.equalsIgnoreCase("oracle")) {
            this.msgBuffer = new StringBuffer();
            this.luceneFields[3] = null;
        }
    }

    public String toString() {
        return "Log Buffer for host: " + this.hostName;
    }
}

