/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.lc;

import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.sa.server.lc.Log;
import com.adventnet.sa.server.lc.LogBuffer;
import com.adventnet.sa.server.lc.RecordStore;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogBufferRepository {
    private static final Logger LOGGER = Logger.getLogger(LogBufferRepository.class.getName());
    private Hashtable typeLevelBuffer = null;
    private static LogBufferRepository instance = null;
    private ArrayList storeList = new ArrayList();
    private Object object = new Object();
    private Long appId = null;
    private Long formatId = null;

    private LogBufferRepository() {
        this.typeLevelBuffer = new Hashtable();
    }

    public static synchronized LogBufferRepository get_instance() {
        if (instance == null) {
            LOGGER.log(Level.INFO, "Creating LogBufferRepository instance");
            instance = new LogBufferRepository();
        }
        return instance;
    }

    public LogBuffer getLogBuffer(Log log) {
        Long hostId = (Long)log.get("HOSTID");
        String type = (String)log.get("HOSTTYPE");
        String hostName = (String)log.get("HOSTNAME");
        if (type.equalsIgnoreCase("Oracle") || type.equalsIgnoreCase("Printer")) {
            this.appId = (Long)log.get("APPID");
            this.formatId = (Long)log.get("FORMATID");
        } else {
            this.appId = new Long(0L);
            this.formatId = new Long(0L);
        }
        return this.getLogBuffer(type, hostId, hostName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogBuffer getLogBuffer(String type, Long hostId, String hostName) {
        if (this.typeLevelBuffer.containsKey(type)) {
            Hashtable hostLevelBuffer = (Hashtable)this.typeLevelBuffer.get(type);
            if (!hostLevelBuffer.containsKey(hostId)) {
                LOGGER.log(Level.INFO, "Adding new log buffer for type " + type + ", hostid " + hostId + ", appId " + this.appId + ", formatId " + this.formatId);
                Object object = this.object;
                synchronized (object) {
                    hostLevelBuffer.put(hostId, new LogBuffer(type, hostId, hostName, this.appId, this.formatId));
                }
            }
            return (LogBuffer)hostLevelBuffer.get(hostId);
        }
        Hashtable<Long, LogBuffer> hostLevelBuffer = new Hashtable<Long, LogBuffer>();
        Object object = this.object;
        synchronized (object) {
            LOGGER.log(Level.INFO, "Adding new log buffer for type " + type + ", hostid " + hostId + ", appId " + this.appId + ", formatId " + this.formatId);
            hostLevelBuffer.put(hostId, new LogBuffer(type, hostId, hostName, this.appId, this.formatId));
            LOGGER.log(Level.INFO, "Adding new hashtable for type " + type);
            this.typeLevelBuffer.put(type, hostLevelBuffer);
        }
        return (LogBuffer)hostLevelBuffer.get(hostId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAndFlushIndex() {
        LOGGER.log(Level.INFO, "Updating index from Buffer repository");
        boolean isRecordPresent = false;
        Object object = this.object;
        synchronized (object) {
            for (Hashtable hostLevelBuffer : this.typeLevelBuffer.values()) {
                for (LogBuffer logBuffer : hostLevelBuffer.values()) {
                    LOGGER.log(Level.FINE, logBuffer.toString());
                    isRecordPresent = logBuffer.updateIndex() || isRecordPresent;
                }
            }
        }
        if (isRecordPresent) {
            LOGGER.log(Level.INFO, "Flushing index");
            LogIndexingAPI.getInstance().fflush();
        }
    }

    public void shutdown() {
        this.updateAndFlushIndex();
    }

    public ArrayList getStoreList() {
        return this.storeList;
    }

    public void addStoreList(RecordStore store) {
        this.storeList.add(store);
    }
}

