/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.lc;

import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.sa.server.lc.FieldRepository;
import com.adventnet.sa.server.lc.UploadUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogDataIndexer {
    private static final Logger LOGGER = Logger.getLogger(LogDataIndexer.class.getName());
    private static final List APPL_DEFAULT_FIELDS = Arrays.asList("HOSTNAME", "APPID", "FORMATID");
    private static final List NON_APPL_DEFAULT_FIELDS = Arrays.asList("HOSTNAME", "HOSTID", "HOSTTYPE");
    private static LogDataIndexer indexerObj = null;
    private long timeTakenForIndexing = 0L;
    private int indexerLogCount = 0;
    private int indexLoggerMaxCount = Integer.parseInt(System.getProperty("indexLoggerLimit", "20000"));

    private LogDataIndexer() {
    }

    public static synchronized LogDataIndexer getInstance() {
        if (indexerObj == null) {
            indexerObj = new LogDataIndexer();
        }
        return indexerObj;
    }

    public void indexLogData(Hashtable log) {
        List typeBasedFields;
        Object formatId;
        Hashtable map = new Hashtable();
        if (log.containsKey("$id$")) {
            map.put("$id$", log.get("$id$"));
        }
        if (log.get("TIME") == null) {
            log.put("TIME", System.currentTimeMillis());
        }
        String type = (String)log.get("HOSTTYPE");
        String msg = (String)log.get("MESSAGE");
        String msgKey = "MSGFIELD";
        if (type == null) {
            formatId = log.get("FORMATID");
            if (formatId == null) {
                LOGGER.log(Level.WARNING, "In LogDataIndexer, both HOSTTYPE & FORMATID are null. I'm going to consider this as Unix type");
                this.putDataToMap(NON_APPL_DEFAULT_FIELDS, log, map);
                type = "Unix";
            } else {
                type = formatId.toString();
                this.putDataToMap(APPL_DEFAULT_FIELDS, log, map);
                msgKey = "RAWLOG";
            }
        }
        if ("Oracle".equalsIgnoreCase(type) || "Printer".equalsIgnoreCase(type) || "MSSQL".equalsIgnoreCase(type) || "Terminal".equalsIgnoreCase(type) || "PMP".equalsIgnoreCase(type) || "OPM".equalsIgnoreCase(type)) {
            formatId = log.get("FORMATID");
            if (formatId != null) {
                type = formatId.toString();
            }
            this.putDataToMap(APPL_DEFAULT_FIELDS, log, map);
            msgKey = "RAWLOG";
        } else {
            this.putDataToMap(NON_APPL_DEFAULT_FIELDS, log, map);
        }
        if (msg != null) {
            map.put(msgKey, msg);
        }
        if ((typeBasedFields = FieldRepository.get_instance().getIndexedFields(type)) != null) {
            ArrayList<String> typeBasedFields_Copy = new ArrayList<String>(typeBasedFields);
            typeBasedFields_Copy.remove("MESSAGE");
            this.putDataToMap(typeBasedFields_Copy, log, map);
        }
        if ("FIM".equals(type)) {
            String serverTime = "SERVERTIME";
            map.put(serverTime, System.currentTimeMillis());
        }
        if (!map.isEmpty()) {
            ++this.indexerLogCount;
            long start = System.currentTimeMillis();
            map.remove("MESSAGE");
            LogIndexingAPI.getInstance().indexRecord(map);
            this.timeTakenForIndexing += System.currentTimeMillis() - start;
            if (this.indexerLogCount == this.indexLoggerMaxCount) {
                LOGGER.log(Level.INFO, "Time taken for indexing {0} logs <-> {1} msec", new Object[]{this.indexerLogCount, this.timeTakenForIndexing});
                this.indexerLogCount = 0;
                this.timeTakenForIndexing = 0L;
            }
            UploadUtils.uploadLogs(map);
            try {
                log.put("UUID", map.get("UUID"));
                log.put("INDEX_NAME", map.get("INDEX_NAME"));
            }
            catch (Exception ee) {
                LOGGER.log(Level.FINER, ee.getMessage());
            }
        }
    }

    private void putDataToMap(List<String> defaultFields, Hashtable log, Map map) {
        if (defaultFields.size() < log.size()) {
            for (String fName : defaultFields) {
                Object fValue = log.get(fName);
                if (fValue == null) continue;
                map.put(fName, fValue);
            }
        } else {
            HashMap temp = new HashMap(log);
            temp.keySet().retainAll(defaultFields);
            map.putAll(temp);
        }
        if ("true".equals(log.remove("IndexAll"))) {
            map.putAll(log);
        }
    }
}

