/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.lc;

import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.lc.Log;
import com.adventnet.sa.server.lc.LogDataIndexer;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.univlogparser.SyslogHandler;
import com.adventnet.sa.server.univlogparser.SyslogHandlerInitializer;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilter;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecordReader {
    private static Logger logger = Logger.getLogger(RecordReader.class.toString());
    private ArchiveFileManager afManager = ArchiveFileManager.getInstance();
    private NotificationManager nfManager = NotificationManager.getInstance();
    private SyslogHandler sHandler = SyslogHandlerInitializer.getInstance().getNewSyslogHandler();
    private LogForwarderFilter logforwarder = LogForwarderFilter.getInstance();
    private Log log = new Log();

    public void processLogs(Hashtable<String, Object> paramMap) {
        this.callHandlers(paramMap);
    }

    public void processLogs(byte[] data) {
        this.log.putData(data, 0);
        if (this.log.parseLog()) {
            this.callHandlers(this.log);
        } else {
            this.log.clear();
        }
    }

    private void callHandlers(Hashtable log) {
        try {
            this.sHandler.parseLog((String)log.get("HOSTNAME"), (Integer)log.get("SOURCEPORT") + "", log);
            LogDataIndexer.getInstance().indexLogData(log);
        }
        catch (Exception ee) {
            logger.log(Level.INFO, "Log Print : {0}", log.toString());
            ee.printStackTrace();
        }
        try {
            this.logforwarder.filterAndForward(log);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.afManager.archiveLog(log);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        this.nfManager.notify((Hashtable)log.clone());
        log.clear();
    }
}

