/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.lc;

import com.adventnet.sa.server.EAService;
import com.adventnet.sa.server.lc.RecordReader;
import com.zoho.za.commons.persistence.queue.PersistedByteQueue;
import com.zoho.za.dae.utils.DAEUtils;
import com.zoho.za.dae.utils.ElasticUtils;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecordStore {
    private static Logger logger = Logger.getLogger(RecordStore.class.toString());
    private static PersistedByteQueue persistedQueue;
    private static DataPoller dataPoller;
    private static DataPoller[] dynamicDataPoller;
    private static ScheduledFuture<?> dataPollerScheduledFuture;
    private static ScheduledFuture<?>[] dynamicDataPollerScheduledFuture;
    private static ScheduledExecutorService dynamicDataPollerIncreasingScheduler;
    private static ScheduledExecutorService dataPollerScheduler;
    private static ScheduledExecutorService dynamicDataPollerScheduler;
    private static ScheduledFuture dynamicDataPollerIncreasingSchedulerHandler;
    private static boolean destroyDynamicDataPoller;
    private static int threadCount;
    private static int dynamicDataPollerCreationCount;

    public static void init() {
        logger.log(Level.INFO, "data poller object inited with static count of 1");
        PersistedByteQueue.QUEUETYPE type = PersistedByteQueue.QUEUETYPE.MEMORY;
        persistedQueue = new PersistedByteQueue(".." + File.separator + "ES", "CachedRecord", 51200000, type);
        dataPoller = new DataPoller();
        dataPollerScheduledFuture = DAEUtils.getScheduledExecutorService().scheduleWithFixedDelay(dataPoller, 10000L, 1000L, TimeUnit.MILLISECONDS);
        DynamicDataPollerScheduler.init();
    }

    public static void destroy() {
        try {
            dataPollerScheduledFuture.cancel(true);
            dataPoller.Close();
            if (destroyDynamicDataPoller && dynamicDataPollerCreationCount != 0) {
                for (int dynamicDataPollerThreadCount = 0; dynamicDataPollerThreadCount < dynamicDataPollerCreationCount - 1; ++dynamicDataPollerThreadCount) {
                    logger.log(Level.INFO, "data poller object destroying dynamic objects with thread count = " + dynamicDataPollerThreadCount);
                    dynamicDataPollerScheduledFuture[dynamicDataPollerThreadCount].cancel(true);
                    dynamicDataPoller[dynamicDataPollerThreadCount].Close();
                }
            }
            persistedQueue.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void storeRecord(byte[] data) {
        if (data != null && data.length > 0) {
            persistedQueue.enqueue(data);
        }
    }

    static /* synthetic */ DataPoller[] access$302(DataPoller[] x0) {
        dynamicDataPoller = x0;
        return x0;
    }

    static /* synthetic */ ScheduledFuture[] access$402(ScheduledFuture[] x0) {
        dynamicDataPollerScheduledFuture = x0;
        return x0;
    }

    static {
        dynamicDataPollerIncreasingScheduler = Executors.newScheduledThreadPool(1);
        dataPollerScheduler = null;
        dynamicDataPollerScheduler = null;
        dynamicDataPollerIncreasingSchedulerHandler = null;
        destroyDynamicDataPoller = false;
        threadCount = 1;
        dynamicDataPollerCreationCount = 0;
    }

    private static class DataPoller
    implements Runnable {
        private RecordReader recordReader = new RecordReader();
        private AtomicBoolean stopFlag = new AtomicBoolean(false);
        private boolean indexTemplateUpdated;

        private DataPoller() {
        }

        public void Close() {
            this.stopFlag.set(true);
        }

        @Override
        public void run() {
            try {
                if (!this.indexTemplateUpdated) {
                    this.indexTemplateUpdated = ElasticUtils.updateIndicesTemplate();
                    if (!this.indexTemplateUpdated) {
                        logger.severe("Index Template update failed. data polling skipped!");
                        return;
                    }
                    logger.info("Index Template updated.");
                }
                while (!this.stopFlag.get() && !persistedQueue.isEmpty()) {
                    byte[] data = persistedQueue.dequeue();
                    if (data == null) continue;
                    try {
                        this.recordReader.processLogs(data);
                    }
                    catch (ClassCastException e) {
                        logger.severe(e.getMessage());
                        logger.log(Level.FINE, "exception while process dump logs", e);
                    }
                }
                if (this.stopFlag.get()) {
                    logger.info("stop flag enable. data poller stopped!");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private static class DynamicDataPollerScheduler
    implements Runnable {
        private DynamicDataPollerScheduler() {
        }

        @Override
        public void run() {
            logger.info("dynamic thread increase called");
            String maxThread = System.getProperty("DataPoller_MaxThread", "2");
            String cachedRecordLimit = System.getProperty("DataPoller_CachedRecordCount", "30");
            int maxThreadCount = 2;
            int cachedRecordLimitCount = 30;
            try {
                maxThreadCount = Integer.parseInt(maxThread);
            }
            catch (Exception ex) {
                logger.info("Exception while getting maxThread : " + ex.getMessage());
            }
            try {
                cachedRecordLimitCount = Integer.parseInt(cachedRecordLimit);
            }
            catch (Exception ex) {
                logger.info("Exception while getting cachedRecordLimit : " + ex.getMessage());
            }
            int cachedRecordCount = 0;
            try {
                cachedRecordCount = new File(DAEUtils.DAE_FOLDER_PATH + File.separator + "CachedRecord").list().length;
            }
            catch (Exception e) {
                logger.info("Exception while getting cachedRecordCount : " + e.getMessage());
            }
            if (dynamicDataPollerCreationCount < maxThreadCount && cachedRecordCount >= cachedRecordLimitCount) {
                int dynamicDataPollerBasedOnCachedRecord = cachedRecordCount / cachedRecordLimitCount;
                logger.log(Level.INFO, "data poller object going to be inited with dynamic thread count based on cachedRecord count " + cachedRecordCount + " and factor : " + dynamicDataPollerBasedOnCachedRecord);
                if (dynamicDataPollerBasedOnCachedRecord + dynamicDataPollerCreationCount >= maxThreadCount) {
                    for (int dynamicDataPollerBasedOnCachedRecordCounter = dynamicDataPollerCreationCount; dynamicDataPollerBasedOnCachedRecordCounter < maxThreadCount; ++dynamicDataPollerBasedOnCachedRecordCounter) {
                        logger.log(Level.INFO, "data poller object creating dynamic objects with thread count = " + dynamicDataPollerBasedOnCachedRecordCounter);
                        dynamicDataPoller[dynamicDataPollerBasedOnCachedRecordCounter] = new DataPoller();
                        dynamicDataPollerScheduledFuture[dynamicDataPollerBasedOnCachedRecordCounter] = dynamicDataPollerScheduler.scheduleWithFixedDelay(dynamicDataPoller[dynamicDataPollerBasedOnCachedRecordCounter], 10000L, 1000L, TimeUnit.MILLISECONDS);
                    }
                    dynamicDataPollerCreationCount = maxThreadCount;
                } else if (dynamicDataPollerBasedOnCachedRecord + dynamicDataPollerCreationCount < maxThreadCount) {
                    for (int dynamicDataPollerBasedOnCachedRecordCounter = dynamicDataPollerCreationCount; dynamicDataPollerBasedOnCachedRecordCounter < dynamicDataPollerBasedOnCachedRecord + dynamicDataPollerCreationCount; ++dynamicDataPollerBasedOnCachedRecordCounter) {
                        logger.log(Level.INFO, "data poller object creating dynamic objects with thread count = " + dynamicDataPollerBasedOnCachedRecordCounter);
                        dynamicDataPoller[dynamicDataPollerBasedOnCachedRecordCounter] = new DataPoller();
                        dynamicDataPollerScheduledFuture[dynamicDataPollerBasedOnCachedRecordCounter] = dynamicDataPollerScheduler.scheduleWithFixedDelay(dynamicDataPoller[dynamicDataPollerBasedOnCachedRecordCounter], 10000L, 1000L, TimeUnit.MILLISECONDS);
                    }
                    dynamicDataPollerCreationCount = dynamicDataPollerBasedOnCachedRecord + dynamicDataPollerCreationCount;
                }
                destroyDynamicDataPoller = true;
            } else if (cachedRecordCount == 0) {
                if (destroyDynamicDataPoller && dynamicDataPollerCreationCount != 0) {
                    for (int dynamicDataPollerThreadCount = 0; dynamicDataPollerThreadCount < dynamicDataPollerCreationCount; ++dynamicDataPollerThreadCount) {
                        logger.log(Level.INFO, "data poller object destroying dynamic objects with thread count = " + dynamicDataPollerThreadCount + ".. since cachedRecordCount is zero");
                        dynamicDataPollerScheduledFuture[dynamicDataPollerThreadCount].cancel(true);
                        dynamicDataPoller[dynamicDataPollerThreadCount].Close();
                    }
                }
                destroyDynamicDataPoller = false;
                dynamicDataPollerCreationCount = 0;
            }
            if (cachedRecordCount >= cachedRecordLimitCount * maxThreadCount && System.getProperty("CachedRecordMail") == null) {
                try {
                    logger.info("Sending mail to user for cachedRecord >= " + cachedRecordLimitCount * maxThreadCount);
                    EAService.getInstance().sendMail("CachedRecordGrowth");
                }
                catch (Exception ece) {
                    logger.info("Exception while sending mail:" + ece.getMessage());
                }
            }
        }

        public static void init() {
            String maxThread = System.getProperty("DataPoller_MaxThread", "4");
            String timing = System.getProperty("DataPoller_DynamicTiming", "300");
            int maxThreadCount = 4;
            int schedulerTiming = 300;
            try {
                maxThreadCount = Integer.parseInt(maxThread);
                schedulerTiming = Integer.parseInt(timing);
            }
            catch (Exception ex) {
                logger.info("Exception while getting maxThread : " + ex.getMessage());
            }
            RecordStore.access$302(new DataPoller[maxThreadCount]);
            dynamicDataPollerScheduler = DAEUtils.getScheduledExecutorService((int)maxThreadCount);
            RecordStore.access$402(new ScheduledFuture[maxThreadCount]);
            dynamicDataPollerIncreasingSchedulerHandler = dynamicDataPollerIncreasingScheduler.scheduleAtFixedRate(new DynamicDataPollerScheduler(), 0L, schedulerTiming, TimeUnit.SECONDS);
            logger.info("Dynamic schedule started");
        }
    }
}

