/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.lc;

import com.adventnet.la.util.dm.DataManagement;
import com.adventnet.mfw.service.Service;
import com.adventnet.mfw.service.ServiceUtil;
import com.adventnet.sa.server.lc.RecordStore;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import com.manageengine.ela.server.logflowrate.LogCountHolder;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyslogServer
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(SyslogServer.class.getName());
    private static final int SYS_BUF_SZ = 7168;
    private static final int EVT_BUF_SZ = 15360;
    private static final int APP_BUF_SZ = 7168;
    private int port = 5000;
    private static AtomicLong logCount = new AtomicLong(0L);
    private DatagramChannel channel = null;
    private DatagramSocket socket = null;
    private ByteBuffer buffer = null;
    private boolean running = false;
    private int bufSize = 15360;
    private long firstLogReceivedTime = -1L;
    private static boolean handleHighFlow = false;
    private static LogCountHolder logCountHolder = LogCountHolder.getJvmHolder();
    private static long currentLogCount = 0L;

    public SyslogServer(int port) {
        this.port = port;
        this.bufSize = System.getProperty("sysPort", "5000").equals(port) ? 7168 : 15360;
        this.bufSize = System.getProperty("orclPort", "5002").equals(port) ? 7168 : this.bufSize;
        try {
            this.buffer = ByteBuffer.allocate(this.bufSize);
            int receiveBufferSize = 262144;
            if (handleHighFlow) {
                receiveBufferSize = 0x100000;
            }
            try {
                this.channel = DatagramChannel.open();
                InetAddress addr = null;
                try {
                    addr = InetAddressHandler.getInetAddress(System.getProperty("socketIP", new StringBuffer(10).append("127").append(".").append("0").append(".").append("0").append(".").append("1").toString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                InetSocketAddress socketAddr = addr != null ? new InetSocketAddress(addr, port) : new InetSocketAddress(port);
                this.socket = this.channel.socket();
                this.socket.bind(socketAddr);
                this.socket.setReceiveBufferSize(receiveBufferSize);
                this.channel.configureBlocking(true);
            }
            catch (IOException ex) {
                Logger.getLogger(SyslogServer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.running = true;
        this.start();
    }

    public void stopServer() {
        this.running = false;
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SyslogServer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.socket != null) {
            this.socket.close();
        }
        LOGGER.info("Shutting down socket for port " + this.port);
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                this.fetchLog();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void resetlogCounter() {
        logCount.set(0L);
    }

    public static long getLogCount() {
        return logCount.get();
    }

    public static long getCurrentLogCount() {
        return currentLogCount;
    }

    private void fetchLog() {
        try {
            SocketAddress socAddr = this.channel.receive(this.buffer);
            if (socAddr == null) {
                return;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.buffer.clear();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.buffer.clear();
            return;
        }
        if (this.firstLogReceivedTime == -1L) {
            this.firstLogReceivedTime = System.currentTimeMillis();
        }
        try {
            int dataLen = this.bufSize - this.buffer.remaining();
            byte[] pktArray = this.buffer.array();
            int pktLen = (short)(0xFF & (short)pktArray[0]) << 8 | (short)(0xFF & (short)pktArray[1]);
            if (pktLen > dataLen) {
                LOGGER.log(Level.INFO, "Stray packet. Returning false");
                this.buffer.clear();
                return;
            }
            logCount.incrementAndGet();
            currentLogCount = logCountHolder.increment();
            if (dataLen == 5) {
                byte[] dataTmp = this.buffer.array();
                short[] shortdata = new short[dataLen];
                for (int i = 0; i < dataLen; ++i) {
                    shortdata[i] = dataTmp[i];
                }
                LOGGER.log(Level.FINER, "Might be a Trigger Signal.. DataLen = {0} and data[4] = {1}", new Object[]{dataLen, shortdata[4]});
                if (shortdata[4] == 0) {
                    this.buffer.clear();
                    SyslogServer.executeTaskGroups(new String[]{"EventTrend-1"});
                    return;
                }
            }
            byte[] data = Arrays.copyOfRange(this.buffer.array(), 0, dataLen);
            RecordStore.storeRecord(data);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        this.buffer.clear();
    }

    private static synchronized void executeTaskGroups(String[] array) {
        if (array == null) {
            return;
        }
        try {
            List<String> taskGroups = Arrays.asList(array);
            Service service = ServiceUtil.lookup((String)"DataManagement");
            DataManagement dmService = (DataManagement)service;
            dmService.executeTaskGroups(taskGroups);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    static {
        if (Integer.parseInt(System.getProperty("maxFlowRate", "5000")) > 5000) {
            System.setProperty("handleHighFlow", "true");
            handleHighFlow = true;
        }
    }
}

