/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.lc;

import com.adventnet.logsearch.index.util.LogSearchUtils;
import com.zoho.log360.agent.service.AgentService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class UploadUtils {
    private static final Logger LOGGER = Logger.getLogger(UploadUtils.class.getName());
    private static final String LOGTYPE_FIELDNAME = "HOSTTYPE";
    private static final HashSet<String> UNWANTED_UPLOAD_FIELDS = new HashSet<String>(Arrays.asList("TIME", "SEVERITY", "INDEX_NAME", "UUID"));
    private static final String DEFAULT_MESSAGE_FIELD_NAME = "MESSAGE";
    private static final HashSet<String> MESSAGE_FIELDS = new HashSet<String>(Arrays.asList("MESSAGE", "MSGFIELD", "RAWLOG"));

    public static void uploadLogs(Map log) {
        if (AgentService.isRunning()) {
            try {
                JSONObject jsonObject = new JSONObject();
                if (log.containsKey("SEVERITY")) {
                    Object logType = log.get(LOGTYPE_FIELDNAME);
                    boolean isWindows = logType != null && logType.toString().toLowerCase().contains("windows");
                    Object severityValue = log.get("SEVERITY");
                    Object severityString = LogSearchUtils.convertToSeverityString(severityValue, (boolean)isWindows);
                    if (severityString != null) {
                        jsonObject.put("SEVERITY", severityString);
                    }
                }
                if (log.containsKey("TIME")) {
                    jsonObject.put("_zl_timestamp", log.get("TIME"));
                }
                for (Map.Entry entry : log.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value == null || "-".equals(value) || UNWANTED_UPLOAD_FIELDS.contains(key)) continue;
                    if (MESSAGE_FIELDS.contains(key)) {
                        jsonObject.put(DEFAULT_MESSAGE_FIELD_NAME, value);
                        continue;
                    }
                    jsonObject.put((String)entry.getKey(), (Object)value.toString().toLowerCase());
                }
                AgentService.push((JSONObject)jsonObject);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "exception while pushing the log " + log + " to upload queue", e);
            }
        }
    }
}

