/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.lc;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.lc.Log;
import com.adventnet.sa.server.lc.LogDataIndexer;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.vmware.vim25.ClusterEvent;
import com.vmware.vim25.ClusterStatusChangedEvent;
import com.vmware.vim25.DatacenterCreatedEvent;
import com.vmware.vim25.DatacenterEvent;
import com.vmware.vim25.DatacenterRenamedEvent;
import com.vmware.vim25.DatastoreCapacityIncreasedEvent;
import com.vmware.vim25.DatastoreEvent;
import com.vmware.vim25.DatastoreFileCopiedEvent;
import com.vmware.vim25.DatastoreFileDeletedEvent;
import com.vmware.vim25.DatastoreFileMovedEvent;
import com.vmware.vim25.DatastorePrincipalConfigured;
import com.vmware.vim25.DatastoreRenamedEvent;
import com.vmware.vim25.DatastoreRenamedOnHostEvent;
import com.vmware.vim25.Event;
import com.vmware.vim25.EventFilterSpec;
import com.vmware.vim25.EventFilterSpecByTime;
import com.vmware.vim25.FolderEventArgument;
import com.vmware.vim25.HostCnxFailedAlreadyManagedEvent;
import com.vmware.vim25.HostDisconnectedEvent;
import com.vmware.vim25.HostEvent;
import com.vmware.vim25.HostInventoryFullEvent;
import com.vmware.vim25.HostIpChangedEvent;
import com.vmware.vim25.HostIpInconsistentEvent;
import com.vmware.vim25.HostIsolationIpPingFailedEvent;
import com.vmware.vim25.HostMonitoringStateChangedEvent;
import com.vmware.vim25.HostNoAvailableNetworksEvent;
import com.vmware.vim25.HostShortNameInconsistentEvent;
import com.vmware.vim25.HostShutdownEvent;
import com.vmware.vim25.HostStatusChangedEvent;
import com.vmware.vim25.HostSyncFailedEvent;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.PermissionAddedEvent;
import com.vmware.vim25.PermissionEvent;
import com.vmware.vim25.PermissionRemovedEvent;
import com.vmware.vim25.PermissionUpdatedEvent;
import com.vmware.vim25.ResourcePoolCreatedEvent;
import com.vmware.vim25.ResourcePoolDestroyedEvent;
import com.vmware.vim25.ResourcePoolEvent;
import com.vmware.vim25.ResourcePoolMovedEvent;
import com.vmware.vim25.ResourcePoolReconfiguredEvent;
import com.vmware.vim25.RoleAddedEvent;
import com.vmware.vim25.RoleEvent;
import com.vmware.vim25.RoleRemovedEvent;
import com.vmware.vim25.RoleUpdatedEvent;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskFilterSpec;
import com.vmware.vim25.TaskFilterSpecByTime;
import com.vmware.vim25.TaskFilterSpecTimeOption;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.TaskReason;
import com.vmware.vim25.TaskReasonUser;
import com.vmware.vim25.VmAcquiredTicketEvent;
import com.vmware.vim25.VmAutoRenameEvent;
import com.vmware.vim25.VmBeingClonedEvent;
import com.vmware.vim25.VmBeingClonedNoFolderEvent;
import com.vmware.vim25.VmBeingDeployedEvent;
import com.vmware.vim25.VmBeingHotMigratedEvent;
import com.vmware.vim25.VmBeingMigratedEvent;
import com.vmware.vim25.VmBeingRelocatedEvent;
import com.vmware.vim25.VmCloneFailedEvent;
import com.vmware.vim25.VmClonedEvent;
import com.vmware.vim25.VmDeployFailedEvent;
import com.vmware.vim25.VmDeployedEvent;
import com.vmware.vim25.VmDiskFailedEvent;
import com.vmware.vim25.VmEvent;
import com.vmware.vim25.VmFailedMigrateEvent;
import com.vmware.vim25.VmFailedRelayoutEvent;
import com.vmware.vim25.VmFailedStartingSecondaryEvent;
import com.vmware.vim25.VmFailedToPowerOffEvent;
import com.vmware.vim25.VmFailedToPowerOnEvent;
import com.vmware.vim25.VmFailedToRebootGuestEvent;
import com.vmware.vim25.VmFailedToResetEvent;
import com.vmware.vim25.VmFailedToShutdownGuestEvent;
import com.vmware.vim25.VmFailedToStandbyGuestEvent;
import com.vmware.vim25.VmFailedToSuspendEvent;
import com.vmware.vim25.VmFaultToleranceStateChangedEvent;
import com.vmware.vim25.VmFaultToleranceVmTerminatedEvent;
import com.vmware.vim25.VmHealthMonitoringStateChangedEvent;
import com.vmware.vim25.VmMigratedEvent;
import com.vmware.vim25.VmNoNetworkAccessEvent;
import com.vmware.vim25.VmPrimaryFailoverEvent;
import com.vmware.vim25.VmRenamedEvent;
import com.vmware.vim25.VmResourcePoolMovedEvent;
import com.vmware.vim25.VmRestartedOnAlternateHostEvent;
import com.vmware.vim25.VmStaticMacConflictEvent;
import com.vmware.vim25.mo.EventHistoryCollector;
import com.vmware.vim25.mo.EventManager;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.TaskHistoryCollector;
import com.vmware.vim25.mo.TaskManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VCenterTaskScheduler
implements Task {
    private static final Logger LOGGER = Logger.getLogger(VCenterTaskScheduler.class.getName());
    private static final String APIFOLDER = "sdk";
    private static HashMap<String, String> sessionMap = new HashMap();
    private Long hostId = null;
    private String hostName = null;
    private String dnsName = null;
    private String hostType = null;
    private String userName = null;
    private String password = null;
    private final SimpleDateFormat hourDf = new SimpleDateFormat("yyyy-MM-dd HH:00:00");
    private String str_last_msg_time = null;
    private Long mon_interval;
    private String protocol = null;
    private ServiceInstance serverInstance = null;
    private String serviceURL = null;
    private int port;
    private TaskManager taskManager = null;
    private EventManager eventManager = null;
    private TaskHistoryCollector taskCollector = null;
    private EventHistoryCollector eventCollector = null;
    private Calendar startDate = null;
    private Calendar endDate = null;
    private final NotificationManager notifyManager = NotificationManager.getInstance();
    private static VCenterTaskScheduler instance = null;
    private static HashMap<String, String> eventSevMap = new HashMap();

    public static synchronized VCenterTaskScheduler getInstance() {
        if (instance == null) {
            instance = new VCenterTaskScheduler();
        }
        return instance;
    }

    public void executeTask(TaskContext context) throws TaskExecutionException {
        try {
            if ("false".equals(System.getProperty("isPremium", "false"))) {
                LOGGER.log(Level.INFO, "Not a premium User");
                return;
            }
            LOGGER.log(Level.INFO, "vCenter Scheduled Task is Started");
            DataObject taskInputDO = context.getTaskInputDO();
            if (taskInputDO != null) {
                Long scheduleId = (Long)taskInputDO.getFirstValue("Task_Input", "SCHEDULE_ID");
                DataObject scheduleDO = DataAccess.get((String)"Schedule", (Criteria)new Criteria(new Column("Schedule", "SCHEDULE_ID"), (Object)scheduleId, 0));
                String scheduleName = (String)scheduleDO.getFirstValue("Schedule", "SCHEDULE_NAME");
                this.fetchvCenterLogs(scheduleName.substring(0, scheduleName.indexOf("_vCenterSchedule")));
            } else {
                LOGGER.log(Level.INFO, "Unable to run the schedule", context);
            }
            LOGGER.info("vCenter Scheduled Task is finished for Host " + this.hostName);
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Exception occured during the task");
            exp.printStackTrace();
        }
    }

    public static void clearCache(String hostname) {
    }

    public void fetchvCenterLogs(String host) {
        this.hostName = host;
        long next_scan_time = 0L;
        try {
            String[] host_id = new String[]{"HOST_ID"};
            SelectQueryImpl hostSql = new SelectQueryImpl(new Table("AddOnHosts"));
            hostSql.addSelectColumn(new Column("AddOnHosts", "*"));
            hostSql.addSelectColumn(new Column("AddOnHostDetails", "*"));
            hostSql.addJoin(new Join(new Table("AddOnHosts"), new Table("AddOnHostDetails"), host_id, host_id, 1));
            hostSql.setCriteria(new Criteria(new Column("AddOnHosts", "DNS_NAME"), (Object)this.hostName, 0));
            DataObject hostDO = DataAccess.get((SelectQuery)hostSql);
            Row hostRow = hostDO.getFirstRow("AddOnHosts");
            Row hostDetailsRow = hostDO.getFirstRow("AddOnHostDetails");
            this.hostId = (Long)hostRow.get("HOSTID");
            this.dnsName = (String)hostRow.get("DNS_NAME");
            this.hostType = (String)hostDetailsRow.get("HOST_TYPE");
            this.userName = (String)hostDetailsRow.get("USERNAME");
            this.password = EnDecryptImplSingleton.getInstance().decrypt((String)hostDetailsRow.get("PASSWORD"));
            this.mon_interval = (Long)hostDetailsRow.get("MON_INTERVAL");
            this.str_last_msg_time = (String)hostDetailsRow.get("LAST_MSG_TIME");
            this.protocol = (String)hostDetailsRow.get("PROTOCOL");
            this.port = Integer.valueOf((String)hostDetailsRow.get("PORT"));
            long current_time = System.currentTimeMillis();
            next_scan_time = current_time + this.mon_interval * 60000L;
            try {
                if (this.fetchvCenterLogs()) {
                    hostDetailsRow.set("LOG_COLLECTION_STATUS", (Object)new Integer(1));
                } else {
                    hostDetailsRow.set("LOG_COLLECTION_STATUS", (Object)new Integer(2));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                hostDetailsRow.set("LOG_COLLECTION_STATUS", (Object)new Integer(2));
            }
            hostDetailsRow.set("NEXT_SCAN_TIME", (Object)Long.toString(next_scan_time));
            hostDetailsRow.set("LAST_MSG_TIME", (Object)this.str_last_msg_time);
            hostDO.updateRow(hostDetailsRow);
            DataAccess.update((DataObject)hostDO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean fetchvCenterLogs() throws Exception {
        this.setTime();
        if (this.initAll()) {
            this.fetchAllEvents();
            this.fetchAllTasks();
            return true;
        }
        return false;
    }

    private void setTime() {
        long last_msg_time = 0L;
        long logTime = Long.parseLong(System.getProperty("lastFetchTime", "1")) * 3600000L;
        if (this.str_last_msg_time != null && !"".equals(this.str_last_msg_time)) {
            last_msg_time = Long.parseLong(this.str_last_msg_time);
            last_msg_time = System.currentTimeMillis() - last_msg_time > logTime ? 0L : last_msg_time;
        }
        long start_time = last_msg_time != 0L ? last_msg_time : System.currentTimeMillis() - logTime;
        long end_time = System.currentTimeMillis();
        this.startDate = this.dateToCalendarConverter(new Date(start_time));
        this.endDate = this.dateToCalendarConverter(new Date(end_time));
        long lmtime = start_time;
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd yyyy HH:mm");
        cal.setTimeInMillis(lmtime);
        LOGGER.log(Level.INFO, "Schedule start time " + sdf.format(cal.getTime()));
        long lmtime1 = end_time;
        cal.setTimeInMillis(lmtime1);
        LOGGER.log(Level.INFO, "Schedule end time " + sdf.format(cal.getTime()));
    }

    private Calendar dateToCalendarConverter(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    private void createCollectors() throws Exception {
        this.taskManager = this.serverInstance.getTaskManager();
        this.eventManager = this.serverInstance.getEventManager();
        this.createEventHistoryCollector();
        this.createTaskHistoryCollector();
    }

    private boolean initAll() {
        boolean connectionSuccess = false;
        this.serviceURL = this.formURL(this.protocol, this.hostName, this.port);
        LOGGER.log(Level.INFO, "vCenter sessionMap : " + sessionMap);
        try {
            if (sessionMap.containsKey(this.serviceURL)) {
                try {
                    this.serverInstance = new ServiceInstance(new URL(this.serviceURL), sessionMap.get(this.serviceURL), true);
                    if (this.serverInstance != null) {
                        this.createCollectors();
                        connectionSuccess = true;
                    }
                }
                catch (InvalidState e) {
                    sessionMap.remove(this.serviceURL);
                    this.serverInstance.getServerConnection().logout();
                    LOGGER.log(Level.INFO, "vCenter session reached InvalidState");
                }
                catch (Exception e) {
                    sessionMap.remove(this.serviceURL);
                    e.printStackTrace();
                }
            }
            if (!connectionSuccess) {
                this.serverInstance = new ServiceInstance(new URL(this.serviceURL), this.userName, this.password, true);
                if (null != this.serverInstance) {
                    this.createCollectors();
                    connectionSuccess = true;
                }
                sessionMap.put(this.serviceURL, this.serverInstance.getServerConnection().getSessionStr());
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return connectionSuccess;
    }

    private void createTaskHistoryCollector() throws InvalidState, RuntimeFault, RemoteException {
        TaskFilterSpec taskFilter = new TaskFilterSpec();
        TaskFilterSpecByTime task = new TaskFilterSpecByTime();
        task.setBeginTime(this.startDate);
        task.setEndTime(this.endDate);
        task.setTimeType(TaskFilterSpecTimeOption.completedTime);
        taskFilter.setTime(task);
        this.taskCollector = this.taskManager.createCollectorForTasks(taskFilter);
        this.taskCollector.setCollectorPageSize(1000);
    }

    private void fetchAllTasks() {
        Hashtable<String, Object> tasksMap = null;
        block3: while (true) {
            try {
                block4: while (true) {
                    TaskInfo[] tasks;
                    if ((tasks = this.taskCollector.readNextTasks(50)) == null || tasks.length == 0) {
                        LOGGER.log(Level.INFO, "task count is empty");
                        break block3;
                    }
                    LOGGER.log(Level.INFO, "task count is " + tasks.length);
                    int i = 0;
                    while (true) {
                        if (i >= tasks.length) continue block4;
                        TaskInfo task = tasks[i];
                        tasksMap = this.parseTasks(task);
                        this.addLogToFile(tasksMap);
                        ++i;
                    }
                    break;
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private Hashtable<String, Object> parseTasks(TaskInfo task) {
        Hashtable<String, Object> tasksMap = new Hashtable<String, Object>();
        try {
            tasksMap.put("TYPE", "TASK");
            if (task != null) {
                TaskReason reason;
                if (null != task.getName()) {
                    tasksMap.put("TASK", task.getName());
                }
                if (null != task.getEntityName()) {
                    tasksMap.put("TARGET", task.getEntityName());
                }
                if (null != task.getEntity().getType()) {
                    tasksMap.put("TARGETTYPE", task.getEntity().getType());
                }
                if (null != task.getDescriptionId()) {
                    tasksMap.put("MESSAGE", task.getDescriptionId());
                }
                if (null != task.getStartTime()) {
                    tasksMap.put("STARTTIME", task.getStartTime().getTimeInMillis());
                }
                if (null != task.getCompleteTime()) {
                    Calendar endTime = task.getCompleteTime();
                    tasksMap.put("ENDTIME", endTime.getTimeInMillis());
                    tasksMap.put("TIME", endTime.getTimeInMillis());
                    tasksMap.put("HOUROFDAY", "" + endTime.get(11));
                    tasksMap.put("HOUR", this.hourDf.format(endTime.getTime()));
                }
                if (null != task.getState()) {
                    tasksMap.put("STATE", task.getState());
                }
                if ((reason = task.getReason()) != null && reason instanceof TaskReasonUser) {
                    tasksMap.put("USERNAME", ((TaskReasonUser)reason).getUserName());
                }
                if (task.getError() != null) {
                    tasksMap.put("ERRORMESSAGE", task.getError().getLocalizedMessage());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tasksMap;
    }

    private void createEventHistoryCollector() throws RuntimeFault, RemoteException {
        EventFilterSpec eventFilter = new EventFilterSpec();
        EventFilterSpecByTime event = new EventFilterSpecByTime();
        event.setBeginTime(this.startDate);
        event.setEndTime(this.endDate);
        eventFilter.setTime(event);
        this.eventCollector = this.eventManager.createCollectorForEvents(eventFilter);
        this.eventCollector.setCollectorPageSize(1000);
    }

    private void fetchAllEvents() {
        Hashtable<String, Object> eventsMap = null;
        block3: while (true) {
            try {
                block4: while (true) {
                    Event[] events;
                    if ((events = this.eventCollector.readNextEvents(100)) == null || events.length == 0) {
                        LOGGER.log(Level.INFO, "Event count is empty");
                        break block3;
                    }
                    LOGGER.log(Level.INFO, "No of events received is :" + events.length);
                    int i = 0;
                    while (true) {
                        if (i >= events.length) continue block4;
                        Event event = events[i];
                        eventsMap = this.parseEventFields(event);
                        this.addLogToFile(eventsMap);
                        ++i;
                    }
                    break;
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void addLogToFile(Hashtable<String, Object> paramMap) {
        if (paramMap.isEmpty()) {
            return;
        }
        long last_time = (Long)paramMap.get("TIME");
        if (null == this.str_last_msg_time) {
            this.str_last_msg_time = "0";
        }
        last_time = last_time > Long.valueOf(this.str_last_msg_time) ? last_time : Long.valueOf(this.str_last_msg_time);
        this.str_last_msg_time = "" + last_time;
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd yyyy HH:mm");
        cal.setTimeInMillis((Long)paramMap.get("TIME"));
        LOGGER.log(Level.FINER, "Last msg time is : " + sdf.format(cal.getTime()));
        Log log = new Log();
        paramMap.put("HOSTID", this.hostId);
        paramMap.put("HOSTNAME", this.dnsName);
        paramMap.put("HOSTTYPE", this.hostType);
        log.parseLog(this.hostType, paramMap);
        SystemCustomPatternHandler.getInstance().parse((Hashtable)log);
        LogIndexingAPI.getInstance().generateLogUniqueID((Map)log);
        paramMap.put("UUID", log.get("$id$"));
        LogDataIndexer.getInstance().indexLogData(log);
        this.notifyManager.notify(paramMap);
    }

    private Hashtable<String, Object> parseEventFields(Event event) {
        Hashtable<String, Object> eventsMap = new Hashtable<String, Object>();
        eventsMap.put("TYPE", "EVENT");
        String message = event.getFullFormattedMessage();
        String eventName = event.getClass().getSimpleName();
        eventsMap.put("EVENTNAME", eventName);
        eventsMap.put("USERNAME", event.getUserName());
        eventsMap.put("MESSAGE", message);
        Calendar cal = event.getCreatedTime();
        eventsMap.put("TIME", cal.getTimeInMillis());
        eventsMap.put("HOUROFDAY", "" + cal.get(11));
        eventsMap.put("HOUR", this.hourDf.format(cal.getTime()));
        LOGGER.log(Level.FINER, "Event received is : " + eventName);
        String IPADDRESS_PATTERN = "\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b";
        try {
            Pattern pattern = Pattern.compile(IPADDRESS_PATTERN);
            Matcher matcher = pattern.matcher(message);
            if (matcher.find()) {
                eventsMap.put("REMOTEIP", matcher.group());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != event.getComputeResource()) {
            eventsMap.put("COMPUTERRESOURCE", event.getComputeResource().getName());
        }
        if (null != event.getDatacenter()) {
            eventsMap.put("DATACENTER", event.getDatacenter().getName());
        }
        if (null != event.getDs()) {
            eventsMap.put("DATASTORE", event.getDs().getName());
        }
        if (null != event.getDvs()) {
            eventsMap.put("DVS", event.getDvs().getName());
        }
        if (null != event.getHost()) {
            eventsMap.put("VMHOST", event.getHost().getName());
        }
        if (null != event.getNet()) {
            eventsMap.put("NETWORK", event.getNet().getName());
        }
        if (null != event.getVm()) {
            eventsMap.put("VIRTUALMACHINE", event.getVm().getName());
        }
        if (eventSevMap.containsKey(eventName)) {
            eventsMap.put("SEVERITY", eventSevMap.get(eventName));
        } else {
            eventsMap.put("SEVERITY", "6");
        }
        this.mapEventType(event, eventsMap);
        return eventsMap;
    }

    private void mapEventType(Event event, Hashtable<String, Object> eventsMap) {
        if (event instanceof HostEvent) {
            eventsMap.put("OBJECTTYPE", "Host");
            this.parseHostEvents(event, eventsMap);
        } else if (event instanceof VmEvent) {
            eventsMap.put("OBJECTTYPE", "VM");
            this.parseVMEvents(event, eventsMap);
        } else if (event instanceof ClusterEvent) {
            eventsMap.put("OBJECTTYPE", "Cluster");
            this.parseClusterEvent(event, eventsMap);
        } else if (event instanceof DatastoreEvent) {
            eventsMap.put("OBJECTTYPE", "DataStore");
            this.parseDataStoreEvent(event, eventsMap);
        } else if (event instanceof ResourcePoolEvent) {
            eventsMap.put("OBJECTTYPE", "ResourcePool");
            this.parseResourcePoolEvent(event, eventsMap);
        } else if (event instanceof DatacenterEvent) {
            eventsMap.put("OBJECTTYPE", "DataCenter");
            this.parseDataCenterEvent(event, eventsMap);
        } else if (event instanceof PermissionEvent) {
            eventsMap.put("OBJECTTYPE", "Permission");
            this.parsePermissionEvent(event, eventsMap);
        } else if (event instanceof RoleEvent) {
            eventsMap.put("OBJECTTYPE", "Role");
            this.parseRoleEvents(event, eventsMap);
        }
    }

    private void parseClusterEvent(Event event, Hashtable<String, Object> eventsMap) {
        if (event instanceof ClusterStatusChangedEvent) {
            eventsMap.put("OLDVALUE", ((ClusterStatusChangedEvent)event).getOldStatus());
            eventsMap.put("NEWVALUE", ((ClusterStatusChangedEvent)event).getNewStatus());
        }
    }

    private void parseRoleEvents(Event event, Hashtable<String, Object> eventsMap) {
        if (event instanceof RoleAddedEvent) {
            String[] roleList = ((RoleAddedEvent)event).getPrivilegeList();
            eventsMap.put("ROLE", ((RoleAddedEvent)event).getRole().getName());
            eventsMap.put("ROLELIST", this.formRoleString(roleList));
        } else if (event instanceof RoleUpdatedEvent) {
            String[] roleList = ((RoleUpdatedEvent)event).getPrivilegeList();
            eventsMap.put("ROLE", ((RoleUpdatedEvent)event).getRole().getName());
            eventsMap.put("ROLELIST", this.formRoleString(roleList));
        } else if (event instanceof RoleRemovedEvent) {
            eventsMap.put("ROLE", ((RoleRemovedEvent)event).getRole().getName());
        }
    }

    private String formRoleString(String[] roleList) {
        StringBuffer buffer = new StringBuffer();
        int j = roleList.length - 1;
        for (int i = 0; i < roleList.length; ++i) {
            buffer.append(roleList[i]);
            if (i == j) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    private void parseResourcePoolEvent(Event event, Hashtable<String, Object> eventsMap) {
        if (event instanceof ResourcePoolEvent) {
            if (event instanceof ResourcePoolCreatedEvent) {
                eventsMap.put("RESOURCEPOOL", ((ResourcePoolCreatedEvent)event).getResourcePool().getName());
            } else if (event instanceof ResourcePoolDestroyedEvent) {
                eventsMap.put("RESOURCEPOOL", ((ResourcePoolDestroyedEvent)event).getResourcePool().getName());
            } else if (event instanceof ResourcePoolMovedEvent) {
                eventsMap.put("RESOURCEPOOL", ((ResourcePoolMovedEvent)event).getResourcePool().getName());
                eventsMap.put("SOURCE", ((ResourcePoolMovedEvent)event).getOldParent().getName());
                eventsMap.put("DESTINATION", ((ResourcePoolMovedEvent)event).getNewParent().getName());
            } else if (event instanceof ResourcePoolReconfiguredEvent) {
                eventsMap.put("RESOURCEPOOL", ((ResourcePoolReconfiguredEvent)event).getResourcePool().getName());
            }
        }
    }

    private void parseHostEvents(Event event, Hashtable<String, Object> eventsMap) {
        if (event instanceof HostCnxFailedAlreadyManagedEvent) {
            eventsMap.put("SERVER", ((HostCnxFailedAlreadyManagedEvent)event).getServerName());
        } else if (event instanceof HostDisconnectedEvent) {
            eventsMap.put("REASON", ((HostDisconnectedEvent)event).getReason());
        } else if (event instanceof HostInventoryFullEvent) {
            eventsMap.put("CAPACITY", ((HostInventoryFullEvent)event).getCapacity());
        } else if (event instanceof HostIpChangedEvent) {
            eventsMap.put("OLDVALUE", ((HostIpChangedEvent)event).getOldIP());
            eventsMap.put("NEWVALUE", ((HostIpChangedEvent)event).getNewIP());
        } else if (event instanceof HostIpInconsistentEvent) {
            eventsMap.put("DUPLICATE1", ((HostIpInconsistentEvent)event).getIpAddress());
            eventsMap.put("DUPLICATE2", ((HostIpInconsistentEvent)event).getIpAddress2());
        } else if (event instanceof HostMonitoringStateChangedEvent) {
            eventsMap.put("STATE", ((HostMonitoringStateChangedEvent)event).getState());
        } else if (event instanceof HostNoAvailableNetworksEvent) {
            eventsMap.put("IPS", ((HostNoAvailableNetworksEvent)event).getIps());
        } else if (event instanceof HostShortNameInconsistentEvent) {
            eventsMap.put("DUPLICATE1", ((HostShortNameInconsistentEvent)event).getShortName());
            eventsMap.put("DUPLICATE2", ((HostShortNameInconsistentEvent)event).getShortName2());
        } else if (event instanceof HostShutdownEvent) {
            eventsMap.put("REASON", ((HostShutdownEvent)event).getReason());
        } else if (event instanceof HostIsolationIpPingFailedEvent) {
            eventsMap.put("ISOLATIONIP", ((HostIsolationIpPingFailedEvent)event).getIsolationIp());
        } else if (event instanceof HostStatusChangedEvent) {
            eventsMap.put("OLDVALUE", ((HostStatusChangedEvent)event).getOldStatus());
            eventsMap.put("NEWVALUE", ((HostStatusChangedEvent)event).getNewStatus());
        } else if (event instanceof HostSyncFailedEvent) {
            eventsMap.put("REASON", ((HostSyncFailedEvent)event).getReason());
        }
    }

    private void parseVMEvents(Event event, Hashtable<String, Object> eventsMap) {
        if (event instanceof VmAcquiredTicketEvent) {
            eventsMap.put("TICKETTYPE", ((VmAcquiredTicketEvent)event).getTicketType());
        } else if (event instanceof VmAutoRenameEvent) {
            eventsMap.put("OLDVALUE", ((VmAutoRenameEvent)event).getOldName());
            eventsMap.put("NEWVALUE", ((VmAutoRenameEvent)event).getNewName());
        } else if (event instanceof VmBeingClonedEvent) {
            eventsMap.put("DESTINATIONFOLDER", ((VmBeingClonedEvent)event).getDestName());
            eventsMap.put("DESTINATIONHOST", ((VmBeingClonedEvent)event).getDestHost());
        } else if (event instanceof VmBeingClonedNoFolderEvent) {
            eventsMap.put("DESTINATIONFOLDER", ((VmBeingClonedNoFolderEvent)event).getDestName());
            eventsMap.put("DESTINATIONHOST", ((VmBeingClonedNoFolderEvent)event).getDestHost());
        } else if (event instanceof VmBeingDeployedEvent) {
            eventsMap.put("TEMPLATE", ((VmBeingDeployedEvent)event).getSrcTemplate().getName());
        } else if (event instanceof VmBeingHotMigratedEvent) {
            eventsMap.put("DESTINATIONHOST", ((VmBeingHotMigratedEvent)event).getDestHost().getName());
            eventsMap.put("DESTINATIONDATACENTER", ((VmBeingHotMigratedEvent)event).getDestDatacenter().getName());
        } else if (event instanceof VmBeingMigratedEvent) {
            eventsMap.put("DESTINATIONHOST", ((VmBeingMigratedEvent)event).getDestHost().getName());
            eventsMap.put("DESTINATIONDATACENTER", ((VmBeingMigratedEvent)event).getDestDatacenter().getName());
        } else if (event instanceof VmBeingRelocatedEvent) {
            eventsMap.put("DESTINATIONHOST", ((VmBeingRelocatedEvent)event).getDestHost().getName());
        } else if (event instanceof VmClonedEvent) {
            eventsMap.put("SOURCEVM", ((VmClonedEvent)event).getSourceVm().getName());
        } else if (event instanceof VmCloneFailedEvent) {
            eventsMap.put("REASON", ((VmCloneFailedEvent)event).getReason().toString());
        } else if (event instanceof VmDeployedEvent) {
            eventsMap.put("TEMPLATE", ((VmDeployedEvent)event).getSrcTemplate().getName());
        } else if (event instanceof VmDeployFailedEvent) {
            eventsMap.put("REASON", ((VmDeployFailedEvent)event).getReason().toString());
        } else if (event instanceof VmDiskFailedEvent) {
            eventsMap.put("DISK", ((VmDiskFailedEvent)event).getDisk());
        } else if (event instanceof VmFailedMigrateEvent) {
            eventsMap.put("DESTINATIONHOST", ((VmFailedMigrateEvent)event).getDestHost().getName());
        } else if (event instanceof VmFailedRelayoutEvent) {
            eventsMap.put("REASON", ((VmFailedRelayoutEvent)event).getReason().toString());
        } else if (event instanceof VmFailedStartingSecondaryEvent) {
            eventsMap.put("REASON", ((VmFailedStartingSecondaryEvent)event).getReason().toString());
        } else if (event instanceof VmFailedToPowerOffEvent) {
            eventsMap.put("REASON", ((VmFailedToPowerOffEvent)event).getReason().toString());
        } else if (event instanceof VmFailedToPowerOnEvent) {
            eventsMap.put("REASON", ((VmFailedToPowerOnEvent)event).getReason().toString());
        } else if (event instanceof VmFailedToRebootGuestEvent) {
            eventsMap.put("REASON", ((VmFailedToRebootGuestEvent)event).getReason().toString());
        } else if (event instanceof VmFailedToPowerOffEvent) {
            eventsMap.put("REASON", ((VmFailedToResetEvent)event).getReason().toString());
        } else if (event instanceof VmFailedToShutdownGuestEvent) {
            eventsMap.put("REASON", ((VmFailedToShutdownGuestEvent)event).getReason().toString());
        } else if (event instanceof VmFailedToStandbyGuestEvent) {
            eventsMap.put("REASON", ((VmFailedToStandbyGuestEvent)event).getReason().toString());
        } else if (event instanceof VmFailedToSuspendEvent) {
            eventsMap.put("REASON", ((VmFailedToSuspendEvent)event).getReason().toString());
        } else if (event instanceof VmFaultToleranceStateChangedEvent) {
            eventsMap.put("OLDVALUE", ((VmFaultToleranceStateChangedEvent)event).getOldState());
            eventsMap.put("NEWVALUE", ((VmFaultToleranceStateChangedEvent)event).getNewState());
        } else if (event instanceof VmFaultToleranceVmTerminatedEvent) {
            eventsMap.put("REASON", ((VmFaultToleranceVmTerminatedEvent)event).getReason());
        } else if (event instanceof VmHealthMonitoringStateChangedEvent) {
            eventsMap.put("STATE", ((VmHealthMonitoringStateChangedEvent)event).getState());
        } else if (event instanceof VmMigratedEvent) {
            eventsMap.put("SOURCEHOST", ((VmMigratedEvent)event).getSourceHost().getName());
        } else if (event instanceof VmNoNetworkAccessEvent) {
            eventsMap.put("DESTINATIONHOST", ((VmNoNetworkAccessEvent)event).getDestHost().getName());
        } else if (event instanceof VmPrimaryFailoverEvent) {
            eventsMap.put("REASON", ((VmPrimaryFailoverEvent)event).getReason());
        } else if (event instanceof VmRenamedEvent) {
            eventsMap.put("OLDVALUE", ((VmRenamedEvent)event).getOldName());
            eventsMap.put("NEWVALUE", ((VmRenamedEvent)event).getNewName());
        } else if (event instanceof VmResourcePoolMovedEvent) {
            eventsMap.put("SOURCE", ((VmResourcePoolMovedEvent)event).getOldParent().getName());
            eventsMap.put("DESTINATION", ((VmResourcePoolMovedEvent)event).getNewParent().getName());
        } else if (event instanceof VmRestartedOnAlternateHostEvent) {
            eventsMap.put("SOURCEHOST", ((VmRestartedOnAlternateHostEvent)event).getSourceHost().getName());
        } else if (event instanceof VmStaticMacConflictEvent) {
            eventsMap.put("MACADDRESS", ((VmStaticMacConflictEvent)event).getMac());
            eventsMap.put("CONFLICTEDVM", ((VmStaticMacConflictEvent)event).getConflictedVm().getName());
        }
    }

    private void parsePermissionEvent(Event event, Hashtable<String, Object> eventsMap) {
        if (event instanceof PermissionAddedEvent) {
            eventsMap.put("PRINCIPAL", ((PermissionAddedEvent)event).getPrincipal());
            eventsMap.put("ROLE", ((PermissionAddedEvent)event).getRole().getName());
            eventsMap.put("ENTITY", ((PermissionAddedEvent)event).getEntity().getName());
            eventsMap.put("ENTITYTYPE", ((PermissionAddedEvent)event).getEntity().getEntity().getType());
            eventsMap.put("PROPOGATION", ((PermissionAddedEvent)event).isPropagate());
        }
        if (event instanceof PermissionRemovedEvent) {
            eventsMap.put("PRINCIPAL", ((PermissionRemovedEvent)event).getPrincipal());
            eventsMap.put("ENTITY", ((PermissionRemovedEvent)event).getEntity().getName());
            eventsMap.put("ENTITYTYPE", ((PermissionRemovedEvent)event).getEntity().getEntity().getType());
        }
        if (event instanceof PermissionUpdatedEvent) {
            eventsMap.put("PRINCIPAL", ((PermissionUpdatedEvent)event).getPrincipal());
            eventsMap.put("ROLE", ((PermissionUpdatedEvent)event).getRole().getName());
            eventsMap.put("ENTITY", ((PermissionUpdatedEvent)event).getEntity().getName());
            eventsMap.put("PROPOGATION", ((PermissionUpdatedEvent)event).isPropagate());
        }
    }

    private void parseDataStoreEvent(Event event, Hashtable<String, Object> eventsMap) {
        if (event instanceof DatastoreEvent) {
            if (event instanceof DatastoreFileCopiedEvent) {
                eventsMap.put("SOURCE", ((DatastoreFileCopiedEvent)event).getSourceFile());
                eventsMap.put("TARGET", ((DatastoreFileCopiedEvent)event).getTargetFile());
                eventsMap.put("SOURCEDATASTORE", ((DatastoreFileCopiedEvent)event).getSourceDatastore().getName());
            }
            if (event instanceof DatastoreFileMovedEvent) {
                eventsMap.put("SOURCE", ((DatastoreFileMovedEvent)event).getSourceFile());
                eventsMap.put("TARGET", ((DatastoreFileMovedEvent)event).getTargetFile());
                eventsMap.put("SOURCEDATASTORE", ((DatastoreFileMovedEvent)event).getSourceDatastore().getName());
            } else if (event instanceof DatastoreFileDeletedEvent) {
                eventsMap.put("FILE", ((DatastoreFileDeletedEvent)event).getTargetFile());
            } else if (event instanceof DatastoreRenamedEvent) {
                eventsMap.put("OLDVALUE", ((DatastoreRenamedEvent)event).getOldName());
                eventsMap.put("NEWVALUE", ((DatastoreRenamedEvent)event).getNewName());
            } else if (event instanceof DatastoreRenamedOnHostEvent) {
                eventsMap.put("OLDVALUE", ((DatastoreRenamedOnHostEvent)event).getOldName());
                eventsMap.put("NEWVALUE", ((DatastoreRenamedOnHostEvent)event).getNewName());
            } else if (event instanceof DatastoreCapacityIncreasedEvent) {
                eventsMap.put("OLDVALUE", ((DatastoreCapacityIncreasedEvent)event).getOldCapacity());
                eventsMap.put("NEWVALUE", ((DatastoreCapacityIncreasedEvent)event).getNewCapacity());
            } else if (event instanceof DatastorePrincipalConfigured) {
                eventsMap.put("PRINCIPAL", ((DatastorePrincipalConfigured)event).getDatastorePrincipal());
            }
        }
    }

    private void parseDataCenterEvent(Event event, Hashtable<String, Object> eventsMap) {
        if (event instanceof DatacenterCreatedEvent) {
            FolderEventArgument es = ((DatacenterCreatedEvent)event).getParent();
            eventsMap.put("FOLDERNAME", es.getName());
        } else if (event instanceof DatacenterRenamedEvent) {
            String newname = ((DatacenterRenamedEvent)event).getNewName();
            String oldname = ((DatacenterRenamedEvent)event).getOldName();
            eventsMap.put("OLDVALUE", oldname);
            eventsMap.put("NEWVALUE", newname);
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    private String formURL(String protocol, String hostIp, int port) {
        StringBuffer urlBuf = new StringBuffer(protocol);
        urlBuf.append("://");
        urlBuf.append(hostIp);
        if (protocol.equals("http") && port != 80 || protocol.equals("https") && port != 443) {
            urlBuf.append(":");
            urlBuf.append(port);
        }
        urlBuf.append("/");
        urlBuf.append(APIFOLDER);
        return urlBuf.toString();
    }

    public void shutdown() {
        Iterator<Map.Entry<String, String>> it = sessionMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> pair = it.next();
            try {
                this.serverInstance = null;
                this.serverInstance = new ServiceInstance(new URL(pair.getKey()), pair.getValue(), true);
                if (this.serverInstance != null) {
                    this.serverInstance.getServerConnection().logout();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            it.remove();
        }
    }

    static {
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("vCenterEvent"));
            sql.addSelectColumn(new Column("vCenterEvent", "*"));
            DataObject hostDO = DataAccess.get((SelectQuery)sql);
            if (hostDO != null && !hostDO.isEmpty()) {
                Iterator keyIT = hostDO.getRows("vCenterEvent");
                while (keyIT.hasNext()) {
                    Row row = (Row)keyIT.next();
                    eventSevMap.put((String)row.get("EVENTNAME"), (String)row.get("SEVERITY"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

