/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.logcollector;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.enterprise.startup.StartUPUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.DiskSpaceCheck;
import com.adventnet.sa.server.EAService;
import com.adventnet.sa.server.logcollector.LogCollectorStatus;
import com.adventnet.sa.server.logcollector.LogCollectorUtil;
import com.adventnet.sa.server.logcollector.LogCollectorWatcher;
import com.adventnet.sa.server.logcollector.TroubleShootLogCollector;
import com.adventnet.sa.server.util.CommonUtil;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import java.io.IOException;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogCollectorProcess {
    private static final Logger LOGGER = Logger.getLogger(LogCollectorProcess.class.getName());
    private static final String PROCESSUTIL = "ProcessUtil.exe";
    private static final String LOGCOLLECTOR = "SysEvtCol.exe";
    public static final long RESTART_LIMIT = 5L;
    private static LogCollectorProcess logCollectorProcess;
    private EnumSet<LogCollectorStatus> logCollectorStatusEnum = EnumSet.noneOf(LogCollectorStatus.class);
    private long startTime;
    private boolean mailStatus = false;
    private Process runSECProcess = null;
    public long restartCount = 0L;
    private boolean isRunning = false;
    public boolean logCollectorQuitStatus = false;
    public boolean deleteAllSysEvtColZip = true;

    public static LogCollectorProcess getInstance() {
        if (logCollectorProcess == null) {
            logCollectorProcess = new LogCollectorProcess();
        }
        return logCollectorProcess;
    }

    public void start() {
        this.setLogCollectorStatusEnum(this.checkPrerequisites());
        if (this.logCollectorStatusEnum.isEmpty()) {
            this.setupLogCollectorData();
            String startBatchFileArgs = this.getLogCollectorArguments();
            try {
                this.runSECProcess = CommonUtil.executeBatch("runSEC", startBatchFileArgs);
                LOGGER.log(Level.INFO, "startBatchFileArgs: " + startBatchFileArgs);
                LOGGER.log(Level.INFO, "LogCollector Started");
                this.setLogCollectorStatusEnum(LogCollectorStatus.RUNNING);
                this.setLogCollectorRunningStatus(true);
                this.startTime = System.currentTimeMillis();
                LogCollectorWatcher logCollector = new LogCollectorWatcher(logCollectorProcess);
                Thread processThread = new Thread(logCollector);
                processThread.start();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "LogCollector: Cannot execute batch");
                e.printStackTrace();
            }
        } else {
            StringBuilder prerequisitesString = new StringBuilder("");
            if (this.logCollectorStatusEnum.contains((Object)LogCollectorStatus.STOPPED_LICENSEEXPIRED)) {
                prerequisitesString.append(LogCollectorStatus.STOPPED_LICENSEEXPIRED.name() + " ");
            }
            if (this.logCollectorStatusEnum.contains((Object)LogCollectorStatus.STOPPED_NOFREESPACE)) {
                prerequisitesString.append(LogCollectorStatus.STOPPED_NOFREESPACE.name() + " ");
            }
            if (this.logCollectorStatusEnum.contains((Object)LogCollectorStatus.STOPPED_ADMINSERVER)) {
                prerequisitesString.append(LogCollectorStatus.STOPPED_ADMINSERVER.name() + " ");
            }
            LOGGER.log(Level.INFO, "LogCollector: Prerequisite: " + prerequisitesString + " failed ");
        }
    }

    public void setLogCollectorStatusEnum(EnumSet<LogCollectorStatus> logCollectorStatus) {
        this.logCollectorStatusEnum.clear();
        this.logCollectorStatusEnum = EnumSet.copyOf(logCollectorStatus);
    }

    public void setLogCollectorStatusEnum(LogCollectorStatus logCollectorStatus) {
        this.logCollectorStatusEnum.clear();
        this.logCollectorStatusEnum.add(logCollectorStatus);
    }

    public void stop(LogCollectorStatus status) {
        String exitvalue = "";
        this.setLogCollectorStatusEnum(status);
        this.setLogCollectorRunningStatus(false);
        try {
            Process stopsec = CommonUtil.executeBatch("stopSEC", "");
            stopsec.waitFor();
            exitvalue = Integer.toHexString(stopsec.exitValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.log(Level.INFO, "LogCollector Stopped");
    }

    public void restart(LogCollectorStatus status) {
        this.setLogCollectorStatusEnum(status);
        if (status.isLogCollectorAbnormalIssue()) {
            this.resetRestartCount();
        }
        LOGGER.log(Level.INFO, "Restarting LogCollector.\tReason:" + status.name());
        this.stop(status);
        TroubleShootLogCollector.checkLogCollectorZip();
        this.start();
    }

    public long getrestartCount() {
        return this.restartCount;
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public void forceStop() {
        if (ServerDetailsBean.getInstance().isWindows()) {
            try {
                Process ProcessUtil = CommonUtil.executeBatch(PROCESSUTIL, LOGCOLLECTOR);
                ProcessUtil.waitFor();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception: Cannot Kill SysEvtCol");
                e.printStackTrace();
            }
        } else {
            try {
                Runtime.getRuntime().exec("killall SysEvtCol");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public EnumSet<LogCollectorStatus> getStatusEnum() {
        return this.logCollectorStatusEnum;
    }

    public boolean isMailSent() {
        return this.mailStatus;
    }

    public EnumSet<LogCollectorStatus> checkPrerequisites() {
        EnumSet<LogCollectorStatus> prerequisites = EnumSet.noneOf(LogCollectorStatus.class);
        if (StartUPUtil.getInstance().isAdminServer()) {
            prerequisites.add(LogCollectorStatus.STOPPED_ADMINSERVER);
        }
        if (!new DiskSpaceCheck().checkMinDiskSpace()) {
            prerequisites.add(LogCollectorStatus.STOPPED_NOFREESPACE);
        }
        if (!EAService.getInstance().licenseCheck()) {
            prerequisites.add(LogCollectorStatus.STOPPED_LICENSEEXPIRED);
        }
        return prerequisites;
    }

    public void troubleShoot(LogCollectorStatus exitValue) throws Exception {
        if (!this.isMailSent()) {
            TroubleShootLogCollector.sendmail(exitValue);
            if (exitValue == LogCollectorStatus.STOPPED_CRASHED) {
                this.mailStatus = true;
            }
        }
        if (exitValue == LogCollectorStatus.STOPPED_CRASHED) {
            if (this.getrestartCount() % 4L == 0L) {
                this.setLogCollectorQuitStatus(true);
            }
        } else {
            this.setLogCollectorQuitStatus(true);
        }
        TroubleShootLogCollector.zipLogs();
        ++TroubleShootLogCollector.zipCount;
    }

    public String getLogCollectorArguments() {
        StringBuilder startBatchFileArgs = new StringBuilder("");
        startBatchFileArgs.append(" -DBType ");
        startBatchFileArgs.append(LogCollectorUtil.getDataBaseType());
        startBatchFileArgs.append(" -buildNo ");
        startBatchFileArgs.append(LogCollectorUtil.getBuildNumber());
        startBatchFileArgs.append("  -fwport ");
        startBatchFileArgs.append(LogCollectorUtil.getForwardingPorts());
        startBatchFileArgs.append(" -isPremium ");
        startBatchFileArgs.append(LogCollectorUtil.isPremium());
        startBatchFileArgs.append(" -localFacility ");
        startBatchFileArgs.append(LogCollectorUtil.getLocalFacilty());
        startBatchFileArgs.append(" -webserverport ");
        startBatchFileArgs.append(LogCollectorUtil.getWebServerPort());
        if (LogCollectorUtil.isWebServerHTTPS()) {
            startBatchFileArgs.append(" -webserversecure ");
        }
        startBatchFileArgs.append(" -webservername ");
        startBatchFileArgs.append(LogCollectorUtil.getWebServerName());
        return startBatchFileArgs.toString();
    }

    public void setupLogCollectorData() {
        CommonUtil.formXmlForLogFormats();
        Long slid = this.initSLServer();
        Criteria crit = new Criteria(Column.getColumn((String)"SLUPDATE", (String)"SLID"), (Object)slid, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"SLUPDATE", (String)"SERVICETYPE"), (Object)new Long("1"), 0));
        try {
            DataObject doo = DataAccess.get((String)"SLUPDATE", (Criteria)crit);
            if (doo.isEmpty()) {
                LOGGER.log(Level.INFO, "Adding SLUPDATE entry");
                doo = DataAccess.constructDataObject();
                Row sluRow = new Row("SLUPDATE");
                sluRow.set("SLID", (Object)slid);
                sluRow.set("SERVICETYPE", (Object)new Long("1"));
                sluRow.set("SERVICEID", (Object)new Long("0"));
                doo.addRow(sluRow);
                DataAccess.update((DataObject)doo);
            }
            Criteria slupdates = new Criteria(Column.getColumn((String)"SLUPDATE", (String)"SERVICETYPE"), (Object)new Long("1"), 1);
            slupdates = slupdates.and(new Criteria(Column.getColumn((String)"SLUPDATE", (String)"SLID"), (Object)slid, 0));
            DataAccess.delete((String)"SLUPDATE", (Criteria)slupdates);
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
        }
    }

    public Long initSLServer() {
        Long slid = null;
        try {
            DataObject doo = DataAccess.get((String)"SyslogServers", (Criteria)new Criteria(Column.getColumn((String)"SyslogServers", (String)"PORTS"), (Object)"-", 1));
            if (doo.isEmpty()) {
                LOGGER.log(Level.INFO, "Adding SyslogServers entry");
                String hostName = InetAddressHandler.getLocalHost().getHostName();
                String hostIPAddress = InetAddressHandler.getLocalHost().getHostAddress();
                String osName = ServerDetailsBean.getInstance().getSystemOS().toLowerCase();
                Row slRow = new Row("SyslogServers");
                slRow.set("HOST_NAME", (Object)hostName);
                slRow.set("HOSTIP", (Object)hostIPAddress);
                slRow.set("TYPE", (Object)osName);
                slRow.set("PORTS", (Object)"-513 -514");
                slRow.set("STATUS", (Object)"AGENT_RUNNING");
                slRow.set("ERROR_CODE", (Object)"0");
                slRow.set("ERROR_DETAILS", (Object)"");
                slRow.set("LOG_LEVEL", (Object)"2");
                doo.addRow(slRow);
                doo = DataAccess.update((DataObject)doo);
                slid = (Long)doo.getFirstValue("SyslogServers", "SLID");
            } else {
                slid = (Long)doo.getFirstValue("SyslogServers", "SLID");
                Row slRow = doo.getFirstRow("SyslogServers");
                slRow.set("PORTS", (Object)"-513 -514");
                doo.updateRow(slRow);
                DataAccess.update((DataObject)doo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return slid == null ? 1L : slid;
    }

    void resetRestartCount() {
        this.restartCount = 0L;
        LOGGER.log(Level.INFO, "Resetting restart count of log collector");
    }

    public boolean getLogCollectorQuitStatus() {
        LOGGER.log(Level.FINER, "EAService LCQuit status that will be returned :: " + this.logCollectorQuitStatus);
        return this.logCollectorQuitStatus;
    }

    public void setLogCollectorQuitStatus(boolean status) {
        this.logCollectorQuitStatus = status;
    }

    public Process getProcess() {
        return this.runSECProcess;
    }

    public boolean isLogCollectorRunning() {
        return this.isRunning;
    }

    public void setLogCollectorRunningStatus(boolean collectorStatus) {
        this.isRunning = collectorStatus;
    }
}

