/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.logcollector;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.LAClientUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.EAService;
import com.adventnet.sa.server.ELSInitializer;
import com.adventnet.sa.server.util.CommonUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogCollectorUtil {
    private static final Logger LOGGER = Logger.getLogger(LogCollectorUtil.class.getName());

    public static String getBuildNumber() {
        return ELSInitializer.getBuildNumber();
    }

    public static String getDataBaseType() {
        return CommonUtil.getCurrentDataBaseName();
    }

    public static String getForwardingPorts() {
        return System.getProperty("sysPort", "5000") + " " + System.getProperty("evtPort", "5001") + " " + System.getProperty("orclPort", "5002");
    }

    public static String getLocalFacilty() {
        return System.getProperty("localFacility", "Local6");
    }

    public static String getWebServerName() {
        return LAClientUtil.getWebAddress();
    }

    public static int getWebServerPort() {
        return LAClientUtil.getWebPort();
    }

    public static boolean isWebServerHTTPS() {
        return "https".equals(LAClientUtil.getWebPortocol());
    }

    public static String isPremium() {
        return EAService.showPremiumFeatures() ? "1" : "0";
    }

    public static String setLogLevel(String logCollector) {
        String logCollectorLevel = "";
        try {
            boolean isAdminServer;
            Criteria crt = new Criteria(Column.getColumn((String)"SyslogServers", (String)"PORTS"), (Object)"-", 1);
            DataObject doo = DataAccess.get((String)"SyslogServers", (Criteria)crt);
            if (logCollector != null && !"".equals(logCollector)) {
                Row slRow = doo.getFirstRow("SyslogServers");
                slRow.set("LOG_LEVEL", (Object)logCollector);
                doo.updateRow(slRow);
                DataAccess.update((DataObject)doo);
            }
            Row logRow = doo.getRow("SyslogServers", crt);
            logCollectorLevel = logRow.get("LOG_LEVEL").toString();
            boolean bl = isAdminServer = "true".equals(System.getProperty("isAdminServer"));
            if (!isAdminServer) {
                Row slUpdate = new Row("SLUPDATE");
                slUpdate.set("SLID", (Object)EAService.getSLID());
                slUpdate.set("SERVICETYPE", (Object)EAService.slUpdateConst.get("LOGLEVEL"));
                slUpdate.set("SERVICEID", logRow.get("LOG_LEVEL"));
                DataObject dobj = DataAccess.constructDataObject();
                dobj.addRow(slUpdate);
                try {
                    DataAccess.add((DataObject)dobj);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Exception was caught while adding Duplicate entry in SLUPDATE");
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return logCollectorLevel;
    }
}

