/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.logcollector;

import com.adventnet.sa.server.logcollector.LogCollectorProcess;
import com.adventnet.sa.server.logcollector.LogCollectorStatus;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogCollectorWatcher
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(LogCollectorWatcher.class.getName());
    private LogCollectorStatus exitStatus;
    private LogCollectorProcess logcollector;
    private Process pr = null;

    public LogCollectorWatcher(LogCollectorProcess logCollectorProcess) {
        this.logcollector = logCollectorProcess;
        this.pr = this.logcollector.getProcess();
    }

    @Override
    public void run() {
        try {
            this.pr.waitFor();
            this.exitStatus = LogCollectorStatus.getValue(this.pr.exitValue());
            LOGGER.log(Level.WARNING, "Problem in LogCollector.  ExitValue=" + (Object)((Object)this.exitStatus));
            LogCollectorProcess.getInstance().setLogCollectorRunningStatus(false);
            if (this.exitStatus == LogCollectorStatus.STOPPED_KILL || this.exitStatus == LogCollectorStatus.STOPPED_KILL_LINUX) {
                this.logcollector.setLogCollectorStatusEnum(LogCollectorStatus.STOPPED_KILL);
                LOGGER.log(Level.INFO, "LogCollector process killed");
            } else if (this.exitStatus.isLogCollectorStartUpIssue()) {
                this.logcollector.setLogCollectorStatusEnum(this.exitStatus);
                if (this.logcollector.getrestartCount() < 5L) {
                    if (this.logcollector.getrestartCount() == 4L) {
                        this.logcollector.troubleShoot(this.exitStatus);
                    } else {
                        this.logcollector.restart(this.exitStatus);
                    }
                }
            } else if (this.exitStatus != LogCollectorStatus.STOPPED_SHUTDOWN) {
                this.logcollector.setLogCollectorStatusEnum(LogCollectorStatus.STOPPED_CRASHED);
                this.logcollector.troubleShoot(this.exitStatus);
                this.logcollector.restart(LogCollectorStatus.STOPPED_CRASHED);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

