/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.logcollector;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.sa.server.logcollector.LogCollectorProcess;
import com.adventnet.sa.server.logcollector.LogCollectorStatus;
import com.adventnet.sa.server.logcollector.ZipLogCollectorLogAfterQuit;
import com.adventnet.sa.server.util.CommonUtil;
import com.manageengine.ads.fw.mail.MailAction;
import com.manageengine.ads.fw.mail.MailHandler;
import java.io.File;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class TroubleShootLogCollector {
    private static final Logger LOGGER = Logger.getLogger(TroubleShootLogCollector.class.getName());
    public static int zipCount = 0;
    public static int limit = 5;
    private static String toAddress = null;
    private static String subject = null;

    public static void sendmail(LogCollectorStatus exitValue) {
        block6: {
            if (CommonUtil.isMailServerConfigured()) {
                JSONObject mailSettings = MailHandler.getMailSettings();
                JSONObject maildata = new JSONObject();
                ResourceBundle bundle = null;
                bundle = ProductBundle.getInstance().getBundle();
                String stopcause = "";
                if (exitValue.isLogCollectorStartUpIssue()) {
                    stopcause = bundle.getString("LogCollector.Alert.Mail." + (Object)((Object)exitValue));
                }
                String message = bundle.getString("LogCollector.Alert.Mail1") + "<br/>" + stopcause + "<br/><br/>" + bundle.getString("LogCollector.Alert.Mail2") + "<br/><br/>" + bundle.getString("LogCollector.Alert.SIF") + "<br/><br/>" + bundle.getString("LogCollector.Alert.SIF.Auto") + "<br/><br/>" + bundle.getString("LogCollector.Alert.SIF.Manual");
                try {
                    SelectQueryImpl query1 = new SelectQueryImpl(Table.getTable((String)"SystemConfigurations"));
                    query1.addSelectColumn(Column.getColumn((String)"SystemConfigurations", (String)"*"));
                    Criteria migCrit = new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"EDMailID", 0);
                    Criteria migCrit2 = new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"EDSubject", 0);
                    Criteria cri = migCrit.or(migCrit2);
                    query1.setCriteria(cri);
                    DataObject obj1 = DataAccess.get((SelectQuery)query1);
                    if (obj1.size("SystemConfigurations") > 0) {
                        toAddress = (String)obj1.getValue("SystemConfigurations", "CONF_VALUE", migCrit);
                        subject = (String)obj1.getValue("SystemConfigurations", "CONF_VALUE", migCrit2);
                        maildata.put("FROM_MAIL_ID", (Object)mailSettings.getString("FROM_MAIL_ID"));
                        maildata.put("TO_ADDRESSES", (Object)toAddress);
                        maildata.put("SUBJECT", (Object)subject);
                        maildata.put("MESSAGE", (Object)message);
                        maildata.put("ENABLE_HTML_FORMAT", true);
                        MailAction.sendMail((JSONObject)maildata);
                        LOGGER.log(Level.INFO, "Logcollector alert mail sent successfully. " + stopcause);
                        break block6;
                    }
                    LOGGER.log(Level.INFO, "Logcollector alert mail not sent::Mail parameters not received from DB");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                LOGGER.log(Level.SEVERE, "MailServer is Not Configured");
            }
        }
    }

    public static void zipLogs() {
        try {
            ZipLogCollectorLogAfterQuit objZip = ZipLogCollectorLogAfterQuit.getInstance();
            File file1 = new File(System.getProperty("server.home") + File.separator + "logs" + File.separator + "eventlog.out");
            File file2 = new File(System.getProperty("server.home") + File.separator + "logs" + File.separator + "eventlog1.out");
            boolean exists = file1.exists();
            long filesize1 = !exists ? 0L : file1.length();
            exists = file2.exists();
            long filesize2 = !exists ? 0L : file2.length();
            if (zipCount > limit) {
                objZip.deleteZip();
            }
            if (filesize1 > 0L && filesize1 <= 314572800L && filesize2 <= 314572800L) {
                LOGGER.log(Level.INFO, "LogCollector: Creating log collector quit files");
                objZip.zipNow();
            } else {
                LOGGER.log(Level.INFO, "LogCollector: Updating log collector quit files");
                objZip.updateZipData();
            }
        }
        catch (Exception qe) {
            qe.printStackTrace();
        }
    }

    public static void checkLogCollectorZip() {
        ZipLogCollectorLogAfterQuit objZip = ZipLogCollectorLogAfterQuit.getInstance();
        if (LogCollectorProcess.getInstance().deleteAllSysEvtColZip) {
            try {
                objZip.deleteOnServiceRestart();
                LogCollectorProcess.getInstance().deleteAllSysEvtColZip = false;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception:::zipping on service restart");
            }
        }
        ++LogCollectorProcess.getInstance().restartCount;
        if (LogCollectorProcess.getInstance().restartCount > 5L) {
            objZip.deleteZip();
        }
    }
}

