/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.logcollector;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipLogCollectorLogAfterQuit {
    private static final Logger LOGGER = Logger.getLogger(ZipLogCollectorLogAfterQuit.class.getName());
    static long[] timestampForFileName = new long[5];
    static int i = 0;
    private static ZipLogCollectorLogAfterQuit zipLogCollectorLogAfterQuit;

    public static ZipLogCollectorLogAfterQuit getInstance() {
        if (zipLogCollectorLogAfterQuit == null) {
            zipLogCollectorLogAfterQuit = new ZipLogCollectorLogAfterQuit();
        }
        return zipLogCollectorLogAfterQuit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipNow() {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        FileInputStream fis = null;
        try {
            Long zipTime = System.currentTimeMillis();
            ZipLogCollectorLogAfterQuit.timestampForFileName[ZipLogCollectorLogAfterQuit.i] = zipTime;
            if (++i == 5) {
                i = 0;
            }
            String temp = String.valueOf(zipTime);
            String filePath = "";
            String[] eventlogFiles = new String[]{"eventlog.out", "sysEvtStatus.out", "winLogs.out", "sysLogs.out", "sysEvtStatus_1.out", "winLogs_1.out", "sysLogs_1.out", ".dmp"};
            File dir = new File(System.getProperty("server.home") + File.separator + "logs");
            File[] dmpFile = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".dmp");
                }
            });
            byte[] buffer = new byte[2048];
            fos = new FileOutputStream(System.getProperty("server.home") + File.separator + "logs" + File.separator + "LogCollectorQuit" + temp + ".zip");
            zos = new ZipOutputStream(fos);
            int len = eventlogFiles.length;
            if (dmpFile.length > 0) {
                eventlogFiles[len - 1] = dmpFile[0].getName();
            }
            for (int j = 0; j < len; ++j) {
                int length;
                filePath = System.getProperty("server.home") + File.separator + "logs" + File.separator + eventlogFiles[j];
                File file = new File(filePath);
                if (!file.exists()) continue;
                fis = new FileInputStream(filePath);
                zos.putNextEntry(new ZipEntry(eventlogFiles[j]));
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
                fis.close();
                if (!eventlogFiles[j].contains(".dmp")) continue;
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateZipData() {
        Long zipTime = System.currentTimeMillis();
        ZipLogCollectorLogAfterQuit.timestampForFileName[ZipLogCollectorLogAfterQuit.i] = zipTime;
        LOGGER.log(Level.INFO, "eventlog files size is greater than 300 MB");
        if (++i == 5) {
            i = 0;
        }
    }

    public void deleteZip() {
        long min = timestampForFileName[0];
        for (int j = 0; j < 5; ++j) {
            if (timestampForFileName[j] > min) continue;
            min = timestampForFileName[j];
        }
        String str = String.valueOf(min);
        try {
            File file = new File(System.getProperty("server.home") + File.separator + "logs" + File.separator + "LogCollectorQuit" + str + ".zip");
            if (file.exists()) {
                if (file.delete()) {
                    LOGGER.log(Level.INFO, "file deleted");
                } else {
                    LOGGER.log(Level.INFO, "file is not deleted");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteOnServiceRestart() {
        try {
            File directory = new File(System.getProperty("server.home") + File.separator + "logs" + File.separator);
            if (directory.exists()) {
                for (File f : directory.listFiles()) {
                    if (!f.getName().startsWith("LogCollectorQuit")) continue;
                    f.delete();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

