/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.LuceneFormatter;
import com.adventnet.la.util.DepartmentUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.NotificationHandler;
import com.adventnet.sa.server.nf.assign.AssignedToHandler;
import com.google.common.collect.TreeMultiset;
import com.zoho.za.dae.threat.ThreatNotifier;
import com.zoho.za.dae.threat.Utils;
import com.zoho.za.ela.logsearch.criteria.JSONCriteriaHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class CustomAlertProfile {
    private HashSet<Long> profileHosts = new HashSet();
    private HashSet<Long> profileHostGroups = new HashSet();
    private JSONCriteriaHandler jsonHandler = null;
    private HashSet<String> configServerities = new HashSet();
    private HashSet<String> configuredTypes = new HashSet();
    private boolean notifEnabled = false;
    private static Map<Long, Long> hostToGroupMap = new HashMap<Long, Long>();
    private static Map<Long, Long> appToGroupMap = new HashMap<Long, Long>();
    private static Map<Long, Long> appToHostMap = new HashMap<Long, Long>();
    private static Map<Integer, String> typeMap = new HashMap<Integer, String>();
    private boolean isAS400Profile = false;
    private boolean isDefaultProfile = false;
    private boolean isCorrelationProfile = false;
    private int configuredThresholdLimit = -1;
    private long configuredThresholdDuration = 600000L;
    private int triggerTime = 0;
    private HashMap<Long, TreeMultiset<Long>> hostBasedRunningTime = null;
    private ArrayList<Integer> customTriggerHours = null;
    private static List specialLogTypes;
    private static ResourceBundle resourceBundle;
    private static final Logger LOGGER;

    public CustomAlertProfile(int thresholdCount, long thresholdDurationInMillis, int triggerTime) {
        this.configuredThresholdLimit = thresholdCount;
        this.configuredThresholdDuration = thresholdDurationInMillis;
        this.triggerTime = triggerTime;
        this.hostBasedRunningTime = new HashMap();
        this.customTriggerHours = new ArrayList();
    }

    public static void populateHostToGroupMap() {
        Table table = new Table("HostGroupMapping");
        SelectQueryImpl sql = new SelectQueryImpl(table);
        Column colHM = new Column("HostGroupMapping", "*");
        sql.addSelectColumn(colHM);
        try {
            DataObject hostGroupMapDO = DataAccess.get((SelectQuery)sql);
            Iterator hgMappingItr = hostGroupMapDO.getRows("HostGroupMapping");
            while (hgMappingItr.hasNext()) {
                Row row = (Row)hgMappingItr.next();
                hostToGroupMap.put((Long)row.get("HOSTID"), (Long)row.get("GROUPID"));
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        CustomAlertProfile.populateAppResourceDetails();
        AssignedToHandler.getInstance().refreshAllProfiles();
    }

    private static void populateAppResourceDetails() {
        Table table = new Table("AppResources");
        SelectQueryImpl sql = new SelectQueryImpl(table);
        Column arCol = new Column("AppResources", "*");
        Column hgmCol = new Column("HostGroupMapping", "*");
        sql.addSelectColumn(arCol);
        sql.addSelectColumn(hgmCol);
        String[] joinCol = new String[]{"HOSTID"};
        Join j = new Join(table, new Table("HostGroupMapping"), joinCol, joinCol, 2);
        sql.addJoin(j);
        try {
            DataObject applnDO = DataAccess.get((SelectQuery)sql);
            Iterator itr = applnDO.getRows("AppResources");
            while (itr.hasNext()) {
                Row appRow = (Row)itr.next();
                Long appId = (Long)appRow.get("APPID");
                Long hostId = (Long)appRow.get("HOSTID");
                appToHostMap.put(appId, hostId);
                Row hgmappingRow = applnDO.getRow("HostGroupMapping", appRow);
                Long groupId = (Long)hgmappingRow.get("GROUPID");
                appToGroupMap.put(appId, groupId);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public static Long getHostIdForAppId(Long appId) {
        Long hId = appToHostMap.get(appId);
        if (hId == null) {
            CustomAlertProfile.populateAppResourceDetails();
            hId = appToHostMap.get(appId);
        }
        return hId;
    }

    private static void populateTypeMap() {
        typeMap.put(3, "kernel");
        typeMap.put(4, "user");
        typeMap.put(5, "mail");
        typeMap.put(6, "daemon");
        typeMap.put(7, "auth");
        typeMap.put(8, "syslog");
        typeMap.put(9, "lpr");
        typeMap.put(10, "news");
        typeMap.put(11, "uucp");
        typeMap.put(12, "cron");
        typeMap.put(13, "authpriv");
        typeMap.put(14, "ftp");
        typeMap.put(15, "ntp");
        typeMap.put(16, "logaudit");
        typeMap.put(17, "logalert");
        typeMap.put(18, "clock");
        typeMap.put(19, "local0");
        typeMap.put(20, "local1");
        typeMap.put(21, "local2");
        typeMap.put(22, "local3");
        typeMap.put(23, "local4");
        typeMap.put(24, "local5");
        typeMap.put(25, "local6");
        typeMap.put(26, "local7");
        CustomAlertProfile.populateWinTypeMap();
    }

    private static void populateWinTypeMap() {
        Table table = new Table("LogTypeMapping");
        SelectQueryImpl sql = new SelectQueryImpl(table);
        Column col = new Column("LogTypeMapping", "*");
        sql.addSelectColumn(col);
        try {
            DataObject doo = DataAccess.get((SelectQuery)sql);
            Iterator it = doo.getRows("LogTypeMapping");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                typeMap.put((Integer)row.get("LVALUE"), ((String)row.get("LTYPE")).toLowerCase());
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public boolean isAS400Profile() {
        return this.isAS400Profile;
    }

    public void setNotificationStatus(int statusIntVal) {
        this.notifEnabled = statusIntVal == 1;
    }

    public void removeConfiguredHost(long hostId) {
        this.profileHosts.remove(hostId);
    }

    public void addSeverity(String sev) {
        String sevInLower = sev.toLowerCase();
        if (!"any".equals(sevInLower)) {
            this.configServerities.add(sevInLower);
        }
    }

    public void setTriggerHours(ArrayList<Integer> triggerHours) {
        this.customTriggerHours = triggerHours;
    }

    public boolean isTriggerTimeMatched(Integer hour) {
        switch (this.triggerTime) {
            case 1: {
                if (!DepartmentUtil.getWorkHourList().contains(hour)) break;
                return true;
            }
            case 2: {
                if (!DepartmentUtil.getNonWorkHourList().contains(hour)) break;
                return true;
            }
            case 3: {
                if (!this.customTriggerHours.contains(hour)) break;
                return true;
            }
        }
        return false;
    }

    public void setDefaultProfile() {
        this.isDefaultProfile = true;
    }

    public void setCorrelationProfile() {
        this.isCorrelationProfile = true;
    }

    public boolean isCorrelationProfile() {
        return this.isCorrelationProfile;
    }

    HashSet<Long> getProfileHosts() {
        return this.profileHosts;
    }

    HashSet<Long> getProfileHostGroups() {
        return this.profileHostGroups;
    }

    public void parseAndAddTypeDetails(long type) {
        if (type == 255L || type < 0L || type == 256L || type == 257L) {
            return;
        }
        boolean repopulated = false;
        long temp = type;
        do {
            int remain;
            String typeOrFacilityStr;
            if ((typeOrFacilityStr = typeMap.get(remain = (int)temp % 100)) != null) {
                this.configuredTypes.add(typeOrFacilityStr);
            } else if (!repopulated) {
                LOGGER.log(Level.INFO, "Going to repopulate the LogTypeMapping details into memory");
                CustomAlertProfile.populateWinTypeMap();
                repopulated = true;
                continue;
            }
            temp /= 100L;
        } while (temp > 0L);
        LOGGER.log(Level.INFO, "Parsed Types/Facilities for given NotificationTypes TYPE -> {0} - is/are -> {1}", new Object[]{type, this.configuredTypes});
    }

    public void setProfileHosts(HashSet hosts) {
        this.profileHosts = hosts;
    }

    public void setProfileHostGroups(HashSet hostGroups) {
        this.profileHostGroups = hostGroups;
    }

    public void addJsonCriteriaStr(String jsonStr) {
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.addJsonCriteriaObject(jsonObj);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public void markAS400Profile(boolean status) {
        this.isAS400Profile = status;
    }

    public void addJsonCriteriaObject(JSONObject jsonObj) {
        try {
            this.jsonHandler = new JSONCriteriaHandler(jsonObj);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private boolean checkThreatAlertProfile(Map logToBeChecked) {
        try {
            Object message;
            String logMsg;
            String string = logMsg = logToBeChecked.get("MESSAGE") == null ? null : String.valueOf(logToBeChecked.get("MESSAGE"));
            if (logMsg == null) {
                logMsg = logToBeChecked.get("RAWLOG") == null ? null : String.valueOf(logToBeChecked.get("RAWLOG"));
            }
            HashSet<String> dataToBeChecked = new HashSet<String>();
            for (String IP_KEY_NAME : Utils.IP_KEYS) {
                if (!logToBeChecked.containsKey(IP_KEY_NAME)) continue;
                dataToBeChecked.add(logToBeChecked.get(IP_KEY_NAME).toString().trim());
            }
            if (!dataToBeChecked.isEmpty()) {
                message = "";
                message = ThreatNotifier.checkThreat(dataToBeChecked);
                if (!((String)message).equals("")) {
                    message = resourceBundle.getString("DefaultThreat.ip.alert") + " : " + (String)message;
                    if (logMsg != null) {
                        message = (String)message + "\n\n" + resourceBundle.getString("DefaultThreat.log.message") + " :\n" + logMsg;
                    }
                    logToBeChecked.put("MESSAGE", message);
                    if (logToBeChecked.get("SOURCE") == null) {
                        logToBeChecked.put("SOURCE", "-");
                    }
                    logToBeChecked.put("NOTIFID", Utils.THREAT_NF_ID + "");
                    NotificationHandler.addLogIntoQueue(new Hashtable(logToBeChecked));
                }
            }
            dataToBeChecked.clear();
            for (Object DOMAIN_KEY_NAME : Utils.DOMAIN_KEYS) {
                if (!logToBeChecked.containsKey(DOMAIN_KEY_NAME)) continue;
                dataToBeChecked.add(logToBeChecked.get(DOMAIN_KEY_NAME).toString().trim().toLowerCase());
            }
            if (!dataToBeChecked.isEmpty()) {
                message = "";
                message = ThreatNotifier.checkDomainsForThreat(dataToBeChecked);
                if (!((String)message).equals("")) {
                    message = resourceBundle.getString("DefaultThreat.domain.alert") + " : " + (String)message;
                    if (logMsg != null) {
                        message = (String)message + "\n\nLog message : \n" + logMsg;
                    }
                    logToBeChecked.put("MESSAGE", message);
                    if (logToBeChecked.get("SOURCE") == null) {
                        logToBeChecked.put("SOURCE", "-");
                    }
                    logToBeChecked.put("NOTIFID", Utils.THREAT_NF_ID + "");
                    NotificationHandler.addLogIntoQueue(new Hashtable(logToBeChecked));
                }
            }
            dataToBeChecked.clear();
            String url = "";
            if (logToBeChecked.containsKey("URL_SITE")) {
                if (logToBeChecked.containsKey("SERVICENAME")) {
                    url = logToBeChecked.get("SERVICENAME").toString();
                    url = url + "://";
                } else if (logToBeChecked.containsKey("PROTOCOL_APP")) {
                    url = logToBeChecked.get("PROTOCOL_APP").toString();
                    url = url + "://";
                }
                for (String URL_KEY_NAME : Utils.URL_KEYS) {
                    if (!logToBeChecked.containsKey(URL_KEY_NAME)) continue;
                    url = url + logToBeChecked.get(URL_KEY_NAME).toString();
                }
                dataToBeChecked.add(url.trim());
            }
            if (!dataToBeChecked.isEmpty()) {
                String message2 = "";
                message2 = ThreatNotifier.checkURLForThreat(dataToBeChecked);
                if (!message2.equals("")) {
                    message2 = resourceBundle.getString("DefaultThreat.url.alert") + " : " + message2;
                    if (logMsg != null) {
                        message2 = message2 + "\n\nLog message : \n" + logMsg;
                    }
                    logToBeChecked.put("MESSAGE", message2);
                    if (logToBeChecked.get("SOURCE") == null) {
                        logToBeChecked.put("SOURCE", "-");
                    }
                    logToBeChecked.put("NOTIFID", Utils.THREAT_NF_ID + "");
                    NotificationHandler.addLogIntoQueue(new Hashtable(logToBeChecked));
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return false;
    }

    private boolean checkCommonAlertProfile(Map log, long deviceID) {
        String deviceType = (String)log.get("HOSTTYPE");
        boolean isWindowsType = "Windows".equals(deviceType);
        if (!this.configServerities.isEmpty()) {
            String severityStr;
            block13: {
                severityStr = "information";
                try {
                    Object sevObj = log.get("SEVERITY");
                    if (sevObj == null) break block13;
                    String s = null;
                    if (sevObj instanceof Integer) {
                        int sevInt = (Integer)log.get("SEVERITY");
                        s = isWindowsType ? (String)LuceneFormatter.winSeverity.get(sevInt) : (String)LuceneFormatter.sysSeverity.get(sevInt);
                    } else {
                        s = sevObj + "";
                        try {
                            if (s.trim().matches("\\d+")) {
                                int sevInt = Integer.parseInt(s.trim());
                                s = isWindowsType ? (String)LuceneFormatter.winSeverity.get(sevInt) : (String)LuceneFormatter.sysSeverity.get(sevInt);
                            }
                        }
                        catch (Exception exp) {
                            exp.printStackTrace();
                        }
                    }
                    if (s != null) {
                        severityStr = s;
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            if (!this.configServerities.contains(severityStr)) {
                return false;
            }
        }
        if (!this.configuredTypes.isEmpty()) {
            Object typeVal;
            Object v = typeVal = isWindowsType || deviceType != null && specialLogTypes.contains(deviceType) ? log.get("TYPE") : log.get("FACILITY");
            if (typeVal == null || typeVal != null && !this.configuredTypes.contains(("" + typeVal).toLowerCase())) {
                return false;
            }
        }
        boolean matched = this.jsonHandler.isCriteriaMatched(log);
        long logTime = (Long)log.get("TIME");
        boolean bl = matched = matched && this.hasThresholdReached(deviceID, logTime);
        if (matched) {
            LOGGER.log(Level.FINER, "Given Notification Criteria matched = true - for - ", this);
        }
        return matched;
    }

    public boolean isCriteriaMatched(Map log, long deviceID, String hourString) {
        if (!this.notifEnabled) {
            return false;
        }
        if (this.jsonHandler == null) {
            return false;
        }
        if (!(this.isCorrelationProfile || !this.profileHostGroups.isEmpty() && this.isHostGroupCritMatched(log) || !this.profileHosts.isEmpty() && this.isHostCritMatched(log))) {
            return false;
        }
        if (this.triggerTime != 0 && !this.isTriggerTimeMatched(Integer.valueOf(hourString))) {
            return false;
        }
        if (this.isDefaultProfile) {
            return this.checkThreatAlertProfile(log);
        }
        return this.checkCommonAlertProfile(log, deviceID);
    }

    private boolean isHostGroupCritMatched(Map log) {
        boolean status = false;
        Object id = log.get("HOSTID");
        if (id != null) {
            status = this.getHostGroupMatchingStatus(hostToGroupMap, Long.parseLong(id + ""));
        } else {
            id = log.get("APPID");
            if (id != null) {
                status = this.getHostGroupMatchingStatus(appToGroupMap, Long.parseLong(id + ""));
            }
        }
        LOGGER.log(Level.FINER, "isHostGroupCritMatched -> {0} for Input Log -> {1}", new Object[]{status, log});
        return status;
    }

    private boolean isHostCritMatched(Map log) {
        Object id;
        boolean status = false;
        Object hostId = log.get("HOSTID");
        if (hostId == null && (id = log.get("APPID")) != null && (hostId = appToHostMap.get(Long.parseLong(id + ""))) == null) {
            CustomAlertProfile.populateAppResourceDetails();
            hostId = appToHostMap.get(Long.parseLong(id + ""));
        }
        if (hostId != null && this.profileHosts.contains(Long.parseLong(hostId + ""))) {
            status = true;
        }
        LOGGER.log(Level.FINER, "isHostCritMatched -> {0} for Input Log -> {1}", new Object[]{status, log});
        return status;
    }

    private boolean getHostGroupMatchingStatus(Map<Long, Long> map, Long hostOrAppId) {
        Long groupId = map.get(hostOrAppId);
        if (groupId == null) {
            CustomAlertProfile.populateHostToGroupMap();
            groupId = map.get(hostOrAppId);
        }
        return groupId != null && this.profileHostGroups.contains(groupId);
    }

    public synchronized boolean hasThresholdReached(long hostId, long logTime) {
        if (this.configuredThresholdLimit < 0 || this.configuredThresholdDuration < 0L) {
            return false;
        }
        boolean status = false;
        long treeSetStartTime = logTime;
        long treeSetEndTime = logTime;
        TreeMultiset criteriaMatchedTimes = this.hostBasedRunningTime.get(hostId);
        boolean removeFirstEntry = true;
        if (criteriaMatchedTimes == null) {
            criteriaMatchedTimes = TreeMultiset.create();
            this.hostBasedRunningTime.put(hostId, (TreeMultiset<Long>)criteriaMatchedTimes);
        } else if (!criteriaMatchedTimes.isEmpty()) {
            treeSetStartTime = (Long)criteriaMatchedTimes.firstEntry().getElement();
            treeSetEndTime = (Long)criteriaMatchedTimes.lastEntry().getElement();
            if (logTime < treeSetStartTime) {
                treeSetStartTime = logTime;
                removeFirstEntry = false;
            } else if (logTime > treeSetEndTime) {
                treeSetEndTime = logTime;
            }
        }
        long treeSetDiff = treeSetEndTime - treeSetStartTime;
        criteriaMatchedTimes.add((Object)logTime);
        if (this.configuredThresholdLimit == 1 || criteriaMatchedTimes.size() >= this.configuredThresholdLimit && treeSetDiff >= 0L && treeSetDiff <= this.configuredThresholdDuration) {
            LOGGER.log(Level.FINER, "Notification Threshold matched. Here the criteriaMatchedTimes = {0}", criteriaMatchedTimes);
            criteriaMatchedTimes.clear();
            return true;
        }
        if (criteriaMatchedTimes.size() >= this.configuredThresholdLimit) {
            long removedTime = -1L;
            removedTime = removeFirstEntry ? ((Long)criteriaMatchedTimes.pollFirstEntry().getElement()).longValue() : ((Long)criteriaMatchedTimes.pollLastEntry().getElement()).longValue();
            LOGGER.log(Level.FINER, "TimeSet not within configured duration eventhough occurrence reached.Removing the Time -> {0}", removedTime);
        }
        LOGGER.log(Level.FINER, "Atlast in isThresholdMatched(), status = {0} for HOSTID -> {1} && criteriaMatchedTimes = {2} && LogTime --> {3}", new Object[]{status, hostId, criteriaMatchedTimes, logTime});
        return status;
    }

    public String toString() {
        return "Hosts -> " + this.profileHosts + " && HostGroups -->" + this.profileHostGroups + " && Criteria --> " + this.jsonHandler.toString() + " && TYPES --> " + this.configuredTypes + " && SEVERITIES -- > " + this.configServerities + " && notifEnabled -> " + this.notifEnabled + " && ThresholdTimeMillis -> " + this.configuredThresholdDuration + " && Occurance Value -> " + this.configuredThresholdLimit;
    }

    static {
        CustomAlertProfile.populateTypeMap();
        CustomAlertProfile.populateHostToGroupMap();
        specialLogTypes = Arrays.asList("Oracle", "Printer", "MSSQL");
        resourceBundle = ProductBundle.getInstance().getBundle();
        LOGGER = Logger.getLogger(CustomAlertProfile.class.getName());
    }
}

