/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf;

import com.adventnet.la.util.SmtpMailer;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.cnf.CorrelMailTemplate;
import com.adventnet.sa.server.cnf.CorrelationConstants;
import com.adventnet.sa.server.fieldgen.LogFormatHandlerImpl;
import com.adventnet.sa.server.nf.NewHTMLTemplate;
import com.adventnet.sa.server.nf.NotificationProfile;
import com.adventnet.sa.server.nf.Notifier;
import com.adventnet.sa.server.nf.NotifierConstants;
import com.adventnet.sa.server.nf.NotifierSettings;
import com.manageengine.ela.server.common.alerts.util.AlertUtil;
import com.manageengine.ela.server.correlation.notification.CorrelationNotificationHandler;
import com.zoho.za.dae.utils.ElasticUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EMailNotifier
implements Notifier {
    private static final Logger LOGGER = Logger.getLogger(EMailNotifier.class.getName());
    private static final File PRODUCT_LOGO_FILE = new File(System.getProperty("server.home") + File.separator + "webapps" + File.separator + "event" + File.separator + "images" + File.separator + "alert_mail_logo.png");
    private long notifId;
    private String to;
    private String subjectPattern;
    private String mailContent;
    private String mailContentPlain;
    private String notes;
    private Map<String, String> inlineImages;
    private boolean isCorrel = false;
    private NotifierSettings nfSettings = NotifierSettings.getInstance();
    private static Pattern findPattern = Pattern.compile("\\%(\\w+)\\%");
    public static boolean isHTMLFormat = true;
    public static boolean isFimType = false;

    public EMailNotifier(Row r) {
        this.notifId = (Long)r.get("NOTIFID");
        this.to = (String)r.get("MAILID");
        this.subjectPattern = (String)r.get("MAIL_SUBJECT");
        this.mailContent = (String)r.get("MAIL_CONTENT");
        this.mailContentPlain = (String)r.get("MAIL_CONTENT_PLAIN");
        this.isCorrel = CorrelationNotificationHandler.getInstance().isCorrelationProfile(this.notifId);
        this.notes = (String)r.get("MAIL_DESCRIPTION");
        this.inlineImages = new HashMap<String, String>();
        this.inlineImages.put("product_logo", PRODUCT_LOGO_FILE.getPath());
    }

    public void init(Map<String, String> profileProps) {
    }

    @Override
    public boolean notify(NotificationProfile profile, Hashtable log) {
        boolean notifstatus;
        String mailContent;
        isHTMLFormat = AlertUtil.getAlertMailFormat().equalsIgnoreCase("html");
        if (NotifierConstants.isDailyEmailLimitReached()) {
            LOGGER.info("DailyLimit Exceeded so skiping the AlertMail sending...");
            return true;
        }
        String subject = null;
        String message = null;
        String string = mailContent = isHTMLFormat ? this.mailContent : this.mailContentPlain;
        if (log.containsValue("FIM")) {
            isFimType = true;
            String string2 = subject = this.subjectPattern.isEmpty() ? profile.getNotifName() + " | " + log.get("DISPLAY_NAME") + " | " + log.get("CHANGETYPE") : this.replaceFields(this.subjectPattern, profile, log, true, true);
            if (mailContent == null || mailContent.isEmpty() || mailContent.equals("-")) {
                mailContent = AlertUtil.getDefaultAlertMailContent(this.notes, isHTMLFormat);
            }
            message = this.replaceFields(mailContent, profile, log, true, false);
        } else if (this.isCorrel) {
            subject = this.subjectPattern.isEmpty() ? profile.getNotifName() + " | " + log.get("DISPLAY_NAME") + " | " + log.get("CHANGETYPE") : CorrelationNotificationHandler.getInstance().replaceFields(this.subjectPattern, log, true);
            subject = this.replaceFields(subject, profile, log, false, true);
            if (mailContent == null || mailContent.isEmpty() || mailContent.equals("-")) {
                mailContent = CorrelationNotificationHandler.getInstance().getDefaultCorrEmailMessage((Long)log.get("RULE_ID"), isHTMLFormat);
            }
            message = CorrelationNotificationHandler.getInstance().replaceFields(mailContent, log, false);
        } else {
            String string3 = subject = this.subjectPattern.isEmpty() ? profile.getNotifName() + " | " + log.get("DISPLAY_NAME") + " | " + log.get("CHANGETYPE") : this.replaceFields(this.subjectPattern, profile, log, false, true);
            if (mailContent == null || mailContent.isEmpty() || mailContent.equals("-")) {
                mailContent = AlertUtil.getDefaultAlertMailContent(this.notes, isHTMLFormat);
            }
            message = this.replaceFields(mailContent, profile, log, false, false);
        }
        if (subject.trim().length() == 0) {
            subject = profile.getNotifName() + " | " + log.get("DISPLAY_NAME") + " | " + log.get("CHANGETYPE");
        }
        if (!isHTMLFormat && message != null && !message.isEmpty()) {
            message = message.replaceAll("<", Matcher.quoteReplacement("&lt;")).replaceAll(">", Matcher.quoteReplacement("&gt;")).replaceAll("\n", Matcher.quoteReplacement("<br/>"));
        }
        if (notifstatus = this.sendEmail(message, subject)) {
            NotifierConstants.updateSentEmailCount();
        }
        return notifstatus;
    }

    private boolean sendEmail(String message, String subject) {
        String mailCover;
        boolean notifStatus = false;
        Map<String, String> mailServerSettings = this.nfSettings.getMailServerSettings();
        String server = mailServerSettings.get("SMTPSERVER");
        String port = mailServerSettings.get("PORT");
        String username = mailServerSettings.get("USERNAME");
        String password = mailServerSettings.get("PASSWORD");
        String auth = mailServerSettings.get("AUTHENTICATE");
        String from = mailServerSettings.get("FROM");
        String tls = mailServerSettings.get("TLS");
        if (isHTMLFormat) {
            mailCover = new NewHTMLTemplate("ELAMailCover.html", null, true).getContent();
        } else {
            mailCover = new NewHTMLTemplate("ELAMailCoverPlain.txt", null, false).getContent();
            mailCover = mailCover.replaceAll("<", Matcher.quoteReplacement("&lt;")).replaceAll(">", Matcher.quoteReplacement("&gt;")).replaceAll("\n", Matcher.quoteReplacement("<br/>"));
        }
        try {
            String statusMsg;
            SmtpMailer mailer = new SmtpMailer(server, from, this.to, subject, null, username, password, port, tls);
            mailCover = mailCover.replaceAll("\\%MAIL_CONTENT\\%", Matcher.quoteReplacement(message));
            if (isHTMLFormat) {
                mailer.addInlineImages(this.inlineImages);
            }
            boolean bl = notifStatus = (statusMsg = mailer.sendMessage(mailCover)) == null;
            if (notifStatus) {
                LOGGER.info("Alert mail sent to " + this.to);
            } else {
                LOGGER.info("Unable to send alert email to " + this.to);
            }
            notifStatus = true;
        }
        catch (Exception e) {
            LOGGER.info("Exception while sending mail");
            e.printStackTrace();
            notifStatus = false;
        }
        return notifStatus;
    }

    @Override
    public synchronized boolean processNotification(Hashtable log) {
        try {
            String mailContent;
            CorrelMailTemplate ct;
            isHTMLFormat = AlertUtil.getAlertMailFormat().equalsIgnoreCase("html");
            String rid = log.get("RULEID").toString();
            Long ruleid = Long.valueOf(rid);
            if (CorrelationConstants.isDailyEmailLimitReached()) {
                LOGGER.info("DailyLimit Exceeded so skiping the CorrelationMail sending...");
                return true;
            }
            if (isHTMLFormat) {
                ct = new CorrelMailTemplate("CorrelationMail.html", "", log);
                mailContent = ct.getContent();
            } else {
                ct = new CorrelMailTemplate("CorrelationMailPlain.txt", "", log);
                mailContent = ct.getContent();
            }
            String message = this.replaceFields(mailContent, null, log, false, false);
            boolean notifstatus = this.sendEmail(message, this.subjectPattern);
            if (notifstatus) {
                CorrelationConstants.updateSentEmailCount();
            }
            return notifstatus;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String replaceFields(String content, NotificationProfile profile, Hashtable log, boolean forFim, boolean forSubject) {
        StringBuffer sb = new StringBuffer();
        Matcher m = findPattern.matcher(content);
        while (m.find()) {
            String toBeReplaced = m.group(1);
            String replacement = null;
            try {
                block10 : switch (toBeReplaced) {
                    case "SOURCE": {
                        if (forFim) {
                            if (forSubject) {
                                replacement = log.get("CHANGETYPE");
                                break;
                            }
                            if (log.get("USERNAME") != null && !"-".equals((String)log.get("USERNAME"))) {
                                replacement = log.get("CHANGETYPE") + " by " + log.get("USERNAME");
                                break;
                            }
                            replacement = log.get("CHANGETYPE");
                            break;
                        }
                        replacement = log.get("SOURCE");
                        break;
                    }
                    case "ALERTNAME": {
                        replacement = profile != null ? profile.getNotifName() : "-";
                        break;
                    }
                    case "TIME": {
                        replacement = log.get("Time");
                        break;
                    }
                    case "EVENTID": {
                        replacement = log.get("EVENTID");
                        if (!forSubject && (replacement == null || replacement.toString().isEmpty())) {
                            replacement = "N/A";
                        }
                        break;
                    }
                    case "HOSTNAME": {
                        replacement = log.get("DISPLAY_NAME");
                        if (replacement == null || replacement.toString().isEmpty()) {
                            replacement = log.get("HOSTNAME");
                        }
                        break;
                    }
                    case "MESSAGE": {
                        if (forSubject) {
                            replacement = " ";
                            break;
                        }
                        if (forFim) {
                            replacement = log.get("FILENAME") + " is " + log.get("CHANGETYPE");
                            if (log.get("USERNAME") != null && !"-".equals((String)log.get("USERNAME"))) {
                                replacement = replacement + " by " + log.get("USERNAME");
                            }
                        } else {
                            for (String field : ElasticUtils.DEFAULT_MESSAGE_FIELDS) {
                                replacement = log.get(field);
                                if (replacement != null && !replacement.toString().isEmpty() && !replacement.toString().equals("-")) break block10;
                            }
                        }
                        break;
                    }
                    case "LOGTYPE": {
                        if (forFim) {
                            replacement = "FIM";
                            break;
                        }
                        replacement = log.get("HOSTTYPE");
                        if (replacement == null && log.get("FORMATID") != null) {
                            replacement = LogFormatHandlerImpl.getInstance().getFormatNameForId((Long)log.get("FORMATID"));
                        }
                        break;
                    }
                    default: {
                        replacement = log.get(toBeReplaced);
                    }
                }
            }
            catch (Exception e) {
                replacement = "-";
                LOGGER.info("Exception while replacing macros in alert mail");
            }
            if (replacement == null || replacement.toString().isEmpty()) {
                m.appendReplacement(sb, "-");
                continue;
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(replacement.toString()));
        }
        m.appendTail(sb);
        String replacedContent = sb.toString();
        return replacedContent.trim();
    }
}

