/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.alerts.incident.IncidentDataProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class IncidentToolConstants {
    private static IncidentToolConstants instance = null;
    private Map<String, Map<?, ?>> incidentToolDetailsMap = new HashMap();

    public static synchronized IncidentToolConstants getInstance() {
        if (instance == null) {
            instance = new IncidentToolConstants();
        }
        return instance;
    }

    public void init() {
        this.populateDefaultToolDetails();
    }

    private void populateDefaultToolDetails() {
        HashMap profileMap;
        block7: {
            profileMap = new HashMap();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSIncidentToolConfiguration"));
            query.addSelectColumn(Column.getColumn((String)"IncidentToProfileMapping", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"ADSIncidentToolConfiguration", (String)"*"));
            query.setCriteria(new Criteria(Column.getColumn((String)"ADSIncidentToolConfiguration", (String)"CUSTOM_CLASS_NAME"), (Object)"NONE", 0));
            query.addJoin(new Join("ADSIncidentToolConfiguration", "IncidentToProfileMapping", new String[]{"CONFIG_ID"}, new String[]{"CONFIG_ID"}, 1));
            try {
                DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
                if (dobj == null) break block7;
                Iterator itr = dobj.getRows("IncidentToProfileMapping");
                while (itr.hasNext()) {
                    Set<Long> apiIDSet = new LinkedHashSet<Long>();
                    Row r = (Row)itr.next();
                    if (((Boolean)r.get("NOTIFY_ALL")).booleanValue()) {
                        JSONArray availableProfiles = IncidentDataProvider.getAllProfiles();
                        Long configID = (Long)r.get("CONFIG_ID");
                        apiIDSet.add(configID);
                        for (int i = 0; i < availableProfiles.length(); ++i) {
                            JSONObject tempObject = availableProfiles.getJSONObject(i);
                            profileMap.put(tempObject.getLong("NOTIF_ID"), apiIDSet);
                        }
                        break;
                    }
                    Long notifID = (Long)r.get("NOTIF_ID");
                    if (profileMap.containsKey(notifID)) {
                        apiIDSet = (Set)profileMap.get(notifID);
                    } else {
                        apiIDSet.add((Long)r.get("CONFIG_ID"));
                    }
                    profileMap.put(notifID, apiIDSet);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.incidentToolDetailsMap.put("DEFAULT_CONFIGURATION", profileMap);
    }

    public void refreshToolSettings() {
        this.init();
    }

    public Map<String, Map<?, ?>> getToolConfigMap() {
        return this.incidentToolDetailsMap;
    }
}

