/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf;

import com.adventnet.la.util.ProductBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NewHTMLTemplate {
    private String content = null;
    private boolean isHTML = true;
    private static StringBuilder messageBuilder = new StringBuilder();
    private static StringBuilder plainText = new StringBuilder();

    public NewHTMLTemplate(String fileName, String mailContent, boolean isHTML) {
        this.isHTML = isHTML;
        this.content = this.loadContent(fileName, mailContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadContent(String fileName, String mailContent) {
        StringBuffer buffer = new StringBuffer();
        String templateFile = System.getProperty("server.home") + File.separator + "server" + File.separator + "conf" + File.separator + fileName;
        BufferedReader reader = null;
        String content = null;
        try {
            reader = new BufferedReader(new FileReader(templateFile));
            String temp = null;
            while ((temp = reader.readLine()) != null) {
                buffer.append(temp);
                if (this.isHTML) continue;
                buffer.append("\n");
            }
            content = NewHTMLTemplate.updateI18NStringsforRpt(buffer.toString(), mailContent, this.isHTML);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return content;
    }

    private static String updateI18NStringsforRpt(String content, String mailContent, boolean isHTML) {
        ResourceBundle rb = ProductBundle.getInstance().getBundle();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("AlertMailH1", rb.getString("AlertMailNewHead1"));
            map.put("AlertMailH2", rb.getString("AlertMailNewHead2"));
            map.put("AlertMailH3", rb.getString("AlertMailNewHead3"));
            map.put("AlertMailH4", rb.getString("AlertMailNewHead4"));
            map.put("AlertMailH5", rb.getString("AlertMailNewHead5"));
            map.put("AlertMailH55", rb.getString("AlertMailNewHead55"));
            map.put("AlertMailH6", rb.getString("AlertMailNewHead6"));
            map.put("AlertMailH7", rb.getString("HOST"));
            map.put("AlertMailH8", rb.getString("TIME"));
            map.put("AlertMailF1", rb.getString("AlertMailNewFoot1"));
            if (mailContent == null || mailContent.trim().isEmpty()) {
                map.put("DYNAMIC_CONTENT", "");
            } else if (isHTML) {
                map.put("DYNAMIC_CONTENT", NewHTMLTemplate.getDataForMessage(rb, mailContent));
            } else {
                map.put("DYNAMIC_CONTENT", NewHTMLTemplate.getPlainMessage(rb, mailContent));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return NewHTMLTemplate.replaceStringsFromMap(content, map);
    }

    private static String getDataForMessage(ResourceBundle rb, String getMailContent) {
        StringBuilder finalString = new StringBuilder();
        try {
            String messagePattern = new String(getMailContent);
            String appendString = messageBuilder.toString();
            for (String field : messagePattern.split(",")) {
                field = field.trim();
                String replacedValue = "";
                try {
                    replacedValue = rb.getString(field);
                }
                catch (Exception e) {
                    replacedValue = field;
                }
                String output = appendString.replaceAll("\\%key\\%", replacedValue);
                output = output.replaceAll("\\%value\\%", "%" + Matcher.quoteReplacement(field) + "%");
                finalString.append(output);
                finalString.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalString.toString();
    }

    private static String getPlainMessage(ResourceBundle rb, String getMailContent) {
        StringBuilder finalString = new StringBuilder();
        try {
            String messagePattern = new String(getMailContent);
            String appendString = plainText.toString();
            for (String field : messagePattern.split(",")) {
                field = field.trim();
                String replacedValue = "";
                try {
                    replacedValue = rb.getString(field);
                }
                catch (Exception e) {
                    replacedValue = field;
                }
                String output = appendString.replaceAll("\\%key\\%", replacedValue);
                output = output.replaceAll("\\%value\\%", "%" + Matcher.quoteReplacement(field) + "%");
                finalString.append(output);
                finalString.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalString.toString();
    }

    private static String replaceStringsFromMap(String content, Map<String, String> map) {
        StringBuffer sb = new StringBuffer();
        Pattern findPattern = Pattern.compile("\\%(\\w+)\\%");
        Matcher m = findPattern.matcher(content);
        while (m.find()) {
            String toBeReplaced = m.group(1);
            String replacement = map.get(toBeReplaced);
            if (replacement == null) {
                replacement = m.group(0);
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String getContent() {
        return this.content;
    }

    static {
        messageBuilder.append("<tr>");
        messageBuilder.append("<td width=\"23%\" style=\"font-family:Gotham, 'Verdana',Helvetica Neue, Helvetica, Arial, sans-serif;font-size:11px;line-height:22px;border-bottom:1px solid #e4e4e4;border-right:1px solid #e4e4e4;padding-left:10px;color:#000;\">%key%</td>");
        messageBuilder.append("<td width=\"77%\" style=\"font-family:Gotham, 'Verdana',Helvetica Neue, Helvetica, Arial, sans-serif;font-size:11px;line-height:22px;border-bottom:1px solid #e4e4e4;border-right:1px solid #e4e4e4;padding-left:10px;\">%value%</td>");
        messageBuilder.append("</tr>");
        plainText.append("%key% : %value%");
    }
}

