/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.nf.NotificationProfile;
import com.adventnet.sa.server.nf.Notifier;
import com.adventnet.sa.server.nf.assign.AssignedToHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class NotificationHandler
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(NotificationHandler.class.getName());
    private NotificationManager nmInstance = NotificationManager.getInstance();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss, EEE, MMM dd yyyy");
    private Calendar cal = Calendar.getInstance();
    private static LinkedBlockingQueue<Hashtable> notificationLogQueue = new LinkedBlockingQueue();
    private static final int MAX_THREAD_LIMIT = Integer.parseInt(System.getProperty("maxNotifHandlerThread", "2"));
    private static final int MAX_ROW_COUNT = 20;
    private DBType dbType = "mysql".equals(System.getProperty("DBType", "mysql")) ? DBType.MYSQL : DBType.MSSQL;
    private static boolean isPostgres = "postgres".equals(System.getProperty("DBType", "postgres"));
    private static int runningThreads = 0;
    private static boolean supportsBatchUpdates = true;
    private static boolean isFirstCheck = false;
    private boolean doExecuteBatch = false;
    private final Object batchUpdateSyncObj = new Object();
    private DataObject assignDO = null;

    private static synchronized void checkThreadStatus() {
        if (runningThreads == 0 || runningThreads < MAX_THREAD_LIMIT && notificationLogQueue.size() > 1000) {
            new Thread(new NotificationHandler()).start();
            ++runningThreads;
        }
    }

    private static synchronized void decrementRunningThreadCount() {
        if (--runningThreads < 0) {
            runningThreads = 0;
        }
    }

    public static void addLogIntoQueue(Hashtable log) {
        notificationLogQueue.add(log);
        NotificationHandler.checkThreadStatus();
    }

    @Override
    public void run() {
        if (notificationLogQueue.isEmpty()) {
            return;
        }
        int notifLogCount = 0;
        try {
            while (!notificationLogQueue.isEmpty()) {
                Hashtable log = notificationLogQueue.poll();
                if (log == null) continue;
                this.sendNotifications(log);
                if (++notifLogCount < 20) continue;
                this.executeBatchInsert();
                notifLogCount = 0;
            }
            this.executeBatchInsert();
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, exp.getMessage(), exp);
        }
        finally {
            NotificationHandler.decrementRunningThreadCount();
        }
    }

    private void sendNotifications(Hashtable log) {
        String notifIds = (String)log.remove("NOTIFID");
        if (notifIds == null) {
            return;
        }
        String[] notifIdArr = notifIds.split(",");
        LOGGER.log(Level.FINER, "notification criteria matched for {0} notifIds, with log {1}", new Object[]{notifIdArr.length, log});
        for (String notifIdStr : notifIdArr) {
            try {
                log.put("NOTIFID", notifIdStr);
                Long assigned_to = AssignedToHandler.getInstance().process(log);
                boolean status = true;
                NotificationProfile profile = this.nmInstance.getNotificationProfile(Long.parseLong(notifIdStr));
                if (profile == null) continue;
                for (Notifier notifier : profile.getNotifiers()) {
                    boolean limitstatus = this.limitReached(profile);
                    LOGGER.log(Level.FINER, "Advanced Notifier Limit Status {0}", limitstatus);
                    if (limitstatus) continue;
                    try {
                        status &= notifier.notify(profile, log);
                    }
                    catch (Throwable throwable) {
                        status = false;
                        LOGGER.log(Level.FINER, "Failed to process notification \n{0}", throwable);
                    }
                }
                if (supportsBatchUpdates) {
                    this.updateDBInBatch(log, profile, status, assigned_to);
                    continue;
                }
                this.updateDB(log, profile, status, assigned_to);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private void updateExpId(Long expid, String jsonString) {
        try {
            LOGGER.log(Level.FINER, "Advanced Notiers jsonString {0} and expid {1}", new Object[]{jsonString, expid});
            UpdateQueryImpl updatequery = new UpdateQueryImpl("LAExpression");
            updatequery.setCriteria(new Criteria(new Column("LAExpression", "EXP_ID"), (Object)expid, 0));
            updatequery.setUpdateColumn("VALUE", (Object)jsonString);
            DataAccess.update((UpdateQuery)updatequery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean limitReached(NotificationProfile profile) {
        block18: {
            try {
                JSONObject advNotifiers = profile.getJSonNotifTimer();
                LOGGER.log(Level.FINER, "Custom Alert Profile -> {0} &  JSON Advanced Notifier -> {1}", new Object[]{profile, advNotifiers});
                if (advNotifiers == null) {
                    return false;
                }
                long timeinmillis = System.currentTimeMillis();
                if (!advNotifiers.optBoolean("notifstatus")) break block18;
                long lastnotiftime = (Long)advNotifiers.get("profiletime");
                long updatedtime = 0L;
                if (!advNotifiers.optBoolean("advlimitreachd")) {
                    JSONObject jSONObject = advNotifiers;
                    synchronized (jSONObject) {
                        advNotifiers.put("advlimitreachd", true);
                        this.updateExpId(profile.getExpId(), advNotifiers.toString());
                    }
                    LOGGER.log(Level.FINER, "First matching alert for this profile with advanced notification enabled sent...");
                    return false;
                }
                if (timeinmillis < lastnotiftime) {
                    LOGGER.log(Level.FINER, "Advanced Alert Notifier only once limit reached hence not notifying");
                    return true;
                }
                if (timeinmillis <= lastnotiftime) break block18;
                String timertype = (String)advNotifiers.get("notiftimertype");
                GregorianCalendar cal = new GregorianCalendar();
                if ("day".equals(timertype)) {
                    ((Calendar)cal).add(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    updatedtime = cal.getTimeInMillis();
                } else if ("week".equals(timertype)) {
                    ((Calendar)cal).add(3, 1);
                    cal.set(7, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    updatedtime = cal.getTimeInMillis();
                } else if ("month".equals(timertype)) {
                    ((Calendar)cal).add(2, 1);
                    cal.set(5, 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    updatedtime = cal.getTimeInMillis();
                } else if ("custom".equals(timertype)) {
                    long customdays = Long.parseLong((String)advNotifiers.get("notifdays"));
                    long customhours = Long.parseLong((String)advNotifiers.get("notifhours"));
                    long custommins = Long.parseLong((String)advNotifiers.get("notifminutes"));
                    long customduration = (customdays * 24L * 60L * 60L + customhours * 60L * 60L + custommins * 60L) * 1000L;
                    updatedtime = timeinmillis + customduration;
                }
                JSONObject jSONObject = advNotifiers;
                synchronized (jSONObject) {
                    advNotifiers.put("profiletime", updatedtime);
                }
                this.updateExpId(profile.getExpId(), advNotifiers.toString());
                LOGGER.log(Level.FINER, "Advanced Notifier Expired hence resetting the profile to future time");
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDBInBatch(Hashtable log, NotificationProfile profile, boolean status, Long assigned_to) {
        Object object = this.batchUpdateSyncObj;
        synchronized (object) {
            if (this.assignDO == null) {
                try {
                    this.assignDO = DataAccess.constructDataObject();
                }
                catch (DataAccessException e) {
                    e.printStackTrace();
                }
            }
            Row alertrow = this.getAlertRow(log, profile, status);
            Row assignrow = this.getAlertAssignRow(alertrow, assigned_to);
            try {
                this.assignDO.addRow(alertrow);
                if (assignrow != null) {
                    this.assignDO.addRow(assignrow);
                }
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
            this.doExecuteBatch = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchInsert() {
        Object object = this.batchUpdateSyncObj;
        synchronized (object) {
            if (this.doExecuteBatch) {
                try {
                    if (this.assignDO != null && !this.assignDO.isEmpty()) {
                        PersistenceDBUtil.getPersistence().update(this.assignDO);
                        this.assignDO = null;
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(NotificationHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDB(Hashtable log, NotificationProfile profile, boolean status, Long assigned_to) {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = RelationalAPI.getInstance().getConnection();
            stmt = conn.createStatement();
            try {
                if (isFirstCheck && !supportsBatchUpdates) {
                    isFirstCheck = false;
                    LOGGER.log(Level.INFO, "supportsBatchUpdates by DB = {0}", supportsBatchUpdates);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Row alertrow = this.getAlertRow(log, profile, status);
            Row assignrow = this.getAlertAssignRow(alertrow, assigned_to);
            DataObject addAlertDO = DataAccess.constructDataObject();
            addAlertDO.addRow(alertrow);
            if (assignrow != null) {
                addAlertDO.addRow(assignrow);
            }
            DataAccess.update((DataObject)addAlertDO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getFormattedTime(Long timeInMillis) {
        this.cal.setTimeInMillis(timeInMillis);
        return this.dateFormat.format(this.cal.getTime());
    }

    private String getAlertQuery(Hashtable log, NotificationProfile profile, boolean status, long audit_id) {
        StringBuilder query = new StringBuilder();
        String logMesg = "-";
        if (log.containsValue("FIM")) {
            logMesg = (String)log.get("FILENAME");
            if (this.dbType == DBType.MYSQL) {
                logMesg = logMesg.replace("\\", "\\\\");
            }
        } else {
            logMesg = (String)log.get("MESSAGE");
            if (logMesg == null) {
                logMesg = (String)log.get("RAWLOG");
            }
        }
        if (logMesg == null) {
            logMesg = "-";
        }
        logMesg = logMesg.replaceAll("'", "''");
        if (isPostgres) {
            query.append("insert into LAAlertAudit (AUDIT_ID,NF_ID, NOTIFIEDTIME, TYPE, SOURCE, STATUS, CRITICALITY, ERROR_DETAILS, RECORD_COLUMN, RECORD_ID, OWNERNAME) values(");
        } else {
            query.append("insert into LAAlertAudit values(");
        }
        query.append(audit_id + ", ");
        query.append(profile.getNotifId() + ", ");
        query.append(log.get("TIME") + ", ");
        query.append("'Syslog', ");
        query.append("'" + log.get("DISPLAY_NAME") + "', ");
        query.append((status ? 1 : -1) + ", ");
        query.append("'" + profile.getCriticality() + "', ");
        if (log.containsValue("FIM")) {
            if (log.get("USERNAME") != null && !"-".equals((String)log.get("USERNAME"))) {
                query.append("':" + log.get("USERNAME") + " " + log.get("CHANGETYPE") + " -> " + logMesg + "', ");
            } else {
                query.append("':" + log.get("CHANGETYPE") + " -> " + logMesg + "', ");
            }
        } else {
            String sourceStr = log.get("SOURCE") != null ? log.get("SOURCE") + "" : "Details";
            query.append("'" + sourceStr + ":" + logMesg + "', ");
        }
        query.append("'', ");
        query.append("0, ");
        query.append("'-')");
        LOGGER.fine("Returning query : " + query);
        return query.toString();
    }

    private Row getAlertRow(Hashtable log, NotificationProfile profile, boolean status) {
        Row r = new Row("LAAlertAudit");
        String logMesg = "-";
        if (log.containsValue("FIM")) {
            logMesg = (String)log.get("FILENAME");
            if (this.dbType == DBType.MYSQL) {
                logMesg = logMesg.replace("\\", "\\\\");
            }
        } else {
            logMesg = (String)log.get("MESSAGE");
            if (logMesg == null) {
                logMesg = (String)log.get("RAWLOG");
            }
        }
        if (logMesg == null) {
            logMesg = "-";
        }
        logMesg = logMesg.replaceAll("'", "''");
        r.set("NF_ID", (Object)profile.getNotifId());
        r.set("NOTIFIEDTIME", log.get("TIME"));
        r.set("TYPE", (Object)"Syslog");
        r.set("SOURCE", log.containsKey("DISPLAY_NAME") ? log.get("DISPLAY_NAME") : "null");
        r.set("STATUS", (Object)(status ? 1 : -1));
        r.set("CRITICALITY", (Object)profile.getCriticality());
        r.set("RECORD_COLUMN", (Object)"");
        r.set("RECORD_ID", (Object)0);
        r.set("OWNERNAME", (Object)"-");
        if (log.containsValue("FIM")) {
            if (log.get("USERNAME") != null && !"-".equals((String)log.get("USERNAME"))) {
                r.set("ERROR_DETAILS", (Object)(":" + log.get("USERNAME") + " " + log.get("CHANGETYPE") + " -> " + logMesg));
            } else {
                r.set("ERROR_DETAILS", (Object)(":" + log.get("CHANGETYPE") + " -> " + logMesg));
            }
        } else {
            String sourceStr = log.get("SOURCE") != null ? log.get("SOURCE") + "" : "Details";
            r.set("ERROR_DETAILS", (Object)(sourceStr + ":" + logMesg));
        }
        return r;
    }

    private Row getAlertAssignRow(Row alertrow, Long assigned_to) {
        if (assigned_to < 1L) {
            return null;
        }
        Row r = new Row("ELA_AlertAssignMapping");
        r.set("AUDIT_ID", alertrow.get("AUDIT_ID"));
        r.set("USER_ID", (Object)assigned_to);
        return r;
    }

    private static enum DBType {
        MYSQL("mysql"),
        MSSQL("mssql");

        String dbName;

        private DBType(String dbName) {
            this.dbName = dbName;
        }

        public String getDBName() {
            return this.dbName;
        }
    }
}

