/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.LaUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.sa.server.nf.CustomAlertProfile;
import com.adventnet.sa.server.nf.IncidentToolConstants;
import com.adventnet.sa.server.nf.NotificationHandler;
import com.adventnet.sa.server.nf.NotificationProfile;
import com.adventnet.sa.server.nf.NotifierConstants;
import com.adventnet.sa.server.nf.NotifierSettings;
import com.adventnet.sa.server.util.CommonUtil;
import com.manageengine.ela.server.correlation.core.listener.NotificationListener;
import com.zoho.za.dae.database.DBManager;
import com.zoho.za.dae.threat.Utils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class NotificationManager {
    private static final Logger LOGGER = Logger.getLogger(NotificationManager.class.getName());
    private Map<Long, NotificationProfile> profileMap = new HashMap<Long, NotificationProfile>();
    public Map<Long, String> hostMap = new HashMap<Long, String>();
    private static NotificationManager instance = null;
    private Map<Long, CustomAlertProfile> customProfiles = new ConcurrentHashMap<Long, CustomAlertProfile>();
    private Map<Long, CustomAlertProfile> enabledProfile = new ConcurrentHashMap<Long, CustomAlertProfile>();
    private boolean handleHighFlowrate = false;
    private int maxLogsInMemory = 30000;
    private int logLimitForNewThread = 1000;
    private List<Map> logsForNotificationCheck = new ArrayList<Map>();
    private Thread criteriaCheckerMainThread = null;
    private static final int MAX_THREADS = 2;
    private int runningSubThreads = 0;
    private int unProcessedlogs = 0;
    private boolean shutdown = false;
    private final Object waitObj = new Object();

    private NotificationManager() {
        this.handleHighFlowrate = "true".equals(System.getProperty("handleHighFlow", "false"));
        if (this.handleHighFlowrate) {
            int valueFromSysConfiguration = -1;
            try {
                valueFromSysConfiguration = Integer.valueOf((String)CommonUtil.getSysConfiguration("NotificationBufferSize"));
            }
            catch (Exception e) {
                LOGGER.info("Exception while gettting value from systemconfigurations for : " + e.toString());
            }
            this.maxLogsInMemory = valueFromSysConfiguration > -1 ? valueFromSysConfiguration : 50000;
            LOGGER.info("maxLogsInMemory set in notificationManager instance : " + this.maxLogsInMemory);
            this.logLimitForNewThread = 20000;
        }
    }

    public static synchronized NotificationManager getInstance() {
        if (instance == null) {
            instance = new NotificationManager();
        }
        return instance;
    }

    public void init() {
        LOGGER.info("Init Notification Manager");
        NotifierSettings.getInstance().init();
        NotifierConstants.init();
        IncidentToolConstants.getInstance().init();
        this.initProfiles();
        this.initHostMap();
    }

    private void initHostMap() {
        try {
            DataObject hostDO = DataAccess.get((String)"Hosts", (Criteria)null);
            Iterator hostItr = hostDO.getRows("Hosts");
            while (hostItr.hasNext()) {
                Row hostRow = (Row)hostItr.next();
                this.hostMap.put((Long)hostRow.get("HOST_ID"), (String)hostRow.get("DISPLAY_NAME"));
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private void initProfiles() {
        try {
            String baseTable = "NotificationType";
            SelectQueryImpl query = new SelectQueryImpl(new Table("NotificationType"));
            query.addSelectColumn(new Column("NotificationType", "*"));
            query.addSelectColumn(new Column("HostNotification", "*"));
            query.addSelectColumn(new Column("HostGroupNotification", "*"));
            query.addSelectColumn(new Column("LAExpression", "*"));
            query.addSelectColumn(new Column("LACriteria2Expressions", "*"));
            query.addJoin(new Join("NotificationType", "HostNotification", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
            query.addJoin(new Join("NotificationType", "HostGroupNotification", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
            String refTable1 = "LACriteria2Expressions";
            String refTable2 = "LAExpression";
            String[] baseJoinCol = new String[]{"NOTIFID"};
            String[] refJoinCol1 = new String[]{"CRIT_ID"};
            String[] refJoinCol2 = new String[]{"EXP_ID"};
            Join join3 = new Join(baseTable, refTable1, baseJoinCol, refJoinCol1, 1);
            Join join4 = new Join(refTable1, refTable2, refJoinCol2, refJoinCol2, 2);
            query.addJoin(join3);
            query.addJoin(join4);
            Criteria hostNotfnCrit = new Criteria(Column.getColumn((String)"HostNotification", (String)"HOSTID"), null, 1);
            Criteria hostGrpNotfnCrit = new Criteria(Column.getColumn((String)"HostGroupNotification", (String)"GROUPID"), null, 1);
            Criteria defaultCrit = new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)-1000L, 0);
            Criteria defaultCorrCriteria = new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)-1001L, 0);
            Criteria corrNotifCriteria = new Criteria(Column.getColumn((String)"NotificationType", (String)"TYPE"), (Object)new long[]{-1002L, -1003L}, 8);
            query.setCriteria(hostNotfnCrit.or(hostGrpNotfnCrit).or(defaultCrit).or(defaultCorrCriteria).or(corrNotifCriteria));
            DataObject doo = DataAccess.get((SelectQuery)query);
            Iterator iter = doo.getRows("NotificationType");
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                Long type = (Long)r.get("TYPE");
                Long notifId = (Long)r.get("NOTIFID");
                Criteria laCriteria = new Criteria(new Column("LACriteria2Expressions", "CRIT_ID"), (Object)notifId, 0);
                ArrayList<Long> expidList = new ArrayList<Long>();
                Iterator laItr = doo.getRows("LACriteria2Expressions", laCriteria);
                while (laItr.hasNext()) {
                    Row laCrit = (Row)laItr.next();
                    Long expid = (Long)laCrit.get("EXP_ID");
                    expidList.add(expid);
                }
                Criteria jsontimerCrit1 = new Criteria(Column.getColumn((String)"LAExpression", (String)"EXP_ID"), (Object)expidList.toArray(), 8);
                Criteria jsontimerCrit2 = new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"JSONNotifTimer", 0);
                Criteria jsontimer = jsontimerCrit1.and(jsontimerCrit2);
                String advanceNotifier = (String)doo.getValue("LAExpression", "VALUE", jsontimer);
                JSONObject jsonadvanceNotifier = null;
                try {
                    if (advanceNotifier != null) {
                        jsonadvanceNotifier = new JSONObject(advanceNotifier);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Long expid = (Long)doo.getValue("LAExpression", "EXP_ID", jsontimer);
                this.profileMap.put(notifId, new NotificationProfile(notifId, expid, jsonadvanceNotifier));
                if (type != null && (type == -1002L || type == -1003L)) continue;
                int thresholdCount = (Integer)r.get("NOOFOCCURRENCE");
                int thresholdDuration = (Integer)r.get("NOTIFINTERVAL");
                int triggerTime = (Integer)r.get("TRIGGERTIME");
                this.addCustomAlertProfile(doo, r, notifId, thresholdCount, (long)thresholdDuration * 1000L, triggerTime, join4);
            }
            LOGGER.fine("Notification Profiles :" + this.profileMap);
            LOGGER.log(Level.INFO, "Custom Alert Profiles :{0}", this.customProfiles);
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
        }
    }

    public void refreshAllNotifiers() {
        for (NotificationProfile value : this.profileMap.values()) {
            value.refreshNotifiers();
        }
    }

    public boolean isAS400Profile(long notifId) {
        CustomAlertProfile alertProf = this.customProfiles.get(notifId);
        boolean jsonProfile = false;
        if (alertProf != null) {
            jsonProfile = alertProf.isAS400Profile();
        }
        return jsonProfile;
    }

    public void removeConfiguredHost(long notifId, long hostId) {
        CustomAlertProfile alertProf = this.customProfiles.get(notifId);
        if (alertProf != null) {
            alertProf.removeConfiguredHost(hostId);
        }
    }

    public void changeNotificationStatus(long notifId, int statusInt) {
        CustomAlertProfile cusProfile = this.customProfiles.get(notifId);
        if (statusInt == 1) {
            this.enabledProfile.put(notifId, cusProfile);
        } else {
            this.enabledProfile.remove(notifId);
        }
        if (cusProfile != null) {
            cusProfile.setNotificationStatus(statusInt);
        } else {
            LOGGER.log(Level.SEVERE, "CustomAlertProfile Object is unavailable in {0} for NotificationId : {1}", new Object[]{this.customProfiles, notifId});
        }
    }

    public void changeProfNotificationStatus(long notifID, boolean isEnabled) {
        NotificationProfile profile = this.getNotificationProfile(notifID);
        if (profile == null) {
            this.updateProfile(notifID, null, null);
            profile = this.getNotificationProfile(notifID);
        }
        if (isEnabled) {
            profile.enableNotification();
        } else {
            profile.disableNotification();
        }
    }

    public void addCustomActionProfile(DataObject dobj, Row notifTypeRow) {
        String[] refJoinCol2 = new String[]{"EXP_ID"};
        Join expressionJoin = new Join("LACriteria2Expressions", "LAExpression", refJoinCol2, refJoinCol2, 2);
        this.addCustomAlertProfile(dobj, notifTypeRow, (Long)notifTypeRow.get("NOTIFID"), 1, 1000L, 0, expressionJoin);
    }

    public void addCustomAlertProfile(DataObject dobj, Row notifTypeRow) {
        Long notifId = (Long)notifTypeRow.get("NOTIFID");
        int thresholdCount = (Integer)notifTypeRow.get("NOOFOCCURRENCE");
        int thresholdDuration = (Integer)notifTypeRow.get("NOTIFINTERVAL");
        int triggerTime = (Integer)notifTypeRow.get("TRIGGERTIME");
        String[] refJoinCol2 = new String[]{"EXP_ID"};
        Join expressionJoin = new Join("LACriteria2Expressions", "LAExpression", refJoinCol2, refJoinCol2, 2);
        this.addCustomAlertProfile(dobj, notifTypeRow, notifId, thresholdCount, (long)thresholdDuration * 1000L, triggerTime, expressionJoin);
    }

    public void addHostsToDefaultThreatProfile(Long hostID, Long hostGroupID) {
        try {
            Long Threat_NF_ID = Utils.THREAT_NF_ID;
            CustomAlertProfile cusProfile = this.customProfiles.get(Threat_NF_ID);
            if (cusProfile != null) {
                String hostGroupMappingTable = "HostGroupMapping";
                String hostNotificationTable = "HostNotification";
                String hostGroupNotificationTable = "HostGroupNotification";
                String groupIDColumn = "GROUPID";
                String hostIDColumn = "HOSTID";
                String notifIDColumn = "NOTIFID";
                HashSet<Long> allDefaultThreatHosts = cusProfile.getProfileHosts();
                HashSet<Long> allDefaultThreatGroups = cusProfile.getProfileHostGroups();
                if (Utils.enableAddHost) {
                    if (!allDefaultThreatGroups.contains(hostGroupID)) {
                        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)hostGroupMappingTable));
                        sql.addSelectColumn(Column.getColumn((String)hostGroupMappingTable, (String)"*"));
                        Criteria hostGroupCriteria = new Criteria(Column.getColumn((String)hostGroupMappingTable, (String)groupIDColumn), (Object)hostGroupID, 0);
                        Criteria hostCriteria = new Criteria(Column.getColumn((String)hostGroupMappingTable, (String)hostIDColumn), (Object)hostID, 1);
                        sql.setCriteria(hostGroupCriteria.and(hostCriteria));
                        DataObject hostsDO = DataAccess.get((SelectQuery)sql);
                        WritableDataObject hostNotificationDO = new WritableDataObject();
                        if (hostsDO.isEmpty()) {
                            Row hostNotificationRow = new Row(hostGroupNotificationTable);
                            hostNotificationRow.set(notifIDColumn, (Object)Threat_NF_ID);
                            hostNotificationRow.set(groupIDColumn, (Object)hostGroupID);
                            hostNotificationDO.addRow(hostNotificationRow);
                            allDefaultThreatGroups.add(hostGroupID);
                            cusProfile.setProfileHostGroups(allDefaultThreatGroups);
                        } else {
                            Row hostNotificationRow = new Row(hostNotificationTable);
                            hostNotificationRow.set(notifIDColumn, (Object)Threat_NF_ID);
                            hostNotificationRow.set(hostIDColumn, (Object)hostID);
                            hostNotificationDO.addRow(hostNotificationRow);
                            allDefaultThreatHosts.add(hostID);
                            cusProfile.setProfileHosts(allDefaultThreatHosts);
                        }
                        DataAccess.update((DataObject)hostNotificationDO);
                    }
                } else if (allDefaultThreatGroups.contains(hostGroupID)) {
                    HashMap<String, Long> columnValues = new HashMap<String, Long>();
                    SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)hostGroupMappingTable));
                    sql.addSelectColumn(Column.getColumn((String)hostGroupMappingTable, (String)"*"));
                    Criteria hostGroupCriteria = new Criteria(Column.getColumn((String)hostGroupMappingTable, (String)groupIDColumn), (Object)hostGroupID, 0);
                    Criteria hostCriteria = new Criteria(Column.getColumn((String)hostGroupMappingTable, (String)hostIDColumn), (Object)hostID, 1);
                    sql.setCriteria(hostGroupCriteria.and(hostCriteria));
                    DataObject hostsDO = DataAccess.get((SelectQuery)sql);
                    Iterator hostIDs = hostsDO.getRows(hostGroupMappingTable);
                    while (hostIDs.hasNext()) {
                        Row hostIDRow = (Row)hostIDs.next();
                        Long existingHostID = (Long)hostIDRow.get(hostIDColumn);
                        columnValues.clear();
                        columnValues.put(notifIDColumn, Threat_NF_ID);
                        columnValues.put(hostIDColumn, existingHostID);
                        DBManager.executeINSERTQuery((String)hostNotificationTable, columnValues);
                        allDefaultThreatHosts.add(existingHostID);
                        cusProfile.setProfileHosts(allDefaultThreatHosts);
                    }
                    columnValues.clear();
                    columnValues.put(groupIDColumn, hostGroupID);
                    columnValues.put(notifIDColumn, Threat_NF_ID);
                    DBManager.executeDELETEQuery((String)hostGroupNotificationTable, (JSONArray)DBManager.formCriteriaMap(columnValues));
                    allDefaultThreatGroups.remove(hostGroupID);
                    cusProfile.setProfileHostGroups(allDefaultThreatGroups);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception occured while adding new hosts to Default Threat profile ", e);
        }
    }

    private void addCustomAlertProfile(DataObject dobj, Row row, long notifId, int thresholdCount, long thresholdDurationInMillis, int triggerTime, Join expressionJoin) {
        boolean isAS400Type;
        String enableHostsStatusColumn = "EnableHostsStatus";
        CustomAlertProfile cusProfile = new CustomAlertProfile(thresholdCount, thresholdDurationInMillis, triggerTime);
        Integer notifStatus = (Integer)row.get("STATUS");
        cusProfile.setNotificationStatus(notifStatus);
        Long typeVal = (Long)row.get("TYPE");
        cusProfile.parseAndAddTypeDetails(typeVal);
        boolean bl = isAS400Type = typeVal == -1L;
        if (-1001L == typeVal) {
            cusProfile.setCorrelationProfile();
        } else if (-1000L == typeVal) {
            cusProfile.setDefaultProfile();
        }
        try {
            Iterator hostRows = dobj.getRows("HostNotification", row);
            HashSet<Long> hosts = new HashSet<Long>();
            while (hostRows.hasNext()) {
                Row r = (Row)hostRows.next();
                hosts.add((Long)r.get("HOSTID"));
            }
            Iterator hostGroupRows = dobj.getRows("HostGroupNotification", row);
            HashSet<Long> hostgroups = new HashSet<Long>();
            while (hostGroupRows.hasNext()) {
                Row r = (Row)hostGroupRows.next();
                hostgroups.add((Long)r.get("GROUPID"));
            }
            cusProfile.setProfileHosts(hosts);
            cusProfile.setProfileHostGroups(hostgroups);
            JSONObject alertCritObj = null;
            JSONObject alertCritObjTmp = null;
            JSONObject alertCritObjCust = null;
            JSONObject alertFormatId = null;
            Criteria cri = new Criteria(new Column("LACriteria2Expressions", "CRIT_ID"), (Object)notifId, 0);
            Iterator expressionRows = dobj.getRows("LAExpression", cri, expressionJoin);
            JSONArray critArr = new JSONArray();
            while (expressionRows.hasNext()) {
                String jsonStr;
                Row r = (Row)expressionRows.next();
                String colName = (String)r.get("COLUMN_NAME");
                if ("JSONAlertCrit".equals(colName)) {
                    try {
                        isAS400Type = false;
                        jsonStr = (String)r.get("VALUE");
                        alertCritObj = new JSONObject(jsonStr);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                    continue;
                }
                if ("JSONAlertCritCustom".equals(colName)) {
                    try {
                        jsonStr = (String)r.get("VALUE");
                        alertCritObjCust = !"".equals(jsonStr) ? new JSONObject(jsonStr) : null;
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                    continue;
                }
                if ("JSONAlertFormat".equals(colName)) {
                    try {
                        String fId = !"".equals((String)r.get("VALUE")) ? (String)r.get("VALUE") : null;
                        if (fId == null) continue;
                        alertFormatId = new JSONObject("{'isArr':false,'key':'FORMATID','value':'" + fId + "','condi':1,'type':101}");
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                    continue;
                }
                if (-1000L == typeVal && enableHostsStatusColumn.equals(colName)) {
                    Utils.enableAddHost = Boolean.valueOf((String)r.get("VALUE"));
                    continue;
                }
                if ("CustomTriggerStartEnd".equals(colName)) {
                    String[] startEnd = r.get("VALUE").toString().split(",");
                    cusProfile.setTriggerHours(LaUtil.getHoursFromStartEnd((Integer)Integer.valueOf(startEnd[0]), (Integer)Integer.valueOf(startEnd[1])));
                    continue;
                }
                if ("JSONNotifTimer".equals(colName) || "JSONAlertTxtVal".equals(colName)) continue;
                this.addToJsonCritArray(critArr, r, cusProfile);
            }
            if (critArr.length() > 0) {
                alertCritObj = new JSONObject();
                alertCritObj.put("isArr", true);
                alertCritObj.put("logic", 111);
                alertCritObj.put("crit", (Object)critArr);
            }
            if (alertCritObjCust != null) {
                JSONArray critArrTmp = new JSONArray();
                alertCritObjTmp = new JSONObject();
                alertCritObjTmp.put("isArr", true);
                alertCritObjTmp.put("sameGroup", false);
                alertCritObjTmp.put("logic", 111);
                critArrTmp.put((Object)alertCritObj);
                critArrTmp.put((Object)alertCritObjCust);
                alertCritObjTmp.put("crit", (Object)critArrTmp);
                alertCritObj = alertCritObjTmp;
            }
            if (alertFormatId != null) {
                JSONArray critArrFmt = new JSONArray();
                alertCritObjTmp = new JSONObject();
                alertCritObjTmp.put("isArr", true);
                alertCritObjTmp.put("sameGroup", false);
                alertCritObjTmp.put("logic", 111);
                critArrFmt.put((Object)alertCritObj);
                critArrFmt.put(alertFormatId);
                alertCritObjTmp.put("crit", (Object)critArrFmt);
                alertCritObj = alertCritObjTmp;
            }
            if (alertCritObj == null) {
                alertCritObj = new JSONObject();
                alertCritObj.put("matchAll", true);
            }
            if (alertCritObj != null) {
                cusProfile.addJsonCriteriaObject(alertCritObj);
                if (notifStatus == 1) {
                    this.enabledProfile.put(notifId, cusProfile);
                }
                this.customProfiles.put(notifId, cusProfile);
                LOGGER.log(Level.FINER, "CustomProfiles created with " + cusProfile);
            }
            cusProfile.markAS400Profile(isAS400Type);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void addToJsonCritArray(JSONArray jsonCritArr, Row row, CustomAlertProfile cusProfile) {
        block30: {
            int condition;
            String val;
            String colName;
            block29: {
                colName = (String)row.get("COLUMN_NAME");
                String tableName = (String)row.get("TABLE_NAME");
                if ("AlertMsgType".equals(colName)) {
                    return;
                }
                colName = "AS400SEVERITY".equals(colName) ? "SEVERITY" : ("MessageID".equals(colName) ? "MSGID" : colName);
                val = (String)row.get("VALUE");
                int n = condition = "FIM".equals(tableName) && "FILENAME".equals(colName) ? 4 : 1;
                if (!"MESSAGE".equals(colName)) break block29;
                String[] msgCrits = val.split("\\|");
                if (msgCrits.length == 0) {
                    return;
                }
                String mustMsgStr = msgCrits[0].isEmpty() ? null : msgCrits[0];
                String mustNotMsgStr = msgCrits.length >= 2 && !msgCrits[1].isEmpty() ? msgCrits[1] : null;
                int comparatorInt = 1;
                try {
                    String comparator = (String)row.get("COMPARATOR");
                    comparatorInt = "=".equals(comparator.trim()) ? 1 : Integer.parseInt(comparator);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                JSONObject obj = null;
                switch (comparatorInt) {
                    case 2: {
                        if (mustMsgStr != null && (obj = this.getJSONObjForCriteria(colName, mustMsgStr, 4)) != null) {
                            jsonCritArr.put((Object)obj);
                        }
                        if (mustNotMsgStr != null) {
                            obj = this.getJSONObjForCriteria(colName, mustNotMsgStr.split(","), 111, 9);
                            jsonCritArr.put((Object)obj);
                            break;
                        }
                        break block30;
                    }
                    case 3: {
                        if (mustMsgStr != null) {
                            obj = this.getJSONObjForCriteria(colName, mustMsgStr.split(","), 111, 4);
                            jsonCritArr.put((Object)obj);
                        }
                        if (mustNotMsgStr != null && (obj = this.getJSONObjForCriteria(colName, mustNotMsgStr, 9)) != null) {
                            jsonCritArr.put((Object)obj);
                            break;
                        }
                        break block30;
                    }
                    case 4: {
                        if (mustMsgStr != null) {
                            obj = this.getJSONObjForCriteria(colName, mustMsgStr.split(","), 111, 4);
                            jsonCritArr.put((Object)obj);
                        }
                        if (mustNotMsgStr != null) {
                            obj = this.getJSONObjForCriteria(colName, mustNotMsgStr.split(","), 111, 9);
                            jsonCritArr.put((Object)obj);
                            break;
                        }
                        break block30;
                    }
                    default: {
                        if (mustMsgStr != null && (obj = this.getJSONObjForCriteria(colName, mustMsgStr, 4)) != null) {
                            jsonCritArr.put((Object)obj);
                        }
                        if (mustNotMsgStr != null && (obj = this.getJSONObjForCriteria(colName, mustNotMsgStr, 9)) != null) {
                            jsonCritArr.put((Object)obj);
                            break;
                        }
                        break block30;
                    }
                }
                break block30;
            }
            if ("SEVERITY".equals(colName)) {
                cusProfile.addSeverity(val);
            } else if ("EXCLUDEEVENTID".equals(colName) || "EVENTID".equals(colName)) {
                boolean isExclude = "EXCLUDEEVENTID".equals(colName);
                int rangeContion = isExclude ? 10 : 5;
                int equalCondition = isExclude ? 2 : 1;
                JSONArray allExclEvents = new JSONArray();
                String[] splitedEvents = val.split(",");
                if (splitedEvents.length == 0) {
                    return;
                }
                for (String e : splitedEvents) {
                    if (e.indexOf("-") > 0) {
                        String[] range = e.split("-");
                        allExclEvents.put((Object)this.getJSONObjForCriteria("EVENTID", range[0].trim(), range[1].trim(), rangeContion, 101));
                        continue;
                    }
                    JSONObject jo = this.getJSONObjForCriteria("EVENTID", e, equalCondition, 101);
                    if (jo == null) continue;
                    allExclEvents.put((Object)jo);
                }
                if (allExclEvents.length() > 1) {
                    JSONObject obj = null;
                    try {
                        obj = new JSONObject();
                        obj.put("isArr", true);
                        obj.put("logic", isExclude ? 111 : 100);
                        obj.put("crit", (Object)allExclEvents);
                        jsonCritArr.put((Object)obj);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                } else {
                    jsonCritArr.put((Object)allExclEvents.optJSONObject(0));
                }
            } else {
                JSONObject obj = this.getJSONObjForCriteria(colName, val, condition);
                if (obj != null && obj.length() > 0) {
                    jsonCritArr.put((Object)obj);
                }
            }
        }
    }

    private JSONObject getJSONObjForCriteria(String fieldName, String val, int condition) {
        return this.getJSONObjForCriteria(fieldName, val, null, condition, 102);
    }

    private JSONObject getJSONObjForCriteria(String fieldName, String val, int condition, int valueType) {
        return this.getJSONObjForCriteria(fieldName, val, null, condition, valueType);
    }

    private JSONObject getJSONObjForCriteria(String fieldName, String val, String val2, int condition, int valueType) {
        if (val2 == null && val.trim().isEmpty()) {
            return null;
        }
        JSONObject obj = null;
        try {
            obj = new JSONObject();
            obj.put("isArr", false);
            obj.put("key", (Object)fieldName);
            if (val2 != null) {
                obj.put("value1", (Object)val);
                obj.put("value2", (Object)val2);
            } else {
                obj.put("value", (Object)val);
            }
            obj.put("type", valueType);
            obj.put("condi", condition);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return obj;
    }

    private JSONObject getJSONObjForCriteria(String fieldName, String[] valueArr, int logic, int condition) {
        if (valueArr.length == 1) {
            return this.getJSONObjForCriteria(fieldName, valueArr[0], condition);
        }
        JSONObject obj = null;
        try {
            obj = new JSONObject();
            obj.put("isArr", true);
            obj.put("logic", logic);
            JSONArray jsonArr = new JSONArray();
            for (String v : valueArr) {
                if (v.trim().isEmpty()) continue;
                jsonArr.put((Object)this.getJSONObjForCriteria(fieldName, v.trim(), condition));
            }
            obj.put("crit", (Object)jsonArr);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return obj;
    }

    public void addProfile(Long notifId, Long expid, JSONObject jsonadvAlert) {
        this.updateProfile(notifId, expid, jsonadvAlert);
    }

    public void deleteProfile(Long notifId) {
        LOGGER.info("Notification Profile " + notifId + " deleted.");
        this.profileMap.remove(notifId);
        this.customProfiles.remove(notifId);
        this.enabledProfile.remove(notifId);
    }

    public void updateProfile(Long notifId, Long expid, JSONObject jsonadvAlert) {
        try {
            LOGGER.info("Notification Profile " + notifId + " updated.");
            this.profileMap.put(notifId, new NotificationProfile(notifId, expid, jsonadvAlert));
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public NotificationProfile getNotificationProfile(Long notifId) {
        return this.profileMap.get(notifId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Hashtable log) {
        String notifId = (String)log.get("NOTIFID");
        if ((notifId == null || notifId.length() <= 0 || "-".equals(notifId)) && this.customProfiles.isEmpty()) {
            this.shutdown = true;
            return;
        }
        Object object = this;
        synchronized (object) {
            if (this.logsForNotificationCheck.size() >= this.maxLogsInMemory) {
                ++this.unProcessedlogs;
                if (this.unProcessedlogs > 1000) {
                    LOGGER.log(Level.WARNING, "Alert Not Processed : exceeds the allowed value : {0} : Please enable handleHighFlow", this.maxLogsInMemory);
                    this.unProcessedlogs = 0;
                }
                return;
            }
            this.logsForNotificationCheck.add(log);
            if (this.criteriaCheckerMainThread == null) {
                AlertCriteriaChecker checker2 = new AlertCriteriaChecker();
                this.criteriaCheckerMainThread = new Thread(checker2);
                this.criteriaCheckerMainThread.start();
                return;
            }
        }
        if (this.logsForNotificationCheck.size() >= this.logLimitForNewThread && this.runningSubThreads < 2) {
            AlertCriteriaChecker checker = null;
            NotificationManager checker2 = this;
            synchronized (checker2) {
                if (this.logsForNotificationCheck.size() >= this.logLimitForNewThread && this.runningSubThreads < 2) {
                    List<Map> tmp = this.logsForNotificationCheck;
                    int splitIndex = tmp.size() / 2;
                    List<Map> tmp2 = tmp.subList(0, splitIndex);
                    this.logsForNotificationCheck = new ArrayList<Map>(tmp2);
                    tmp2.clear();
                    checker = new AlertCriteriaChecker(tmp);
                }
            }
            if (checker != null) {
                Thread subThread = new Thread(checker);
                ++this.runningSubThreads;
                subThread.start();
            }
        }
        if (this.criteriaCheckerMainThread.getState() == Thread.State.TIMED_WAITING) {
            object = this.waitObj;
            synchronized (object) {
                this.waitObj.notifyAll();
            }
        }
    }

    private synchronized List<Map> getLogListToProcess() {
        if (this.logsForNotificationCheck.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List<Map> list = this.logsForNotificationCheck;
        this.logsForNotificationCheck = new ArrayList<Map>();
        return list;
    }

    private String getFormattedTime(Long timeInMillis) {
        Date logTime = new Date(timeInMillis);
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss, EEE, MMM dd yyyy");
        return timeFormat.format(logTime);
    }

    public void refreshNotifier(Long notifId) {
        try {
            NotificationProfile profile = this.profileMap.get(notifId);
            if (profile != null) {
                profile.refreshNotifiers();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class AlertCriteriaChecker
    implements Runnable {
        private List<Map> currentLogsList = null;

        private AlertCriteriaChecker() {
        }

        private AlertCriteriaChecker(List<Map> logs) {
            this.currentLogsList = logs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean runContinuously;
            boolean bl = runContinuously = this.currentLogsList == null;
            if (runContinuously) {
                while (!NotificationManager.this.shutdown) {
                    List logListToProcess = NotificationManager.this.getLogListToProcess();
                    this.processLogsForNotification(logListToProcess);
                    try {
                        Object object = NotificationManager.this.waitObj;
                        synchronized (object) {
                            if (NotificationManager.this.logsForNotificationCheck.isEmpty()) {
                                NotificationManager.this.waitObj.wait(60000L);
                            }
                        }
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                }
            } else {
                this.processLogsForNotification(this.currentLogsList);
                NotificationManager.this.runningSubThreads--;
            }
        }

        private void processLogsForNotification(List<Map> logListToProcess) {
            Iterator<Map> logMapItr = logListToProcess.iterator();
            SimpleDateFormat hourOnlyFormat = new SimpleDateFormat("HH");
            while (logMapItr.hasNext()) {
                try {
                    Object appId;
                    Map log = logMapItr.next();
                    this.correctLogData(log);
                    Long deviceID = (Long)log.get("HOSTID");
                    if (deviceID == null && (appId = log.get("APPID")) != null) {
                        deviceID = CustomAlertProfile.getHostIdForAppId(Long.parseLong(appId + ""));
                    }
                    Long logTime = (Long)log.get("TIME");
                    if (!NotificationManager.this.hostMap.containsKey(deviceID)) {
                        NotificationManager.this.initHostMap();
                    }
                    if (!NotificationManager.this.hostMap.containsKey(deviceID)) {
                        LOGGER.log(Level.FINER, "HostId is NULL for ", log);
                        continue;
                    }
                    log.put("DISPLAY_NAME", NotificationManager.this.hostMap.get(deviceID));
                    StringBuilder notifIdBuilder = new StringBuilder();
                    Long formattedDeviceID = deviceID;
                    NotificationManager.this.enabledProfile.forEach((notifId, profile) -> {
                        if (profile != null && profile.isCriteriaMatched(log, formattedDeviceID, hourOnlyFormat.format(logTime))) {
                            if (profile.isCorrelationProfile()) {
                                NotificationListener.process(notifId, log);
                            } else {
                                notifIdBuilder.append(notifId).append(",");
                            }
                        }
                    });
                    String notifIds = notifIdBuilder.toString();
                    if (!notifIds.isEmpty()) {
                        log.put("NOTIFID", notifIds);
                        NotificationHandler.addLogIntoQueue((Hashtable)log);
                    } else if (log.containsKey("NOTIFID") && !"-".equals((String)log.get("NOTIFID")) && !"".equals((String)log.get("NOTIFID")) && NotificationManager.this.isAS400Profile(Long.parseLong((String)log.get("NOTIFID")))) {
                        NotificationHandler.addLogIntoQueue((Hashtable)log);
                    }
                    logMapItr.remove();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    logMapItr.remove();
                }
            }
        }

        private void correctLogData(Map log) {
            Long timeInLong = System.currentTimeMillis();
            Object timeVal = log.get("TIME");
            if (timeVal == null) {
                timeInLong = System.currentTimeMillis();
            } else if (timeVal instanceof Long) {
                timeInLong = (Long)timeVal;
            } else {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    timeInLong = sdf.parse(timeVal + "").getTime();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            log.put("TIME", timeInLong);
            log.put("Time", NotificationManager.this.getFormattedTime(timeInLong));
            String logMsg = (String)log.get("MESSAGE");
            if (logMsg == null && (logMsg = (String)log.get("RAWLOG")) != null) {
                log.put("MESSAGE", logMsg);
            }
            if (log.get("SOURCE") == null) {
                log.put("SOURCE", "-");
            }
        }
    }
}

