/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.nf;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.EMailNotifier;
import com.adventnet.sa.server.nf.IncidentToolConstants;
import com.adventnet.sa.server.nf.Notifier;
import com.adventnet.sa.server.nf.ScriptNotifier;
import com.adventnet.sa.server.nf.SmsNotifier;
import com.adventnet.sa.server.nf.incident.IncidentNotifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.json.JSONObject;

public class NotificationProfile {
    private static final Logger LOGGER = Logger.getLogger(NotificationProfile.class.getName());
    private Long notifId = null;
    private Long expid = null;
    private JSONObject jsonadvanceNotifier = null;
    private String notifName = null;
    private boolean isNotifEnabled = true;
    private String criticality = null;
    private Integer occurances = null;
    private Long type = null;
    private Set<Notifier> notifiers = new HashSet<Notifier>();

    public NotificationProfile(Long notifId, Long expid, JSONObject jsonadvanceNotifier) {
        this.notifId = notifId;
        this.expid = expid;
        this.jsonadvanceNotifier = jsonadvanceNotifier;
        this.setProfileDetails();
    }

    public void updateProfile() {
        this.notifiers.clear();
        this.setProfileDetails();
    }

    public JSONObject getJSonNotifTimer() {
        return this.jsonadvanceNotifier;
    }

    public Long getExpId() {
        return this.expid;
    }

    private void setProfileDetails() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("NotificationType"));
            query.addSelectColumn(new Column("NotificationType", "*"));
            query.addSelectColumn(new Column("NotfnConfiguration", "*"));
            query.addSelectColumn(new Column("NotfnConfigurationSms", "*"));
            query.addSelectColumn(new Column("ScriptDetails", "*"));
            query.addJoin(new Join("NotificationType", "NotfnConfiguration", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
            query.addJoin(new Join("NotificationType", "NotfnConfigurationSms", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
            query.addJoin(new Join("NotificationType", "ScriptDetails", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
            query.setCriteria(new Criteria(new Column("NotificationType", "NOTIFID"), (Object)this.notifId, 0));
            DataObject doo = DataAccess.get((SelectQuery)query);
            Row r = doo.getRow("NotificationType");
            Boolean isResolveNeeded = (Boolean)r.get("ISRESOLVENEEDED");
            String resolvedName = (String)r.get("NOTIFNAME");
            if (isResolveNeeded != null && isResolveNeeded.booleanValue()) {
                resolvedName = ProductBundle.getInstance().getString(ResourceBundleMgr.getInstance().getServerLocale(), resolvedName);
            }
            this.notifName = resolvedName;
            this.isNotifEnabled = (Integer)r.get("STATUS") == 1;
            this.criticality = (String)r.get("CRITICALITY");
            this.occurances = (Integer)r.get("NOOFOCCURRENCE");
            this.type = (Long)r.get("TYPE");
            this.setNotifiers(doo);
            this.setOtherNotifiers();
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
        }
    }

    private void setOtherNotifiers() {
        try {
            Map<String, Map<?, ?>> toolDetailsMap = IncidentToolConstants.getInstance().getToolConfigMap();
            ArrayList apiID = null;
            Map<?, ?> apiIDMap = toolDetailsMap.get("DEFAULT_CONFIGURATION");
            if (apiIDMap.containsKey(this.notifId)) {
                apiID = new ArrayList((Collection)apiIDMap.get(this.notifId));
                for (int i = 0; apiID != null && i < apiID.size(); ++i) {
                    IncidentNotifier notifier = new IncidentNotifier((Long)apiID.get(i));
                    if (!notifier.isConfigured()) continue;
                    this.notifiers.add(notifier);
                }
            }
        }
        catch (Exception e) {
            LOGGER.info("Exception occurred while setting notifiers");
            e.printStackTrace();
        }
    }

    private void setNotifiers(DataObject doo) throws DataAccessException {
        Row r = doo.getRow("NotfnConfiguration");
        if (r != null) {
            HashMap<String, String> profileDetails = new HashMap<String, String>();
            profileDetails.put("NoOfOccurances", this.getOccurances().toString());
            profileDetails.put("Criticality", this.getCriticality());
            profileDetails.put("AlertName", this.getNotifName());
            EMailNotifier notifier = new EMailNotifier(r);
            notifier.init(profileDetails);
            this.notifiers.add(notifier);
        }
        if ((r = doo.getRow("NotfnConfigurationSms")) != null) {
            this.notifiers.add(new SmsNotifier(r));
        }
        if ((r = doo.getRow("ScriptDetails")) != null) {
            this.notifiers.add(new ScriptNotifier(r));
        }
    }

    Long getNotifId() {
        return this.notifId;
    }

    public String getNotifName() {
        return this.notifName;
    }

    String getCriticality() {
        return this.criticality;
    }

    Integer getOccurances() {
        return this.occurances;
    }

    Set<Notifier> getNotifiers() {
        return this.notifiers;
    }

    public void refreshNotifiers() {
        this.notifiers.clear();
        this.setProfileDetails();
    }

    public boolean isNotifEnabled() {
        return this.isNotifEnabled;
    }

    public void enableNotification() {
        this.isNotifEnabled = true;
    }

    public void disableNotification() {
        this.isNotifEnabled = false;
    }

    public Long getNotificationType() {
        return this.type;
    }
}

